package com.biz.crm.salegoal.service.impl;

import com.biz.crm.nebular.dms.salecontract.SaleContractVo;
import com.biz.crm.nebular.dms.salegoal.SaleGoalRatioVo;
import com.biz.crm.salegoal.service.SaleGoalRatioService;
import com.biz.crm.salegoal.utils.SaleGoalUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

/**
 * 获取销售目标月度比例默认实现
 * @Author: chenrong
 * @Date: 2021/2/26 14:58
 */
@Service(value = "saleGoalRatioService")
@ConditionalOnMissingBean(name = "saleGoalRatioServiceImpl")
public class SaleGoalRatioServiceImpl implements SaleGoalRatioService {
  /**
   * 根据合同信息（年度+类型+所属组织+开始时间）获取月度比例明细接口
   * @param targetYear 目标年份
   * @param contractVo 合同对象，其中包含了渠道类型(channelCode)，组织(orgCode)，开始时间(startTime)，合同年度(yearly)
   * @return
   */
  @Override
  public SaleGoalRatioVo findMonthRatio(Integer targetYear, SaleContractVo contractVo) {
    return SaleGoalUtil.packageDefaultRatioVo();
  }
}
