package com.biz.crm.salesarea.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.nebular.dms.salesarea.SalesAreaVo;
import com.biz.crm.salesarea.service.SalesAreaService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @author liufan E-mail:fan.liu@biz-united.com.cn
 * @version 创建时间：2021/2/20
 */
@Api(value = "销售范围", tags = "销售范围")
@RestController
@RequestMapping(value = "/m/salesArea")
public class SalesAreamController {
    @Resource
    private SalesAreaService salesAreaService;

    @CrmLog
    @ApiOperation(value = "查询销售范围")
    @GetMapping("findSalesAreaBySaleContractCode")
    public Result<SalesAreaVo> listSalesArea(@RequestParam @ApiParam("合同编号") String saleContractCode) {
        SalesAreaVo result = this.salesAreaService.listSalesArea(saleContractCode);
        return Result.ok(result);
    }

}
