package com.biz.crm.salestarget.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.salestarget.SalesTargetVo;
import com.biz.crm.salestarget.service.SalesTargetService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/8 17:37
 **/
@Api(value = "管理端-销售目标", tags = "管理端-销售目标")
@RestController
@RequestMapping("/m/salesTarget")
public class SalesTargetmController {

    @Resource
    private SalesTargetService salesTargetService;

    @CrmLog
    @ApiOperation(value = "批量新增")
    @PostMapping(value = "addBatch")
    public Result addBatch(@RequestBody List<SalesTargetVo> salesTargetVos) {
        salesTargetService.addBatch(salesTargetVos);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "编辑")
    @PostMapping(value = "edit")
    public Result edit(@RequestBody SalesTargetVo salesTargetVo) {
        salesTargetService.edit(salesTargetVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "通过id查询")
    @GetMapping(value = "findById/{id}")
    public Result<SalesTargetVo> findById(@PathVariable("id") String id) {
        return Result.ok(salesTargetService.findById(id));
    }

    @CrmLog
    @ApiOperation(value = "分页搜索")
    @PostMapping(value = "list")
    public Result<PageResult<SalesTargetVo>> list(@RequestBody SalesTargetVo salesTargetVo) {
        return Result.ok(salesTargetService.list(salesTargetVo));
    }

    @ApiOperation(value = "根据id批量删除")
    @PostMapping(value = "delByIds")
    public Result<Object> delByIds(@RequestBody ArrayList<String> ids) {
        salesTargetService.delByIds(ids);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "根据查询条件批量删除")
    @PostMapping(value = "delByParam")
    public Result<Object> delByParam(@RequestBody SalesTargetVo salesTargetVo) {
        salesTargetService.delByParam(salesTargetVo);
        return Result.ok();
    }
}
