package com.biz.crm.salestarget.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.salestarget.SalesTargetVo;
import com.biz.crm.salestarget.service.SalesTargetService;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

@Api(value = "微信端-销售目标", tags = "微信端-销售目标")
@RestController
@RequestMapping(value = "/v/salesTarget")
public class SalesTargetvController {

    @Resource
    private SalesTargetService salesTargetService;

    @CrmLog
    @CrossOrigin
    @ApiOperation(value = "分页展示销售目标")
    @PostMapping(value = "list")
    public Result<PageResult<SalesTargetVo>> list(@RequestBody SalesTargetVo salesTargetVo){
        salesTargetVo.setCusCode(UserUtils.getUser().getCustcode());
        return Result.ok(salesTargetService.list(salesTargetVo));
    }
}
