package com.biz.crm.salestarget.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @Description:销售目标
 * @Author: zhangyuzhu
 * @Date: 2020/9/11 15:43
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_sales_target")
public class SalesTargetEntity extends CrmExtEntity<SalesTargetEntity> {


    /**
     * 客户编码
     */
    private String cusCode;

    /**
     * 客户名称
     */
    private String cusName;

    /**
     * 客户所属组织编码
     */
    private String cusOrgCode;

    /**
     * 客户所属组织名称
     */
    private String cusOrgName;

    /**
     * 客户所属渠道编码
     */
    private String cusChannelCode;

    /**
     * 客户所属渠道名称
     */
    private String cusChannelName;


    /**
     * 销售区域编码
     */
    private String salesAreaCode;

    /**
     * 销售区域名称
     */
    private String salesAreaName;


    /**
     * 销量目标类型
     */
    private Integer type;

    /**
     * 销量目标名称
     */
    private String name;

    /**
     * 目标年份
     */
    private Integer targetYear;

    /**
     * 目标年份总量
     */
    private BigDecimal targetNum;

    /**
     * 商品编码(类型是单品销售目标 该字段不能空)
     */
    private String goodsCode;

    /**
     * 商品名称(类型是单品销售目标 该字段不能空)
     */
    private String goodsName;

    /**
     * 商品规格(类型是单品销售目标 该字段不能空)
     */
    private String productSpec;

    /**
     * 产品层级code(类型是非常规 该字段不能空)
     */
    private String productLevelCode;

    /**
     * 产品层级名称(类型是非常规 该字段不能空)
     */
    private String productLevelName;

    /**
     * 唯一值，去重时查询用 (类型是单品：产品code + 目标年份 ；类型是层级：产品层级code + 目标年份;类型是常规： 目标年份)
     */
    private String onlyKey;
}
