package com.biz.crm.salestarget.utils;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.dms.SalesTargetEunm;
import com.biz.crm.nebular.dms.salestarget.SalesTargetVo;
import com.biz.crm.salestarget.entity.SalesTargetEntity;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.util.ValidateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/15 16:23
 **/
public class SalesTargetUtil {

    /**
     * 验证添加方法的参数
     * @param salesTargetVo
     */
    public static void validateAddParam(SalesTargetVo salesTargetVo){
        ValidateUtils.validate(salesTargetVo.getCusCode(),"客户编码不能为空!");
        ValidateUtils.validate(salesTargetVo.getCusName(),"客户名称不能为空!");
//        ValidateUtils.validate(salesTargetVo.getCusOrgCode(),"客户所属组织编码不能为空!");
//        ValidateUtils.validate(salesTargetVo.getCusOrgName(),"客户所属组织名称不能为空!");
//        ValidateUtils.validate(salesTargetVo.getCusChannelCode(),"客户所属渠道编码不能为空!");
//        ValidateUtils.validate(salesTargetVo.getCusChannelName(),"客户所属渠道名称不能为空!");
        ValidateUtils.validate(salesTargetVo.getTargetYear(),"目标年份不能为空!");
        ValidateUtils.validate(salesTargetVo.getType(),"销量目标类型不能为空!");
        if(salesTargetVo.getType().intValue() == SalesTargetEunm.type.PRODUCTLQVEL.getCode().intValue()){
            ValidateUtils.validate(salesTargetVo.getProductLevelCode(),"产品层级编码不能为空!");
            ValidateUtils.validate(salesTargetVo.getProductLevelName(),"产品层级名称不能为空!");
        }
        if(salesTargetVo.getType().intValue() == SalesTargetEunm.type.GOODS.getCode().intValue()){
            ValidateUtils.validate(salesTargetVo.getGoodsCode(),"商品编码不能为空!");
            ValidateUtils.validate(salesTargetVo.getGoodsName(),"商品名称不能为空!");
//            ValidateUtils.validate(salesTargetVo.getProductSpec(),"商品规格不能为空!");
//            ValidateUtils.validate(salesTargetVo.getProductLevelCode(),"产品层级编码不能为空!");
//            ValidateUtils.validate(salesTargetVo.getProductLevelName(),"产品层级名称不能为空!");
        }
    }

    /**
     * 验证参数(为addBatch方法)
     * 1、验证目标类型必须是同一个
     * 2、验证经销商必须是同一个
     * 3、验证详细参数
     * 4、验证参数中产品是否重复
     * @param salesTargetVos
     */
    public static void validateParamForAddBatch(List<SalesTargetVo> salesTargetVos){
        if(CollectionUtils.isEmpty(salesTargetVos)){
            return;
        }

        //1
        Integer type = salesTargetVos.get(0).getType();
        if(!CollectionUtils.isEmpty(
                salesTargetVos.stream().filter(vo -> type.intValue() != vo.getType()).collect(Collectors.toList())
        )){
            throw new BusinessException("暂不支持跨目标类型批量操作！");
        }

        //2
        String cusCode = salesTargetVos.get(0).getCusCode();
        if(!CollectionUtils.isEmpty(
                salesTargetVos.stream().filter(vo -> !vo.getCusCode().equals(cusCode)).collect(Collectors.toList())
        )){
            throw new BusinessException("暂时仅支持同一个客户批量操作！");
        }

        //3
        for(SalesTargetVo vo : salesTargetVos){
            validateAddParam(vo);
        }

        //4
        Map<String,Object> map = new HashMap<>(salesTargetVos.size());//验证重复用的map
        for(SalesTargetVo vo : salesTargetVos){
            //验重
            String key = "";
            String repeat = "";
            if(vo.getType().intValue() == SalesTargetEunm.type.GOODS.getCode().intValue()){
                key = new StringBuilder(vo.getGoodsCode()).append(vo.getTargetYear()).toString();
                repeat = vo.getGoodsName();
            }else if(vo.getType().intValue() == SalesTargetEunm.type.PRODUCTLQVEL.getCode().intValue()){
                key = new StringBuilder(vo.getProductLevelCode()).append(vo.getTargetYear()).toString();
                repeat = vo.getProductLevelName();
            }else {
                key = vo.getTargetYear().toString();
            }
            if(map.get(key) != null){
                StringBuilder msg = new StringBuilder("目标重复");
                if(!StringUtils.isEmpty(repeat)){
                    msg.append(",产品/产品层级:").append(repeat);
                }
                msg.append(",目标年份:").append(vo.getTargetYear());
                throw new BusinessException(msg.toString());
            }
            map.put(key,key);
        }
    }


    /**
     * 组装实体对象，为add方法
     * @return
     */
    public static SalesTargetEntity packageEntityForAdd(SalesTargetVo vo){
        SalesTargetEntity entity = new SalesTargetEntity();
        BeanUtils.copyProperties(vo,entity);
        entity.setId(UUIDGenerator.generate());
        if(vo.getType().intValue() == SalesTargetEunm.type.PRODUCTLQVEL.getCode().intValue()){
            entity.setGoodsCode(null);
            entity.setGoodsName(null);
            entity.setProductSpec(null);
            entity.setOnlyKey(new StringBuilder(vo.getCusCode()).append(",").append(vo.getProductLevelCode()).append(",").append(vo.getTargetYear()).toString());
        }
        if(vo.getType().intValue() == SalesTargetEunm.type.ROUTINE.getCode().intValue()){
            entity.setGoodsCode(null);
            entity.setGoodsName(null);
            entity.setProductSpec(null);
            entity.setProductLevelCode(null);
            entity.setProductLevelName(null);
            entity.setOnlyKey(new StringBuilder(vo.getCusCode()).append(vo.getTargetYear().toString()).toString());
        }
        if(vo.getType().intValue() == SalesTargetEunm.type.GOODS.getCode().intValue()){
            entity.setOnlyKey(new StringBuilder(vo.getCusCode()).append(",").append(vo.getGoodsCode()).append(",").append(vo.getTargetYear()).toString());
        }
        //全年总目标
        entity.setTargetNum(SalesMonthTargetUtil.countTargetNum(vo.getSalesMonthTargetVo()));
        return entity;
    }


}
