/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.salegoal.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.dms.SaleGoalEunm;
import com.biz.crm.nebular.dms.salecontract.SaleContractVo;
import com.biz.crm.nebular.dms.salegoal.SaleGoalItemVo;
import com.biz.crm.nebular.dms.salegoal.SaleGoalRatioVo;
import com.biz.crm.nebular.dms.salegoal.SaleGoalVo;
import com.biz.crm.salegoal.entity.SaleGoalEntity;
import com.biz.crm.salegoal.mapper.SaleGoalMapper;
import com.biz.crm.salegoal.service.SaleGoalItemService;
import com.biz.crm.salegoal.service.SaleGoalRatioService;
import com.biz.crm.salegoal.service.SaleGoalService;
import com.biz.crm.salegoal.utils.SaleGoalItemUtil;
import com.biz.crm.salegoal.utils.SaleGoalUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"saleGoalServiceImpl"})
@Service(value="saleGoalService")
public class SaleGoalServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SaleGoalMapper, SaleGoalEntity>
implements SaleGoalService {
    @Resource
    private SaleGoalMapper saleGoalMapper;
    @Resource
    private SaleGoalItemService saleGoalItemService;
    @Resource
    private SaleGoalRatioService saleGoalRatioService;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    @Transactional
    public List<SaleGoalVo> addBatch(List<SaleGoalVo> saleGoalVos) {
        this.validateForAddBatch(saleGoalVos);
        HashMap<String, SaleGoalItemVo> saleGoalItemMap = new HashMap<String, SaleGoalItemVo>(saleGoalVos.size());
        ArrayList<Object> entities = new ArrayList<Object>(saleGoalVos.size());
        for (SaleGoalVo vo : saleGoalVos) {
            SaleGoalItemVo goalItemVo = vo.getSaleGoalItemVo();
            ValidateUtils.validate((Object)goalItemVo, (String)"\u76ee\u6807\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            SaleGoalEntity entity = SaleGoalUtil.packageEntityForAdd(vo);
            goalItemVo.setSaleGoalId(entity.getId());
            goalItemVo.setTaskType(entity.getTaskType());
            entities.add((Object)entity);
            saleGoalItemMap.put(entity.getId(), goalItemVo);
        }
        ArrayList<SaleGoalEntity> currentEntities = new ArrayList<SaleGoalEntity>();
        ArrayList<SaleGoalItemVo> currentItemVos = new ArrayList<SaleGoalItemVo>(saleGoalVos.size());
        int entityI = 0;
        for (SaleGoalEntity saleGoalEntity : entities) {
            currentEntities.add(saleGoalEntity);
            currentItemVos.add((SaleGoalItemVo)saleGoalItemMap.get(saleGoalEntity.getId()));
            if (currentEntities.size() != 500 && ++entityI != entities.size()) continue;
            this.saveBatch(currentEntities);
            this.saleGoalItemService.addBatch(currentItemVos);
            currentEntities.clear();
            currentItemVos.clear();
        }
        List resultVos = CrmBeanUtil.copyList(entities, SaleGoalVo.class);
        Object object = ThreadLocalUtil.getObj((String)"menuCode");
        for (SaleGoalVo vo : resultVos) {
            this.crmLogSendUtil.sendForAdd(object.toString(), vo.getId(), vo.getId(), (Object)vo);
        }
        return CrmBeanUtil.copyList(entities, SaleGoalVo.class);
    }

    private void validateForAddBatch(List<SaleGoalVo> saleGoalVos) {
        SaleGoalUtil.validateParamForAddBatch(saleGoalVos);
        SaleGoalUtil.buildOnlyKey(saleGoalVos);
        List params = saleGoalVos.stream().map(SaleGoalVo::getOnlyKey).collect(Collectors.toList());
        ArrayList<String> currentParam = new ArrayList<String>();
        ArrayList exsits = new ArrayList();
        int i = 0;
        Integer type = saleGoalVos.get(0).getType();
        Integer objectType = saleGoalVos.get(0).getObjectType();
        for (Object param : params) {
            currentParam.add((String)param);
            if (currentParam.size() != 500 && ++i != params.size()) continue;
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.in((Object)"only_key", currentParam);
            List entities = this.saleGoalMapper.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)entities)) {
                exsits.addAll(entities);
            }
            currentParam.clear();
        }
        if (!CollectionUtils.isEmpty(exsits)) {
            StringBuilder stb = new StringBuilder();
            for (SaleGoalEntity entity : exsits) {
                if (SaleGoalEunm.ObjectType.CUSTOMER.getCode().equals(objectType)) {
                    stb.append(entity.getCusName()).append("-");
                } else if (SaleGoalEunm.ObjectType.ORGANIZATION.getCode().equals(objectType)) {
                    stb.append(entity.getOrgName()).append("-");
                } else if (SaleGoalEunm.ObjectType.TERMINAL.getCode().equals(objectType)) {
                    stb.append(entity.getTerminalName()).append("-");
                }
                if (type.intValue() == SaleGoalEunm.GoalType.GOODS.getCode().intValue()) {
                    stb.append(entity.getGoodsName()).append("-").append(entity.getTargetYear()).append(";");
                    continue;
                }
                if (type.intValue() == SaleGoalEunm.GoalType.PRODUCT_LEVEL.getCode().intValue()) {
                    stb.append(entity.getProductLevelName()).append("-").append(entity.getTargetYear()).append(";");
                    continue;
                }
                stb.append(entity.getTargetYear()).append(";");
            }
            StringBuilder msgPre = new StringBuilder("\u9500\u91cf\u76ee\u6807\u5df2\u7ecf\u5b58\u5728,\u5e74\u4efd\u4e3a\uff1a");
            if (type.intValue() != SaleGoalEunm.GoalType.ROUTINE.getCode().intValue()) {
                msgPre = new StringBuilder("\u9500\u91cf\u76ee\u6807\u5df2\u7ecf\u5b58\u5728,\u4ea7\u54c1/\u4ea7\u54c1\u5c42\u7ea7\u548c\u5e74\u4efd\u4e3a: ");
            }
            throw new BusinessException(msgPre.append((CharSequence)stb).toString());
        }
    }

    @Override
    @Transactional
    public void edit(SaleGoalVo saleGoalVo) {
        ValidateUtils.validate((Object)saleGoalVo.getId(), (String)"\u8bf7\u6307\u5b9a\u8981\u7f16\u8f91\u7684\u9500\u552e\u76ee\u6807!");
        SaleGoalEntity entity = (SaleGoalEntity)((Object)this.saleGoalMapper.selectById((Serializable)((Object)saleGoalVo.getId())));
        ValidateUtils.validate((Object)((Object)entity), (String)"\u60a8\u8981\u7f16\u8f91\u7684\u9500\u552e\u76ee\u6807\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u7ecf\u88ab\u5220\u9664!");
        SaleGoalVo oldObject = this.findById(saleGoalVo.getId());
        saleGoalVo.getSaleGoalItemVo().setTaskType(saleGoalVo.getTaskType());
        entity.setTargetNum(SaleGoalItemUtil.sumSingleItem(saleGoalVo.getSaleGoalItemVo()).getYearlySum());
        entity.setName(saleGoalVo.getName());
        entity.setTaskType(saleGoalVo.getTaskType());
        this.saleGoalMapper.updateById((Object)entity);
        this.saleGoalItemService.update(saleGoalVo.getSaleGoalItemVo());
        SaleGoalVo newObject = this.findById(saleGoalVo.getId());
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), saleGoalVo.getId(), saleGoalVo.getId(), (Object)oldObject, (Object)newObject);
    }

    @Override
    @CrmDictMethod
    public SaleGoalVo findById(String id) {
        SaleGoalVo vo = null;
        ValidateUtils.validate((Object)id, (String)"\u8bf7\u6307\u5b9a\u9700\u8981\u67e5\u8be2\u7684\u9500\u552e\u76ee\u6807\uff01");
        SaleGoalEntity entity = (SaleGoalEntity)((Object)this.saleGoalMapper.selectById((Serializable)((Object)id)));
        if (null == entity) {
            return vo;
        }
        vo = new SaleGoalVo();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        vo.setTargetNumStr(vo.getTargetNum().stripTrailingZeros().toPlainString());
        vo.setSaleGoalItemVo(this.saleGoalItemService.findBySaleGoalId(vo.getId()));
        return vo;
    }

    @Override
    @CrmDictMethod
    public PageResult<SaleGoalVo> list(SaleGoalVo saleGoalVo) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getCusName()), (Object)"cus_name", (Object)saleGoalVo.getCusName())).like(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getCusCode()), (Object)"cus_code", (Object)saleGoalVo.getCusCode())).like(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getCusOrgName()), (Object)"cus_org_name", (Object)saleGoalVo.getCusOrgName())).like(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getCusOrgCode()), (Object)"cus_org_code", (Object)saleGoalVo.getCusOrgCode())).like(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getCusChannelName()), (Object)"cus_channel_name", (Object)saleGoalVo.getCusChannelName())).eq(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getCusChannelCode()), (Object)"cus_channel_code", (Object)saleGoalVo.getCusChannelCode())).eq(null != saleGoalVo.getType(), (Object)"type", (Object)saleGoalVo.getType())).eq(null != saleGoalVo.getTargetYear(), (Object)"target_year", (Object)saleGoalVo.getTargetYear())).eq(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getName()), (Object)"name", (Object)saleGoalVo.getName())).like(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getGoodsName()), (Object)"goods_name", (Object)saleGoalVo.getGoodsName())).eq(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getGoodsCode()), (Object)"goods_code", (Object)saleGoalVo.getGoodsCode())).like(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getProductLevelName()), (Object)"product_level_name", (Object)saleGoalVo.getProductLevelName())).eq(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getProductLevelCode()), (Object)"product_level_code", (Object)saleGoalVo.getProductLevelCode())).like(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getOrgCode()), (Object)"org_code", (Object)saleGoalVo.getOrgCode())).like(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getOrgName()), (Object)"org_name", (Object)saleGoalVo.getOrgName())).eq(!Objects.isNull(saleGoalVo.getObjectType()), (Object)"object_type", (Object)saleGoalVo.getObjectType())).eq(!Objects.isNull(saleGoalVo.getTaskType()), (Object)"task_type", (Object)saleGoalVo.getTaskType())).like(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getTerminalCode()), (Object)"terminal_code", (Object)saleGoalVo.getTerminalCode())).like(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getTerminalName()), (Object)"terminal_name", (Object)saleGoalVo.getTerminalName())).eq(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getContractCode()), (Object)"contract_code", (Object)saleGoalVo.getContractCode())).orderByDesc((Object[])new String[]{"create_date", "create_date_second"});
        Page page = PageUtil.buildPage((Integer)saleGoalVo.getPageNum(), (Integer)saleGoalVo.getPageSize());
        List<SaleGoalVo> list = this.saleGoalMapper.list(page, (QueryWrapper<SaleGoalVo>)wrapper);
        if (!CollectionUtils.isEmpty(list)) {
            Map<String, SaleGoalItemVo> detailMap = this.saleGoalItemService.findBySaleGoalIds(list.stream().map(UuidVo::getId).collect(Collectors.toList()));
            for (SaleGoalVo vo : list) {
                vo.setTargetNumStr(vo.getTargetNum().stripTrailingZeros().toPlainString());
                vo.setSaleGoalItemVo(detailMap.get(vo.getId()));
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional
    public void delByIds(ArrayList<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        List<SaleGoalVo> vos = this.findByIds(ids);
        ValidateUtils.validate(vos, (String)"\u8bf7\u6307\u5b9a\u9700\u8981\u67e5\u8be2\u7684\u9500\u552e\u76ee\u6807\uff01");
        this.saleGoalMapper.deleteBatchIds(ids);
        vos.forEach(vo -> this.crmLogSendUtil.sendForDel(menuCodeObj.toString(), vo.getId(), vo.getId(), vo));
    }

    @Override
    @Transactional
    public void delByParam(SaleGoalVo saleGoalVo) {
        if (null == saleGoalVo) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u67e5\u8be2\u6761\u4ef6!");
        }
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getCusName()), (Object)"cus_name", (Object)saleGoalVo.getCusName())).eq(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getCusCode()), (Object)"cus_code", (Object)saleGoalVo.getCusCode())).like(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getCusOrgName()), (Object)"cus_org_name", (Object)saleGoalVo.getCusOrgName())).eq(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getCusOrgCode()), (Object)"cus_org_code", (Object)saleGoalVo.getCusOrgCode())).like(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getCusChannelName()), (Object)"cus_channel_name", (Object)saleGoalVo.getCusChannelName())).eq(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getCusChannelCode()), (Object)"cus_channel_code", (Object)saleGoalVo.getCusChannelCode())).eq(null != saleGoalVo.getType(), (Object)"type", (Object)saleGoalVo.getType())).eq(null != saleGoalVo.getTargetYear(), (Object)"target_year", (Object)saleGoalVo.getTargetYear())).like(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getGoodsName()), (Object)"goods_name", (Object)saleGoalVo.getGoodsName())).eq(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getGoodsCode()), (Object)"goods_code", (Object)saleGoalVo.getGoodsCode())).like(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getProductLevelName()), (Object)"product_level_name", (Object)saleGoalVo.getProductLevelName())).eq(!org.springframework.util.StringUtils.isEmpty((Object)saleGoalVo.getProductLevelCode()), (Object)"product_level_code", (Object)saleGoalVo.getProductLevelCode());
        List entities = this.saleGoalMapper.selectList((Wrapper)wrapper);
        List copies = CrmBeanUtil.copyList((List)entities, SaleGoalVo.class);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        this.saleGoalMapper.delete((Wrapper)wrapper);
        copies.forEach(copy -> this.crmLogSendUtil.sendForDel(menuCodeObj.toString(), copy.getId(), copy.getId(), copy));
    }

    @Override
    public List<SaleGoalVo> replace(List<SaleGoalVo> saleGoalVos, String contractCode, String indexCode, SaleContractVo saleContractVo) {
        ValidateUtils.validate((Object)contractCode, (String)"\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtil.listEmpty(saleGoalVos)) {
            return Lists.newArrayList();
        }
        saleGoalVos.forEach(vo -> {
            SaleGoalRatioVo ratioVo = this.saleGoalRatioService.findMonthRatio(vo.getTargetYear(), saleContractVo);
            SaleGoalUtil.sharingMonthByYear(ratioVo, vo);
        });
        List<SaleGoalVo> dbVos = this.findDetailsByContractCodeAndIndexCode(contractCode, indexCode);
        List<SaleGoalVo> addVos = saleGoalVos.stream().filter(vo -> org.springframework.util.StringUtils.isEmpty((Object)vo.getId())).collect(Collectors.toList());
        addVos.forEach(sale -> {
            sale.setContractCode(contractCode);
            sale.setIndexCode(indexCode);
        });
        if (CollectionUtil.listNotEmpty(addVos)) {
            this.addBatch(addVos);
        }
        List<SaleGoalVo> updateVos = saleGoalVos.stream().filter(vo -> !org.springframework.util.StringUtils.isEmpty((Object)vo.getId())).collect(Collectors.toList());
        updateVos.forEach(vo -> this.edit((SaleGoalVo)vo));
        List<String> deleteIds = this.difference(dbVos, saleGoalVos);
        this.delByIds(new ArrayList<String>(deleteIds));
        return saleGoalVos;
    }

    private List<String> difference(List<SaleGoalVo> dbVos, List<SaleGoalVo> vos) {
        Set<String> ids;
        Set<String> dbIds = dbVos.stream().collect(Collectors.groupingBy(UuidVo::getId)).keySet();
        Sets.SetView differenceIds = Sets.difference(dbIds, ids = vos.stream().filter(vo -> StringUtils.isNotEmpty((String)vo.getId())).collect(Collectors.groupingBy(UuidVo::getId)).keySet());
        if (!CollectionUtil.collectionNotEmpty((Collection)differenceIds)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)differenceIds);
    }

    @Override
    @Transactional
    public void deleteByContractCode(String contractCode) {
        if (org.springframework.util.StringUtils.isEmpty((Object)contractCode)) {
            return;
        }
        List entities = this.saleGoalMapper.selectList((Wrapper)Wrappers.query().eq((Object)"contract_code", (Object)contractCode));
        if (CollectionUtil.listEmpty((List)entities)) {
            return;
        }
        ArrayList goalIds = Lists.newArrayList(entities.stream().collect(Collectors.toMap(BaseIdEntity::getId, a -> a)).keySet());
        this.saleGoalItemService.deleteByGoalIds(goalIds);
        this.delByIds(goalIds);
    }

    @Override
    public List<SaleGoalVo> findDetailsByContractCodeAndIndexCode(String contractCode, String indexCode) {
        if (org.springframework.util.StringUtils.isEmpty((Object)contractCode)) {
            return Lists.newArrayList();
        }
        List entities = this.saleGoalMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"contract_code", (Object)contractCode)).eq((Object)"index_code", (Object)indexCode)).orderByAsc((Object)"create_date")).orderByAsc((Object)"create_date_second"));
        List saleGoalVos = CrmBeanUtil.copyList((List)entities, SaleGoalVo.class);
        if (CollectionUtil.listEmpty((List)saleGoalVos)) {
            return Lists.newArrayList();
        }
        saleGoalVos.forEach(vo -> {
            SaleGoalItemVo itemVo = this.saleGoalItemService.findBySaleGoalId(vo.getId());
            vo.setSaleGoalItemVo(itemVo);
        });
        return saleGoalVos;
    }

    private List<SaleGoalVo> findByIds(ArrayList<String> ids) {
        List vos = null;
        ValidateUtils.validate(ids, (String)"\u8bf7\u6307\u5b9a\u9700\u8981\u67e5\u8be2\u7684\u9500\u552e\u76ee\u6807\uff01");
        List entities = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).list();
        if (null == entities) {
            return vos;
        }
        vos = CrmBeanUtil.copyList((List)entities, SaleGoalVo.class);
        Map<String, SaleGoalItemVo> detailMap = this.saleGoalItemService.findBySaleGoalIds(ids);
        Iterator iterator = vos.iterator();
        while (iterator.hasNext()) {
            SaleGoalVo vo;
            vo.setTargetNumStr((vo = (SaleGoalVo)iterator.next()).getTargetNum() == null ? null : vo.getTargetNum().stripTrailingZeros().toPlainString());
            vo.setSaleGoalItemVo(detailMap.get(vo.getId()));
        }
        return vos;
    }
}

