package com.biz.crm.capital.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.capital.service.CapitalFlowService;
import com.biz.crm.capital.service.CapitalService;
import com.biz.crm.nebular.fee.capital.CapitalFlowVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/8 17:37
 **/
@Api(value = "管理端-资金", tags = "管理端-资金")
@RestController
@RequestMapping("/m/capital")
public class CapitalmController {

    @Resource
    private CapitalService capitalService;

    @Resource
    private CapitalFlowService capitalFlowService;


    @CrmLog
    @ApiOperation(value = "新增")
    @PostMapping(value = "add")
    public Result add(@RequestBody CapitalFlowVo capitalFlowVo) {
        capitalFlowService.add(capitalFlowVo);
        return Result.ok();
    }
}
