package com.biz.crm.pool.controller;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailLogPageReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailLogPageRespVo;
import com.biz.crm.pool.service.FeePoolDetailLogService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 费用池明细操作记录表
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Slf4j
@RestController
@RequestMapping("/feePoolDetailLogController")
@Api(tags = "FEE-产品组-费用池明细表操作记录表")
public class FeePoolDetailLogController {

    @Resource
    private FeePoolDetailLogService feePoolDetailLogService;

    @ApiOperation(value = "（费用池管理页面专用）费用池明细操作记录表分页列表")
    @PostMapping("/findFeePoolDetailLogList")
    public Result<PageResult<FeePoolDetailLogPageRespVo>> findFeePoolDetailLogList(@RequestBody FeePoolDetailLogPageReqVo reqVo) {
        return Result.ok(feePoolDetailLogService.findFeePoolDetailLogList(reqVo));
    }

    @ApiOperation(value = "（费用池管理页面专用）费用池明细操作记录表分页列表，按照配置编码")
    @PostMapping("/findFeePoolDetailLogListByConfigCode")
    public Result<PageResult<FeePoolDetailLogPageRespVo>> findFeePoolDetailLogListByConfigCode(@RequestBody FeePoolDetailLogPageReqVo reqVo) {
        return Result.ok(feePoolDetailLogService.findFeePoolDetailLogListByConfigCode(reqVo));
    }

    @ApiOperation(value = "（费用池管理页面专用）费用池明细操作记录表分页列表，按照费用池编号")
    @PostMapping("/findFeePoolDetailLogListByPoolCode")
    public Result<PageResult<FeePoolDetailLogPageRespVo>> findFeePoolDetailLogListByPoolCode(@RequestBody FeePoolDetailLogPageReqVo reqVo) {
        return Result.ok(feePoolDetailLogService.findFeePoolDetailLogListByPoolCode(reqVo));
    }

    @ApiOperation(value = "（费用池管理页面专用）费用池明细操作记录表分页列表，按照费用池明细编号")
    @PostMapping("/findFeePoolDetailLogListByPoolDetailCode")
    public Result<PageResult<FeePoolDetailLogPageRespVo>> findFeePoolDetailLogListByPoolDetailCode(@RequestBody FeePoolDetailLogPageReqVo reqVo) {
        return Result.ok(feePoolDetailLogService.findFeePoolDetailLogListByPoolDetailCode(reqVo));
    }

    @ApiOperation(value = "（费用池管理页面专用）费用池明细操作记录表分页列表，按照操作记录编号")
    @PostMapping("/findFeePoolDetailLogListByOperationCode")
    public Result<PageResult<FeePoolDetailLogPageRespVo>> findFeePoolDetailLogListByOperationCode(@RequestBody FeePoolDetailLogPageReqVo reqVo) {
        return Result.ok(feePoolDetailLogService.findFeePoolDetailLogListByOperationCode(reqVo));
    }

}
