package com.biz.crm.pool.controller;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.fee.pool.req.FeePoolOperationPageReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolOperationPageRespVo;
import com.biz.crm.pool.service.FeePoolOperationService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 费用池操作记录表
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Slf4j
@RestController
@RequestMapping("/feePoolOperationController")
@Api(tags = "FEE-产品组-费用池主表操作记录表")
public class FeePoolOperationController {

    @Resource
    private FeePoolOperationService feePoolOperationService;

    @ApiOperation(value = "（费用池管理页面专用）查询费用池操作记录分页列表")
    @PostMapping("/findFeePoolOperationPageList")
    public Result<PageResult<FeePoolOperationPageRespVo>> findFeePoolOperationPageList(@RequestBody FeePoolOperationPageReqVo reqVo) {
        return Result.ok(feePoolOperationService.findFeePoolOperationPageList(reqVo));
    }

    @ApiOperation(value = "（费用池管理页面专用）查询费用池操作记录分页列表，按照配置编码")
    @PostMapping("/findFeePoolOperationPageListByConfigCode")
    public Result<PageResult<FeePoolOperationPageRespVo>> findFeePoolOperationPageListByConfigCode(@RequestBody FeePoolOperationPageReqVo reqVo) {
        return Result.ok(feePoolOperationService.findFeePoolOperationPageListByConfigCode(reqVo));
    }

    @ApiOperation(value = "（费用池管理页面专用）查询费用池操作记录分页列表，按照费用池编号筛选")
    @PostMapping("/findFeePoolOperationPageListByPoolCode")
    public Result<PageResult<FeePoolOperationPageRespVo>> findFeePoolOperationPageListByPoolCode(@RequestBody FeePoolOperationPageReqVo reqVo) {
        return Result.ok(feePoolOperationService.findFeePoolOperationPageListByPoolCode(reqVo));
    }

}
