package com.biz.crm.pool.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsProductGroupReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolPageReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolGoodsProductGroupRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolPageRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolRespVo;
import com.biz.crm.pool.model.FeePoolEntity;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 费用池主表
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
public interface FeePoolMapper extends BaseMapper<FeePoolEntity> {

    /**
     * 查询费用池主表列表
     *
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(custCode = "customer_code")
    List<FeePoolPageRespVo> findFeePoolPageList(Page<FeePoolPageRespVo> page, @Param("vo") FeePoolPageReqVo reqVo);

    /**
     * 查询货补费用池商品组列表
     *
     * @param page
     * @param reqVo
     * @param poolType
     * @return
     */
    List<FeePoolGoodsProductGroupRespVo> findFeePoolGoodsProductGroupList(Page<FeePoolGoodsProductGroupRespVo> page, @Param("vo") FeePoolGoodsProductGroupReqVo reqVo, @Param("poolType") String poolType, @Param("productLevelCodeList") List<String> productLevelCodeList, @Param("productLikeList") List<Map<String, String>> productLikeList);

    /**
     * 计算客户的可用余额
     *
     * @param poolGroup    费用池分组
     * @param poolType     费用池类型
     * @param customerCode 客户编码
     * @return
     */
    BigDecimal sumUsableAmount(@Param("poolGroup") String poolGroup, @Param("poolType") String poolType, @Param("customerCode") String customerCode);

    /**
     * 计算客户本月可用金额
     *
     * @param poolGroup    费用池分组
     * @param poolType     费用池类型
     * @param customerCode 客户编码
     * @param yearMonth    年月
     * @return
     */
    BigDecimal sumThisMonthUsableAmount(@Param("poolGroup") String poolGroup, @Param("poolType") String poolType, @Param("customerCode") String customerCode, @Param("yearMonth") String yearMonth);

    /**
     * 计算客户当月上账金额
     *
     * @param poolGroup    费用池分组
     * @param poolType     费用池类型
     * @param customerCode 客户编码
     * @param yearMonth    年月
     * @return
     */
    BigDecimal sumThisMonthAccountAmount(@Param("poolGroup") String poolGroup, @Param("poolType") String poolType, @Param("customerCode") String customerCode, @Param("yearMonth") String yearMonth);

    /**
     * 计算客户的上月剩余可用余额
     *
     * @param poolGroup    费用池分组
     * @param poolType     费用池类型
     * @param customerCode 客户编号
     * @param yearMonth    年月
     * @return
     */
    BigDecimal sumLastMonthUsableAmount(@Param("poolGroup") String poolGroup, @Param("poolType") String poolType, @Param("customerCode") String customerCode, @Param("yearMonth") String yearMonth);

    /**
     * 计算客户当月使用金额
     *
     * @param poolGroup         费用池分组
     * @param poolType          费用池类型
     * @param customerCode      客户编码
     * @param yearMonth         年月
     * @param operationTypeList 统计的操作类型集合
     * @return
     */
    BigDecimal sumThisMonthHasUseAmount(@Param("poolGroup") String poolGroup, @Param("poolType") String poolType, @Param("customerCode") String customerCode, @Param("yearMonth") String yearMonth, @Param("operationTypeList") List<String> operationTypeList);


}
