package com.biz.crm.pool.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.fee.pool.req.FeePoolOperationPageReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolOperationPageRespVo;
import com.biz.crm.pool.model.FeePoolOperationEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 费用池操作记录表
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
public interface FeePoolOperationMapper extends BaseMapper<FeePoolOperationEntity> {

    /**
     * 查询费用池操作记录分页列表
     *
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(custCode = "a.customer_code")
    List<FeePoolOperationPageRespVo> findFeePoolOperationPageList(Page<FeePoolOperationPageRespVo> page, @Param("vo") FeePoolOperationPageReqVo reqVo);

}
