package com.biz.crm.pool.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.fee.pool.req.FeePoolFileReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolFileRespVo;
import com.biz.crm.pool.model.FeePoolFileEntity;

import java.util.List;
import java.util.Map;

/**
 * 费用池附件表
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
public interface FeePoolFileService extends IService<FeePoolFileEntity> {

    /**
     * 根据操作记录编号分组查询附件集合
     *
     * @param operationCodeList
     * @return
     */
    Map<String, List<FeePoolFileRespVo>> getFeePoolFileListGroupByOperationCodeList(List<String> operationCodeList);

    /**
     * 根据操作记录编号查询附件集合
     *
     * @param operationCode
     * @return
     */
    List<FeePoolFileRespVo> getFeePoolFileListByOperationCode(String operationCode);

    /**
     * 保存附件
     *
     * @param poolCode      费用池编号
     * @param operationCode 操作记录编号
     * @param list          附件集合
     */
    void savePoolFileList(String poolCode, String operationCode, List<FeePoolFileReqVo> list);

}

