package com.biz.crm.pool.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.fee.pool.req.FeePoolFileReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsProductGroupReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsUseByPoolProductItemReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsUseByProductLevelItemReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolGoodsProductGroupRespVo;

import java.util.List;

/**
 * 货补费用池
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
public interface FeePoolGoodsService {

    /**
     * 查询货补费用池商品组列表
     *
     * @param reqVo
     * @return
     */
    PageResult<FeePoolGoodsProductGroupRespVo> findFeePoolGoodsProductGroupList(FeePoolGoodsProductGroupReqVo reqVo);

    /**
     * 使用货补费用池，按照（费用池+商品）维度
     *
     * @param operationType       操作类型
     * @param fromCode            来源单号
     * @param fromDesc            来源描述
     * @param remarks             备注
     * @param poolProductItemList 使用明细（费用池+商品维度）
     * @param fileList            附件
     */
    void useGoodsAmountByPoolProductList(String poolGroup, String useType, String operationType, String fromCode, String fromDesc, String remarks, List<FeePoolGoodsUseByPoolProductItemReqVo> poolProductItemList, List<FeePoolFileReqVo> fileList);

    /**
     * 使用货补费用池，按照（产品层级）维度
     *
     * @param operationType        操作类型
     * @param fromCode             来源单号
     * @param fromDesc             来源描述
     * @param remarks              备注
     * @param productLevelItemList 使用明细（产品层级维度）
     * @param fileList             附件
     * @param customerCode         客户编码
     */
    void useGoodsAmountByProductLevelList(String poolGroup, String useType, String operationType, String fromCode, String fromDesc, String remarks, List<FeePoolGoodsUseByProductLevelItemReqVo> productLevelItemList, List<FeePoolFileReqVo> fileList, String customerCode);

    /**
     * 占用货补费用池，按照（费用池+商品）维度
     *
     * @param operationType       操作类型
     * @param fromCode            来源单号
     * @param fromDesc            来源描述
     * @param remarks             备注
     * @param poolProductItemList 使用明细（费用池+商品维度）
     * @param fileList            附件
     */
    void occupyGoodsAmountByPoolProductList(String poolGroup, String useType, String operationType, String fromCode, String fromDesc, String remarks, List<FeePoolGoodsUseByPoolProductItemReqVo> poolProductItemList, List<FeePoolFileReqVo> fileList);

    /**
     * 占用货补费用池，按照（产品层级）维度
     *
     * @param operationType        操作类型
     * @param fromCode             来源单号
     * @param fromDesc             来源描述
     * @param remarks              备注
     * @param productLevelItemList 使用明细（产品层级维度）
     * @param fileList             附件
     * @param customerCode         客户编码
     */
    void occupyGoodsAmountByProductLevelList(String poolGroup, String useType, String operationType, String fromCode, String fromDesc, String remarks, List<FeePoolGoodsUseByProductLevelItemReqVo> productLevelItemList, List<FeePoolFileReqVo> fileList, String customerCode);
}

