package com.biz.crm.pool.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.IsShelfEnum;
import com.biz.crm.eunm.fee.FeePoolGroupEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeGroupEnum;
import com.biz.crm.eunm.fee.FeePoolTypeEnum;
import com.biz.crm.mdm.pricesetting.MdmPriceSettingFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.nebular.fee.pool.req.*;
import com.biz.crm.nebular.fee.pool.resp.FeePoolGoodsProductGroupRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolGoodsProductRespVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSearchReqVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceResp;
import com.biz.crm.nebular.mdm.product.req.MdmProductQueryReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductMediaRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductQueryRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.pool.mapper.FeePoolMapper;
import com.biz.crm.pool.model.FeePoolDetailEntity;
import com.biz.crm.pool.model.FeePoolEntity;
import com.biz.crm.pool.service.*;
import com.biz.crm.util.*;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 费用池主表接口实现
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "FeePoolGoodsServiceExpandImpl")
public class FeePoolGoodsServiceImpl implements FeePoolGoodsService {

    @Resource
    private FeePoolMapper feePoolMapper;
    @Resource
    private FeePoolService feePoolService;
    @Resource
    private FeePoolOperationService feePoolOperationService;
    @Resource
    private FeePoolDetailService feePoolDetailService;
    @Resource
    private FeePoolDetailLogService feePoolDetailLogService;
    @Resource
    private MdmProductFeign mdmProductFeign;
    @Resource
    private MdmPriceSettingFeign mdmPriceSettingFeign;

    @Override
    public PageResult<FeePoolGoodsProductGroupRespVo> findFeePoolGoodsProductGroupList(FeePoolGoodsProductGroupReqVo reqVo) {
        if (StringUtils.isEmpty(reqVo.getPoolGroup())) {
            reqVo.setPoolGroup(FeePoolGroupEnum.DEFAULT.getValue());
        }
        Assert.hasText(reqVo.getCustomerCode(), "缺失客户编码");
        Page<FeePoolGoodsProductGroupRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        Result<List<MdmProductQueryRespVo>> productQueryResult = mdmProductFeign.queryProductList(new MdmProductQueryReqVo().setIsShelf(IsShelfEnum.UP.getCode()).setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()).setProductCode(reqVo.getGoodsProductCode()).setProductName(reqVo.getGoodsProductName()));
        Assert.isTrue(productQueryResult.isSuccess(), "查询商品失败：" + productQueryResult.getMessage());
        List<MdmProductQueryRespVo> productQueryList = productQueryResult.getResult();
        if (CollectionUtil.listEmpty(productQueryList)) {
            return PageResult.<FeePoolGoodsProductGroupRespVo>builder()
                    .data(new ArrayList<>())
                    .count(0L)
                    .build();
        }
        List<String> productCodeList = productQueryList.stream().filter(x -> StringUtils.isNotEmpty(x.getProductLevelCode())).map(MdmProductQueryRespVo::getProductCode).distinct().collect(Collectors.toList());
        List<Map<String, String>> productLikeMapList = productCodeList.stream().map(x -> {
            Map<String, String> map = new HashMap<>(4);
            map.put("likeLeft", "%," + x);
            map.put("likeRight", x + ",%");
            map.put("like", "%," + x + ",%");
            map.put("equals", x);
            return map;
        }).collect(Collectors.toList());
        List<String> strings = productQueryList.stream().filter(x -> StringUtils.isNotEmpty(x.getProductLevelCode())).map(MdmProductQueryRespVo::getProductLevelCode).distinct().collect(Collectors.toList());
        List<String> productLevelCodeList = ProductLevelUtil.getParentProductLevelCodeListIncludeSelfEnable(strings);
        List<FeePoolGoodsProductGroupRespVo> list = feePoolMapper.findFeePoolGoodsProductGroupList(page, reqVo, FeePoolTypeEnum.GOODS.getValue(), productLevelCodeList, productLikeMapList);
        if (CollectionUtil.listEmpty(list)) {
            return PageResult.<FeePoolGoodsProductGroupRespVo>builder()
                    .data(new ArrayList<>())
                    .count(0L)
                    .build();
        }
        Set<String> paramProductLevelCodeSet = list.stream().filter(item -> StringUtils.isNotEmpty(item.getGoodsProductLevelCode()) && StringUtils.isEmpty(item.getGoodsProductCode())).map(item -> Arrays.asList(item.getGoodsProductLevelCode().split(","))).flatMap(Collection::stream).collect(Collectors.toSet());
        Set<String> paramProductCodeSet = list.stream().filter(item -> StringUtils.isNotEmpty(item.getGoodsProductCode())).map(item -> Arrays.asList(item.getGoodsProductCode().split(","))).flatMap(Collection::stream).collect(Collectors.toSet());

        Set<String> goodsProductCodeSet = new HashSet<>(16);
        if (!paramProductCodeSet.isEmpty()) {
            goodsProductCodeSet.addAll(paramProductCodeSet);
        }
        if (!paramProductLevelCodeSet.isEmpty()) {
            Result<List<MdmProductQueryRespVo>> productQueryByProductLevelResult = mdmProductFeign.queryProductList(new MdmProductQueryReqVo().setIsShelf(IsShelfEnum.UP.getCode()).setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()).setProductCode(reqVo.getGoodsProductCode()).setProductName(reqVo.getGoodsProductName()).setUnderProductLevelCodeList(new ArrayList<>(paramProductLevelCodeSet)));
            Assert.isTrue(productQueryByProductLevelResult.isSuccess(), "查询商品失败：" + productQueryByProductLevelResult.getMessage());
            if (CollectionUtil.listNotEmptyNotSizeZero(productQueryByProductLevelResult.getResult())) {
                goodsProductCodeSet.addAll(productQueryByProductLevelResult.getResult().stream().map(MdmProductQueryRespVo::getProductCode).collect(Collectors.toSet()));
            }
        }
        if (goodsProductCodeSet.isEmpty()) {
            return PageResult.<FeePoolGoodsProductGroupRespVo>builder()
                    .data(new ArrayList<>())
                    .count(0L)
                    .build();
        }
        Result<List<MdmProductQueryRespVo>> productQueryByProductResult = mdmProductFeign.queryProductList(new MdmProductQueryReqVo().setIsShelf(IsShelfEnum.UP.getCode()).setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()).setProductCode(reqVo.getGoodsProductCode()).setProductName(reqVo.getGoodsProductName()).setProductCodeList(new ArrayList<>(goodsProductCodeSet)));
        Assert.isTrue(productQueryByProductResult.isSuccess(), "查询商品失败：" + productQueryByProductResult.getMessage());

        final List<MdmProductQueryRespVo> usableProductList = productQueryByProductResult.getResult();
        final Set<String> usableProductCodeSet = usableProductList.stream().map(MdmProductQueryRespVo::getProductCode).collect(Collectors.toSet());

        Map<String, List<MdmProductMediaRespVo>> productPictureMap = new HashMap<>(16);
        if (!usableProductCodeSet.isEmpty()) {
            Result<List<MdmProductMediaRespVo>> pictureResult = mdmProductFeign.queryBatchProductPictureList(new ArrayList<>(usableProductCodeSet));
            Assert.isTrue(pictureResult.isSuccess(), "查询商品图片失败：" + pictureResult.getMessage());
            productPictureMap = pictureResult.getResult().stream().collect(Collectors.groupingBy(MdmProductMediaRespVo::getProductCode));
        }
        final Map<String, String> productMainPictureMap = productPictureMap.entrySet().stream().collect(Collectors.toMap(k -> k.getKey(), v -> {
            String mainPictureUrl = "";
            List<MdmProductMediaRespVo> value = v.getValue();
            if (value != null && value.size() > 0) {
                for (MdmProductMediaRespVo item :
                        value) {
                    if (StringUtils.isNotEmpty(item.getUrlAddress())) {
                        mainPictureUrl = item.getUrlAddress();
                        break;
                    }
                }
            }
            return mainPictureUrl;
        }));

        Map<String, Map<String, MdmPriceResp>> productPriceSearchMap = new HashMap<>(16);
        final String conditionType = reqVo.getConditionType();
        final boolean priceSearch = StringUtils.isNotEmpty(conditionType);
        if (priceSearch) {
            MdmPriceSearchReqVo searchReqVo = new MdmPriceSearchReqVo();
            searchReqVo.setCustomerCode(reqVo.getCustomerCode());
            searchReqVo.setProductCodeList(new ArrayList<>(usableProductCodeSet));
            searchReqVo.setSearchTime(DateUtil.dateNow2Str());
            searchReqVo.setConditionTypeCodeList(Collections.singletonList(conditionType));
            Result<Map<String, Map<String, MdmPriceResp>>> search = mdmPriceSettingFeign.search(searchReqVo);
            Assert.isTrue(search.isSuccess(), "查询价格失败");
            productPriceSearchMap = search.getResult();
        }
        final Map<String, BigDecimal> productPriceMap = priceSearch ? productPriceSearchMap.values().stream().filter(item -> item.containsKey(conditionType) && item.get(conditionType) != null).map(item -> item.get(conditionType)).collect(Collectors.toMap(MdmPriceResp::getProductCode, MdmPriceResp::getPrice)) : new HashMap<>(16);
        final Map<String, MdmProductQueryRespVo> usableProductMap = usableProductList.stream().collect(Collectors.toMap(MdmProductQueryRespVo::getProductCode, v -> v));
        final Map<String, String> saleUnitMap = DictUtil.dictMap(DictConstant.PRODUCT_SALE_UNIT);

        list.forEach(item -> {
            List<FeePoolGoodsProductRespVo> productList = new ArrayList<>();
            List<String> goodsProductCodeList = new ArrayList<>();
            if (StringUtils.isNotEmpty(item.getGoodsProductCode())) {
                goodsProductCodeList.addAll(Arrays.asList(item.getGoodsProductCode().split(",")).stream().filter(x -> usableProductCodeSet.contains(x)).collect(Collectors.toList()));
            } else if (StringUtils.isNotEmpty(item.getGoodsProductLevelCode())) {
                List<String> goodsProductLevelChildrenCodeList = ProductLevelUtil.getChildrenProductLevelCodeListIncludeSelfEnable(Arrays.asList(item.getGoodsProductLevelCode().split(",")));
                if (CollectionUtil.listNotEmptyNotSizeZero(goodsProductLevelChildrenCodeList)) {
                    final Set<String> set = new HashSet<>(goodsProductLevelChildrenCodeList);
                    goodsProductCodeList.addAll(usableProductList.stream().filter(x -> set.contains(x.getProductLevelCode())).map(MdmProductQueryRespVo::getProductCode).collect(Collectors.toList()));
                }
            } else {
                //全品类，暂不支持
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(goodsProductCodeList)) {
                productList.addAll(goodsProductCodeList.stream().map(x -> {
                    MdmProductQueryRespVo product = usableProductMap.get(x);
                    FeePoolGoodsProductRespVo goodsProduct = new FeePoolGoodsProductRespVo();
                    goodsProduct.setProductCode(product.getProductCode());
                    goodsProduct.setProductName(product.getProductName());
                    goodsProduct.setSpec(product.getSpec());
                    goodsProduct.setSaleUnit(product.getSaleUnit());
                    goodsProduct.setSaleUnitName(saleUnitMap.get(product.getSaleUnit()));
                    if (priceSearch) {
                        goodsProduct.setPrice(productPriceMap.get(product.getProductCode()));
                    }
                    if (productMainPictureMap.containsKey(product.getProductCode())) {
                        goodsProduct.setMainPictureUrl(productMainPictureMap.get(product.getProductCode()));
                    }
                    return goodsProduct;
                }).collect(Collectors.toList()));
            }
            item.setProductList(productList);
            item.setGoodsProductCode(productList.stream().map(FeePoolGoodsProductRespVo::getProductCode).collect(Collectors.joining(",")));
            item.setGoodsProductName(productList.stream().map(FeePoolGoodsProductRespVo::getProductName).collect(Collectors.joining(",")));
        });
        return PageResult.<FeePoolGoodsProductGroupRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void useGoodsAmountByPoolProductList(String poolGroup, String useType, String operationType, String fromCode, String fromDesc, String remarks, List<FeePoolGoodsUseByPoolProductItemReqVo> poolProductItemList, List<FeePoolFileReqVo> fileList) {
        Assert.hasText(operationType, "缺失操作类型");
        String operationTypeValue = DictUtil.dictValue(DictConstant.FEE_POOL_OPERATION_TYPE, operationType);
        Assert.hasText(operationTypeValue, "无效的操作类型");
        Assert.notEmpty(poolProductItemList, "缺失使用明细");
        Assert.isTrue(FeePoolConfigUtil.checkOperationTypeGroup(operationType, FeePoolOperationTypeGroupEnum.USE), "该操作类型不能使用费用池" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC);
        if (FeePoolOperationTypeEnum.ORDER_USE.getValue().equals(operationType)) {
            Assert.hasText(fromCode, operationTypeValue + "必须有来源单号");
        }
        poolProductItemList.forEach(x -> {
            Assert.hasText(x.getPoolCode(), "缺失费用池编码");
            Assert.hasText(x.getProductCode(), "缺失商品编码");
            Assert.isTrue(x.getAmount() != null, "缺失使用" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC);
            Assert.isTrue(x.getAmount().compareTo(BigDecimal.ZERO) >= 0, "使用" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "不能小于0");
        });
        Result<List<MdmProductRespVo>> result = mdmProductFeign.queryBatchByProductCodeList(poolProductItemList.stream().map(FeePoolGoodsUseByPoolProductItemReqVo::getProductCode).collect(Collectors.toList()));
        Assert.isTrue(result.isSuccess(), "查询商品失败");
        final Map<String, MdmProductRespVo> productMap = result.getResult().stream().collect(Collectors.toMap(MdmProductRespVo::getProductCode, v -> v));
        poolProductItemList.forEach(x -> {
            Assert.isTrue(productMap.containsKey(x.getProductCode()), "商品编码【" + x.getProductCode() + "】不存在");
        });
        final Map<String, List<FeePoolGoodsUseByPoolProductItemReqVo>> groupByPoolCodeMap = poolProductItemList.stream().collect(Collectors.groupingBy(FeePoolGoodsUseByPoolProductItemReqVo::getPoolCode));

        String operationDateTime = DateUtil.dateNowHms();
        FeePoolOperationTypeGroupEnum operationTypeGroupEnum = FeePoolConfigUtil.getOperationTypeGroup(operationType);
        for (Map.Entry<String, List<FeePoolGoodsUseByPoolProductItemReqVo>> entry :
                groupByPoolCodeMap.entrySet()) {
            String poolCode = entry.getKey();
            List<FeePoolGoodsUseByPoolProductItemReqVo> itemList = entry.getValue();
            FeePoolEntity pool = feePoolService.lambdaQuery()
                    .eq(FeePoolEntity::getPoolCode, entry.getKey())
                    .one();

            BigDecimal amount = itemList.stream().map(FeePoolGoodsUseByPoolProductItemReqVo::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            Assert.notNull(pool, "未找到费用池[" + poolCode + "]");
            Assert.isTrue(pool.getUsableAmount().compareTo(amount) >= 0, "费用池" + poolCode + "可以余额不足");

            pool.setHasUseAmount(pool.getHasUseAmount().add(amount));
            pool.setUsableAmount(pool.getUsableAmount().subtract(amount));
            feePoolService.updateById(pool);

            FeePoolOperationReqVo operationReqVo = new FeePoolOperationReqVo();
            operationReqVo.setPoolCode(pool.getPoolCode());
            operationReqVo.setOperationType(operationType);
            operationReqVo.setFromCode(fromCode);
            operationReqVo.setFromDesc(StringUtils.isNotEmpty(fromDesc) ? fromDesc : operationTypeValue);
            operationReqVo.setOperationDateTime(operationDateTime);
            operationReqVo.setOperationAmount(amount.multiply(operationTypeGroupEnum.getUsableAmountWeight()));
            operationReqVo.setFileList(fileList);
            operationReqVo.setRemarks(remarks);
            String operationCode = feePoolOperationService.savePoolOperation(operationReqVo);

            List<FeePoolDetailEntity> poolDetailList = feePoolDetailService.lambdaQuery()
                    .eq(FeePoolDetailEntity::getPoolCode, poolCode)
                    .orderByAsc(FeePoolDetailEntity::getAccountDateTime)
                    .list();

            List<FeePoolDetailLogReqVo> detailLogList = new ArrayList<>();
            for (FeePoolGoodsUseByPoolProductItemReqVo useItem :
                    itemList) {
                BigDecimal restAmount = useItem.getAmount();
                for (FeePoolDetailEntity poolDetail :
                        poolDetailList) {
                    if (restAmount.compareTo(BigDecimal.ZERO) <= 0) {
                        break;
                    }
                    if (poolDetail.getUsableAmount().compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal itemUse = BigDecimal.ZERO;
                        if (poolDetail.getUsableAmount().compareTo(restAmount) >= 0) {
                            itemUse = restAmount;
                        } else {
                            itemUse = poolDetail.getUsableAmount();
                        }
                        restAmount = restAmount.subtract(itemUse);
                        poolDetail.setHasUseAmount(poolDetail.getHasUseAmount().add(itemUse));
                        poolDetail.setUsableAmount(poolDetail.getUsableAmount().subtract(itemUse));

                        FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
                        detailLog.setPoolCode(poolCode);
                        detailLog.setPoolDetailCode(poolDetail.getPoolDetailCode());
                        detailLog.setOperationCode(operationCode);
                        detailLog.setOperationType(operationType);
                        detailLog.setFromCode(fromCode);
                        detailLog.setFromDesc(StringUtils.isNotEmpty(fromDesc) ? fromDesc : operationTypeValue);
                        detailLog.setRemarks(remarks);
                        detailLog.setOperationAmount(itemUse.multiply(operationTypeGroupEnum.getUsableAmountWeight()));
                        detailLog.setOperationDateTime(operationDateTime);
                        detailLog.setProductCode(useItem.getProductCode());
                        detailLog.setProductName(productMap.get(useItem.getProductCode()).getProductName());
                        detailLogList.add(detailLog);
                    }
                }
                Assert.isTrue(restAmount.compareTo(BigDecimal.ZERO) == 0, "费用池" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "异常");
            }
            feePoolDetailService.updateBatchById(poolDetailList);
            feePoolDetailLogService.savePoolDetailLog(detailLogList);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void useGoodsAmountByProductLevelList(String poolGroup, String useType, String operationType, String fromCode, String fromDesc, String remarks, List<FeePoolGoodsUseByProductLevelItemReqVo> productLevelItemList, List<FeePoolFileReqVo> fileList, String customerCode) {
        Assert.hasText(operationType, "缺失操作类型");
        String operationTypeValue = DictUtil.dictValue(DictConstant.FEE_POOL_OPERATION_TYPE, operationType);
        Assert.hasText(operationTypeValue, "无效的操作类型");
        Assert.notEmpty(productLevelItemList, "缺失使用明细");
        Assert.isTrue(FeePoolConfigUtil.checkOperationTypeGroup(operationType, FeePoolOperationTypeGroupEnum.USE), "该操作类型不能使用费用池" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC);
        if (FeePoolOperationTypeEnum.ORDER_USE.getValue().equals(operationType)) {
            Assert.hasText(fromCode, operationTypeValue + "必须有来源单号");
        }
        productLevelItemList.forEach(x -> {
            Assert.hasText(x.getProductLevelCode(), "缺失产品层级编码");
            Assert.isTrue(x.getAmount() != null, "缺失使用" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC);
            Assert.isTrue(x.getAmount().compareTo(BigDecimal.ZERO) >= 0, "使用" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "不能小于0");
        });
        List<MdmProductLevelRespVo> productLevelByCodeList = ProductLevelUtil.getProductLevelByCodeList(productLevelItemList.stream().map(FeePoolGoodsUseByProductLevelItemReqVo::getProductLevelCode).collect(Collectors.toList()));
        final Map<String, MdmProductLevelRespVo> productLevelMap = productLevelByCodeList.stream().collect(Collectors.toMap(MdmProductLevelRespVo::getProductLevelCode, v -> v));
        productLevelItemList.forEach(x -> {
            Assert.isTrue(productLevelMap.containsKey(x.getProductLevelCode()), "产品层级编码【" + x.getProductLevelCode() + "】不存在");
        });
        final Map<String, BigDecimal> productLevelAmountMap = productLevelItemList.stream().collect(Collectors.groupingBy(FeePoolGoodsUseByProductLevelItemReqVo::getProductLevelCode, Collectors.mapping(FeePoolGoodsUseByProductLevelItemReqVo::getAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));

        String operationDateTime = DateUtil.dateNowHms();
        FeePoolOperationTypeGroupEnum operationTypeGroupEnum = FeePoolConfigUtil.getOperationTypeGroup(operationType);
        for (Map.Entry<String, BigDecimal> entry :
                productLevelAmountMap.entrySet()) {
            String productLevelCode = entry.getKey();
            String productLevelName = productLevelMap.get(productLevelCode).getProductLevelName();
            List<FeePoolEntity> collect = feePoolService.lambdaQuery()
                    .eq(FeePoolEntity::getPoolType, FeePoolTypeEnum.GOODS.getValue())
                    .eq(FeePoolEntity::getCustomerCode, customerCode)
                    .eq(FeePoolEntity::getGoodsProductLevelCode, productLevelCode)
                    .list()
                    .stream().filter(x -> StringUtils.isEmpty(x.getGoodsProductCode())).collect(Collectors.toList());
            Assert.notEmpty(collect, "未找到产品层级【" + productLevelName + "】的货补费用池");
            FeePoolEntity pool = collect.get(0);
            BigDecimal amount = entry.getValue();
            Assert.isTrue(pool.getUsableAmount().compareTo(amount) >= 0, "产品层级【" + productLevelName + "】的货补可用余额不足");
            pool.setHasUseAmount(pool.getHasUseAmount().add(amount));
            pool.setUsableAmount(pool.getUsableAmount().subtract(amount));
            feePoolService.updateById(pool);

            FeePoolOperationReqVo operationReqVo = new FeePoolOperationReqVo();
            operationReqVo.setPoolCode(pool.getPoolCode());
            operationReqVo.setOperationType(operationType);
            operationReqVo.setFromCode(fromCode);
            operationReqVo.setFromDesc(StringUtils.isNotEmpty(fromDesc) ? fromDesc : operationTypeValue);
            operationReqVo.setOperationDateTime(operationDateTime);
            operationReqVo.setOperationAmount(amount.multiply(operationTypeGroupEnum.getUsableAmountWeight()));
            operationReqVo.setFileList(fileList);
            operationReqVo.setRemarks(remarks);
            String operationCode = feePoolOperationService.savePoolOperation(operationReqVo);


            List<FeePoolDetailEntity> poolDetailList = feePoolDetailService.lambdaQuery()
                    .eq(FeePoolDetailEntity::getPoolCode, pool.getPoolCode())
                    .orderByAsc(FeePoolDetailEntity::getAccountDateTime)
                    .list();
            List<FeePoolDetailLogReqVo> detailLogList = new ArrayList<>();
            BigDecimal restAmount = amount;
            for (FeePoolDetailEntity poolDetail :
                    poolDetailList) {
                if (restAmount.compareTo(BigDecimal.ZERO) <= 0) {
                    break;
                }
                if (poolDetail.getUsableAmount().compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal itemUse = BigDecimal.ZERO;
                    if (poolDetail.getUsableAmount().compareTo(restAmount) >= 0) {
                        itemUse = restAmount;
                    } else {
                        itemUse = poolDetail.getUsableAmount();
                    }
                    restAmount = restAmount.subtract(itemUse);
                    poolDetail.setHasUseAmount(poolDetail.getHasUseAmount().add(itemUse));
                    poolDetail.setUsableAmount(poolDetail.getUsableAmount().subtract(itemUse));

                    FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
                    detailLog.setPoolCode(pool.getPoolCode());
                    detailLog.setPoolDetailCode(poolDetail.getPoolDetailCode());
                    detailLog.setOperationCode(operationCode);
                    detailLog.setOperationType(operationType);
                    detailLog.setFromCode(fromCode);
                    detailLog.setFromDesc(StringUtils.isNotEmpty(fromDesc) ? fromDesc : operationTypeValue);
                    detailLog.setRemarks(remarks);
                    detailLog.setOperationAmount(itemUse.multiply(operationTypeGroupEnum.getUsableAmountWeight()));
                    detailLog.setOperationDateTime(operationDateTime);
                    detailLog.setProductCode(productLevelCode);
                    detailLog.setProductName(productLevelName);
                    detailLogList.add(detailLog);
                }
            }
            Assert.isTrue(restAmount.compareTo(BigDecimal.ZERO) == 0, "费用池" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "异常");
            feePoolDetailService.updateBatchById(poolDetailList);
            feePoolDetailLogService.savePoolDetailLog(detailLogList);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void occupyGoodsAmountByPoolProductList(String poolGroup, String useType, String operationType, String fromCode, String fromDesc, String remarks, List<FeePoolGoodsUseByPoolProductItemReqVo> poolProductItemList, List<FeePoolFileReqVo> fileList) {
        Assert.hasText(operationType, "缺失操作类型");
        String operationTypeValue = DictUtil.dictValue(DictConstant.FEE_POOL_OPERATION_TYPE, operationType);
        Assert.hasText(operationTypeValue, "无效的操作类型");
        Assert.notEmpty(poolProductItemList, "缺失使用明细");
        Assert.isTrue(FeePoolConfigUtil.checkOperationTypeGroup(operationType, FeePoolOperationTypeGroupEnum.OCCUPY), "该操作类型不能占用费用池" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC);
        Assert.hasText(fromCode, "占用操作必须有来源单号");
        poolProductItemList.forEach(x -> {
            Assert.hasText(x.getPoolCode(), "缺失费用池编码");
            Assert.hasText(x.getProductCode(), "缺失商品编码");
            Assert.isTrue(x.getAmount() != null, "缺失使用" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC);
            Assert.isTrue(x.getAmount().compareTo(BigDecimal.ZERO) >= 0, "使用" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "不能小于0");
        });
        Result<List<MdmProductRespVo>> result = mdmProductFeign.queryBatchByProductCodeList(poolProductItemList.stream().map(FeePoolGoodsUseByPoolProductItemReqVo::getProductCode).collect(Collectors.toList()));
        Assert.isTrue(result.isSuccess(), "查询商品失败");
        final Map<String, MdmProductRespVo> productMap = result.getResult().stream().collect(Collectors.toMap(MdmProductRespVo::getProductCode, v -> v));
        poolProductItemList.forEach(x -> {
            Assert.isTrue(productMap.containsKey(x.getProductCode()), "商品编码【" + x.getProductCode() + "】不存在");
        });
        final Map<String, List<FeePoolGoodsUseByPoolProductItemReqVo>> groupByPoolCodeMap = poolProductItemList.stream().collect(Collectors.groupingBy(FeePoolGoodsUseByPoolProductItemReqVo::getPoolCode));

        String operationDateTime = DateUtil.dateNowHms();
        FeePoolOperationTypeGroupEnum operationTypeGroupEnum = FeePoolConfigUtil.getOperationTypeGroup(operationType);
        for (Map.Entry<String, List<FeePoolGoodsUseByPoolProductItemReqVo>> entry :
                groupByPoolCodeMap.entrySet()) {
            String poolCode = entry.getKey();
            List<FeePoolGoodsUseByPoolProductItemReqVo> itemList = entry.getValue();
            FeePoolEntity pool = feePoolService.lambdaQuery()
                    .eq(FeePoolEntity::getPoolCode, entry.getKey())
                    .one();

            BigDecimal amount = itemList.stream().map(FeePoolGoodsUseByPoolProductItemReqVo::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            Assert.notNull(pool, "未找到费用池[" + poolCode + "]");
            Assert.isTrue(pool.getUsableAmount().compareTo(amount) >= 0, "费用池" + poolCode + "可用余额不足");
            feePoolService.addOccupyAmountByPoolCode(poolCode, amount);

            FeePoolOperationReqVo operationReqVo = new FeePoolOperationReqVo();
            operationReqVo.setPoolCode(poolCode);
            operationReqVo.setOperationType(operationType);
            operationReqVo.setFromCode(fromCode);
            operationReqVo.setFromDesc(StringUtils.isNotEmpty(fromDesc) ? fromDesc : operationTypeValue);
            operationReqVo.setOperationDateTime(operationDateTime);
            operationReqVo.setOperationAmount(amount.multiply(operationTypeGroupEnum.getUsableAmountWeight()));
            operationReqVo.setFileList(fileList);
            operationReqVo.setRemarks(remarks);
            String operationCode = feePoolOperationService.savePoolOperation(operationReqVo);

            List<FeePoolDetailEntity> poolDetailList = feePoolDetailService.lambdaQuery()
                    .eq(FeePoolDetailEntity::getPoolCode, poolCode)
                    .orderByAsc(FeePoolDetailEntity::getAccountDateTime)
                    .list();

            List<FeePoolDetailLogReqVo> detailLogList = new ArrayList<>();
            for (FeePoolGoodsUseByPoolProductItemReqVo useItem :
                    itemList) {
                BigDecimal restAmount = useItem.getAmount();
                for (FeePoolDetailEntity poolDetail :
                        poolDetailList) {
                    if (restAmount.compareTo(BigDecimal.ZERO) <= 0) {
                        break;
                    }
                    if (poolDetail.getUsableAmount().compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal itemUse = BigDecimal.ZERO;
                        if (poolDetail.getUsableAmount().compareTo(restAmount) >= 0) {
                            itemUse = restAmount;
                        } else {
                            itemUse = poolDetail.getUsableAmount();
                        }
                        restAmount = restAmount.subtract(itemUse);
                        poolDetail.setOccupyAmount(poolDetail.getOccupyAmount().add(itemUse));
                        poolDetail.setUsableAmount(poolDetail.getUsableAmount().subtract(itemUse));

                        FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
                        detailLog.setPoolCode(poolCode);
                        detailLog.setPoolDetailCode(poolDetail.getPoolDetailCode());
                        detailLog.setOperationCode(operationCode);
                        detailLog.setOperationType(operationType);
                        detailLog.setFromCode(fromCode);
                        detailLog.setFromDesc(StringUtils.isNotEmpty(fromDesc) ? fromDesc : operationTypeValue);
                        detailLog.setRemarks(remarks);
                        detailLog.setOperationAmount(itemUse.multiply(operationTypeGroupEnum.getUsableAmountWeight()));
                        detailLog.setOperationDateTime(operationDateTime);
                        detailLog.setProductCode(useItem.getProductCode());
                        detailLog.setProductName(productMap.get(useItem.getProductCode()).getProductName());
                        detailLogList.add(detailLog);
                    }
                }
                Assert.isTrue(restAmount.compareTo(BigDecimal.ZERO) == 0, "费用池" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "异常");
            }
            feePoolDetailService.updateBatchById(poolDetailList);
            feePoolDetailLogService.savePoolDetailLog(detailLogList);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void occupyGoodsAmountByProductLevelList(String poolGroup, String useType, String operationType, String fromCode, String fromDesc, String remarks, List<FeePoolGoodsUseByProductLevelItemReqVo> productLevelItemList, List<FeePoolFileReqVo> fileList, String customerCode) {
        Assert.hasText(operationType, "缺失操作类型");
        String operationTypeValue = DictUtil.dictValue(DictConstant.FEE_POOL_OPERATION_TYPE, operationType);
        Assert.hasText(operationTypeValue, "无效的操作类型");
        Assert.notEmpty(productLevelItemList, "缺失使用明细");
        Assert.isTrue(FeePoolConfigUtil.checkOperationTypeGroup(operationType, FeePoolOperationTypeGroupEnum.OCCUPY), "该操作类型不能占用费用池" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC);
        Assert.hasText(fromCode, operationTypeValue + "必须有来源单号");
        productLevelItemList.forEach(x -> {
            Assert.hasText(x.getProductLevelCode(), "缺失产品层级编码");
            Assert.isTrue(x.getAmount() != null, "缺失占用" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC);
            Assert.isTrue(x.getAmount().compareTo(BigDecimal.ZERO) >= 0, "占用" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "不能小于0");
        });
        List<MdmProductLevelRespVo> productLevelByCodeList = ProductLevelUtil.getProductLevelByCodeList(productLevelItemList.stream().map(FeePoolGoodsUseByProductLevelItemReqVo::getProductLevelCode).collect(Collectors.toList()));
        final Map<String, MdmProductLevelRespVo> productLevelMap = productLevelByCodeList.stream().collect(Collectors.toMap(MdmProductLevelRespVo::getProductLevelCode, v -> v));
        productLevelItemList.forEach(x -> {
            Assert.isTrue(productLevelMap.containsKey(x.getProductLevelCode()), "产品层级编码【" + x.getProductLevelCode() + "】不存在");
        });
        final Map<String, BigDecimal> productLevelAmountMap = productLevelItemList.stream().collect(Collectors.groupingBy(FeePoolGoodsUseByProductLevelItemReqVo::getProductLevelCode, Collectors.mapping(FeePoolGoodsUseByProductLevelItemReqVo::getAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));

        String operationDateTime = DateUtil.dateNowHms();
        FeePoolOperationTypeGroupEnum operationTypeGroupEnum = FeePoolConfigUtil.getOperationTypeGroup(operationType);
        for (Map.Entry<String, BigDecimal> entry :
                productLevelAmountMap.entrySet()) {
            String productLevelCode = entry.getKey();
            String productLevelName = productLevelMap.get(productLevelCode).getProductLevelName();
            List<FeePoolEntity> collect = feePoolService.lambdaQuery()
                    .eq(FeePoolEntity::getPoolType, FeePoolTypeEnum.GOODS.getValue())
                    .eq(FeePoolEntity::getCustomerCode, customerCode)
                    .eq(FeePoolEntity::getGoodsProductLevelCode, productLevelCode)
                    .list()
                    .stream().filter(x -> StringUtils.isEmpty(x.getGoodsProductCode())).collect(Collectors.toList());
            Assert.notEmpty(collect, "未找到产品层级【" + productLevelName + "】的货补费用池");
            FeePoolEntity pool = collect.get(0);
            BigDecimal amount = entry.getValue();
            Assert.isTrue(pool.getUsableAmount().compareTo(amount) >= 0, "产品层级【" + productLevelName + "】的货补可用余额不足");
            pool.setOccupyAmount(Optional.ofNullable(pool.getOccupyAmount()).orElse(BigDecimal.ZERO).add(amount));
            pool.setUsableAmount(pool.getUsableAmount().subtract(amount));
            feePoolService.updateById(pool);

            FeePoolOperationReqVo operationReqVo = new FeePoolOperationReqVo();
            operationReqVo.setPoolCode(pool.getPoolCode());
            operationReqVo.setOperationType(operationType);
            operationReqVo.setFromCode(fromCode);
            operationReqVo.setFromDesc(StringUtils.isNotEmpty(fromDesc) ? fromDesc : operationTypeValue);
            operationReqVo.setOperationDateTime(operationDateTime);
            operationReqVo.setOperationAmount(amount.multiply(operationTypeGroupEnum.getUsableAmountWeight()));
            operationReqVo.setFileList(fileList);
            operationReqVo.setRemarks(remarks);
            String operationCode = feePoolOperationService.savePoolOperation(operationReqVo);


            List<FeePoolDetailEntity> poolDetailList = feePoolDetailService.lambdaQuery()
                    .eq(FeePoolDetailEntity::getPoolCode, pool.getPoolCode())
                    .orderByAsc(FeePoolDetailEntity::getAccountDateTime)
                    .list();
            List<FeePoolDetailLogReqVo> detailLogList = new ArrayList<>();
            BigDecimal restAmount = amount;
            for (FeePoolDetailEntity poolDetail :
                    poolDetailList) {
                if (restAmount.compareTo(BigDecimal.ZERO) <= 0) {
                    break;
                }
                if (poolDetail.getUsableAmount().compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal itemUse = BigDecimal.ZERO;
                    if (poolDetail.getUsableAmount().compareTo(restAmount) >= 0) {
                        itemUse = restAmount;
                    } else {
                        itemUse = poolDetail.getUsableAmount();
                    }
                    restAmount = restAmount.subtract(itemUse);
                    poolDetail.setOccupyAmount(poolDetail.getOccupyAmount().add(itemUse));
                    poolDetail.setUsableAmount(poolDetail.getUsableAmount().subtract(itemUse));

                    FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
                    detailLog.setPoolCode(pool.getPoolCode());
                    detailLog.setPoolDetailCode(poolDetail.getPoolDetailCode());
                    detailLog.setOperationCode(operationCode);
                    detailLog.setOperationType(operationType);
                    detailLog.setFromCode(fromCode);
                    detailLog.setFromDesc(StringUtils.isNotEmpty(fromDesc) ? fromDesc : operationTypeValue);
                    detailLog.setRemarks(remarks);
                    detailLog.setOperationAmount(itemUse.multiply(operationTypeGroupEnum.getUsableAmountWeight()));
                    detailLog.setOperationDateTime(operationDateTime);
                    detailLog.setProductCode(productLevelCode);
                    detailLog.setProductName(productLevelName);
                    detailLogList.add(detailLog);
                }
            }
            Assert.isTrue(restAmount.compareTo(BigDecimal.ZERO) == 0, "费用池" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "异常");
            feePoolDetailService.updateBatchById(poolDetailList);
            feePoolDetailLogService.savePoolDetailLog(detailLogList);
        }
    }

}
