/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.fee.FeePoolOperationTypeEnum;
import com.biz.crm.eunm.fee.FeePoolTypeEnum;
import com.biz.crm.nebular.fee.pool.req.FeePoolDiscountAccountReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDiscountInitAccountReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDiscountQueryForAdjustRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDiscountQueryForInitAccountRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeeSelectOptionVo;
import com.biz.crm.pool.service.FeePoolDiscountService;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collections;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/feePoolDiscountController"})
@Api(tags={"\u6298\u6263\u8d39\u7528\u6c60"})
@CrmGlobalLog
public class FeePoolDiscountController {
    private static final Logger log = LoggerFactory.getLogger(FeePoolDiscountController.class);
    @Resource
    private FeePoolDiscountService feePoolDiscountService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/pageList"})
    public Result<PageResult<FeePoolRespVo>> pageList(@RequestBody FeePoolReqVo reqVo) {
        PageResult<FeePoolRespVo> result = this.feePoolDiscountService.findList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u83b7\u53d6\u671f\u521d\u52a0\u8f7d\u8be6\u60c5\u6570\u636e")
    @GetMapping(value={"/queryForInitAccount"})
    public Result<FeePoolDiscountQueryForInitAccountRespVo> queryForInitAccount() {
        FeePoolDiscountQueryForInitAccountRespVo respVo = new FeePoolDiscountQueryForInitAccountRespVo();
        String payType = FeePoolConfigUtil.getPayType((String)FeePoolTypeEnum.DISCOUNT.getValue());
        respVo.setOperationTypeSelectList(Collections.singletonList(new FeeSelectOptionVo().setValue(FeePoolOperationTypeEnum.INIT.getValue()).setText(DictUtil.dictValue((String)"fee_pool_operation_type", (String)FeePoolOperationTypeEnum.INIT.getValue()))));
        respVo.setPayTypeList(Collections.singletonList(new FeeSelectOptionVo().setValue(payType).setText(DictUtil.dictValue((String)"fee_pool_pay_type", (String)payType))));
        respVo.setDiscountTypeList(FeePoolConfigUtil.getDiscountSelectList());
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u6dfb\u52a0\u671f\u521d\u91d1\u989d")
    @PostMapping(value={"/saveInitAccount"})
    public Result saveInitAccount(@RequestBody FeePoolDiscountInitAccountReqVo reqVo) {
        this.feePoolDiscountService.saveInitAccount(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u901a\u8fc7id\u83b7\u53d6\u8c03\u6574\u8be6\u60c5", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/queryForAdjust"})
    public Result<FeePoolDiscountQueryForAdjustRespVo> queryForAdjust(@RequestParam(value="id", required=true) String id) {
        return Result.ok((Object)this.feePoolDiscountService.queryForAdjust(id));
    }

    @ApiOperation(value="\u8c03\u6574")
    @PostMapping(value={"/accountById"})
    public Result accountById(@RequestBody FeePoolDiscountAccountReqVo reqVo) {
        this.feePoolDiscountService.accountById(reqVo);
        return Result.ok();
    }
}

