/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.nebular.fee.pool.req.FeePoolFileReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolFileRespVo;
import com.biz.crm.pool.mapper.FeePoolFileMapper;
import com.biz.crm.pool.model.FeePoolFileEntity;
import com.biz.crm.pool.service.FeePoolFileService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"FeePoolFileServiceExpandImpl"})
public class FeePoolFileServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<FeePoolFileMapper, FeePoolFileEntity>
implements FeePoolFileService {
    private static final Logger log = LoggerFactory.getLogger(FeePoolFileServiceImpl.class);
    @Resource
    private FeePoolFileMapper feePoolFileMapper;

    @Override
    public Map<String, List<FeePoolFileRespVo>> getFeePoolFileListGroupByOperationCodeList(List<String> operationCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(operationCodeList)) {
            ArrayList fileEntityList = new ArrayList();
            List partition = Lists.partition(operationCodeList, (int)500);
            partition.forEach(item -> {
                List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(FeePoolFileEntity::getOperationCode, (Collection)item)).select(new SFunction[]{FeePoolFileEntity::getPoolCode, FeePoolFileEntity::getOperationCode, FeePoolFileEntity::getFileName, FeePoolFileEntity::getUrlAddress}).list();
                if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                    fileEntityList.addAll(list);
                }
            });
            if (CollectionUtil.listNotEmptyNotSizeZero(fileEntityList)) {
                return CrmBeanUtil.copyList(fileEntityList, FeePoolFileRespVo.class).stream().collect(Collectors.groupingBy(FeePoolFileRespVo::getOperationCode));
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public List<FeePoolFileRespVo> getFeePoolFileListByOperationCode(String operationCode) {
        List list;
        if (StringUtils.isNotEmpty((String)operationCode) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolFileEntity::getOperationCode, (Object)operationCode)).list()))) {
            return CrmBeanUtil.copyList((List)list, FeePoolFileRespVo.class);
        }
        return Collections.emptyList();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void savePoolFileList(String poolCode, String operationCode, List<FeePoolFileReqVo> list) {
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            Assert.hasText((String)poolCode, (String)"\u9644\u4ef6\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
            Assert.hasText((String)operationCode, (String)"\u9644\u4ef6\u7f3a\u5931\u64cd\u4f5c\u8bb0\u5f55\u7f16\u53f7");
            list.forEach(item -> {
                Assert.hasText((String)item.getFileName(), (String)"\u9644\u4ef6\u7f3a\u5931\u540d\u79f0");
                Assert.hasText((String)item.getUrlAddress(), (String)"\u9644\u4ef6\u7f3a\u5931\u5730\u5740");
            });
            List entityList = CrmBeanUtil.copyList(list, FeePoolFileEntity.class);
            entityList.forEach(item -> {
                item.setPoolCode(poolCode);
                item.setOperationCode(operationCode);
            });
            this.saveBatch(entityList);
        }
    }
}

