/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeEnum;
import com.biz.crm.eunm.fee.FeePoolTypeEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.nebular.fee.pool.req.FeePoolDiscountAccountReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDiscountInitAccountReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDiscountQueryForAdjustRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeeSelectOptionVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.pool.mapper.FeePoolMapper;
import com.biz.crm.pool.model.FeePoolEntity;
import com.biz.crm.pool.service.FeePoolDetailService;
import com.biz.crm.pool.service.FeePoolDiscountService;
import com.biz.crm.pool.service.FeePoolOperationService;
import com.biz.crm.pool.service.FeePoolService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"FeePoolDiscountServiceExpandImpl"})
public class FeePoolDiscountServiceImpl
implements FeePoolDiscountService {
    private static final Logger log = LoggerFactory.getLogger(FeePoolDiscountServiceImpl.class);
    @Resource
    private FeePoolMapper feePoolMapper;
    @Resource
    private FeePoolService feePoolService;
    @Resource
    private FeePoolOperationService feePoolOperationService;
    @Resource
    private FeePoolDetailService feePoolAccountService;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;

    @Override
    public PageResult<FeePoolRespVo> findList(FeePoolReqVo reqVo) {
        reqVo.setPoolType(FeePoolTypeEnum.DISCOUNT.getValue());
        return this.feePoolService.findList(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveInitAccount(FeePoolDiscountInitAccountReqVo reqVo) {
        FeePoolTypeEnum feePoolTypeEnum = FeePoolTypeEnum.DISCOUNT;
        FeePoolOperationTypeEnum operationTypeEnum = FeePoolOperationTypeEnum.INIT;
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        Result customerResult = this.mdmCustomerMsgFeign.query(null, reqVo.getCustomerCode());
        Assert.isTrue((boolean)customerResult.isSuccess(), (String)"\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        MdmCustomerMsgRespVo customer = (MdmCustomerMsgRespVo)customerResult.getResult();
        Assert.isTrue((customer != null && StringUtils.isNotEmpty((String)customer.getCustomerCode()) ? 1 : 0) != 0, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
        Assert.isTrue((reqVo.getTotalAmount() != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u4e0a\u8d26\u91d1\u989d");
        Assert.isTrue((reqVo.getTotalAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u671f\u521d\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        LambdaQueryWrapper uniqueQuery = new LambdaQueryWrapper();
        uniqueQuery.eq(FeePoolEntity::getCustomerCode, (Object)reqVo.getCustomerCode());
        if (StringUtils.isNotEmpty((String)reqVo.getDiscountType())) {
            uniqueQuery.eq(FeePoolEntity::getDiscountType, (Object)reqVo.getDiscountType());
        } else {
            uniqueQuery.and(x -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(FeePoolEntity::getDiscountType, (Object)"")).or()).isNull(FeePoolEntity::getDiscountType);
            });
        }
        List feeUniqueList = this.feePoolMapper.selectList((Wrapper)uniqueQuery);
        Assert.isTrue((boolean)CollectionUtil.listEmpty((List)feeUniqueList), (String)"\u8be5\u5ba2\u6237\u5df2\u7ecf\u5b58\u5728\u8be5\u7ef4\u5ea6\u4e0b\u7684\u671f\u521d\u6570\u636e\uff0c\u4e0d\u53ef\u91cd\u590d\u6dfb\u52a0");
        String payType = FeePoolConfigUtil.getPayType((String)feePoolTypeEnum.getValue());
        FeePoolEntity entity = (FeePoolEntity)((Object)CrmBeanUtil.copy((Object)reqVo, FeePoolEntity.class));
        entity.setPoolType(feePoolTypeEnum.getValue());
        entity.setPoolCode(CodeUtil.generateCode((String)CodeRuleEnum.FEE_POOL_CODE.getCode()));
        entity.setCustomerName(customer.getCustomerName());
        entity.setUsableAmount(entity.getTotalAmount());
        entity.setUseAmount(BigDecimal.ZERO);
        entity.setFreezeAmount(BigDecimal.ZERO);
        this.feePoolService.save((Object)entity);
        String operationCode = this.feePoolOperationService.savePoolOperation(entity.getPoolCode(), operationTypeEnum.getValue(), reqVo.getFromCode(), FeePoolOperationTypeEnum.INIT.getDesc(), reqVo.getRemarks(), payType, reqVo.getTotalAmount(), BigDecimal.ONE, reqVo.getFileList());
        this.feePoolAccountService.savePoolDetail(entity.getPoolCode(), operationCode, operationTypeEnum.getValue(), reqVo.getFromCode(), FeePoolOperationTypeEnum.INIT.getValue(), reqVo.getRemarks(), payType, reqVo.getTotalAmount(), BigDecimal.ONE);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void accountById(FeePoolDiscountAccountReqVo reqVo) {
        Assert.hasText((String)reqVo.getId(), (String)"\u7f3a\u5931id");
        Assert.hasText((String)reqVo.getOperationType(), (String)"\u7f3a\u5931\u8c03\u6574\u7c7b\u578b");
        Assert.isTrue((reqVo.getTotalAmount() != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u4e0a\u8d26\u91d1\u989d");
        Assert.isTrue((reqVo.getTotalAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u4e0a\u8d26\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        FeePoolEntity feePool = (FeePoolEntity)((Object)this.feePoolService.getById((Serializable)((Object)reqVo.getId())));
        Assert.notNull((Object)((Object)feePool), (String)"\u65e0\u6548\u7684id");
        Assert.isTrue((boolean)FeePoolTypeEnum.DISCOUNT.getValue().equals(feePool.getPoolType()), (String)("\u8be5\u884c\u4e0d\u662f" + FeePoolTypeEnum.DISCOUNT.getDesc() + "\u6570\u636e"));
        String operationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)reqVo.getOperationType());
        Assert.hasText((String)operationTypeValue, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
        Assert.isTrue((boolean)FeePoolConfigUtil.checkOperationTypeUseInAccount((String)reqVo.getOperationType()), (String)"\u8be5\u64cd\u4f5c\u7c7b\u578b\u4e0d\u652f\u6301\u4e0a\u8d26");
        BigDecimal weight = FeePoolConfigUtil.getOperationTypeWeight((String)reqVo.getOperationType());
        String payType = FeePoolConfigUtil.getPayType((String)FeePoolTypeEnum.DISCOUNT.getValue());
        this.feePoolService.addTotalAmount(feePool.getPoolCode(), reqVo.getTotalAmount());
        String operationCode = this.feePoolOperationService.savePoolOperation(feePool.getPoolCode(), reqVo.getOperationType(), reqVo.getFromCode(), operationTypeValue, reqVo.getRemarks(), payType, reqVo.getTotalAmount(), weight, reqVo.getFileList());
        this.feePoolAccountService.savePoolDetail(feePool.getPoolCode(), operationCode, reqVo.getOperationType(), reqVo.getFromCode(), operationTypeValue, reqVo.getRemarks(), payType, reqVo.getTotalAmount(), weight);
    }

    @Override
    public FeePoolDiscountQueryForAdjustRespVo queryForAdjust(String id) {
        FeePoolEntity feePool;
        if (StringUtils.isNotEmpty((String)id) && (feePool = (FeePoolEntity)((Object)this.feePoolService.getById((Serializable)((Object)id)))) != null) {
            FeePoolDiscountQueryForAdjustRespVo copy = (FeePoolDiscountQueryForAdjustRespVo)CrmBeanUtil.copy((Object)((Object)feePool), FeePoolDiscountQueryForAdjustRespVo.class);
            String payType = FeePoolConfigUtil.getPayType((String)FeePoolTypeEnum.DISCOUNT.getValue());
            copy.setPayType(payType);
            copy.setDiscountTypeList(FeePoolConfigUtil.getDiscountSelectList());
            copy.setOperationTypeSelectList(FeePoolConfigUtil.getUseInAccountOperationTypeSelectList());
            copy.setPayTypeList(Collections.singletonList(new FeeSelectOptionVo().setValue(payType).setText(DictUtil.dictValue((String)"fee_pool_pay_type", (String)payType))));
            return copy;
        }
        return null;
    }
}

