/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailLogReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailLogRespVo;
import com.biz.crm.pool.mapper.FeePoolDetailLogMapper;
import com.biz.crm.pool.model.FeePoolDetailLogEntity;
import com.biz.crm.pool.service.FeePoolDetailLogService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"FeePoolDetailLogServiceExpandImpl"})
public class FeePoolDetailLogServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<FeePoolDetailLogMapper, FeePoolDetailLogEntity>
implements FeePoolDetailLogService {
    private static final Logger log = LoggerFactory.getLogger(FeePoolDetailLogServiceImpl.class);
    @Resource
    private FeePoolDetailLogMapper feePoolDetailLogMapper;

    @Override
    public PageResult<FeePoolDetailLogRespVo> findList(FeePoolDetailLogReqVo reqVo, String thisPoolCode, String thisPoolDetailCode) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<FeePoolDetailLogRespVo> list = this.feePoolDetailLogMapper.findList((Page<FeePoolDetailLogRespVo>)page, reqVo, thisPoolCode, thisPoolDetailCode);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void savePoolDetailLog(String poolCode, String poolDetailCode, String operationCode, String operationType, String fromCode, String fromDesc, String remarks, String payType, BigDecimal amount, BigDecimal weight) {
        FeePoolDetailLogReqVo reqVo = new FeePoolDetailLogReqVo();
        reqVo.setPoolCode(poolCode);
        reqVo.setPoolDetailCode(poolDetailCode);
        reqVo.setOperationCode(operationCode);
        reqVo.setOperationType(operationType);
        reqVo.setFromCode(fromCode);
        reqVo.setFromDesc(fromDesc);
        reqVo.setPayType(payType);
        reqVo.setRemarks(remarks);
        reqVo.setOperationAmount(amount);
        reqVo.setAmountWeight(weight);
        this.savePoolDetailLog(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void savePoolDetailLog(FeePoolDetailLogReqVo reqVo) {
        this.save(CrmBeanUtil.copy((Object)reqVo, FeePoolDetailLogEntity.class));
    }
}

