/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeEnum;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailFreezeReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailPageReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailPageRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolFileRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeeSelectOptionVo;
import com.biz.crm.pool.mapper.FeePoolDetailMapper;
import com.biz.crm.pool.model.FeePoolDetailEntity;
import com.biz.crm.pool.service.FeePoolDetailLogService;
import com.biz.crm.pool.service.FeePoolDetailService;
import com.biz.crm.pool.service.FeePoolFileService;
import com.biz.crm.pool.service.FeePoolOperationService;
import com.biz.crm.pool.service.FeePoolService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"FeePoolDetailServiceExpandImpl"})
public class FeePoolDetailServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<FeePoolDetailMapper, FeePoolDetailEntity>
implements FeePoolDetailService {
    private static final Logger log = LoggerFactory.getLogger(FeePoolDetailServiceImpl.class);
    @Resource
    private FeePoolDetailMapper feePoolDetailMapper;
    @Resource
    private FeePoolDetailLogService feePoolDetailLogService;
    @Resource
    private FeePoolService feePoolService;
    @Resource
    private FeePoolFileService feePoolFileService;
    @Resource
    private FeePoolOperationService feePoolOperationService;

    @Override
    public FeePoolDetailRespVo queryByPoolDetailCode(String poolDetailCode) {
        FeePoolDetailEntity one;
        if (StringUtils.isNotEmpty((String)poolDetailCode) && (one = (FeePoolDetailEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolDetailEntity::getPoolDetailCode, (Object)poolDetailCode)).one())) != null) {
            FeePoolDetailRespVo copy = (FeePoolDetailRespVo)CrmBeanUtil.copy((Object)((Object)one), FeePoolDetailRespVo.class);
            copy.setFileList(this.feePoolFileService.getFeePoolFileListByOperationCode(copy.getOperationCode()));
            return copy;
        }
        return null;
    }

    @Override
    public FeePoolDetailRespVo queryById(String id) {
        FeePoolDetailEntity one;
        if (StringUtils.isNotEmpty((String)id) && (one = (FeePoolDetailEntity)((Object)this.getById((Serializable)((Object)id)))) != null) {
            FeePoolDetailRespVo copy = (FeePoolDetailRespVo)CrmBeanUtil.copy((Object)((Object)one), FeePoolDetailRespVo.class);
            copy.setFileList(this.feePoolFileService.getFeePoolFileListByOperationCode(copy.getOperationCode()));
            return copy;
        }
        return null;
    }

    @Override
    public PageResult<FeePoolDetailPageRespVo> findFeePoolDetailPageList(FeePoolDetailPageReqVo reqVo) {
        List<String> collect;
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<FeePoolDetailPageRespVo> list = this.feePoolDetailMapper.findFeePoolDetailPageList((Page<FeePoolDetailPageRespVo>)page, reqVo, collect = FeePoolConfigUtil.getAllOperationTypeSelectList().stream().map(FeeSelectOptionVo::getValue).collect(Collectors.toList()));
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            Map<String, List<FeePoolFileRespVo>> map = this.feePoolFileService.getFeePoolFileListGroupByOperationCodeList(list.stream().map(FeePoolDetailPageRespVo::getOperationCode).collect(Collectors.toList()));
            list.forEach(item -> {
                if (map.containsKey(item.getOperationCode())) {
                    item.setFileList((List)map.get(item.getOperationCode()));
                }
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void savePoolDetail(String poolCode, String operationCode, String operationType, String fromCode, String fromDesc, String remarks, BigDecimal amount, BigDecimal weight) {
        FeePoolDetailEntity entity = new FeePoolDetailEntity();
        entity.setPoolCode(poolCode);
        entity.setPoolDetailCode(CodeUtil.generateCode((String)CodeRuleEnum.FEE_POOL_ACCOUNT_CODE.getCode()));
        entity.setOperationCode(operationCode);
        entity.setOperationType(operationType);
        entity.setFromCode(fromCode);
        entity.setFromDesc(fromDesc);
        entity.setRemarks(remarks);
        entity.setTotalAmount(amount);
        entity.setUsableAmount(amount);
        entity.setUseAmount(BigDecimal.ZERO);
        entity.setFreezeAmount(BigDecimal.ZERO);
        entity.setAccountDateTime(DateUtil.dateNowHms());
        this.save((Object)entity);
        this.feePoolDetailLogService.savePoolDetailLog(poolCode, entity.getPoolDetailCode(), operationCode, operationType, fromCode, fromDesc, remarks, amount, weight);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void savePoolDetail(FeePoolDetailReqVo reqVo) {
        FeePoolDetailEntity entity = (FeePoolDetailEntity)((Object)CrmBeanUtil.copy((Object)reqVo, FeePoolDetailEntity.class));
        if (StringUtils.isEmpty((String)entity.getPoolDetailCode())) {
            entity.setPoolDetailCode(CodeUtil.generateCode((String)CodeRuleEnum.FEE_POOL_ACCOUNT_CODE.getCode()));
        }
        BigDecimal operationTypeWeight = FeePoolConfigUtil.getOperationTypeWeight((String)entity.getOperationType());
        this.feePoolDetailLogService.savePoolDetailLog(entity.getPoolCode(), entity.getPoolDetailCode(), entity.getOperationCode(), entity.getOperationType(), entity.getFromCode(), entity.getFromDesc(), entity.getRemarks(), entity.getTotalAmount(), operationTypeWeight);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void usePoolDetailAmount(String poolCode, String poolDetailCode, String operationCode, String operationType, String fromCode, String fromDesc, String remarks, BigDecimal amount, BigDecimal weight) {
        FeePoolDetailEntity poolDetail = (FeePoolDetailEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolDetailEntity::getPoolDetailCode, (Object)poolDetailCode)).one());
        poolDetail.setUsableAmount(poolDetail.getUsableAmount().subtract(amount));
        poolDetail.setUseAmount(poolDetail.getUseAmount().add(amount));
        this.updateById((Object)poolDetail);
        this.feePoolDetailLogService.savePoolDetailLog(poolCode, poolDetailCode, operationCode, operationType, fromCode, fromDesc, remarks, amount, weight);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void freeze(FeePoolDetailFreezeReqVo reqVo) {
        Assert.hasText((String)reqVo.getPoolDetailCode(), (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        BigDecimal freezeAmount = reqVo.getAmount();
        Assert.isTrue((freezeAmount != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u51bb\u7ed3\u91d1\u989d");
        Assert.isTrue((freezeAmount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u51bb\u7ed3\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        FeePoolDetailEntity poolDetail = (FeePoolDetailEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolDetailEntity::getPoolDetailCode, (Object)reqVo.getPoolDetailCode())).one());
        Assert.notNull((Object)((Object)poolDetail), (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        Assert.isTrue((poolDetail.getUsableAmount().compareTo(freezeAmount) >= 0 ? 1 : 0) != 0, (String)"\u51bb\u7ed3\u91d1\u989d\u5927\u4e8e\u53ef\u7528\u91d1\u989d");
        String operationCode = this.feePoolOperationService.savePoolOperation(poolDetail.getPoolCode(), FeePoolOperationTypeEnum.FREEZE.getValue(), reqVo.getFromCode(), FeePoolOperationTypeEnum.FREEZE.getDesc(), reqVo.getRemarks(), freezeAmount, new BigDecimal(-1), reqVo.getFileList());
        poolDetail.setFreezeAmount(poolDetail.getFreezeAmount().add(freezeAmount));
        poolDetail.setUsableAmount(poolDetail.getUsableAmount().subtract(freezeAmount));
        this.updateById((Object)poolDetail);
        this.feePoolService.addFreezeAmount(poolDetail.getPoolCode(), freezeAmount);
        this.feePoolDetailLogService.savePoolDetailLog(poolDetail.getPoolCode(), poolDetail.getPoolDetailCode(), operationCode, FeePoolOperationTypeEnum.FREEZE.getValue(), reqVo.getFromCode(), FeePoolOperationTypeEnum.FREEZE.getDesc(), reqVo.getRemarks(), freezeAmount, new BigDecimal(-1));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unfreeze(FeePoolDetailFreezeReqVo reqVo) {
        Assert.hasText((String)reqVo.getPoolDetailCode(), (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        BigDecimal unfreezeAmount = reqVo.getAmount();
        Assert.isTrue((unfreezeAmount != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u89e3\u51bb\u91d1\u989d");
        Assert.isTrue((unfreezeAmount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u51bb\u7ed3\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        FeePoolDetailEntity poolDetail = (FeePoolDetailEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolDetailEntity::getPoolDetailCode, (Object)reqVo.getPoolDetailCode())).one());
        Assert.notNull((Object)((Object)poolDetail), (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        Assert.isTrue((poolDetail.getFreezeAmount().compareTo(unfreezeAmount) >= 0 ? 1 : 0) != 0, (String)"\u89e3\u51bb\u91d1\u989d\u5927\u4e8e\u5df2\u51bb\u7ed3\u91d1\u989d");
        String operationCode = this.feePoolOperationService.savePoolOperation(poolDetail.getPoolCode(), FeePoolOperationTypeEnum.UNFREEZE.getValue(), reqVo.getFromCode(), FeePoolOperationTypeEnum.UNFREEZE.getDesc(), reqVo.getRemarks(), unfreezeAmount, BigDecimal.ONE, reqVo.getFileList());
        poolDetail.setFreezeAmount(poolDetail.getFreezeAmount().subtract(unfreezeAmount));
        poolDetail.setUsableAmount(poolDetail.getUsableAmount().add(unfreezeAmount));
        this.updateById((Object)poolDetail);
        this.feePoolService.subtractFreezeAmount(poolDetail.getPoolCode(), unfreezeAmount);
        this.feePoolDetailLogService.savePoolDetailLog(poolDetail.getPoolCode(), poolDetail.getPoolDetailCode(), operationCode, FeePoolOperationTypeEnum.UNFREEZE.getValue(), reqVo.getFromCode(), FeePoolOperationTypeEnum.UNFREEZE.getDesc(), reqVo.getRemarks(), unfreezeAmount, BigDecimal.ONE);
    }
}

