/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeEnum;
import com.biz.crm.eunm.fee.FeePoolTypeEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailPageReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDiscountAccountReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDiscountAdjustReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDiscountInitAccountReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDiscountUseByPoolDetailCodeReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDiscountUseReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolOperationReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailPageRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDiscountQueryForAdjustRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolOperationRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeeSelectOptionVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.pool.mapper.FeePoolMapper;
import com.biz.crm.pool.model.FeePoolDetailEntity;
import com.biz.crm.pool.model.FeePoolEntity;
import com.biz.crm.pool.service.FeePoolDetailService;
import com.biz.crm.pool.service.FeePoolDiscountService;
import com.biz.crm.pool.service.FeePoolOperationService;
import com.biz.crm.pool.service.FeePoolService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"FeePoolDiscountServiceExpandImpl"})
public class FeePoolDiscountServiceImpl
implements FeePoolDiscountService {
    private static final Logger log = LoggerFactory.getLogger(FeePoolDiscountServiceImpl.class);
    @Resource
    private FeePoolMapper feePoolMapper;
    @Resource
    private FeePoolService feePoolService;
    @Resource
    private FeePoolOperationService feePoolOperationService;
    @Resource
    private FeePoolDetailService feePoolDetailService;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;

    @Override
    public PageResult<FeePoolRespVo> findList(FeePoolReqVo reqVo) {
        reqVo.setPoolType(FeePoolTypeEnum.DISCOUNT.getValue());
        return this.feePoolService.findList(reqVo);
    }

    @Override
    public PageResult<FeePoolDetailPageRespVo> findFeePoolDetailPageList(FeePoolDetailPageReqVo reqVo) {
        reqVo.setPoolType(FeePoolTypeEnum.DISCOUNT.getValue());
        return this.feePoolDetailService.findFeePoolDetailPageList(reqVo);
    }

    @Override
    public PageResult<FeePoolOperationRespVo> findFeePoolOperationPageList(FeePoolOperationReqVo reqVo) {
        return this.feePoolOperationService.findFeePoolOperationPageList(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveInitAccount(FeePoolDiscountInitAccountReqVo reqVo) {
        FeePoolTypeEnum feePoolTypeEnum = FeePoolTypeEnum.DISCOUNT;
        FeePoolOperationTypeEnum operationTypeEnum = FeePoolOperationTypeEnum.INIT;
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        Result customerResult = this.mdmCustomerMsgFeign.query(null, reqVo.getCustomerCode());
        Assert.isTrue((boolean)customerResult.isSuccess(), (String)"\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        MdmCustomerMsgRespVo customer = (MdmCustomerMsgRespVo)customerResult.getResult();
        Assert.isTrue((customer != null && StringUtils.isNotEmpty((String)customer.getCustomerCode()) ? 1 : 0) != 0, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
        Assert.isTrue((reqVo.getAmount() != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u4e0a\u8d26\u91d1\u989d");
        Assert.isTrue((reqVo.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u671f\u521d\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        LambdaQueryWrapper uniqueQuery = new LambdaQueryWrapper();
        uniqueQuery.eq(FeePoolEntity::getCustomerCode, (Object)reqVo.getCustomerCode());
        uniqueQuery.eq(FeePoolEntity::getPoolType, (Object)FeePoolTypeEnum.DISCOUNT.getValue());
        if (StringUtils.isNotEmpty((String)reqVo.getDiscountType())) {
            uniqueQuery.eq(FeePoolEntity::getDiscountType, (Object)reqVo.getDiscountType());
        } else {
            uniqueQuery.and(x -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(FeePoolEntity::getDiscountType, (Object)"")).or()).isNull(FeePoolEntity::getDiscountType);
            });
        }
        List feeUniqueList = this.feePoolMapper.selectList((Wrapper)uniqueQuery);
        Assert.isTrue((boolean)CollectionUtil.listEmpty((List)feeUniqueList), (String)"\u8be5\u5ba2\u6237\u5df2\u7ecf\u5b58\u5728\u8be5\u7ef4\u5ea6\u4e0b\u7684\u671f\u521d\u6570\u636e\uff0c\u4e0d\u53ef\u91cd\u590d\u6dfb\u52a0");
        String payType = FeePoolConfigUtil.getPayType((String)feePoolTypeEnum.getValue());
        FeePoolEntity entity = (FeePoolEntity)((Object)CrmBeanUtil.copy((Object)reqVo, FeePoolEntity.class));
        entity.setPoolType(feePoolTypeEnum.getValue());
        entity.setPoolCode(CodeUtil.generateCode((String)CodeRuleEnum.FEE_POOL_CODE.getCode()));
        entity.setPayType(payType);
        entity.setCustomerName(customer.getCustomerName());
        entity.setUsableAmount(entity.getTotalAmount());
        entity.setUseAmount(BigDecimal.ZERO);
        entity.setFreezeAmount(BigDecimal.ZERO);
        this.feePoolService.save((Object)entity);
        String operationCode = this.feePoolOperationService.savePoolOperation(entity.getPoolCode(), operationTypeEnum.getValue(), reqVo.getFromCode(), FeePoolOperationTypeEnum.INIT.getDesc(), reqVo.getRemarks(), reqVo.getAmount(), BigDecimal.ONE, reqVo.getFileList());
        FeePoolDetailReqVo detailReqVo = new FeePoolDetailReqVo();
        CrmBeanUtil.copyExt10((Object)reqVo, (Object)detailReqVo);
        detailReqVo.setPoolCode(entity.getPoolCode());
        detailReqVo.setOperationCode(operationCode);
        detailReqVo.setOperationType(operationTypeEnum.getValue());
        detailReqVo.setFromCode(reqVo.getFromCode());
        detailReqVo.setFromDesc(FeePoolOperationTypeEnum.INIT.getValue());
        detailReqVo.setRemarks(reqVo.getRemarks());
        detailReqVo.setTotalAmount(reqVo.getAmount());
        detailReqVo.setUsableAmount(reqVo.getAmount());
        detailReqVo.setUseAmount(BigDecimal.ZERO);
        detailReqVo.setFreezeAmount(BigDecimal.ZERO);
        this.feePoolDetailService.savePoolDetail(detailReqVo);
    }

    @Override
    public FeePoolDiscountQueryForAdjustRespVo queryForAdjust(String id) {
        FeePoolEntity feePool;
        if (StringUtils.isNotEmpty((String)id) && (feePool = (FeePoolEntity)((Object)this.feePoolService.getById((Serializable)((Object)id)))) != null) {
            FeePoolDiscountQueryForAdjustRespVo copy = (FeePoolDiscountQueryForAdjustRespVo)CrmBeanUtil.copy((Object)((Object)feePool), FeePoolDiscountQueryForAdjustRespVo.class);
            String payType = FeePoolConfigUtil.getPayType((String)FeePoolTypeEnum.DISCOUNT.getValue());
            copy.setPayType(payType);
            copy.setDiscountTypeList(FeePoolConfigUtil.getDiscountSelectList());
            copy.setOperationTypeSelectList(FeePoolConfigUtil.getUseInAccountOperationTypeSelectList());
            copy.setPayTypeList(Collections.singletonList(new FeeSelectOptionVo().setValue(payType).setText(DictUtil.dictValue((String)"fee_pool_pay_type", (String)payType))));
            return copy;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void adjustById(FeePoolDiscountAccountReqVo reqVo) {
        Assert.hasText((String)reqVo.getId(), (String)"\u7f3a\u5931id");
        Assert.hasText((String)reqVo.getOperationType(), (String)"\u7f3a\u5931\u8c03\u6574\u7c7b\u578b");
        Assert.isTrue((reqVo.getAmount() != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u4e0a\u8d26\u91d1\u989d");
        Assert.isTrue((reqVo.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u4e0a\u8d26\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        FeePoolEntity feePool = (FeePoolEntity)((Object)this.feePoolService.getById((Serializable)((Object)reqVo.getId())));
        Assert.notNull((Object)((Object)feePool), (String)"\u65e0\u6548\u7684id");
        Assert.isTrue((boolean)FeePoolTypeEnum.DISCOUNT.getValue().equals(feePool.getPoolType()), (String)("\u8be5\u884c\u4e0d\u662f" + FeePoolTypeEnum.DISCOUNT.getDesc() + "\u6570\u636e"));
        String operationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)reqVo.getOperationType());
        Assert.hasText((String)operationTypeValue, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
        Assert.isTrue((boolean)FeePoolConfigUtil.checkOperationTypeUseInAccount((String)reqVo.getOperationType()), (String)"\u8be5\u64cd\u4f5c\u7c7b\u578b\u4e0d\u652f\u6301\u4e0a\u8d26");
        BigDecimal weight = FeePoolConfigUtil.getOperationTypeWeight((String)reqVo.getOperationType());
        String payType = FeePoolConfigUtil.getPayType((String)FeePoolTypeEnum.DISCOUNT.getValue());
        this.feePoolService.addTotalAmount(feePool.getPoolCode(), reqVo.getAmount());
        String operationCode = this.feePoolOperationService.savePoolOperation(feePool.getPoolCode(), reqVo.getOperationType(), reqVo.getFromCode(), operationTypeValue, reqVo.getRemarks(), reqVo.getAmount(), weight, reqVo.getFileList());
        FeePoolDetailReqVo detailReqVo = new FeePoolDetailReqVo();
        CrmBeanUtil.copyExt10((Object)reqVo, (Object)detailReqVo);
        detailReqVo.setPoolCode(feePool.getPoolCode());
        detailReqVo.setOperationCode(operationCode);
        detailReqVo.setOperationType(reqVo.getOperationType());
        detailReqVo.setFromCode(reqVo.getFromCode());
        detailReqVo.setFromDesc(operationTypeValue);
        detailReqVo.setRemarks(reqVo.getRemarks());
        detailReqVo.setTotalAmount(reqVo.getAmount());
        detailReqVo.setUsableAmount(reqVo.getAmount());
        detailReqVo.setUseAmount(BigDecimal.ZERO);
        detailReqVo.setFreezeAmount(BigDecimal.ZERO);
        this.feePoolDetailService.savePoolDetail(detailReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void adjust(FeePoolDiscountAdjustReqVo reqVo) {
        reqVo.setId(null);
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        Assert.hasText((String)reqVo.getOperationType(), (String)"\u7f3a\u5931\u8c03\u6574\u7c7b\u578b");
        Assert.isTrue((reqVo.getAmount() != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u91d1\u989d");
        Assert.isTrue((reqVo.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        String operationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)reqVo.getOperationType());
        Assert.hasText((String)operationTypeValue, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
        FeePoolEntity pool = null;
        LambdaQueryWrapper poolQueryWrapper = new LambdaQueryWrapper();
        poolQueryWrapper.eq(FeePoolEntity::getPoolType, (Object)FeePoolTypeEnum.DISCOUNT.getValue());
        poolQueryWrapper.eq(FeePoolEntity::getCustomerCode, (Object)reqVo.getCustomerCode());
        if (StringUtils.isEmpty((String)reqVo.getDiscountType())) {
            reqVo.setDiscountType("default");
        }
        poolQueryWrapper.eq(FeePoolEntity::getDiscountType, (Object)reqVo.getDiscountType());
        List poolList = this.feePoolMapper.selectList((Wrapper)poolQueryWrapper);
        BigDecimal weight = FeePoolConfigUtil.getOperationTypeWeight((String)reqVo.getOperationType());
        if (CollectionUtil.listNotEmptyNotSizeZero((List)poolList)) {
            pool = (FeePoolEntity)((Object)poolList.get(0));
            this.feePoolService.addTotalAmount(pool.getPoolCode(), reqVo.getAmount());
        } else {
            Assert.isTrue((weight.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)("\u672a\u627e\u5230\u5ba2\u6237[" + reqVo.getCustomerCode() + "]\u6298\u6263\u7c7b\u578b[" + DictUtil.dictValue((String)"fee_pool_discount_type", (String)reqVo.getDiscountType()) + "]\u7ef4\u5ea6\u7684\u8d39\u7528\uff0c\u4e0d\u80fd\u8c03\u51cf\u91d1\u989d"));
            pool = this.createNewPool(reqVo);
        }
        String operationCode = this.feePoolOperationService.savePoolOperation(pool.getPoolCode(), reqVo.getOperationType(), reqVo.getFromCode(), operationTypeValue, reqVo.getRemarks(), reqVo.getAmount(), weight, reqVo.getFileList());
        FeePoolDetailReqVo detailReqVo = new FeePoolDetailReqVo();
        CrmBeanUtil.copyExt10((Object)reqVo, (Object)detailReqVo);
        detailReqVo.setPoolCode(pool.getPoolCode());
        detailReqVo.setOperationCode(operationCode);
        detailReqVo.setOperationType(reqVo.getOperationType());
        detailReqVo.setFromCode(reqVo.getFromCode());
        detailReqVo.setFromDesc(operationTypeValue);
        detailReqVo.setRemarks(reqVo.getRemarks());
        detailReqVo.setTotalAmount(reqVo.getAmount());
        detailReqVo.setUsableAmount(reqVo.getAmount());
        detailReqVo.setUseAmount(BigDecimal.ZERO);
        detailReqVo.setFreezeAmount(BigDecimal.ZERO);
        this.feePoolDetailService.savePoolDetail(detailReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void useDiscountPool(FeePoolDiscountUseReqVo reqVo) {
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        Assert.hasText((String)reqVo.getOperationType(), (String)"\u7f3a\u5931\u64cd\u4f5c\u7c7b\u578b");
        Assert.isTrue((reqVo.getAmount() != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u4f7f\u7528\u91d1\u989d");
        Assert.isTrue((reqVo.getAmount().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u4f7f\u7528\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
        Assert.isTrue((boolean)FeePoolConfigUtil.checkOperationTypeCanUseInDetail((String)reqVo.getOperationType()), (String)"\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c\u7c7b\u578b");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(FeePoolEntity::getCustomerCode, (Object)reqVo.getCustomerCode());
        queryWrapper.eq(FeePoolEntity::getPoolType, (Object)FeePoolTypeEnum.DISCOUNT.getValue());
        if (StringUtils.isNotEmpty((String)reqVo.getDiscountType())) {
            queryWrapper.eq(FeePoolEntity::getDiscountType, (Object)reqVo.getDiscountType());
        } else {
            queryWrapper.and(x -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(FeePoolEntity::getDiscountType, (Object)"")).or()).isNull(FeePoolEntity::getDiscountType);
            });
        }
        List feeUniqueList = this.feePoolMapper.selectList((Wrapper)queryWrapper);
        Assert.notNull((Object)feeUniqueList, (String)("\u672a\u627e\u5230\u5ba2\u6237[" + reqVo.getCustomerCode() + "]\u6298\u6263\u7c7b\u578b[" + reqVo.getDiscountType() + "]\u7ef4\u5ea6\u7684\u6298\u6263\u8d39\u7528\u6c60"));
        FeePoolEntity pool = (FeePoolEntity)((Object)feeUniqueList.get(0));
        Assert.isTrue((pool.getUsableAmount().compareTo(reqVo.getAmount()) >= 0 ? 1 : 0) != 0, (String)"\u53ef\u7528\u91d1\u989d\u4e0d\u8db3");
        if (FeePoolOperationTypeEnum.ORDER_USE.getValue().equals(reqVo.getOperationType())) {
            Assert.hasText((String)reqVo.getFromCode(), (String)(FeePoolOperationTypeEnum.ORDER_USE.getDesc() + "\u65f6\u6765\u6e90\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        BigDecimal operationTypeWeight = FeePoolConfigUtil.getOperationTypeWeight((String)reqVo.getOperationType());
        String operationCode = this.feePoolOperationService.savePoolOperation(pool.getPoolCode(), reqVo.getOperationType(), reqVo.getFromCode(), reqVo.getFromDesc(), reqVo.getRemarks(), reqVo.getAmount(), operationTypeWeight, reqVo.getFileList());
        this.feePoolService.addUseAmount(pool.getPoolCode(), reqVo.getAmount());
        List detailEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolDetailService.lambdaQuery().eq(FeePoolDetailEntity::getPoolCode, (Object)pool.getPoolCode())).orderByAsc(FeePoolDetailEntity::getAccountDateTime)).list();
        BigDecimal restAmount = reqVo.getAmount();
        LinkedHashMap<String, BigDecimal> detailUseAmountMap = new LinkedHashMap<String, BigDecimal>(16);
        for (FeePoolDetailEntity feePoolDetailEntity : detailEntityList) {
            if (restAmount.compareTo(BigDecimal.ZERO) <= 0) break;
            if (feePoolDetailEntity.getUsableAmount().compareTo(BigDecimal.ZERO) < 0) continue;
            BigDecimal itemUse = BigDecimal.ZERO;
            itemUse = feePoolDetailEntity.getUsableAmount().compareTo(restAmount) >= 0 ? restAmount : feePoolDetailEntity.getUsableAmount();
            restAmount = restAmount.subtract(itemUse);
            feePoolDetailEntity.setUseAmount(feePoolDetailEntity.getUseAmount().add(itemUse));
            feePoolDetailEntity.setUsableAmount(feePoolDetailEntity.getUsableAmount().subtract(itemUse));
            detailUseAmountMap.put(feePoolDetailEntity.getPoolDetailCode(), itemUse);
        }
        for (Map.Entry entry : detailUseAmountMap.entrySet()) {
            this.feePoolDetailService.usePoolDetailAmount(pool.getPoolCode(), (String)entry.getKey(), operationCode, reqVo.getOperationType(), reqVo.getFromCode(), reqVo.getFromDesc(), reqVo.getRemarks(), reqVo.getAmount(), operationTypeWeight);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void useDiscountPoolBatch(List<FeePoolDiscountUseReqVo> list) {
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(this::useDiscountPool);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void useDiscountPoolByPoolDetailCode(FeePoolDiscountUseByPoolDetailCodeReqVo reqVo) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void useDiscountPoolByPoolDetailCodeBatch(List<FeePoolDiscountUseByPoolDetailCodeReqVo> list) {
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(this::useDiscountPoolByPoolDetailCode);
        }
    }

    private FeePoolEntity createNewPool(FeePoolDiscountAdjustReqVo reqVo) {
        Result customerResult = this.mdmCustomerMsgFeign.query(null, reqVo.getCustomerCode());
        Assert.isTrue((boolean)customerResult.isSuccess(), (String)"\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        MdmCustomerMsgRespVo customer = (MdmCustomerMsgRespVo)customerResult.getResult();
        Assert.isTrue((customer != null && StringUtils.isNotEmpty((String)customer.getCustomerCode()) ? 1 : 0) != 0, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
        FeePoolEntity entity = new FeePoolEntity();
        entity.setCustomerCode(reqVo.getCustomerCode());
        entity.setDiscountType(reqVo.getDiscountType());
        entity.setPoolType(FeePoolTypeEnum.DISCOUNT.getValue());
        entity.setPoolCode(CodeUtil.generateCode((String)CodeRuleEnum.FEE_POOL_CODE.getCode()));
        entity.setPayType(FeePoolConfigUtil.getPayType((String)FeePoolTypeEnum.DISCOUNT.getValue()));
        entity.setCustomerName(customer.getCustomerName());
        entity.setTotalAmount(reqVo.getAmount());
        entity.setUsableAmount(reqVo.getAmount());
        entity.setUseAmount(BigDecimal.ZERO);
        entity.setFreezeAmount(BigDecimal.ZERO);
        this.feePoolService.save((Object)entity);
        return entity;
    }
}

