/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeEnum;
import com.biz.crm.eunm.fee.FeePoolTypeEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailPageReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsAccountReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsInitAccountReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailPageRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolGoodsQueryForAdjustRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeeSelectOptionVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.pool.mapper.FeePoolMapper;
import com.biz.crm.pool.model.FeePoolEntity;
import com.biz.crm.pool.service.FeePoolDetailService;
import com.biz.crm.pool.service.FeePoolGoodsService;
import com.biz.crm.pool.service.FeePoolOperationService;
import com.biz.crm.pool.service.FeePoolService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.ProductLevelUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"FeePoolGoodsServiceExpandImpl"})
public class FeePoolGoodsServiceImpl
implements FeePoolGoodsService {
    private static final Logger log = LoggerFactory.getLogger(FeePoolGoodsServiceImpl.class);
    @Resource
    private FeePoolMapper feePoolMapper;
    @Resource
    private FeePoolService feePoolService;
    @Resource
    private FeePoolOperationService feePoolOperationService;
    @Resource
    private FeePoolDetailService feePoolDetailService;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private MdmProductFeign mdmProductFeign;

    @Override
    public PageResult<FeePoolRespVo> findList(FeePoolReqVo reqVo) {
        reqVo.setPoolType(FeePoolTypeEnum.GOODS.getValue());
        return this.feePoolService.findList(reqVo);
    }

    @Override
    public PageResult<FeePoolDetailPageRespVo> findFeePoolDetailPageList(FeePoolDetailPageReqVo reqVo) {
        reqVo.setPoolType(FeePoolTypeEnum.GOODS.getValue());
        return this.feePoolDetailService.findFeePoolDetailPageList(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveInitAccount(FeePoolGoodsInitAccountReqVo reqVo) {
        FeePoolTypeEnum feePoolTypeEnum = FeePoolTypeEnum.GOODS;
        FeePoolOperationTypeEnum operationTypeEnum = FeePoolOperationTypeEnum.INIT;
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        Result customerResult = this.mdmCustomerMsgFeign.query(null, reqVo.getCustomerCode());
        Assert.isTrue((boolean)customerResult.isSuccess(), (String)"\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        MdmCustomerMsgRespVo customer = (MdmCustomerMsgRespVo)customerResult.getResult();
        Assert.isTrue((customer != null && StringUtils.isNotEmpty((String)customer.getCustomerCode()) ? 1 : 0) != 0, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
        Assert.isTrue((reqVo.getAmount() != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u4e0a\u8d26\u91d1\u989d");
        Assert.isTrue((reqVo.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u671f\u521d\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        HashMap<String, MdmProductRespVo> productMap = new HashMap<String, MdmProductRespVo>(16);
        if (StringUtils.isNotEmpty((String)reqVo.getGoodsProductCode())) {
            List<String> sortedProductCodeList = Arrays.stream(reqVo.getGoodsProductCode().split(",")).sorted().collect(Collectors.toList());
            Result productResult = this.mdmProductFeign.queryBatchByProductCodeList(sortedProductCodeList);
            Assert.isTrue((boolean)productResult.isSuccess(), (String)"\u67e5\u8be2\u5546\u54c1\u5931\u8d25");
            productMap.putAll(((List)productResult.getResult()).stream().collect(Collectors.toMap(MdmProductRespVo::getProductCode, v -> v)));
            sortedProductCodeList.forEach(productCode -> {
                if (!productMap.containsKey(productCode)) {
                    throw new BusinessException("\u5546\u54c1\u7f16\u7801[" + productCode + "]\u65e0\u6548");
                }
            });
            List sortedProductNameList = sortedProductCodeList.stream().map(productCode -> ((MdmProductRespVo)productMap.get(productCode)).getProductName()).collect(Collectors.toList());
            reqVo.setGoodsProductCode(String.join((CharSequence)",", sortedProductCodeList));
            reqVo.setGoodsProductName(String.join((CharSequence)",", sortedProductNameList));
        }
        if (StringUtils.isNotEmpty((String)reqVo.getGoodsProductLevelCode())) {
            MdmProductLevelRespVo productLevel = ProductLevelUtil.getProductLevelByCode((String)reqVo.getGoodsProductLevelCode());
            Assert.notNull((Object)productLevel, (String)"\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u65e0\u6548");
            reqVo.setGoodsProductLevelName(productLevel.getProductLevelName());
            HashSet childrenCodeSet = new HashSet(ProductLevelUtil.getChildrenProductLevelCodeListIncludeSelf((String)productLevel.getProductLevelCode()));
            if (StringUtils.isNotEmpty((String)reqVo.getGoodsProductCode())) {
                List<String> goodsProductCodeList = Arrays.stream(reqVo.getGoodsProductCode().split(",")).collect(Collectors.toList());
                goodsProductCodeList.forEach(productCode -> {
                    if (!childrenCodeSet.contains(((MdmProductRespVo)productMap.get(productCode)).getProductLevelCode())) {
                        throw new BusinessException("\u5546\u54c1[" + productCode + "]\u4e0d\u5c5e\u4e8e\u4ea7\u54c1\u5c42\u7ea7[" + reqVo.getGoodsProductLevelCode() + "]");
                    }
                });
            }
        }
        LambdaQueryWrapper uniqueQuery = new LambdaQueryWrapper();
        uniqueQuery.eq(FeePoolEntity::getCustomerCode, (Object)reqVo.getCustomerCode());
        uniqueQuery.eq(FeePoolEntity::getPoolType, (Object)FeePoolTypeEnum.GOODS.getValue());
        if (StringUtils.isNotEmpty((String)reqVo.getGoodsProductLevelCode())) {
            uniqueQuery.eq(FeePoolEntity::getGoodsProductLevelCode, (Object)reqVo.getGoodsProductLevelCode());
        } else {
            uniqueQuery.and(x -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(FeePoolEntity::getGoodsProductLevelCode, (Object)"")).or()).isNull(FeePoolEntity::getGoodsProductLevelCode);
            });
        }
        if (StringUtils.isNotEmpty((String)reqVo.getGoodsProductCode())) {
            uniqueQuery.eq(FeePoolEntity::getGoodsProductCode, (Object)reqVo.getGoodsProductCode());
        } else {
            uniqueQuery.and(x -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(FeePoolEntity::getGoodsProductCode, (Object)"")).or()).isNull(FeePoolEntity::getGoodsProductCode);
            });
        }
        List feeUniqueList = this.feePoolMapper.selectList((Wrapper)uniqueQuery);
        Assert.isTrue((boolean)CollectionUtil.listEmpty((List)feeUniqueList), (String)"\u8be5\u5ba2\u6237\u5df2\u7ecf\u5b58\u5728\u8be5\u7ef4\u5ea6\u4e0b\u7684\u671f\u521d\u6570\u636e\uff0c\u4e0d\u53ef\u91cd\u590d\u6dfb\u52a0");
        String payType = FeePoolConfigUtil.getPayType((String)feePoolTypeEnum.getValue());
        FeePoolEntity entity = (FeePoolEntity)((Object)CrmBeanUtil.copy((Object)reqVo, FeePoolEntity.class));
        entity.setPoolType(feePoolTypeEnum.getValue());
        entity.setPoolCode(CodeUtil.generateCode((String)CodeRuleEnum.FEE_POOL_CODE.getCode()));
        entity.setPayType(payType);
        entity.setCustomerName(customer.getCustomerName());
        entity.setUsableAmount(entity.getTotalAmount());
        entity.setUseAmount(BigDecimal.ZERO);
        entity.setFreezeAmount(BigDecimal.ZERO);
        this.feePoolService.save((Object)entity);
        String operationCode = this.feePoolOperationService.savePoolOperation(entity.getPoolCode(), operationTypeEnum.getValue(), reqVo.getFromCode(), FeePoolOperationTypeEnum.INIT.getDesc(), reqVo.getRemarks(), reqVo.getAmount(), BigDecimal.ONE, reqVo.getFileList());
        FeePoolDetailReqVo detailReqVo = new FeePoolDetailReqVo();
        CrmBeanUtil.copyExt10((Object)reqVo, (Object)detailReqVo);
        detailReqVo.setPoolCode(entity.getPoolCode());
        detailReqVo.setOperationCode(operationCode);
        detailReqVo.setOperationType(FeePoolOperationTypeEnum.INIT.getValue());
        detailReqVo.setFromCode(reqVo.getFromCode());
        detailReqVo.setFromDesc(FeePoolOperationTypeEnum.INIT.getValue());
        detailReqVo.setRemarks(reqVo.getRemarks());
        detailReqVo.setTotalAmount(reqVo.getAmount());
        detailReqVo.setUsableAmount(reqVo.getAmount());
        detailReqVo.setUseAmount(BigDecimal.ZERO);
        detailReqVo.setFreezeAmount(BigDecimal.ZERO);
        this.feePoolDetailService.savePoolDetail(detailReqVo);
    }

    @Override
    public FeePoolGoodsQueryForAdjustRespVo queryForAdjust(String id) {
        FeePoolEntity feePool;
        if (StringUtils.isNotEmpty((String)id) && (feePool = (FeePoolEntity)((Object)this.feePoolService.getById((Serializable)((Object)id)))) != null) {
            FeePoolGoodsQueryForAdjustRespVo copy = (FeePoolGoodsQueryForAdjustRespVo)CrmBeanUtil.copy((Object)((Object)feePool), FeePoolGoodsQueryForAdjustRespVo.class);
            String payType = FeePoolConfigUtil.getPayType((String)FeePoolTypeEnum.GOODS.getValue());
            copy.setPayType(payType);
            copy.setOperationTypeSelectList(FeePoolConfigUtil.getUseInAccountOperationTypeSelectList());
            copy.setPayTypeList(Collections.singletonList(new FeeSelectOptionVo().setValue(payType).setText(DictUtil.dictValue((String)"fee_pool_pay_type", (String)payType))));
            return copy;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void adjustById(FeePoolGoodsAccountReqVo reqVo) {
        Assert.hasText((String)reqVo.getId(), (String)"\u7f3a\u5931id");
        Assert.hasText((String)reqVo.getOperationType(), (String)"\u7f3a\u5931\u8c03\u6574\u7c7b\u578b");
        Assert.isTrue((reqVo.getAmount() != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u4e0a\u8d26\u91d1\u989d");
        Assert.isTrue((reqVo.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u4e0a\u8d26\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        FeePoolEntity feePool = (FeePoolEntity)((Object)this.feePoolService.getById((Serializable)((Object)reqVo.getId())));
        Assert.notNull((Object)((Object)feePool), (String)"\u65e0\u6548\u7684id");
        Assert.isTrue((boolean)FeePoolTypeEnum.GOODS.getValue().equals(feePool.getPoolType()), (String)("\u8be5\u884c\u4e0d\u662f" + FeePoolTypeEnum.GOODS.getDesc() + "\u6570\u636e"));
        String operationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)reqVo.getOperationType());
        Assert.hasText((String)operationTypeValue, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
        Assert.isTrue((boolean)FeePoolConfigUtil.checkOperationTypeUseInAccount((String)reqVo.getOperationType()), (String)"\u8be5\u64cd\u4f5c\u7c7b\u578b\u4e0d\u652f\u6301\u4e0a\u8d26");
        BigDecimal weight = FeePoolConfigUtil.getOperationTypeWeight((String)reqVo.getOperationType());
        String payType = FeePoolConfigUtil.getPayType((String)FeePoolTypeEnum.GOODS.getValue());
        this.feePoolService.addTotalAmount(feePool.getPoolCode(), reqVo.getAmount());
        String operationCode = this.feePoolOperationService.savePoolOperation(feePool.getPoolCode(), reqVo.getOperationType(), reqVo.getFromCode(), operationTypeValue, reqVo.getRemarks(), reqVo.getAmount(), weight, reqVo.getFileList());
        FeePoolDetailReqVo detailReqVo = new FeePoolDetailReqVo();
        CrmBeanUtil.copyExt10((Object)reqVo, (Object)detailReqVo);
        detailReqVo.setPoolCode(feePool.getPoolCode());
        detailReqVo.setOperationCode(operationCode);
        detailReqVo.setOperationType(reqVo.getOperationType());
        detailReqVo.setFromCode(reqVo.getFromCode());
        detailReqVo.setFromDesc(operationTypeValue);
        detailReqVo.setRemarks(reqVo.getRemarks());
        detailReqVo.setTotalAmount(reqVo.getAmount());
        detailReqVo.setUsableAmount(reqVo.getAmount());
        detailReqVo.setUseAmount(BigDecimal.ZERO);
        detailReqVo.setFreezeAmount(BigDecimal.ZERO);
        this.feePoolDetailService.savePoolDetail(detailReqVo);
    }
}

