/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.fee.FeePoolOperationTypeEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeExtendEnum;
import com.biz.crm.eunm.fee.FeePoolTypeEnum;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailPageReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsAccountReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsAdjustReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsInitAccountReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolOperationPageReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailPageRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolGoodsQueryForAdjustRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolGoodsQueryForInitAccountRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolOperationPageRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeeSelectOptionVo;
import com.biz.crm.pool.service.FeePoolGoodsService;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collections;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/feePoolGoodsController"})
@Api(tags={"\u8d27\u8865-\u8d39\u7528\u6c60"})
@CrmGlobalLog
public class FeePoolGoodsController {
    private static final Logger log = LoggerFactory.getLogger(FeePoolGoodsController.class);
    @Resource
    private FeePoolGoodsService feePoolGoodsService;

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/pageList"})
    public Result<PageResult<FeePoolRespVo>> pageList(@RequestBody FeePoolReqVo reqVo) {
        PageResult<FeePoolRespVo> result = this.feePoolGoodsService.findList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u83b7\u53d6\u671f\u521d\u52a0\u8f7d\u8be6\u60c5\u6570\u636e")
    @GetMapping(value={"/queryForInitAccount"})
    public Result<FeePoolGoodsQueryForInitAccountRespVo> queryForInitAccount() {
        FeePoolGoodsQueryForInitAccountRespVo respVo = new FeePoolGoodsQueryForInitAccountRespVo();
        String payType = FeePoolConfigUtil.getPayType((String)FeePoolTypeEnum.GOODS.getValue());
        respVo.setOperationTypeSelectList(Collections.singletonList(new FeeSelectOptionVo().setValue(FeePoolOperationTypeEnum.INIT.getValue()).setText(DictUtil.dictValue((String)"fee_pool_operation_type", (String)FeePoolOperationTypeEnum.INIT.getValue()))));
        respVo.setPayTypeList(Collections.singletonList(new FeeSelectOptionVo().setValue(payType).setText(DictUtil.dictValue((String)"fee_pool_pay_type", (String)payType))));
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u7ba1\u7406\u9875\u9762\u4e3b\u8868\u4e0a\u6dfb\u52a0\u671f\u521d")
    @PostMapping(value={"/saveInitAccount"})
    public Result saveInitAccount(@RequestBody FeePoolGoodsInitAccountReqVo reqVo) {
        this.feePoolGoodsService.saveInitAccount(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u901a\u8fc7id\u83b7\u53d6\u8c03\u6574\u8be6\u60c5", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/queryForAdjust"})
    public Result<FeePoolGoodsQueryForAdjustRespVo> queryForAdjust(@RequestParam(value="id", required=true) String id) {
        return Result.ok((Object)this.feePoolGoodsService.queryForAdjust(id));
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u7ba1\u7406\u9875\u9762\u4e3b\u8868\u4e0a\u8c03\u6574")
    @PostMapping(value={"/adjustById"})
    public Result adjustById(@RequestBody FeePoolGoodsAccountReqVo reqVo) {
        this.feePoolGoodsService.adjustById(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u67e5\u8be2\u8d27\u8865\u8d39\u7528\u6c60\u660e\u7ec6\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/findFeePoolDetailPageList"})
    public Result<PageResult<FeePoolDetailPageRespVo>> findFeePoolDetailPageList(@RequestBody FeePoolDetailPageReqVo reqVo) {
        return Result.ok(this.feePoolGoodsService.findFeePoolDetailPageList(reqVo));
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u67e5\u8be2\u8d39\u7528\u6c60\u64cd\u4f5c\u8bb0\u5f55\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/findFeePoolOperationPageList"})
    public Result<PageResult<FeePoolOperationPageRespVo>> findFeePoolOperationPageList(@RequestBody FeePoolOperationPageReqVo reqVo) {
        return Result.ok(this.feePoolGoodsService.findFeePoolOperationPageList(reqVo));
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u83b7\u53d6\u8d27\u8865\u8d39\u7528\u6c60\u660e\u7ec6\u8c03\u6574\u521d\u59cb\u5316\u6570\u636e")
    @GetMapping(value={"/queryForAdjustDetail"})
    public Result<FeePoolGoodsQueryForInitAccountRespVo> queryForAdjustDetail() {
        FeePoolGoodsQueryForInitAccountRespVo respVo = new FeePoolGoodsQueryForInitAccountRespVo();
        String payType = FeePoolConfigUtil.getPayType((String)FeePoolTypeEnum.GOODS.getValue());
        respVo.setOperationTypeSelectList(FeePoolConfigUtil.getOperationTypeSelectList((String)FeePoolOperationTypeExtendEnum.USE_IN_DETAIL.getValue()));
        respVo.setPayTypeList(Collections.singletonList(new FeeSelectOptionVo().setValue(payType).setText(DictUtil.dictValue((String)"fee_pool_pay_type", (String)payType))));
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u8d27\u8865\u8d39\u7528\u6c60\u901a\u7528\u8c03\u6574\uff08\u6309\u7167\u7ef4\u5ea6\u8c03\u6574\uff0c\u7ef4\u5ea6\u4e0d\u5b58\u5728\u751f\u6210\u65b0\u7ef4\u5ea6\uff09")
    @PostMapping(value={"/adjust"})
    public Result adjust(@RequestBody FeePoolGoodsAdjustReqVo reqVo) {
        this.feePoolGoodsService.adjust(reqVo);
        return Result.ok();
    }
}

