/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.controller;

import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.fee.FeePoolOperationTypeExtendEnum;
import com.biz.crm.nebular.fee.pool.req.FeePoolAdjustReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailAdjustReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolQueryForAdjustRespVo;
import com.biz.crm.pool.service.FeePoolDetailService;
import com.biz.crm.util.Result;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/feePoolDetailController"})
@Api(tags={"\u901a\u7528-\u8d39\u7528\u6c60\u660e\u7ec6\u8868"})
public class FeePoolDetailController {
    private static final Logger log = LoggerFactory.getLogger(FeePoolDetailController.class);
    @Resource
    private FeePoolDetailService feePoolDetailService;

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u67e5\u8be2\u8d39\u7528\u6c60\u660e\u7ec6\u5206\u9875\u5217\u8868\uff0c\u6839\u636e\u8d39\u7528\u6c60\u7f16\u53f7")
    @PostMapping(value={"/findFeePoolDetailPageListByPoolCode"})
    public Result<PageResult<FeePoolDetailRespVo>> findFeePoolDetailPageListByPoolCode(@RequestBody FeePoolDetailReqVo reqVo) {
        Assert.hasText((String)reqVo.getPoolCode(), (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
        return Result.ok(this.feePoolDetailService.findFeePoolDetailPageList(reqVo));
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u67e5\u8be2\u8d39\u7528\u6c60\u660e\u7ec6\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/findFeePoolDetailPageList"})
    public Result<PageResult<FeePoolDetailRespVo>> findFeePoolDetailPageList(@RequestBody FeePoolDetailReqVo reqVo) {
        return Result.ok(this.feePoolDetailService.findFeePoolDetailPageList(reqVo));
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u660e\u7ec6\u51bb\u7ed3\uff0c\u901a\u8fc7\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7")
    @PostMapping(value={"/freeze"})
    public Result freeze(@RequestBody FeePoolDetailAdjustReqVo reqVo) {
        this.feePoolDetailService.freezeByPoolDetailCode(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u660e\u7ec6\u89e3\u51bb\uff0c\u901a\u8fc7\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7")
    @PostMapping(value={"/unfreeze"})
    public Result unfreeze(@RequestBody FeePoolDetailAdjustReqVo reqVo) {
        this.feePoolDetailService.unfreezeByPoolDetailCode(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u660e\u7ec6\u8c03\u6574\uff0c\u901a\u8fc7\u7ef4\u5ea6")
    @PostMapping(value={"/adjust"})
    public Result adjust(@RequestBody FeePoolAdjustReqVo reqVo) {
        this.feePoolDetailService.adjust(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u660e\u7ec6\u8c03\u6574\uff0c\u901a\u8fc7\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7")
    @PostMapping(value={"/adjustByPoolDetailCode"})
    public Result adjustByPoolDetailCode(@RequestBody FeePoolDetailAdjustReqVo reqVo) {
        this.feePoolDetailService.adjustByPoolDetailCode(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u901a\u8fc7\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7\u67e5\u8be2\u660e\u7ec6\u884c\u8c03\u6574\u521d\u59cb\u5316\u6570\u636e", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="poolDetailCode", value="\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/queryForAdjustByPoolDetailCode"})
    public Result<FeePoolQueryForAdjustRespVo> queryForAdjustByPoolDetailCode(@RequestParam(value="poolDetailCode", required=true) String poolDetailCode) {
        FeePoolQueryForAdjustRespVo respVo = this.feePoolDetailService.queryForAdjustByPoolDetailCode(poolDetailCode);
        respVo.setOperationTypeSelectList(FeePoolConfigUtil.getOperationTypeSelectList((String)FeePoolOperationTypeExtendEnum.ADJUST_POOL_DETAIL_LINE.getValue()));
        respVo.setPayTypeList(FeePoolConfigUtil.getPayTypeSelectList());
        respVo.setDiscountTypeList(FeePoolConfigUtil.getDiscountSelectList());
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u901a\u8fc7\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7\u67e5\u8be2\u660e\u7ec6\u8be6\u60c5", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="poolDetailCode", value="\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/queryByPoolDetailCode"})
    public Result<FeePoolDetailRespVo> queryByPoolDetailCode(@RequestParam(value="poolDetailCode", required=true) String poolDetailCode) {
        return Result.ok((Object)this.feePoolDetailService.queryByPoolDetailCode(poolDetailCode));
    }

    @ApiOperation(value="\u901a\u8fc7\u660e\u7ec6id\u67e5\u8be2\u660e\u7ec6\u8be6\u60c5", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/queryById"})
    public Result<FeePoolDetailRespVo> queryById(@RequestParam(value="id", required=true) String id) {
        return Result.ok((Object)this.feePoolDetailService.queryById(id));
    }
}

