/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.fee.FeePoolOperationTypeExtendEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeGroupEnum;
import com.biz.crm.eunm.fee.FeePoolTypeEnum;
import com.biz.crm.mdm.pricesetting.MdmPriceSettingFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.nebular.fee.pool.req.FeePoolAdjustReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsProductReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsUseItemReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsUseReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolOperationReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolGoodsRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolOperationRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeeSelectOptionVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSearchReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.pool.mapper.FeePoolMapper;
import com.biz.crm.pool.service.FeePoolDetailService;
import com.biz.crm.pool.service.FeePoolGoodsService;
import com.biz.crm.pool.service.FeePoolOperationService;
import com.biz.crm.pool.service.FeePoolService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"FeePoolGoodsServiceExpandImpl"})
public class FeePoolGoodsServiceImpl
implements FeePoolGoodsService {
    private static final Logger log = LoggerFactory.getLogger(FeePoolGoodsServiceImpl.class);
    @Resource
    private FeePoolMapper feePoolMapper;
    @Resource
    private FeePoolService feePoolService;
    @Resource
    private FeePoolOperationService feePoolOperationService;
    @Resource
    private FeePoolDetailService feePoolDetailService;
    @Resource
    private MdmProductFeign mdmProductFeign;
    @Resource
    private MdmPriceSettingFeign mdmPriceSettingFeign;

    @Override
    public PageResult<FeePoolRespVo> findList(FeePoolReqVo reqVo) {
        reqVo.setPoolType(FeePoolTypeEnum.GOODS.getValue());
        return this.feePoolService.findList(reqVo);
    }

    @Override
    public PageResult<FeePoolDetailRespVo> findFeePoolDetailPageList(FeePoolDetailReqVo reqVo) {
        reqVo.setPoolType(FeePoolTypeEnum.GOODS.getValue());
        return this.feePoolDetailService.findFeePoolDetailPageList(reqVo);
    }

    @Override
    public PageResult<FeePoolDetailRespVo> findFeePoolDetailAccountList(FeePoolDetailReqVo reqVo) {
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        reqVo.setPoolType(FeePoolTypeEnum.GOODS.getValue());
        return this.feePoolDetailService.findFeePoolDetailPageList(reqVo);
    }

    @Override
    public PageResult<FeePoolOperationRespVo> findFeePoolOperationPageList(FeePoolOperationReqVo reqVo) {
        reqVo.setPoolType(FeePoolTypeEnum.GOODS.getValue());
        return this.feePoolOperationService.findFeePoolOperationPageList(reqVo);
    }

    @Override
    public PageResult<FeePoolOperationRespVo> findFeePoolUseList(FeePoolOperationReqVo reqVo) {
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        reqVo.setPoolType(FeePoolTypeEnum.GOODS.getValue());
        List<String> collect = FeePoolConfigUtil.getOperationTypeSelectList((String)FeePoolOperationTypeExtendEnum.SHOW_DETAIL_USE.getValue()).stream().map(FeeSelectOptionVo::getValue).collect(Collectors.toList());
        return this.feePoolOperationService.findList(reqVo, collect);
    }

    @Override
    public PageResult<FeePoolGoodsRespVo> findGoodsPoolProductList(FeePoolGoodsProductReqVo reqVo) {
        Set collect;
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        reqVo.setPoolType(FeePoolTypeEnum.GOODS.getValue());
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<FeePoolGoodsRespVo> list = this.feePoolMapper.findGoodsPoolProductList((Page<FeePoolGoodsRespVo>)page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list) && !(collect = list.stream().filter(item -> StringUtils.isNotEmpty((String)item.getGoodsProductCode())).map(FeePoolGoodsRespVo::getGoodsProductCode).collect(Collectors.toSet())).isEmpty()) {
            List result;
            Result listResult = this.mdmProductFeign.queryBatchByProductCodeList(new ArrayList(collect));
            if (listResult.isSuccess() && CollectionUtil.listNotEmptyNotSizeZero((List)(result = (List)listResult.getResult()))) {
                Map<String, MdmProductRespVo> productMap = result.stream().collect(Collectors.toMap(MdmProductRespVo::getProductCode, v -> v));
                Map saleUnitMap = DictUtil.dictMap((String)"product_sale_unit");
                list.forEach(item -> {
                    if (StringUtils.isNotEmpty((String)item.getGoodsProductCode()) && productMap.containsKey(item.getGoodsProductCode())) {
                        MdmProductRespVo product = (MdmProductRespVo)productMap.get(item.getGoodsProductCode());
                        item.setSpec(product.getSpec());
                        item.setSaleUnit(product.getSaleUnit());
                        item.setSaleUnitName((String)saleUnitMap.get(product.getSaleUnit()));
                    }
                });
            }
            String salePrice = "sale_price";
            MdmPriceSearchReqVo searchReqVo = new MdmPriceSearchReqVo();
            searchReqVo.setCustomerCode(reqVo.getCustomerCode());
            searchReqVo.setProductCodeList(new ArrayList(collect));
            searchReqVo.setSearchTime(DateUtil.dateNow2Str());
            searchReqVo.setConditionTypeCodeList(Collections.singletonList("sale_price"));
            Result search = this.mdmPriceSettingFeign.search(searchReqVo);
            if (search.isSuccess()) {
                Map productPriceMap = (Map)search.getResult();
                list.forEach(item -> {
                    Map stringObjectMap;
                    Map priceMap;
                    if (StringUtils.isNotEmpty((String)item.getGoodsProductCode()) && productPriceMap.containsKey(item.getGoodsProductCode()) && (priceMap = (Map)productPriceMap.get(item.getGoodsProductCode())).containsKey("sale_price") && (stringObjectMap = (Map)priceMap.get("sale_price")) != null) {
                        Object price = stringObjectMap.get("price");
                        item.setPrice(price == null ? BigDecimal.ZERO : new BigDecimal(price.toString()));
                    }
                });
            }
            list.forEach(item -> {
                if (item.getPrice() == null) {
                    item.setPrice(BigDecimal.ZERO);
                }
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void adjust(FeePoolAdjustReqVo reqVo) {
        this.feePoolService.adjust(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void adjustByPoolCode(FeePoolAdjustReqVo reqVo) {
        this.feePoolService.adjustByPoolCode(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void useGoodsPoolByPoolCode(FeePoolGoodsUseReqVo reqVo) {
        Assert.hasText((String)reqVo.getOperationType(), (String)"\u7f3a\u5931\u64cd\u4f5c\u7c7b\u578b");
        Assert.notEmpty((Collection)reqVo.getPoolAmountList(), (String)"\u7f3a\u5931\u4f7f\u7528\u91d1\u989d\u660e\u7ec6");
        Assert.isTrue((boolean)FeePoolConfigUtil.checkOperationTypeGroup((String)reqVo.getOperationType(), (FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.USE), (String)"\u8be5\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4f7f\u7528\u8d39\u7528\u6c60\u91d1\u989d");
        for (FeePoolGoodsUseItemReqVo item : reqVo.getPoolAmountList()) {
            Assert.isTrue((item.getAmount() != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u4f7f\u7528\u91d1\u989d");
            Assert.isTrue((item.getAmount().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u4f7f\u7528\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
            this.feePoolService.useByPoolCode(item.getPoolCode(), reqVo.getOperationType(), item.getAmount(), "", reqVo.getFromCode(), StringUtils.isNotEmpty((String)reqVo.getFromDesc()) ? reqVo.getFromDesc() : DictUtil.dictValue((String)"fee_pool_operation_type", (String)reqVo.getOperationType()), reqVo.getRemarks(), reqVo.getFileList());
        }
    }
}

