/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.fee.FeePoolOperationTypeExtendEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeGroupEnum;
import com.biz.crm.eunm.fee.FeePoolTypeEnum;
import com.biz.crm.nebular.fee.pool.req.FeePoolAdjustReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDiscountUseReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolOperationReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolOperationRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeeSelectOptionVo;
import com.biz.crm.pool.mapper.FeePoolMapper;
import com.biz.crm.pool.model.FeePoolEntity;
import com.biz.crm.pool.service.FeePoolDetailService;
import com.biz.crm.pool.service.FeePoolDiscountService;
import com.biz.crm.pool.service.FeePoolOperationService;
import com.biz.crm.pool.service.FeePoolService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"FeePoolDiscountServiceExpandImpl"})
public class FeePoolDiscountServiceImpl
implements FeePoolDiscountService {
    private static final Logger log = LoggerFactory.getLogger(FeePoolDiscountServiceImpl.class);
    @Resource
    private FeePoolMapper feePoolMapper;
    @Resource
    private FeePoolService feePoolService;
    @Resource
    private FeePoolOperationService feePoolOperationService;
    @Resource
    private FeePoolDetailService feePoolDetailService;

    @Override
    public PageResult<FeePoolRespVo> findList(FeePoolReqVo reqVo) {
        reqVo.setPoolType(FeePoolTypeEnum.DISCOUNT.getValue());
        return this.feePoolService.findList(reqVo);
    }

    @Override
    public PageResult<FeePoolDetailRespVo> findFeePoolDetailPageList(FeePoolDetailReqVo reqVo) {
        reqVo.setPoolType(FeePoolTypeEnum.DISCOUNT.getValue());
        return this.feePoolDetailService.findFeePoolDetailPageList(reqVo);
    }

    @Override
    public PageResult<FeePoolDetailRespVo> findFeePoolDetailAccountList(FeePoolDetailReqVo reqVo) {
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        reqVo.setPoolType(FeePoolTypeEnum.DISCOUNT.getValue());
        return this.feePoolDetailService.findFeePoolDetailPageList(reqVo);
    }

    @Override
    public PageResult<FeePoolOperationRespVo> findFeePoolOperationPageList(FeePoolOperationReqVo reqVo) {
        reqVo.setPoolType(FeePoolTypeEnum.DISCOUNT.getValue());
        return this.feePoolOperationService.findFeePoolOperationPageList(reqVo);
    }

    @Override
    public PageResult<FeePoolOperationRespVo> findFeePoolUseList(FeePoolOperationReqVo reqVo) {
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        reqVo.setPoolType(FeePoolTypeEnum.DISCOUNT.getValue());
        List<String> collect = FeePoolConfigUtil.getOperationTypeSelectList((String)FeePoolOperationTypeExtendEnum.SHOW_DETAIL_USE.getValue()).stream().map(FeeSelectOptionVo::getValue).collect(Collectors.toList());
        return this.feePoolOperationService.findList(reqVo, collect);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void adjust(FeePoolAdjustReqVo reqVo) {
        this.feePoolService.adjust(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void adjustByPoolCode(FeePoolAdjustReqVo reqVo) {
        this.feePoolService.adjustByPoolCode(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void useDiscountPool(FeePoolDiscountUseReqVo reqVo) {
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        Assert.hasText((String)reqVo.getOperationType(), (String)"\u7f3a\u5931\u64cd\u4f5c\u7c7b\u578b");
        Assert.isTrue((reqVo.getAmount() != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u4f7f\u7528\u91d1\u989d");
        Assert.isTrue((reqVo.getAmount().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u4f7f\u7528\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
        Assert.isTrue((boolean)FeePoolConfigUtil.checkOperationTypeGroup((String)reqVo.getOperationType(), (FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.USE), (String)"\u8be5\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4f7f\u7528\u8d39\u7528\u6c60\u91d1\u989d");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(FeePoolEntity::getCustomerCode, (Object)reqVo.getCustomerCode());
        queryWrapper.eq(FeePoolEntity::getPoolType, (Object)FeePoolTypeEnum.DISCOUNT.getValue());
        if (StringUtils.isNotEmpty((String)reqVo.getDiscountType())) {
            queryWrapper.eq(FeePoolEntity::getDiscountType, (Object)reqVo.getDiscountType());
        } else {
            queryWrapper.and(x -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(FeePoolEntity::getDiscountType, (Object)"")).or()).isNull(FeePoolEntity::getDiscountType);
            });
        }
        List feeUniqueList = this.feePoolMapper.selectList((Wrapper)queryWrapper);
        Assert.notNull((Object)feeUniqueList, (String)("\u672a\u627e\u5230\u5ba2\u6237[" + reqVo.getCustomerCode() + "]\u6298\u6263\u7c7b\u578b[" + reqVo.getDiscountType() + "]\u7ef4\u5ea6\u7684\u6298\u6263\u8d39\u7528\u6c60"));
        FeePoolEntity pool = (FeePoolEntity)((Object)feeUniqueList.get(0));
        this.feePoolService.useByPoolCode(pool.getPoolCode(), reqVo.getOperationType(), reqVo.getAmount(), "", reqVo.getFromCode(), StringUtils.isNotEmpty((String)reqVo.getFromDesc()) ? reqVo.getFromDesc() : DictUtil.dictValue((String)"fee_pool_operation_type", (String)reqVo.getOperationType()), reqVo.getRemarks(), reqVo.getFileList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void useDiscountPoolBatch(List<FeePoolDiscountUseReqVo> list) {
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(this::useDiscountPool);
        }
    }
}

