/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeExtendEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeGroupEnum;
import com.biz.crm.eunm.fee.FeePoolTypeEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.nebular.fee.pool.req.FeePoolAccountReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolAdjustReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailLogReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolFileReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolUseBackAllReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolAmountRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolMonthAmountRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolQueryForAdjustRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeeSelectOptionVo;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.pool.mapper.FeePoolMapper;
import com.biz.crm.pool.model.FeePoolDetailEntity;
import com.biz.crm.pool.model.FeePoolDetailLogEntity;
import com.biz.crm.pool.model.FeePoolEntity;
import com.biz.crm.pool.model.FeePoolOperationEntity;
import com.biz.crm.pool.service.FeePoolDetailLogService;
import com.biz.crm.pool.service.FeePoolDetailService;
import com.biz.crm.pool.service.FeePoolOperationService;
import com.biz.crm.pool.service.FeePoolService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ProductLevelUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"FeePoolServiceExpandImpl"})
public class FeePoolServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<FeePoolMapper, FeePoolEntity>
implements FeePoolService {
    private static final Logger log = LoggerFactory.getLogger(FeePoolServiceImpl.class);
    @Resource
    private FeePoolMapper feePoolMapper;
    @Resource
    private FeePoolOperationService feePoolOperationService;
    @Resource
    private FeePoolDetailService feePoolDetailService;
    @Resource
    private FeePoolDetailLogService feePoolDetailLogService;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private MdmProductFeign mdmProductFeign;

    @Override
    public PageResult<FeePoolRespVo> findList(FeePoolReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<FeePoolRespVo> list = this.feePoolMapper.findList((Page<FeePoolRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public FeePoolRespVo queryByPoolCode(String poolCode) {
        FeePoolEntity one;
        if (StringUtils.isNotEmpty((String)poolCode) && (one = (FeePoolEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolCode)).one())) != null) {
            return (FeePoolRespVo)CrmBeanUtil.copy((Object)((Object)one), FeePoolRespVo.class);
        }
        return null;
    }

    @Override
    public FeePoolRespVo queryById(String id) {
        FeePoolEntity one;
        if (StringUtils.isNotEmpty((String)id) && (one = (FeePoolEntity)((Object)this.getById((Serializable)((Object)id)))) != null) {
            return (FeePoolRespVo)CrmBeanUtil.copy((Object)((Object)one), FeePoolRespVo.class);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void account(FeePoolAccountReqVo reqVo) {
        Assert.hasText((String)reqVo.getPoolType(), (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7c7b\u578b");
        FeePoolTypeEnum poolTypeEnum = FeePoolTypeEnum.getEnum((String)reqVo.getPoolType());
        Assert.notNull((Object)poolTypeEnum, (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u7c7b\u578b");
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        Assert.hasText((String)reqVo.getOperationType(), (String)"\u7f3a\u5931\u64cd\u4f5c\u7c7b\u578b");
        Assert.isTrue((reqVo.getAmount() != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u4e0a\u8d26\u91d1\u989d");
        Assert.isTrue((reqVo.getAmount().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u4e0a\u8d26\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
        Assert.isTrue((boolean)FeePoolConfigUtil.checkOperationTypeGroup((String)reqVo.getOperationType(), (FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.ACCOUNT), (String)"\u8be5\u64cd\u4f5c\u7c7b\u578b\u4e0d\u652f\u6301\u4e0a\u8d26");
        String payType = FeePoolConfigUtil.getPayType((String)poolTypeEnum.getValue());
        FeePoolAdjustReqVo adjust = new FeePoolAdjustReqVo();
        switch (poolTypeEnum) {
            case DISCOUNT: {
                adjust.setDiscountType(reqVo.getDiscountType());
                break;
            }
            case GOODS: {
                Assert.isTrue((StringUtils.isNotEmpty((String)reqVo.getProductLevelCode()) || CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getProductCodeList()) ? 1 : 0) != 0, (String)"\u4ea7\u54c1\u5c42\u7ea7\u548c\u5546\u54c1\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
                adjust.setGoodsProductLevelCode(reqVo.getProductLevelCode());
                if (!CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getProductCodeList())) break;
                adjust.setGoodsProductCode(String.join((CharSequence)",", reqVo.getProductCodeList()));
                break;
            }
        }
        adjust.setPoolType(poolTypeEnum.getValue());
        adjust.setCustomerCode(reqVo.getCustomerCode());
        adjust.setOperationType(reqVo.getOperationType());
        adjust.setFromCode(reqVo.getFromCode());
        adjust.setFromDesc(reqVo.getFromDesc());
        adjust.setRemarks(reqVo.getRemarks());
        adjust.setAmount(reqVo.getAmount());
        adjust.setPayType(payType);
        adjust.setFileList(reqVo.getFileList());
        CrmBeanUtil.copyExt10((Object)reqVo, (Object)adjust);
        this.adjust(adjust);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void adjust(FeePoolAdjustReqVo reqVo) {
        reqVo.setId(null);
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        Assert.hasText((String)reqVo.getOperationType(), (String)"\u7f3a\u5931\u8c03\u6574\u7c7b\u578b");
        Assert.isTrue((reqVo.getAmount() != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u91d1\u989d");
        Assert.isTrue((reqVo.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        String operationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)reqVo.getOperationType());
        Assert.hasText((String)operationTypeValue, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
        String fromDesc = StringUtils.isNotEmpty((String)reqVo.getFromDesc()) ? reqVo.getFromDesc() : operationTypeValue;
        FeePoolOperationTypeGroupEnum operationTypeGroup = FeePoolConfigUtil.getOperationTypeGroup((String)reqVo.getOperationType());
        Assert.isTrue((FeePoolOperationTypeGroupEnum.BACK != operationTypeGroup ? 1 : 0) != 0, (String)"\u5934\u64cd\u4f5c\u4e0d\u652f\u6301\u56de\u9000\u91d1\u989d\u7c7b\u64cd\u4f5c");
        Result customerResult = this.mdmCustomerMsgFeign.query(null, reqVo.getCustomerCode());
        Assert.isTrue((boolean)customerResult.isSuccess(), (String)"\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        MdmCustomerMsgRespVo customer = (MdmCustomerMsgRespVo)customerResult.getResult();
        Assert.isTrue((customer != null && StringUtils.isNotEmpty((String)customer.getCustomerCode()) ? 1 : 0) != 0, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
        Assert.hasText((String)reqVo.getPayType(), (String)"\u7f3a\u5931\u652f\u4ed8\u65b9\u5f0f");
        FeePoolTypeEnum poolTypeEnum = FeePoolConfigUtil.getPoolTypeByPayType((String)reqVo.getPayType());
        FeePoolEntity pool = null;
        LambdaQueryWrapper poolQuery = new LambdaQueryWrapper();
        poolQuery.eq(FeePoolEntity::getCustomerCode, (Object)reqVo.getCustomerCode());
        poolQuery.eq(FeePoolEntity::getPoolType, (Object)poolTypeEnum.getValue());
        String goodsProductLevelCode = null;
        String goodsProductLevelName = null;
        String goodsProductCode = null;
        String goodsProductName = null;
        if (poolTypeEnum == FeePoolTypeEnum.DISCOUNT) {
            if (StringUtils.isNotEmpty((String)reqVo.getDiscountType())) {
                poolQuery.eq(FeePoolEntity::getDiscountType, (Object)reqVo.getDiscountType());
            } else {
                poolQuery.and(x -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(FeePoolEntity::getDiscountType, (Object)"")).or()).isNull(FeePoolEntity::getDiscountType);
                });
            }
        } else if (poolTypeEnum == FeePoolTypeEnum.GOODS) {
            Assert.isTrue((StringUtils.isNotEmpty((String)reqVo.getGoodsProductLevelCode()) || StringUtils.isNotEmpty((String)reqVo.getGoodsProductCode()) ? 1 : 0) != 0, (String)"\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5546\u54c1\u6216\u4e00\u4e2a\u4ea7\u54c1\u5c42\u7ea7");
            HashMap<String, MdmProductRespVo> productMap = new HashMap<String, MdmProductRespVo>(16);
            if (StringUtils.isNotEmpty((String)reqVo.getGoodsProductCode())) {
                List<String> sortedProductCodeList = Arrays.stream(reqVo.getGoodsProductCode().split(",")).sorted().collect(Collectors.toList());
                Result productResult = this.mdmProductFeign.queryBatchByProductCodeList(sortedProductCodeList);
                Assert.isTrue((boolean)productResult.isSuccess(), (String)"\u67e5\u8be2\u5546\u54c1\u5931\u8d25");
                productMap.putAll(((List)productResult.getResult()).stream().collect(Collectors.toMap(MdmProductRespVo::getProductCode, v -> v)));
                sortedProductCodeList.forEach(productCode -> Assert.isTrue((boolean)productMap.containsKey(productCode), (String)("\u5546\u54c1\u7f16\u7801[" + productCode + "]\u65e0\u6548")));
                List sortedProductNameList = sortedProductCodeList.stream().map(productCode -> ((MdmProductRespVo)productMap.get(productCode)).getProductName()).collect(Collectors.toList());
                reqVo.setGoodsProductCode(String.join((CharSequence)",", sortedProductCodeList));
                goodsProductCode = String.join((CharSequence)",", sortedProductCodeList);
                goodsProductName = String.join((CharSequence)",", sortedProductNameList);
            }
            if (StringUtils.isNotEmpty((String)reqVo.getGoodsProductLevelCode())) {
                MdmProductLevelRespVo productLevel = ProductLevelUtil.getProductLevelByCode((String)reqVo.getGoodsProductLevelCode());
                Assert.notNull((Object)productLevel, (String)"\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u65e0\u6548");
                goodsProductLevelCode = productLevel.getProductLevelCode();
                goodsProductLevelName = productLevel.getProductLevelName();
                HashSet childrenCodeSet = new HashSet(ProductLevelUtil.getChildrenProductLevelCodeListIncludeSelf((String)productLevel.getProductLevelCode()));
                if (StringUtils.isNotEmpty((String)reqVo.getGoodsProductCode())) {
                    List<String> goodsProductCodeList = Arrays.stream(reqVo.getGoodsProductCode().split(",")).collect(Collectors.toList());
                    goodsProductCodeList.forEach(productCode -> Assert.isTrue((boolean)childrenCodeSet.contains(((MdmProductRespVo)productMap.get(productCode)).getProductLevelCode()), (String)("\u5546\u54c1[" + productCode + "]\u4e0d\u5c5e\u4e8e\u4ea7\u54c1\u5c42\u7ea7[" + reqVo.getGoodsProductLevelCode() + "]")));
                }
            }
            if (StringUtils.isNotEmpty(goodsProductLevelCode)) {
                poolQuery.eq(FeePoolEntity::getGoodsProductLevelCode, goodsProductLevelCode);
            } else {
                poolQuery.and(x -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(FeePoolEntity::getGoodsProductLevelCode, (Object)"")).or()).isNull(FeePoolEntity::getGoodsProductLevelCode);
                });
            }
            if (StringUtils.isNotEmpty(goodsProductCode)) {
                poolQuery.eq(FeePoolEntity::getGoodsProductCode, goodsProductCode);
            } else {
                poolQuery.and(x -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(FeePoolEntity::getGoodsProductCode, (Object)"")).or()).isNull(FeePoolEntity::getGoodsProductCode);
                });
            }
        } else {
            throw new BusinessException("\u4e0d\u8bc6\u522b\u7684\u8d39\u7528\u6c60\u7c7b\u578b");
        }
        List poolEntityList = this.feePoolMapper.selectList((Wrapper)poolQuery);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)poolEntityList)) {
            pool = (FeePoolEntity)((Object)poolEntityList.get(0));
        }
        block0 : switch (operationTypeGroup) {
            case ACCOUNT: {
                if (FeePoolOperationTypeEnum.INIT.getValue().equals(reqVo.getOperationType())) {
                    switch (poolTypeEnum) {
                        case DISCOUNT: {
                            Assert.isTrue((pool == null ? 1 : 0) != 0, (String)("\u5df2\u5b58\u5728\u5ba2\u6237\u3010" + customer.getCustomerName() + "\u3011" + (StringUtils.isNotEmpty((String)reqVo.getDiscountType()) ? "\u6298\u6263\u7c7b\u578b\u3010" + DictUtil.dictValue((String)"fee_pool_discount_type", (String)reqVo.getDiscountType()) + "\u3011" : "\u65e0\u6298\u6263\u7c7b\u578b") + "\u7684\u8d39\u7528\u6c60\uff0c\u4e0d\u80fd\u518d\u671f\u521d\u4e0a\u8d26"));
                            break;
                        }
                        case GOODS: {
                            Assert.isTrue((pool == null ? 1 : 0) != 0, (String)("\u5df2\u5b58\u5728\u5ba2\u6237\u3010" + customer.getCustomerName() + "\u3011" + (StringUtils.isNotEmpty((String)goodsProductLevelName) ? "\u8d27\u8865\u4ea7\u54c1\u5c42\u7ea7\u3010" + goodsProductLevelName + "\u3011" : "") + (StringUtils.isNotEmpty(goodsProductName) ? "\u8d27\u8865\u5546\u54c1\u3010" + goodsProductName + "\u3011" : "") + "\u7684\u8d39\u7528\u6c60\uff0c\u4e0d\u80fd\u518d\u671f\u521d\u4e0a\u8d26"));
                            break;
                        }
                    }
                }
                if (pool != null) {
                    this.accountByPoolCode(pool.getPoolCode(), reqVo.getOperationType(), reqVo.getAmount(), reqVo.getBpmStatus(), reqVo.getFromCode(), fromDesc, reqVo.getRemarks(), reqVo.getFileList(), (CrmExtTenVo)CrmBeanUtil.copy((Object)reqVo, CrmExtTenVo.class));
                    break;
                }
                switch (poolTypeEnum) {
                    case DISCOUNT: {
                        this.initDiscount(customer.getCustomerCode(), customer.getCustomerName(), reqVo.getDiscountType(), reqVo.getOperationType(), reqVo.getAmount(), reqVo.getBpmStatus(), reqVo.getFromCode(), fromDesc, reqVo.getRemarks(), reqVo.getFileList(), (CrmExtTenVo)CrmBeanUtil.copy((Object)reqVo, CrmExtTenVo.class));
                        break block0;
                    }
                    case GOODS: {
                        this.initGoods(customer.getCustomerCode(), customer.getCustomerName(), goodsProductLevelCode, goodsProductLevelName, goodsProductCode, goodsProductName, reqVo.getOperationType(), reqVo.getAmount(), reqVo.getBpmStatus(), reqVo.getFromCode(), fromDesc, reqVo.getRemarks(), reqVo.getFileList(), (CrmExtTenVo)CrmBeanUtil.copy((Object)reqVo, CrmExtTenVo.class));
                        break block0;
                    }
                }
                break;
            }
            case USE: {
                Assert.notNull((Object)((Object)pool), (String)"\u4e0d\u5b58\u5728\u7ef4\u5ea6\uff0c\u4e0d\u80fd\u4f7f\u7528\u6263\u51cf\u91d1\u989d\u7c7b\u64cd\u4f5c");
                this.useByPoolCode(pool.getPoolCode(), reqVo.getOperationType(), reqVo.getAmount(), reqVo.getBpmStatus(), reqVo.getFromCode(), fromDesc, reqVo.getRemarks(), reqVo.getFileList());
                break;
            }
            case FREEZE: {
                Assert.notNull((Object)((Object)pool), (String)"\u4e0d\u5b58\u5728\u7ef4\u5ea6\uff0c\u4e0d\u80fd\u4f7f\u7528\u51bb\u7ed3\u91d1\u989d\u7c7b\u64cd\u4f5c");
                this.freezeByPoolCode(pool.getPoolCode(), reqVo.getOperationType(), reqVo.getAmount(), reqVo.getBpmStatus(), reqVo.getFromCode(), fromDesc, reqVo.getRemarks(), reqVo.getFileList());
                break;
            }
            case UNFREEZE: {
                Assert.notNull((Object)((Object)pool), (String)"\u4e0d\u5b58\u5728\u7ef4\u5ea6\uff0c\u4e0d\u80fd\u4f7f\u7528\u89e3\u51bb\u91d1\u989d\u7c7b\u64cd\u4f5c");
                this.unfreezeByPoolCode(pool.getPoolCode(), reqVo.getOperationType(), reqVo.getAmount(), reqVo.getBpmStatus(), reqVo.getFromCode(), fromDesc, reqVo.getRemarks(), reqVo.getFileList());
                break;
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void adjustByPoolCode(FeePoolAdjustReqVo reqVo) {
        Assert.hasText((String)reqVo.getPoolCode(), (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.hasText((String)reqVo.getOperationType(), (String)"\u7f3a\u5931\u8c03\u6574\u7c7b\u578b");
        Assert.isTrue((reqVo.getAmount() != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u8c03\u6574\u91d1\u989d");
        Assert.isTrue((reqVo.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u8c03\u6574\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        FeePoolEntity pool = (FeePoolEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)reqVo.getPoolCode())).one());
        Assert.notNull((Object)((Object)pool), (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u7f16\u53f7");
        String operationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)reqVo.getOperationType());
        Assert.hasText((String)operationTypeValue, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
        FeePoolOperationTypeGroupEnum operationTypeGroup = FeePoolConfigUtil.getOperationTypeGroup((String)reqVo.getOperationType());
        switch (operationTypeGroup) {
            case ACCOUNT: {
                this.accountByPoolCode(pool.getPoolCode(), reqVo.getOperationType(), reqVo.getAmount(), reqVo.getBpmStatus(), reqVo.getFromCode(), operationTypeValue, reqVo.getRemarks(), reqVo.getFileList(), (CrmExtTenVo)CrmBeanUtil.copy((Object)reqVo, CrmExtTenVo.class));
                break;
            }
            case USE: {
                this.useByPoolCode(pool.getPoolCode(), reqVo.getOperationType(), reqVo.getAmount(), reqVo.getBpmStatus(), reqVo.getFromCode(), operationTypeValue, reqVo.getRemarks(), reqVo.getFileList());
                break;
            }
            case FREEZE: {
                this.freezeByPoolCode(pool.getPoolCode(), reqVo.getOperationType(), reqVo.getAmount(), reqVo.getBpmStatus(), reqVo.getFromCode(), operationTypeValue, reqVo.getRemarks(), reqVo.getFileList());
                break;
            }
            case UNFREEZE: {
                this.unfreezeByPoolCode(pool.getPoolCode(), reqVo.getOperationType(), reqVo.getAmount(), reqVo.getBpmStatus(), reqVo.getFromCode(), operationTypeValue, reqVo.getRemarks(), reqVo.getFileList());
                break;
            }
            case BACK: {
                break;
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void initDiscount(String customerCode, String customerName, String discountType, String operationType, BigDecimal amount, String bpmStatus, String fromCode, String fromDesc, String remarks, List<FeePoolFileReqVo> fileList, CrmExtTenVo reqVo) {
        String operationDateTime = DateUtil.dateNowHms();
        FeePoolEntity pool = new FeePoolEntity();
        pool.setPoolCode(CodeUtil.generateCode((String)CodeRuleEnum.FEE_POOL_CODE.getCode()));
        pool.setPoolType(FeePoolTypeEnum.DISCOUNT.getValue());
        pool.setPayType(FeePoolConfigUtil.getPayType((String)FeePoolTypeEnum.DISCOUNT.getValue()));
        pool.setCustomerCode(customerCode);
        pool.setCustomerName(customerName);
        pool.setDiscountType(discountType);
        pool.setTotalAmount(amount);
        pool.setUsableAmount(amount);
        pool.setHasUseAmount(BigDecimal.ZERO);
        pool.setFreezeAmount(BigDecimal.ZERO);
        this.save((Object)pool);
        String operationCode = this.feePoolOperationService.savePoolOperation(pool.getPoolCode(), operationType, fromCode, fromDesc, remarks, amount, FeePoolOperationTypeGroupEnum.ACCOUNT.getUsableAmountWeight(), operationDateTime, fileList);
        FeePoolDetailEntity poolDetail = new FeePoolDetailEntity();
        CrmBeanUtil.copyExt10((Object)reqVo, (Object)((Object)poolDetail));
        poolDetail.setPoolCode(pool.getPoolCode());
        poolDetail.setPoolDetailCode(CodeUtil.generateCode((String)CodeRuleEnum.FEE_POOL_DETAIL_CODE.getCode()));
        poolDetail.setBpmStatus(bpmStatus);
        poolDetail.setOperationCode(operationCode);
        poolDetail.setOperationType(operationType);
        poolDetail.setFromCode(fromCode);
        poolDetail.setFromDesc(fromDesc);
        poolDetail.setAccountDateTime(operationDateTime);
        poolDetail.setTotalAmount(amount);
        poolDetail.setUsableAmount(amount);
        poolDetail.setHasUseAmount(BigDecimal.ZERO);
        poolDetail.setFreezeAmount(BigDecimal.ZERO);
        poolDetail.setRemarks(remarks);
        this.feePoolDetailService.save((Object)poolDetail);
        this.feePoolDetailLogService.savePoolDetailLog(pool.getPoolCode(), poolDetail.getPoolDetailCode(), operationCode, operationType, fromCode, fromDesc, remarks, amount, FeePoolOperationTypeGroupEnum.ACCOUNT.getUsableAmountWeight(), operationDateTime);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void initGoods(String customerCode, String customerName, String goodsProductLevelCode, String goodsProductLevelName, String goodsProductCode, String goodsProductName, String operationType, BigDecimal amount, String bpmStatus, String fromCode, String fromDesc, String remarks, List<FeePoolFileReqVo> fileList, CrmExtTenVo reqVo) {
        String operationDateTime = DateUtil.dateNowHms();
        FeePoolEntity pool = new FeePoolEntity();
        pool.setPoolCode(CodeUtil.generateCode((String)CodeRuleEnum.FEE_POOL_CODE.getCode()));
        pool.setPoolType(FeePoolTypeEnum.GOODS.getValue());
        pool.setPayType(FeePoolConfigUtil.getPayType((String)FeePoolTypeEnum.GOODS.getValue()));
        pool.setCustomerCode(customerCode);
        pool.setCustomerName(customerName);
        pool.setGoodsProductLevelCode(goodsProductLevelCode);
        pool.setGoodsProductLevelName(goodsProductLevelName);
        pool.setGoodsProductCode(goodsProductCode);
        pool.setGoodsProductName(goodsProductName);
        pool.setTotalAmount(amount);
        pool.setUsableAmount(amount);
        pool.setHasUseAmount(BigDecimal.ZERO);
        pool.setFreezeAmount(BigDecimal.ZERO);
        this.save((Object)pool);
        String operationCode = this.feePoolOperationService.savePoolOperation(pool.getPoolCode(), operationType, fromCode, fromDesc, remarks, amount, FeePoolOperationTypeGroupEnum.ACCOUNT.getUsableAmountWeight(), operationDateTime, fileList);
        FeePoolDetailEntity poolDetail = new FeePoolDetailEntity();
        CrmBeanUtil.copyExt10((Object)reqVo, (Object)((Object)poolDetail));
        poolDetail.setPoolCode(pool.getPoolCode());
        poolDetail.setPoolDetailCode(CodeUtil.generateCode((String)CodeRuleEnum.FEE_POOL_DETAIL_CODE.getCode()));
        poolDetail.setBpmStatus(bpmStatus);
        poolDetail.setOperationCode(operationCode);
        poolDetail.setOperationType(operationType);
        poolDetail.setFromCode(fromCode);
        poolDetail.setFromDesc(fromDesc);
        poolDetail.setAccountDateTime(operationDateTime);
        poolDetail.setTotalAmount(amount);
        poolDetail.setUsableAmount(amount);
        poolDetail.setHasUseAmount(BigDecimal.ZERO);
        poolDetail.setFreezeAmount(BigDecimal.ZERO);
        poolDetail.setRemarks(remarks);
        this.feePoolDetailService.save((Object)poolDetail);
        this.feePoolDetailLogService.savePoolDetailLog(pool.getPoolCode(), poolDetail.getPoolDetailCode(), operationCode, operationType, fromCode, fromDesc, remarks, amount, FeePoolOperationTypeGroupEnum.ACCOUNT.getUsableAmountWeight(), operationDateTime);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void accountByPoolCode(String poolCode, String operationType, BigDecimal amount, String bpmStatus, String fromCode, String fromDesc, String remarks, List<FeePoolFileReqVo> fileList, CrmExtTenVo reqVo) {
        String operationDateTime = DateUtil.dateNowHms();
        FeePoolEntity pool = (FeePoolEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolCode)).one());
        pool.setTotalAmount(pool.getTotalAmount().add(amount));
        pool.setUsableAmount(pool.getUsableAmount().add(amount));
        this.updateById((Object)pool);
        FeePoolOperationTypeGroupEnum operationTypeGroupEnum = FeePoolConfigUtil.getOperationTypeGroup((String)operationType);
        String operationCode = this.feePoolOperationService.savePoolOperation(pool.getPoolCode(), operationType, fromCode, fromDesc, remarks, amount, operationTypeGroupEnum.getUsableAmountWeight(), operationDateTime, fileList);
        FeePoolDetailEntity poolDetail = new FeePoolDetailEntity();
        CrmBeanUtil.copyExt10((Object)reqVo, (Object)((Object)poolDetail));
        poolDetail.setPoolCode(pool.getPoolCode());
        poolDetail.setPoolDetailCode(CodeUtil.generateCode((String)CodeRuleEnum.FEE_POOL_DETAIL_CODE.getCode()));
        poolDetail.setBpmStatus(bpmStatus);
        poolDetail.setOperationCode(operationCode);
        poolDetail.setOperationType(operationType);
        poolDetail.setFromCode(fromCode);
        poolDetail.setFromDesc(fromDesc);
        poolDetail.setAccountDateTime(operationDateTime);
        poolDetail.setTotalAmount(amount);
        poolDetail.setUsableAmount(amount);
        poolDetail.setHasUseAmount(BigDecimal.ZERO);
        poolDetail.setFreezeAmount(BigDecimal.ZERO);
        poolDetail.setRemarks(remarks);
        this.feePoolDetailService.save((Object)poolDetail);
        this.feePoolDetailLogService.savePoolDetailLog(pool.getPoolCode(), poolDetail.getPoolDetailCode(), operationCode, operationType, fromCode, fromDesc, remarks, amount, operationTypeGroupEnum.getUsableAmountWeight(), operationDateTime);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void useByPoolCode(String poolCode, String operationType, BigDecimal amount, String bpmStatus, String fromCode, String fromDesc, String remarks, List<FeePoolFileReqVo> fileList) {
        String operationDateTime = DateUtil.dateNowHms();
        FeePoolEntity pool = (FeePoolEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolCode)).one());
        Assert.notNull((Object)((Object)pool), (String)("\u672a\u627e\u5230\u8d39\u7528\u6c60[" + poolCode + "]"));
        Assert.isTrue((pool.getUsableAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60" + poolCode + "\u53ef\u4ee5\u4f59\u989d\u4e0d\u8db3"));
        pool.setHasUseAmount(pool.getHasUseAmount().add(amount));
        pool.setUsableAmount(pool.getUsableAmount().subtract(amount));
        this.updateById((Object)pool);
        FeePoolOperationTypeGroupEnum operationTypeGroupEnum = FeePoolConfigUtil.getOperationTypeGroup((String)operationType);
        String operationCode = this.feePoolOperationService.savePoolOperation(pool.getPoolCode(), operationType, fromCode, fromDesc, remarks, amount, operationTypeGroupEnum.getUsableAmountWeight(), operationDateTime, fileList);
        List poolDetailList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolDetailService.lambdaQuery().eq(FeePoolDetailEntity::getPoolCode, (Object)poolCode)).orderByAsc(FeePoolDetailEntity::getAccountDateTime)).list();
        BigDecimal restAmount = amount;
        for (FeePoolDetailEntity poolDetail : poolDetailList) {
            if (restAmount.compareTo(BigDecimal.ZERO) <= 0) break;
            if (poolDetail.getUsableAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal itemUse = BigDecimal.ZERO;
            itemUse = poolDetail.getUsableAmount().compareTo(restAmount) >= 0 ? restAmount : poolDetail.getUsableAmount();
            restAmount = restAmount.subtract(itemUse);
            poolDetail.setHasUseAmount(poolDetail.getHasUseAmount().add(itemUse));
            poolDetail.setUsableAmount(poolDetail.getUsableAmount().subtract(itemUse));
            this.feePoolDetailService.updateById((Object)poolDetail);
            this.feePoolDetailLogService.savePoolDetailLog(pool.getPoolCode(), poolDetail.getPoolDetailCode(), operationCode, operationType, fromCode, fromDesc, remarks, itemUse, operationTypeGroupEnum.getUsableAmountWeight(), operationDateTime);
        }
        Assert.isTrue((restAmount.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)"\u8d39\u7528\u6c60\u91d1\u989d\u5f02\u5e38");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void freezeByPoolCode(String poolCode, String operationType, BigDecimal amount, String bpmStatus, String fromCode, String fromDesc, String remarks, List<FeePoolFileReqVo> fileList) {
        String operationDateTime = DateUtil.dateNowHms();
        FeePoolEntity pool = (FeePoolEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolCode)).one());
        Assert.notNull((Object)((Object)pool), (String)("\u672a\u627e\u5230\u8d39\u7528\u6c60[" + poolCode + "]"));
        Assert.isTrue((pool.getUsableAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60" + poolCode + "\u53ef\u4ee5\u4f59\u989d\u4e0d\u8db3"));
        pool.setFreezeAmount(pool.getFreezeAmount().add(amount));
        pool.setUsableAmount(pool.getUsableAmount().subtract(amount));
        this.updateById((Object)pool);
        FeePoolOperationTypeGroupEnum operationTypeGroupEnum = FeePoolConfigUtil.getOperationTypeGroup((String)operationType);
        String operationCode = this.feePoolOperationService.savePoolOperation(pool.getPoolCode(), operationType, fromCode, fromDesc, remarks, amount, operationTypeGroupEnum.getUsableAmountWeight(), operationDateTime, fileList);
        List poolDetailList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolDetailService.lambdaQuery().eq(FeePoolDetailEntity::getPoolCode, (Object)poolCode)).orderByAsc(FeePoolDetailEntity::getAccountDateTime)).list();
        BigDecimal restAmount = amount;
        for (FeePoolDetailEntity poolDetail : poolDetailList) {
            if (restAmount.compareTo(BigDecimal.ZERO) <= 0) break;
            if (poolDetail.getUsableAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal itemUse = BigDecimal.ZERO;
            itemUse = poolDetail.getUsableAmount().compareTo(restAmount) >= 0 ? restAmount : poolDetail.getUsableAmount();
            restAmount = restAmount.subtract(itemUse);
            poolDetail.setFreezeAmount(poolDetail.getFreezeAmount().add(itemUse));
            poolDetail.setUsableAmount(poolDetail.getUsableAmount().subtract(itemUse));
            this.feePoolDetailService.updateById((Object)poolDetail);
            this.feePoolDetailLogService.savePoolDetailLog(pool.getPoolCode(), poolDetail.getPoolDetailCode(), operationCode, operationType, fromCode, fromDesc, remarks, itemUse, operationTypeGroupEnum.getUsableAmountWeight(), operationDateTime);
        }
        Assert.isTrue((restAmount.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)"\u8d39\u7528\u6c60\u91d1\u989d\u5f02\u5e38");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unfreezeByPoolCode(String poolCode, String operationType, BigDecimal amount, String bpmStatus, String fromCode, String fromDesc, String remarks, List<FeePoolFileReqVo> fileList) {
        String operationDateTime = DateUtil.dateNowHms();
        FeePoolEntity pool = (FeePoolEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolCode)).one());
        Assert.notNull((Object)((Object)pool), (String)("\u672a\u627e\u5230\u8d39\u7528\u6c60[" + poolCode + "]"));
        Assert.isTrue((pool.getFreezeAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60" + poolCode + "\u89e3\u51bb\u91d1\u989d\u8d85\u8fc7\u51bb\u7ed3\u91d1\u989d"));
        pool.setFreezeAmount(pool.getFreezeAmount().subtract(amount));
        pool.setUsableAmount(pool.getUsableAmount().add(amount));
        this.updateById((Object)pool);
        FeePoolOperationTypeGroupEnum operationTypeGroupEnum = FeePoolConfigUtil.getOperationTypeGroup((String)operationType);
        String operationCode = this.feePoolOperationService.savePoolOperation(pool.getPoolCode(), operationType, fromCode, fromDesc, remarks, amount, operationTypeGroupEnum.getUsableAmountWeight(), operationDateTime, fileList);
        List poolDetailList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolDetailService.lambdaQuery().eq(FeePoolDetailEntity::getPoolCode, (Object)poolCode)).orderByAsc(FeePoolDetailEntity::getAccountDateTime)).list();
        BigDecimal restAmount = amount;
        for (FeePoolDetailEntity poolDetail : poolDetailList) {
            if (restAmount.compareTo(BigDecimal.ZERO) <= 0) break;
            if (poolDetail.getFreezeAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal itemUse = BigDecimal.ZERO;
            itemUse = poolDetail.getFreezeAmount().compareTo(restAmount) >= 0 ? restAmount : poolDetail.getFreezeAmount();
            restAmount = restAmount.subtract(itemUse);
            poolDetail.setFreezeAmount(poolDetail.getFreezeAmount().subtract(itemUse));
            poolDetail.setUsableAmount(poolDetail.getUsableAmount().add(itemUse));
            this.feePoolDetailService.updateById((Object)poolDetail);
            this.feePoolDetailLogService.savePoolDetailLog(pool.getPoolCode(), poolDetail.getPoolDetailCode(), operationCode, operationType, fromCode, fromDesc, remarks, itemUse, operationTypeGroupEnum.getUsableAmountWeight(), operationDateTime);
        }
        Assert.isTrue((restAmount.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)"\u8d39\u7528\u6c60\u91d1\u989d\u5f02\u5e38");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void backAllUseByFromCode(FeePoolUseBackAllReqVo reqVo) {
        String fromCode = reqVo.getFromCode();
        String fromDesc = reqVo.getFromDesc();
        String remarks = reqVo.getRemarks();
        String operationType = reqVo.getOperationType();
        Assert.hasText((String)operationType, (String)"\u7f3a\u5931\u64cd\u4f5c\u7c7b\u578b");
        Assert.hasText((String)fromCode, (String)"\u7f3a\u5931\u6765\u6e90\u5355\u53f7");
        FeePoolOperationTypeGroupEnum operationTypeGroupEnum = FeePoolConfigUtil.getOperationTypeGroup((String)operationType);
        String operationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)operationType);
        HashSet operationTypeSet = new HashSet(16);
        operationTypeSet.addAll(FeePoolConfigUtil.getOperationTypeList((FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.USE));
        operationTypeSet.addAll(FeePoolConfigUtil.getOperationTypeList((FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.BACK));
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolOperationService.lambdaQuery().eq(FeePoolOperationTypeEnum.ORDER_BACK.getValue().equals(operationType), FeePoolOperationEntity::getOperationType, (Object)FeePoolOperationTypeEnum.ORDER_USE.getValue())).eq(FeePoolOperationEntity::getFromCode, (Object)fromCode)).in(FeePoolOperationEntity::getOperationType, operationTypeSet)).list();
        Assert.notEmpty((Collection)list, (String)("\u672a\u627e\u5230\u5355\u53f7\u3010" + fromCode + "\u3011\u5bf9\u5e94\u7684\u8ba2\u5355\u4f7f\u7528\u8bb0\u5f55"));
        Map<String, List<FeePoolOperationEntity>> poolOperationGroup = list.stream().collect(Collectors.groupingBy(FeePoolOperationEntity::getPoolCode));
        String operationDateTime = DateUtil.dateNowHms();
        for (Map.Entry<String, List<FeePoolOperationEntity>> entry : poolOperationGroup.entrySet()) {
            List<FeePoolOperationEntity> value = entry.getValue();
            BigDecimal operationAmountTotal = value.stream().map(FeePoolOperationEntity::getOperationAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            Assert.isTrue((operationAmountTotal.compareTo(BigDecimal.ZERO) <= 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60\u3010" + entry.getKey() + "\u3011\u6570\u636e\u5f02\u5e38"));
            List detailLogList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolDetailLogService.lambdaQuery().eq(FeePoolOperationTypeEnum.ORDER_BACK.getValue().equals(operationType), FeePoolDetailLogEntity::getOperationType, (Object)FeePoolOperationTypeEnum.ORDER_USE.getValue())).eq(FeePoolDetailLogEntity::getPoolCode, (Object)entry.getKey())).eq(FeePoolDetailLogEntity::getFromCode, (Object)fromCode)).in(FeePoolDetailLogEntity::getOperationType, operationTypeSet)).list();
            if (!CollectionUtil.listNotEmptyNotSizeZero((List)detailLogList)) continue;
            String operationCode = this.feePoolOperationService.savePoolOperation(entry.getKey(), FeePoolOperationTypeEnum.ORDER_BACK.getValue(), fromCode, fromDesc, remarks, operationAmountTotal.abs(), operationTypeGroupEnum.getUsableAmountWeight(), operationDateTime, null);
            Set poolDetailCodeSet = detailLogList.stream().map(FeePoolDetailLogEntity::getPoolDetailCode).collect(Collectors.toSet());
            Map<String, BigDecimal> collect = detailLogList.stream().collect(Collectors.groupingBy(FeePoolDetailLogEntity::getPoolDetailCode, Collectors.mapping(FeePoolDetailLogEntity::getOperationAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            List detailEntityList = ((LambdaQueryChainWrapper)this.feePoolDetailService.lambdaQuery().in(FeePoolDetailEntity::getPoolDetailCode, poolDetailCodeSet)).list();
            ArrayList<FeePoolDetailLogReqVo> logList = new ArrayList<FeePoolDetailLogReqVo>();
            for (FeePoolDetailEntity item : detailEntityList) {
                if (!collect.containsKey(item.getPoolDetailCode())) continue;
                BigDecimal bigDecimal = collect.get(item.getPoolDetailCode());
                Assert.isTrue((bigDecimal.compareTo(BigDecimal.ZERO) <= 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60\u660e\u7ec6\u3010" + item.getPoolDetailCode() + "\u3011\u6570\u636e\u5f02\u5e38"));
                BigDecimal backAmount = bigDecimal.abs();
                Assert.isTrue((item.getHasUseAmount().compareTo(backAmount) >= 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60\u660e\u7ec6\u3010" + item.getPoolDetailCode() + "\u3011\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
                item.setHasUseAmount(item.getHasUseAmount().subtract(backAmount));
                item.setUsableAmount(item.getUsableAmount().add(backAmount));
                FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
                detailLog.setPoolCode(item.getPoolCode());
                detailLog.setPoolDetailCode(item.getPoolDetailCode());
                detailLog.setOperationCode(operationCode);
                detailLog.setOperationType(operationType);
                detailLog.setFromCode(fromCode);
                detailLog.setFromDesc(StringUtils.isNotEmpty((String)fromDesc) ? fromDesc : operationTypeValue);
                detailLog.setRemarks(remarks);
                detailLog.setOperationAmount(backAmount.multiply(operationTypeGroupEnum.getUsableAmountWeight()));
                detailLog.setOperationDateTime(operationDateTime);
                logList.add(detailLog);
            }
            this.subtractHasUseAmount(entry.getKey(), operationAmountTotal.abs());
            this.feePoolDetailService.updateBatchById(detailEntityList);
            this.feePoolDetailLogService.savePoolDetailLog(logList);
        }
    }

    @Override
    public FeePoolAmountRespVo queryAmountByCustomerCode(String customerCode, String poolType) {
        Assert.hasText((String)customerCode, (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)poolType), FeePoolEntity::getPoolType, (Object)poolType)).eq(FeePoolEntity::getCustomerCode, (Object)customerCode)).select(new SFunction[]{FeePoolEntity::getTotalAmount, FeePoolEntity::getFreezeAmount, FeePoolEntity::getHasUseAmount, FeePoolEntity::getUsableAmount}).list();
        FeePoolAmountRespVo respVo = new FeePoolAmountRespVo();
        respVo.setCustomerCode(customerCode);
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal freezeAmount = BigDecimal.ZERO;
        BigDecimal hasUseAmount = BigDecimal.ZERO;
        BigDecimal usableAmount = BigDecimal.ZERO;
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            totalAmount = list.stream().map(FeePoolEntity::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            freezeAmount = list.stream().map(FeePoolEntity::getFreezeAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            hasUseAmount = list.stream().map(FeePoolEntity::getHasUseAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            usableAmount = list.stream().map(FeePoolEntity::getUsableAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        respVo.setTotalAmount(totalAmount);
        respVo.setFreezeAmount(freezeAmount);
        respVo.setHasUseAmount(hasUseAmount);
        respVo.setUsableAmount(usableAmount);
        return respVo;
    }

    @Override
    public FeePoolMonthAmountRespVo queryMonthAmountByCustomerCode(String customerCode, String poolType, String yearMonth) {
        Assert.hasText((String)customerCode, (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        Assert.hasText((String)yearMonth, (String)"\u7f3a\u5931\u5e74\u6708");
        boolean flag = false;
        try {
            Date parse = DateUtil.yyyy_MM.parse(yearMonth);
            String format = DateUtil.yyyy_MM.format(parse);
            if (format.equals(yearMonth)) {
                flag = true;
            }
        }
        catch (Exception parse) {
            // empty catch block
        }
        Assert.isTrue((boolean)flag, (String)"\u5e74\u6708\u683c\u5f0f\u4e0d\u5408\u6cd5");
        FeePoolMonthAmountRespVo respVo = new FeePoolMonthAmountRespVo();
        BigDecimal usableAmount = this.feePoolMapper.sumUsableAmount(poolType, customerCode);
        BigDecimal thisMonthUsableAmount = this.feePoolMapper.sumThisMonthUsableAmount(poolType, customerCode, yearMonth);
        BigDecimal thisMonthAccountAmount = this.feePoolMapper.sumThisMonthAccountAmount(poolType, customerCode, yearMonth);
        BigDecimal lastMonthUsableAmount = this.feePoolMapper.sumLastMonthUsableAmount(poolType, customerCode, yearMonth);
        List<String> collect = FeePoolConfigUtil.getOperationTypeSelectList((String)FeePoolOperationTypeExtendEnum.SHOW_DETAIL_USE.getValue()).stream().map(FeeSelectOptionVo::getValue).collect(Collectors.toList());
        BigDecimal thisMonthHasUseAmount = this.feePoolMapper.sumThisMonthHasUseAmount(poolType, customerCode, yearMonth, collect);
        respVo.setCustomerCode(customerCode);
        respVo.setYearMonth(yearMonth);
        respVo.setUsableAmount(usableAmount == null ? BigDecimal.ZERO : usableAmount);
        respVo.setThisMonthUsableAmount(thisMonthUsableAmount == null ? BigDecimal.ZERO : thisMonthUsableAmount);
        respVo.setThisMonthAccountAmount(thisMonthAccountAmount == null ? BigDecimal.ZERO : thisMonthAccountAmount);
        respVo.setLastMonthUsableAmount(lastMonthUsableAmount == null ? BigDecimal.ZERO : lastMonthUsableAmount);
        respVo.setThisMonthHasUseAmount(thisMonthHasUseAmount == null ? BigDecimal.ZERO : thisMonthHasUseAmount.negate());
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addTotalAmount(String poolCode, BigDecimal amount) {
        Assert.hasText((String)poolCode, (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.isTrue((amount != null ? 1 : 0) != 0, (String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((amount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
        FeePoolEntity pool = (FeePoolEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolCode)).one());
        Assert.notNull((Object)((Object)pool), (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u7f16\u53f7");
        pool.setTotalAmount(pool.getTotalAmount().add(amount));
        pool.setUsableAmount(pool.getUsableAmount().add(amount));
        this.updateById((Object)pool);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addHasUseAmount(String poolCode, BigDecimal amount) {
        Assert.hasText((String)poolCode, (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.isTrue((amount != null ? 1 : 0) != 0, (String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((amount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
        FeePoolEntity pool = (FeePoolEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolCode)).one());
        Assert.isTrue((pool.getUsableAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)"\u4f7f\u7528\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u53ef\u4f7f\u7528\u91d1\u989d");
        pool.setHasUseAmount(pool.getHasUseAmount().add(amount));
        pool.setUsableAmount(pool.getUsableAmount().subtract(amount));
        this.updateById((Object)pool);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void subtractHasUseAmount(String poolCode, BigDecimal amount) {
        Assert.hasText((String)poolCode, (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.isTrue((amount != null ? 1 : 0) != 0, (String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((amount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
        FeePoolEntity pool = (FeePoolEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolCode)).one());
        Assert.isTrue((pool.getHasUseAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)"\u56de\u9000\u4f7f\u7528\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u53ef\u4f7f\u7528\u91d1\u989d");
        pool.setHasUseAmount(pool.getHasUseAmount().subtract(amount));
        pool.setUsableAmount(pool.getUsableAmount().add(amount));
        this.updateById((Object)pool);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addFreezeAmount(String poolCode, BigDecimal amount) {
        Assert.hasText((String)poolCode, (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.isTrue((amount != null ? 1 : 0) != 0, (String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((amount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
        FeePoolEntity pool = (FeePoolEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolCode)).one());
        Assert.notNull((Object)((Object)pool), (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.isTrue((pool.getUsableAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)"\u51bb\u7ed3\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u53ef\u4f7f\u7528\u91d1\u989d");
        pool.setFreezeAmount(pool.getFreezeAmount().add(amount));
        pool.setUsableAmount(pool.getUsableAmount().subtract(amount));
        this.updateById((Object)pool);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void subtractFreezeAmount(String poolCode, BigDecimal amount) {
        Assert.hasText((String)poolCode, (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.isTrue((amount != null ? 1 : 0) != 0, (String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((amount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
        FeePoolEntity pool = (FeePoolEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolCode)).one());
        Assert.notNull((Object)((Object)pool), (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.isTrue((pool.getFreezeAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)"\u89e3\u51bb\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u51bb\u7ed3\u91d1\u989d");
        pool.setFreezeAmount(pool.getFreezeAmount().subtract(amount));
        pool.setUsableAmount(pool.getUsableAmount().add(amount));
        this.updateById((Object)pool);
    }

    @Override
    public FeePoolQueryForAdjustRespVo queryForAdjustByPoolCode(String poolCode) {
        FeePoolEntity feePool;
        FeePoolQueryForAdjustRespVo respVo = new FeePoolQueryForAdjustRespVo();
        if (StringUtils.isNotEmpty((String)poolCode) && (feePool = (FeePoolEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolCode)).one())) != null) {
            CrmBeanUtil.copyProperties((Object)((Object)feePool), (Object)respVo);
            String payType = FeePoolConfigUtil.getPayType((String)FeePoolTypeEnum.DISCOUNT.getValue());
            respVo.setDiscountTypeList(FeePoolConfigUtil.getDiscountSelectList());
            respVo.setOperationTypeSelectList(FeePoolConfigUtil.getOperationTypeSelectList((String)FeePoolOperationTypeExtendEnum.ADJUST_POOL_LINE.getValue()));
            respVo.setPayTypeList(Collections.singletonList(new FeeSelectOptionVo().setValue(payType).setText(DictUtil.dictValue((String)"fee_pool_pay_type", (String)payType))));
        }
        return respVo;
    }
}

