/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.fee.FeePoolOperationTypeExtendEnum;
import com.biz.crm.nebular.fee.pool.req.FeePoolAccountReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolAdjustReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolUseBackAllReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolUseReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeeSelectOptionVo;
import com.biz.crm.pool.service.FeePoolService;
import com.biz.crm.util.Result;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/feePoolController"})
@Api(tags={"\u901a\u7528-\u8d39\u7528\u6c60\u4e3b\u8868"})
@CrmGlobalLog
public class FeePoolController {
    private static final Logger log = LoggerFactory.getLogger(FeePoolController.class);
    @Resource
    private FeePoolService feePoolService;

    @ApiOperation(value="\u8d39\u7528\u6c60\u4e3b\u8868\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/pageList"})
    public Result<PageResult<FeePoolRespVo>> pageList(@RequestBody FeePoolReqVo reqVo) {
        PageResult<FeePoolRespVo> result = this.feePoolService.findList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u901a\u8fc7\u8d39\u7528\u6c60\u7f16\u53f7\u67e5\u8be2\u8d39\u7528\u6c60", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="poolCode", value="\u8d39\u7528\u6c60\u7f16\u53f7", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/queryByPoolCode"})
    public Result<FeePoolRespVo> queryByPoolCode(@RequestParam(value="poolCode", required=true) String poolCode) {
        return Result.ok((Object)this.feePoolService.queryByPoolCode(poolCode));
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u901a\u8fc7id\u67e5\u8be2\u8d39\u7528\u6c60", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/queryById"})
    public Result<FeePoolRespVo> queryById(@RequestParam(value="id", required=true) String id) {
        return Result.ok((Object)this.feePoolService.queryById(id));
    }

    @ApiOperation(value="\u4e0a\u8d26")
    @PostMapping(value={"/account"})
    public Result account(@RequestBody FeePoolAccountReqVo reqVo) {
        this.feePoolService.account(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u8c03\u6574\uff0c\u6309\u7167\u7ef4\u5ea6")
    @PostMapping(value={"/adjust"})
    public Result adjust(@RequestBody FeePoolAdjustReqVo reqVo) {
        this.feePoolService.adjust(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u8c03\u6574\uff0c\u6309\u7167\u8d39\u7528\u6c60\u7f16\u53f7")
    @PostMapping(value={"/adjustByPoolCode"})
    public Result adjustByPoolCode(@RequestBody FeePoolAdjustReqVo reqVo) {
        this.feePoolService.adjustByPoolCode(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u4f7f\u7528\u8d39\u7528\u6c60\u91d1\u989d")
    @PostMapping(value={"/usePool"})
    public Result usePool(@RequestBody FeePoolUseReqVo reqVo) {
        this.feePoolService.usePool(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5148\u9000\u56de\u4f7f\u7528\u91d1\u989d\uff0c\u518d\u91cd\u65b0\u4f7f\u7528\u8d39\u7528\u6c60\u91d1\u989d")
    @PostMapping(value={"/usePoolAfterBackByFromCode"})
    public Result usePoolAfterBackByFromCode(@RequestBody FeePoolUseReqVo reqVo) {
        this.feePoolService.usePoolAfterBackByFromCode(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u83b7\u53d6\u8d39\u7528\u6c60\u660e\u7ec6\u5217\u8868\u7b5b\u9009\u64cd\u4f5c\u7c7b\u578b\u4e0b\u62c9\u6846\u9009\u9879", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="queryType", value="\u7c7b\u578b\uff1a\u67e5\u8be2\u7c7b\u578b\uff1a2:\u67e5\u8be2\u5728\u4e3b\u8868\u5934\u8c03\u6574\u7684\u64cd\u4f5c\u7c7b\u578b\uff0c3:\u67e5\u8be2\u5728\u4e3b\u8868\u884c\u8c03\u6574\u7684\u64cd\u4f5c\u7c7b\u578b\uff0c4:\u67e5\u8be2\u5728\u660e\u7ec6\u8868\u5934\u8c03\u6574\u7684\u64cd\u4f5c\u7c7b\u578b\uff0c5:\u67e5\u8be2\u5728\u660e\u7ec6\u8868\u884c\u8c03\u6574\u7684\u64cd\u4f5c\u7c7b\u578b\uff0c6:\u67e5\u8be2\u5728\u660e\u7ec6\u8868\u663e\u793a\u7684\u64cd\u4f5c\u7c7b\u578b\uff0c7:\u67e5\u8be2\u5728\u4f7f\u7528\u660e\u7ec6\u8868\u663e\u793a\u7684\u64cd\u4f5c\u7c7b\u578b\uff0c8:\u67e5\u8be2\u5728\u64cd\u4f5c\u8bb0\u5f55\u8868\u663e\u793a\u7684\u64cd\u4f5c\u7c7b\u578b\uff0c9:\u67e5\u8be2\u5728\u660e\u7ec6\u64cd\u4f5c\u65e5\u5fd7\u8868\u663e\u793a\u7684\u64cd\u4f5c\u7c7b\u578b\u3002", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/getOperationTypeSelectList"})
    public Result<List<FeeSelectOptionVo>> getOperationTypeSelectList(@RequestParam(value="queryType", required=true) String queryType) {
        String extendByQueryType = FeePoolOperationTypeExtendEnum.getExtendByQueryType((String)queryType);
        Assert.notNull((Object)extendByQueryType, (String)"\u65e0\u6548\u7684\u7b5b\u9009\u7c7b\u578b");
        return Result.ok((Object)FeePoolConfigUtil.getOperationTypeSelectList((String)extendByQueryType));
    }

    @ApiOperation(value="\u5168\u91cf\u56de\u9000\u4f7f\u7528\u91d1\u989d\uff0c\u6839\u636e\u6765\u6e90\u5355\u53f7")
    @PostMapping(value={"/backAllUseByFromCode"})
    public Result backAllUseByFromCode(@RequestBody FeePoolUseBackAllReqVo reqVo) {
        this.feePoolService.backAllUseByFromCode(reqVo);
        return Result.ok();
    }
}

