/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.fee.FeePoolOperationTypeExtendEnum;
import com.biz.crm.eunm.fee.FeePoolTypeEnum;
import com.biz.crm.nebular.fee.pool.req.FeePoolAdjustReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsAccountReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsProductGroupReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsUseBackReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolOperationReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolAmountRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolGoodsProductGroupRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolMonthAmountRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolOperationRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolQueryForAdjustRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeeSelectOptionVo;
import com.biz.crm.pool.service.FeePoolGoodsService;
import com.biz.crm.pool.service.FeePoolService;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collections;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/feePoolGoodsController"})
@Api(tags={"\u8d27\u8865-\u8d39\u7528\u6c60"})
@CrmGlobalLog
public class FeePoolGoodsController {
    private static final Logger log = LoggerFactory.getLogger(FeePoolGoodsController.class);
    @Resource
    private FeePoolGoodsService feePoolGoodsService;
    @Resource
    private FeePoolService feePoolService;

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u8d27\u8865\u8d39\u7528\u6c60\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/pageList"})
    public Result<PageResult<FeePoolRespVo>> pageList(@RequestBody FeePoolReqVo reqVo) {
        PageResult<FeePoolRespVo> result = this.feePoolGoodsService.findList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u8d27\u8865\u8d39\u7528\u6c60\u4e3b\u8868\u5934\u8c03\u6574\u521d\u59cb\u5316\u52a0\u8f7d\u6570\u636e")
    @GetMapping(value={"/queryForAdjust"})
    public Result<FeePoolQueryForAdjustRespVo> queryForAdjust() {
        FeePoolQueryForAdjustRespVo respVo = new FeePoolQueryForAdjustRespVo();
        String payType = FeePoolConfigUtil.getPayType((String)FeePoolTypeEnum.GOODS.getValue());
        respVo.setOperationTypeSelectList(FeePoolConfigUtil.getOperationTypeSelectList((String)FeePoolOperationTypeExtendEnum.ADJUST_POOL.getValue()));
        respVo.setPayTypeList(Collections.singletonList(new FeeSelectOptionVo().setValue(payType).setText(DictUtil.dictValue((String)"fee_pool_pay_type", (String)payType))));
        respVo.setDiscountTypeList(FeePoolConfigUtil.getDiscountSelectList());
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u901a\u8fc7\u8d39\u7528\u6c60\u7f16\u53f7\u83b7\u53d6\u8d27\u8865\u8d39\u7528\u6c60\u4e3b\u8868\u884c\u8c03\u6574\u521d\u59cb\u5316\u52a0\u8f7d\u6570\u636e", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="poolCode", value="\u8d39\u7528\u6c60\u7f16\u53f7", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/queryForAdjustByPoolCode"})
    public Result<FeePoolQueryForAdjustRespVo> queryForAdjustByPoolCode(@RequestParam(value="poolCode", required=true) String poolCode) {
        FeePoolQueryForAdjustRespVo respVo = this.feePoolService.queryForAdjustByPoolCode(poolCode);
        String payType = FeePoolConfigUtil.getPayType((String)FeePoolTypeEnum.GOODS.getValue());
        respVo.setOperationTypeSelectList(FeePoolConfigUtil.getOperationTypeSelectList((String)FeePoolOperationTypeExtendEnum.ADJUST_POOL_LINE.getValue()));
        respVo.setPayTypeList(Collections.singletonList(new FeeSelectOptionVo().setValue(payType).setText(DictUtil.dictValue((String)"fee_pool_pay_type", (String)payType))));
        respVo.setDiscountTypeList(FeePoolConfigUtil.getDiscountSelectList());
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u8d27\u8865\u8d39\u7528\u6c60\u660e\u7ec6\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/findFeePoolDetailPageList"})
    public Result<PageResult<FeePoolDetailRespVo>> findFeePoolDetailPageList(@RequestBody FeePoolDetailReqVo reqVo) {
        return Result.ok(this.feePoolGoodsService.findFeePoolDetailPageList(reqVo));
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u8d27\u8865\u8d39\u7528\u6c60\u64cd\u4f5c\u8bb0\u5f55\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/findFeePoolOperationPageList"})
    public Result<PageResult<FeePoolOperationRespVo>> findFeePoolOperationPageList(@RequestBody FeePoolOperationReqVo reqVo) {
        return Result.ok(this.feePoolGoodsService.findFeePoolOperationPageList(reqVo));
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u8d27\u8865\u8d39\u7528\u6c60\u660e\u7ec6\u8868\u5934\u8c03\u6574\u521d\u59cb\u5316\u52a0\u8f7d\u6570\u636e")
    @GetMapping(value={"/queryForAdjustDetail"})
    public Result<FeePoolQueryForAdjustRespVo> queryForAdjustDetail() {
        FeePoolQueryForAdjustRespVo respVo = new FeePoolQueryForAdjustRespVo();
        String payType = FeePoolConfigUtil.getPayType((String)FeePoolTypeEnum.GOODS.getValue());
        respVo.setOperationTypeSelectList(FeePoolConfigUtil.getOperationTypeSelectList((String)FeePoolOperationTypeExtendEnum.ADJUST_POOL_DETAIL.getValue()));
        respVo.setPayTypeList(Collections.singletonList(new FeeSelectOptionVo().setValue(payType).setText(DictUtil.dictValue((String)"fee_pool_pay_type", (String)payType))));
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u8d27\u8865\u4e0a\u8d26")
    @PostMapping(value={"/accountGoods"})
    public Result accountGoods(@RequestBody FeePoolGoodsAccountReqVo reqVo) {
        this.feePoolGoodsService.account(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u8d27\u8865\u8d39\u7528\u6c60\u4e3b\u8868\u5934\u8c03\u6574\uff0c\u6309\u7167\u7ef4\u5ea6")
    @PostMapping(value={"/adjust"})
    public Result adjust(@RequestBody FeePoolAdjustReqVo reqVo) {
        this.feePoolGoodsService.adjust(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u8d27\u8865\u8d39\u7528\u6c60\u4e3b\u8868\u884c\u8c03\u6574\uff0c\u6309\u7167\u8d39\u7528\u6c60\u7f16\u53f7")
    @PostMapping(value={"/adjustByPoolCode"})
    public Result adjustByPoolCode(@RequestBody FeePoolAdjustReqVo reqVo) {
        this.feePoolGoodsService.adjustByPoolCode(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\uff08DMS\u3001\u5c0f\u7a0b\u5e8f\uff09\u67e5\u8be2\u5ba2\u6237\u8d27\u8865\u8d39\u7528\u6c60\u4e0a\u8d26\u660e\u7ec6\u5206\u9875")
    @PostMapping(value={"/findFeePoolDetailAccountList"})
    @CrmDictMethod
    public Result<PageResult<FeePoolDetailRespVo>> findFeePoolDetailAccountList(@RequestBody FeePoolDetailReqVo reqVo) {
        return Result.ok(this.feePoolGoodsService.findFeePoolDetailAccountList(reqVo));
    }

    @ApiOperation(value="\uff08DMS\u3001\u5c0f\u7a0b\u5e8f\uff09\u67e5\u8be2\u5ba2\u6237\u8d27\u8865\u8d39\u7528\u6c60\u4f7f\u7528\u660e\u7ec6\u5206\u9875")
    @PostMapping(value={"/findFeePoolUseList"})
    @CrmDictMethod
    public Result<PageResult<FeePoolOperationRespVo>> findFeePoolUseList(@RequestBody FeePoolOperationReqVo reqVo) {
        return Result.ok(this.feePoolGoodsService.findFeePoolUseList(reqVo));
    }

    @ApiOperation(value="\uff08\u5e9f\u5f03\uff09\u67e5\u8be2\u8d27\u8865\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/findGoodsPoolProductList"})
    public Result<PageResult<FeePoolGoodsProductGroupRespVo>> findGoodsPoolProductList(@RequestBody FeePoolGoodsProductGroupReqVo reqVo) {
        PageResult<FeePoolGoodsProductGroupRespVo> result = this.feePoolGoodsService.findGoodsPoolProductList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\uff08DMS\u3001\u5c0f\u7a0b\u5e8f\uff09\u67e5\u8be2\u8d27\u8865\u5546\u54c1\u7ec4\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/findFeePoolGoodsProductList"})
    public Result<PageResult<FeePoolGoodsProductGroupRespVo>> findFeePoolGoodsProductGroupList(@RequestBody FeePoolGoodsProductGroupReqVo reqVo) {
        PageResult<FeePoolGoodsProductGroupRespVo> result = this.feePoolGoodsService.findFeePoolGoodsProductGroupList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u901a\u8fc7\u5ba2\u6237\u7f16\u7801\u83b7\u53d6\u5ba2\u6237\u4e0b\u7684\u8d27\u8865\u91d1\u989d\u6c47\u603b", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="customerCode", value="\u5ba2\u6237\u7f16\u7801", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/queryGoodsAmountByCustomerCode"})
    public Result<FeePoolAmountRespVo> queryGoodsAmountByCustomerCode(@RequestParam(value="customerCode", required=true) String customerCode) {
        return Result.ok((Object)this.feePoolService.queryAmountByCustomerCode(customerCode, FeePoolTypeEnum.GOODS.getValue()));
    }

    @ApiOperation(value="\u901a\u8fc7\u5ba2\u6237\u7f16\u7801\u548c\u5e74\u6708\u83b7\u53d6\u5ba2\u6237\u4e0b\u7684\u6708\u5ea6\u8d27\u8865\u91d1\u989d\u6c47\u603b", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="customerCode", value="\u5ba2\u6237\u7f16\u7801", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="yearMonth", value="\u5e74\u6708 yyyy-MM", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/queryGoodsMonthAmountByCustomerCode"})
    public Result<FeePoolMonthAmountRespVo> queryGoodsMonthAmountByCustomerCode(@RequestParam(value="customerCode", required=true) String customerCode, @RequestParam(value="yearMonth", required=true) String yearMonth) {
        return Result.ok((Object)this.feePoolService.queryMonthAmountByCustomerCode(customerCode, FeePoolTypeEnum.GOODS.getValue(), yearMonth));
    }

    @ApiOperation(value="\u8d27\u8865\u8d39\u7528\u4f7f\u7528\u91d1\u989d\u90e8\u5206\u56de\u9000\uff0c\u6839\u636e\u6765\u6e90\u7f16\u53f7")
    @PostMapping(value={"/backGoodsUseByFromCode"})
    public Result backGoodsUseByFromCode(@RequestBody FeePoolGoodsUseBackReqVo reqVo) {
        this.feePoolGoodsService.backGoodsUseByFromCode(reqVo);
        return Result.ok();
    }
}

