/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.IsShelfEnum;
import com.biz.crm.eunm.fee.FeeBpmStatusEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeExtendEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeGroupEnum;
import com.biz.crm.eunm.fee.FeePoolTypeEnum;
import com.biz.crm.mdm.pricesetting.MdmPriceSettingFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.nebular.fee.pool.req.FeePoolAccountReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolAdjustReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailLogReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolFileReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsAccountReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsProductGroupReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsUseByPoolProductItemReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsUseByProductLevelItemReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsUseItemReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolOperationReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolGoodsProductGroupRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolGoodsProductGroupTempRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolGoodsProductRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolOperationRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeeSelectOptionVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSearchReqVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceResp;
import com.biz.crm.nebular.mdm.product.req.MdmProductQueryReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductQueryRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.pool.mapper.FeePoolMapper;
import com.biz.crm.pool.model.FeePoolDetailEntity;
import com.biz.crm.pool.model.FeePoolEntity;
import com.biz.crm.pool.service.FeePoolDetailLogService;
import com.biz.crm.pool.service.FeePoolDetailService;
import com.biz.crm.pool.service.FeePoolGoodsService;
import com.biz.crm.pool.service.FeePoolOperationService;
import com.biz.crm.pool.service.FeePoolService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ProductLevelUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"FeePoolGoodsServiceExpandImpl"})
public class FeePoolGoodsServiceImpl
implements FeePoolGoodsService {
    private static final Logger log = LoggerFactory.getLogger(FeePoolGoodsServiceImpl.class);
    @Resource
    private FeePoolMapper feePoolMapper;
    @Resource
    private FeePoolService feePoolService;
    @Resource
    private FeePoolOperationService feePoolOperationService;
    @Resource
    private FeePoolDetailService feePoolDetailService;
    @Resource
    private FeePoolDetailLogService feePoolDetailLogService;
    @Resource
    private MdmProductFeign mdmProductFeign;
    @Resource
    private MdmPriceSettingFeign mdmPriceSettingFeign;

    @Override
    public PageResult<FeePoolRespVo> findList(FeePoolReqVo reqVo) {
        reqVo.setPoolType(FeePoolTypeEnum.GOODS.getValue());
        return this.feePoolService.findList(reqVo);
    }

    @Override
    public PageResult<FeePoolDetailRespVo> findFeePoolDetailPageList(FeePoolDetailReqVo reqVo) {
        reqVo.setPoolType(FeePoolTypeEnum.GOODS.getValue());
        return this.feePoolDetailService.findFeePoolDetailPageList(reqVo);
    }

    @Override
    public PageResult<FeePoolDetailRespVo> findFeePoolDetailAccountList(FeePoolDetailReqVo reqVo) {
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        reqVo.setPoolType(FeePoolTypeEnum.GOODS.getValue());
        return this.feePoolDetailService.findFeePoolDetailPageList(reqVo);
    }

    @Override
    public PageResult<FeePoolOperationRespVo> findFeePoolOperationPageList(FeePoolOperationReqVo reqVo) {
        reqVo.setPoolType(FeePoolTypeEnum.GOODS.getValue());
        return this.feePoolOperationService.findFeePoolOperationPageList(reqVo);
    }

    @Override
    public PageResult<FeePoolOperationRespVo> findFeePoolUseList(FeePoolOperationReqVo reqVo) {
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        reqVo.setPoolType(FeePoolTypeEnum.GOODS.getValue());
        List<String> collect = FeePoolConfigUtil.getOperationTypeSelectList((String)FeePoolOperationTypeExtendEnum.SHOW_DETAIL_USE.getValue()).stream().map(FeeSelectOptionVo::getValue).collect(Collectors.toList());
        return this.feePoolOperationService.findList(reqVo, collect);
    }

    @Override
    @Deprecated
    public PageResult<FeePoolGoodsProductGroupTempRespVo> findGoodsPoolProductList(FeePoolGoodsProductGroupReqVo reqVo) {
        Set collect;
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<FeePoolGoodsProductGroupRespVo> list2 = this.feePoolMapper.findFeePoolGoodsProductGroupList((Page<FeePoolGoodsProductGroupRespVo>)page, reqVo, FeePoolTypeEnum.GOODS.getValue(), null, null);
        List list = CrmBeanUtil.copyList(list2, FeePoolGoodsProductGroupTempRespVo.class);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list) && !(collect = list.stream().filter(item -> StringUtils.isNotEmpty((String)item.getGoodsProductCode())).map(FeePoolGoodsProductGroupTempRespVo::getGoodsProductCode).collect(Collectors.toSet())).isEmpty()) {
            List result;
            Result listResult = this.mdmProductFeign.queryBatchByProductCodeList(new ArrayList(collect));
            if (listResult.isSuccess() && CollectionUtil.listNotEmptyNotSizeZero((List)(result = (List)listResult.getResult()))) {
                Map<String, MdmProductRespVo> productMap = result.stream().collect(Collectors.toMap(MdmProductRespVo::getProductCode, v -> v));
                Map saleUnitMap = DictUtil.dictMap((String)"product_sale_unit");
                list.forEach(item -> {
                    if (StringUtils.isNotEmpty((String)item.getGoodsProductCode()) && productMap.containsKey(item.getGoodsProductCode())) {
                        MdmProductRespVo product = (MdmProductRespVo)productMap.get(item.getGoodsProductCode());
                        item.setSpec(product.getSpec());
                        item.setSaleUnit(product.getSaleUnit());
                        item.setSaleUnitName((String)saleUnitMap.get(product.getSaleUnit()));
                    }
                });
            }
            String conditionType = "sale_price";
            MdmPriceSearchReqVo searchReqVo = new MdmPriceSearchReqVo();
            searchReqVo.setCustomerCode(reqVo.getCustomerCode());
            searchReqVo.setProductCodeList(new ArrayList(collect));
            searchReqVo.setSearchTime(DateUtil.dateNow2Str());
            searchReqVo.setConditionTypeCodeList(Collections.singletonList("sale_price"));
            Result search = this.mdmPriceSettingFeign.search(searchReqVo);
            Assert.isTrue((boolean)search.isSuccess(), (String)"\u67e5\u8be2\u4ef7\u683c\u5931\u8d25");
            Map productPriceSearchMap = (Map)search.getResult();
            Map<String, BigDecimal> productPriceMap = productPriceSearchMap.values().stream().filter(item -> item.containsKey("sale_price") && item.get("sale_price") != null).map(item -> (MdmPriceResp)item.get("sale_price")).collect(Collectors.toMap(MdmPriceResp::getProductCode, MdmPriceResp::getPrice));
            list.forEach(item -> item.setPrice(productPriceMap.getOrDefault(item.getGoodsProductCode(), BigDecimal.ZERO)));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<FeePoolGoodsProductGroupRespVo> findFeePoolGoodsProductGroupList(FeePoolGoodsProductGroupReqVo reqVo) {
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        Result productQueryResult = this.mdmProductFeign.queryProductList(new MdmProductQueryReqVo().setIsShelf(IsShelfEnum.UP.getCode()).setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()).setProductCode(reqVo.getGoodsProductCode()).setProductName(reqVo.getGoodsProductName()));
        Assert.isTrue((boolean)productQueryResult.isSuccess(), (String)("\u67e5\u8be2\u5546\u54c1\u5931\u8d25\uff1a" + productQueryResult.getMessage()));
        List productQueryList = (List)productQueryResult.getResult();
        if (CollectionUtil.listEmpty((List)productQueryList)) {
            return PageResult.builder().data(new ArrayList()).count(Long.valueOf(0L)).build();
        }
        List productCodeList = productQueryList.stream().map(MdmProductQueryRespVo::getProductCode).collect(Collectors.toList());
        List<Map<String, String>> productLikeMapList = productCodeList.stream().map(x -> {
            HashMap<String, String> map = new HashMap<String, String>(4);
            map.put("likeLeft", "%," + x);
            map.put("likeRight", x + ",%");
            map.put("like", "%," + x + ",%");
            map.put("equals", (String)x);
            return map;
        }).collect(Collectors.toList());
        List productLevelCodeList = ProductLevelUtil.getParentProductLevelCodeListIncludeSelfEnable(new ArrayList(productQueryList.stream().map(MdmProductQueryRespVo::getProductLevelCode).collect(Collectors.toSet())));
        List<FeePoolGoodsProductGroupRespVo> list = this.feePoolMapper.findFeePoolGoodsProductGroupList((Page<FeePoolGoodsProductGroupRespVo>)page, reqVo, FeePoolTypeEnum.GOODS.getValue(), productLevelCodeList, productLikeMapList);
        if (CollectionUtil.listEmpty(list)) {
            return PageResult.builder().data(new ArrayList()).count(Long.valueOf(0L)).build();
        }
        Set paramProductLevelCodeSet = list.stream().filter(item -> StringUtils.isNotEmpty((String)item.getGoodsProductLevelCode()) && StringUtils.isEmpty((String)item.getGoodsProductCode())).map(item -> Arrays.asList(item.getGoodsProductLevelCode().split(","))).flatMap(Collection::stream).collect(Collectors.toSet());
        Set paramProductCodeSet = list.stream().filter(item -> StringUtils.isNotEmpty((String)item.getGoodsProductCode())).map(item -> Arrays.asList(item.getGoodsProductCode().split(","))).flatMap(Collection::stream).collect(Collectors.toSet());
        HashSet goodsProductCodeSet = new HashSet(16);
        if (!paramProductCodeSet.isEmpty()) {
            goodsProductCodeSet.addAll(paramProductCodeSet);
        }
        if (!paramProductLevelCodeSet.isEmpty()) {
            Result productQueryByProductLevelResult = this.mdmProductFeign.queryProductList(new MdmProductQueryReqVo().setIsShelf(IsShelfEnum.UP.getCode()).setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()).setProductCode(reqVo.getGoodsProductCode()).setProductName(reqVo.getGoodsProductName()).setUnderProductLevelCodeList(new ArrayList(paramProductLevelCodeSet)));
            Assert.isTrue((boolean)productQueryByProductLevelResult.isSuccess(), (String)("\u67e5\u8be2\u5546\u54c1\u5931\u8d25\uff1a" + productQueryByProductLevelResult.getMessage()));
            if (CollectionUtil.listNotEmptyNotSizeZero((List)((List)productQueryByProductLevelResult.getResult()))) {
                goodsProductCodeSet.addAll(((List)productQueryByProductLevelResult.getResult()).stream().map(MdmProductQueryRespVo::getProductCode).collect(Collectors.toSet()));
            }
        }
        if (goodsProductCodeSet.isEmpty()) {
            return PageResult.builder().data(new ArrayList()).count(Long.valueOf(0L)).build();
        }
        Result productQueryByProductResult = this.mdmProductFeign.queryProductList(new MdmProductQueryReqVo().setIsShelf(IsShelfEnum.UP.getCode()).setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()).setProductCode(reqVo.getGoodsProductCode()).setProductName(reqVo.getGoodsProductName()).setProductCodeList(new ArrayList(goodsProductCodeSet)));
        Assert.isTrue((boolean)productQueryByProductResult.isSuccess(), (String)("\u67e5\u8be2\u5546\u54c1\u5931\u8d25\uff1a" + productQueryByProductResult.getMessage()));
        List usableProductList = (List)productQueryByProductResult.getResult();
        Set usableProductCodeSet = usableProductList.stream().map(MdmProductQueryRespVo::getProductCode).collect(Collectors.toSet());
        Map productPriceSearchMap = new HashMap(16);
        String conditionType = reqVo.getConditionType();
        boolean priceSearch = StringUtils.isNotEmpty((String)conditionType);
        if (priceSearch) {
            MdmPriceSearchReqVo searchReqVo = new MdmPriceSearchReqVo();
            searchReqVo.setCustomerCode(reqVo.getCustomerCode());
            searchReqVo.setProductCodeList(new ArrayList(usableProductCodeSet));
            searchReqVo.setSearchTime(DateUtil.dateNow2Str());
            searchReqVo.setConditionTypeCodeList(Collections.singletonList(conditionType));
            Result search = this.mdmPriceSettingFeign.search(searchReqVo);
            Assert.isTrue((boolean)search.isSuccess(), (String)"\u67e5\u8be2\u4ef7\u683c\u5931\u8d25");
            productPriceSearchMap = (Map)search.getResult();
        }
        HashMap productPriceMap = priceSearch ? productPriceSearchMap.values().stream().filter(item -> item.containsKey(conditionType) && item.get(conditionType) != null).map(item -> (MdmPriceResp)item.get(conditionType)).collect(Collectors.toMap(MdmPriceResp::getProductCode, MdmPriceResp::getPrice)) : new HashMap(16);
        Map<String, MdmProductQueryRespVo> usableProductMap = usableProductList.stream().collect(Collectors.toMap(MdmProductQueryRespVo::getProductCode, v -> v));
        Map saleUnitMap = DictUtil.dictMap((String)"product_sale_unit");
        list.forEach(item -> {
            List goodsProductLevelChildrenCodeList;
            ArrayList productList = new ArrayList();
            ArrayList goodsProductCodeList = new ArrayList();
            if (StringUtils.isNotEmpty((String)item.getGoodsProductCode())) {
                goodsProductCodeList.addAll(Arrays.asList(item.getGoodsProductCode().split(",")).stream().filter(x -> usableProductCodeSet.contains(x)).collect(Collectors.toList()));
            } else if (StringUtils.isNotEmpty((String)item.getGoodsProductLevelCode()) && CollectionUtil.listNotEmptyNotSizeZero((List)(goodsProductLevelChildrenCodeList = ProductLevelUtil.getChildrenProductLevelCodeListIncludeSelfEnable(Arrays.asList(item.getGoodsProductLevelCode().split(",")))))) {
                HashSet set = new HashSet(goodsProductLevelChildrenCodeList);
                goodsProductCodeList.addAll(usableProductList.stream().filter(x -> set.contains(x.getProductLevelCode())).map(MdmProductQueryRespVo::getProductCode).collect(Collectors.toList()));
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(goodsProductCodeList)) {
                productList.addAll(goodsProductCodeList.stream().map(x -> {
                    MdmProductQueryRespVo product = (MdmProductQueryRespVo)usableProductMap.get(x);
                    FeePoolGoodsProductRespVo goodsProduct = new FeePoolGoodsProductRespVo();
                    goodsProduct.setProductCode(product.getProductCode());
                    goodsProduct.setProductName(product.getProductName());
                    goodsProduct.setSpec(product.getSpec());
                    goodsProduct.setSaleUnit(product.getSaleUnit());
                    goodsProduct.setSaleUnitName((String)saleUnitMap.get(product.getSaleUnit()));
                    if (priceSearch) {
                        goodsProduct.setPrice((BigDecimal)productPriceMap.get(product.getProductCode()));
                    }
                    return goodsProduct;
                }).collect(Collectors.toList()));
            }
            item.setProductList(productList);
            item.setGoodsProductCode(productList.stream().map(FeePoolGoodsProductRespVo::getProductCode).collect(Collectors.joining(",")));
            item.setGoodsProductName(productList.stream().map(FeePoolGoodsProductRespVo::getProductName).collect(Collectors.joining(",")));
        });
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void account(FeePoolGoodsAccountReqVo reqVo) {
        FeePoolAccountReqVo copy = (FeePoolAccountReqVo)CrmBeanUtil.copy((Object)reqVo, FeePoolAccountReqVo.class);
        copy.setPoolType(FeePoolTypeEnum.GOODS.getValue());
        this.feePoolService.account(copy);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void adjust(FeePoolAdjustReqVo reqVo) {
        this.feePoolService.adjust(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void adjustByPoolCode(FeePoolAdjustReqVo reqVo) {
        this.feePoolService.adjustByPoolCode(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Deprecated
    public void useGoodsPool(String operationType, String fromCode, String fromDesc, String remarks, List<FeePoolGoodsUseItemReqVo> poolProductAmountList, List<FeePoolFileReqVo> fileList) {
        Assert.hasText((String)operationType, (String)"\u7f3a\u5931\u64cd\u4f5c\u7c7b\u578b");
        String operationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)operationType);
        Assert.hasText((String)operationTypeValue, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
        Assert.notEmpty(poolProductAmountList, (String)"\u7f3a\u5931\u4f7f\u7528\u91d1\u989d\u660e\u7ec6");
        Assert.isTrue((boolean)FeePoolConfigUtil.checkOperationTypeGroup((String)operationType, (FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.USE), (String)"\u8be5\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4f7f\u7528\u8d39\u7528\u6c60\u91d1\u989d");
        if (FeePoolOperationTypeEnum.ORDER_USE.getValue().equals(operationType)) {
            Assert.hasText((String)fromCode, (String)(operationTypeValue + "\u5fc5\u987b\u6709\u6765\u6e90\u5355\u53f7"));
        }
        poolProductAmountList.forEach(x -> {
            Assert.hasText((String)x.getPoolCode(), (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u7801");
            Assert.hasText((String)x.getProductCode(), (String)"\u7f3a\u5931\u5546\u54c1\u7f16\u7801");
            Assert.isTrue((x.getAmount() != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u4f7f\u7528\u91d1\u989d");
            Assert.isTrue((x.getAmount().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u4f7f\u7528\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
        });
        Result result = this.mdmProductFeign.queryBatchByProductCodeList(poolProductAmountList.stream().map(FeePoolGoodsUseItemReqVo::getProductCode).collect(Collectors.toList()));
        Assert.isTrue((boolean)result.isSuccess(), (String)"\u67e5\u8be2\u5546\u54c1\u5931\u8d25");
        Map<String, MdmProductRespVo> productMap = ((List)result.getResult()).stream().collect(Collectors.toMap(MdmProductRespVo::getProductCode, v -> v));
        poolProductAmountList.forEach(x -> Assert.isTrue((boolean)productMap.containsKey(x.getProductCode()), (String)("\u5546\u54c1\u7f16\u7801\u3010" + x.getProductCode() + "\u3011\u4e0d\u5b58\u5728")));
        Map<String, List<FeePoolGoodsUseItemReqVo>> groupByPoolCodeMap = poolProductAmountList.stream().collect(Collectors.groupingBy(FeePoolGoodsUseItemReqVo::getPoolCode));
        String operationDateTime = DateUtil.dateNowHms();
        FeePoolOperationTypeGroupEnum operationTypeGroupEnum = FeePoolConfigUtil.getOperationTypeGroup((String)operationType);
        for (Map.Entry<String, List<FeePoolGoodsUseItemReqVo>> entry : groupByPoolCodeMap.entrySet()) {
            String poolCode = entry.getKey();
            List<FeePoolGoodsUseItemReqVo> itemList = entry.getValue();
            FeePoolEntity pool = (FeePoolEntity)((LambdaQueryChainWrapper)this.feePoolService.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)entry.getKey())).one();
            BigDecimal amount = itemList.stream().map(FeePoolGoodsUseItemReqVo::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            Assert.notNull((Object)pool, (String)("\u672a\u627e\u5230\u8d39\u7528\u6c60[" + poolCode + "]"));
            Assert.isTrue((pool.getUsableAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60" + poolCode + "\u53ef\u4ee5\u4f59\u989d\u4e0d\u8db3"));
            pool.setHasUseAmount(pool.getHasUseAmount().add(amount));
            pool.setUsableAmount(pool.getUsableAmount().subtract(amount));
            this.feePoolService.updateById(pool);
            String operationCode = this.feePoolOperationService.savePoolOperation(pool.getPoolCode(), operationType, FeeBpmStatusEnum.PASS.getValue(), fromCode, StringUtils.isNotEmpty((String)fromDesc) ? fromDesc : operationTypeValue, remarks, amount, operationTypeGroupEnum.getUsableAmountWeight(), operationDateTime, fileList);
            List poolDetailList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolDetailService.lambdaQuery().eq(FeePoolDetailEntity::getPoolCode, (Object)poolCode)).orderByAsc(FeePoolDetailEntity::getAccountDateTime)).list();
            ArrayList<FeePoolDetailLogReqVo> detailLogList = new ArrayList<FeePoolDetailLogReqVo>();
            for (FeePoolGoodsUseItemReqVo useItem : itemList) {
                BigDecimal restAmount = useItem.getAmount();
                for (FeePoolDetailEntity poolDetail : poolDetailList) {
                    if (restAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                    if (poolDetail.getUsableAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                    BigDecimal itemUse = BigDecimal.ZERO;
                    itemUse = poolDetail.getUsableAmount().compareTo(restAmount) >= 0 ? restAmount : poolDetail.getUsableAmount();
                    restAmount = restAmount.subtract(itemUse);
                    poolDetail.setHasUseAmount(poolDetail.getHasUseAmount().add(itemUse));
                    poolDetail.setUsableAmount(poolDetail.getUsableAmount().subtract(itemUse));
                    FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
                    detailLog.setPoolCode(poolCode);
                    detailLog.setPoolDetailCode(poolDetail.getPoolDetailCode());
                    detailLog.setOperationCode(operationCode);
                    detailLog.setOperationType(operationType);
                    detailLog.setFromCode(fromCode);
                    detailLog.setFromDesc(StringUtils.isNotEmpty((String)fromDesc) ? fromDesc : operationTypeValue);
                    detailLog.setRemarks(remarks);
                    detailLog.setOperationAmount(itemUse.multiply(operationTypeGroupEnum.getUsableAmountWeight()));
                    detailLog.setOperationDateTime(operationDateTime);
                    detailLog.setProductCode(useItem.getProductCode());
                    detailLog.setProductName(productMap.get(useItem.getProductCode()).getProductName());
                    detailLogList.add(detailLog);
                }
                Assert.isTrue((restAmount.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)"\u8d39\u7528\u6c60\u91d1\u989d\u5f02\u5e38");
            }
            this.feePoolDetailService.updateBatchById(poolDetailList);
            this.feePoolDetailLogService.savePoolDetailLog(detailLogList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void useGoodsAmountByPoolProductList(String operationType, String fromCode, String fromDesc, String remarks, List<FeePoolGoodsUseByPoolProductItemReqVo> poolProductItemList, List<FeePoolFileReqVo> fileList) {
        Assert.hasText((String)operationType, (String)"\u7f3a\u5931\u64cd\u4f5c\u7c7b\u578b");
        String operationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)operationType);
        Assert.hasText((String)operationTypeValue, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
        Assert.notEmpty(poolProductItemList, (String)"\u7f3a\u5931\u4f7f\u7528\u91d1\u989d\u660e\u7ec6");
        Assert.isTrue((boolean)FeePoolConfigUtil.checkOperationTypeGroup((String)operationType, (FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.USE), (String)"\u8be5\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4f7f\u7528\u8d39\u7528\u6c60\u91d1\u989d");
        if (FeePoolOperationTypeEnum.ORDER_USE.getValue().equals(operationType)) {
            Assert.hasText((String)fromCode, (String)(operationTypeValue + "\u5fc5\u987b\u6709\u6765\u6e90\u5355\u53f7"));
        }
        poolProductItemList.forEach(x -> {
            Assert.hasText((String)x.getPoolCode(), (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u7801");
            Assert.hasText((String)x.getProductCode(), (String)"\u7f3a\u5931\u5546\u54c1\u7f16\u7801");
            Assert.isTrue((x.getAmount() != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u4f7f\u7528\u91d1\u989d");
            Assert.isTrue((x.getAmount().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u4f7f\u7528\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
        });
        Result result = this.mdmProductFeign.queryBatchByProductCodeList(poolProductItemList.stream().map(FeePoolGoodsUseByPoolProductItemReqVo::getProductCode).collect(Collectors.toList()));
        Assert.isTrue((boolean)result.isSuccess(), (String)"\u67e5\u8be2\u5546\u54c1\u5931\u8d25");
        Map<String, MdmProductRespVo> productMap = ((List)result.getResult()).stream().collect(Collectors.toMap(MdmProductRespVo::getProductCode, v -> v));
        poolProductItemList.forEach(x -> Assert.isTrue((boolean)productMap.containsKey(x.getProductCode()), (String)("\u5546\u54c1\u7f16\u7801\u3010" + x.getProductCode() + "\u3011\u4e0d\u5b58\u5728")));
        Map<String, List<FeePoolGoodsUseByPoolProductItemReqVo>> groupByPoolCodeMap = poolProductItemList.stream().collect(Collectors.groupingBy(FeePoolGoodsUseByPoolProductItemReqVo::getPoolCode));
        String operationDateTime = DateUtil.dateNowHms();
        FeePoolOperationTypeGroupEnum operationTypeGroupEnum = FeePoolConfigUtil.getOperationTypeGroup((String)operationType);
        for (Map.Entry<String, List<FeePoolGoodsUseByPoolProductItemReqVo>> entry : groupByPoolCodeMap.entrySet()) {
            String poolCode = entry.getKey();
            List<FeePoolGoodsUseByPoolProductItemReqVo> itemList = entry.getValue();
            FeePoolEntity pool = (FeePoolEntity)((LambdaQueryChainWrapper)this.feePoolService.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)entry.getKey())).one();
            BigDecimal amount = itemList.stream().map(FeePoolGoodsUseByPoolProductItemReqVo::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            Assert.notNull((Object)pool, (String)("\u672a\u627e\u5230\u8d39\u7528\u6c60[" + poolCode + "]"));
            Assert.isTrue((pool.getUsableAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60" + poolCode + "\u53ef\u4ee5\u4f59\u989d\u4e0d\u8db3"));
            pool.setHasUseAmount(pool.getHasUseAmount().add(amount));
            pool.setUsableAmount(pool.getUsableAmount().subtract(amount));
            this.feePoolService.updateById(pool);
            String operationCode = this.feePoolOperationService.savePoolOperation(pool.getPoolCode(), operationType, FeeBpmStatusEnum.PASS.getValue(), fromCode, StringUtils.isNotEmpty((String)fromDesc) ? fromDesc : operationTypeValue, remarks, amount, operationTypeGroupEnum.getUsableAmountWeight(), operationDateTime, fileList);
            List poolDetailList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolDetailService.lambdaQuery().eq(FeePoolDetailEntity::getPoolCode, (Object)poolCode)).orderByAsc(FeePoolDetailEntity::getAccountDateTime)).list();
            ArrayList<FeePoolDetailLogReqVo> detailLogList = new ArrayList<FeePoolDetailLogReqVo>();
            for (FeePoolGoodsUseByPoolProductItemReqVo useItem : itemList) {
                BigDecimal restAmount = useItem.getAmount();
                for (FeePoolDetailEntity poolDetail : poolDetailList) {
                    if (restAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                    if (poolDetail.getUsableAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                    BigDecimal itemUse = BigDecimal.ZERO;
                    itemUse = poolDetail.getUsableAmount().compareTo(restAmount) >= 0 ? restAmount : poolDetail.getUsableAmount();
                    restAmount = restAmount.subtract(itemUse);
                    poolDetail.setHasUseAmount(poolDetail.getHasUseAmount().add(itemUse));
                    poolDetail.setUsableAmount(poolDetail.getUsableAmount().subtract(itemUse));
                    FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
                    detailLog.setPoolCode(poolCode);
                    detailLog.setPoolDetailCode(poolDetail.getPoolDetailCode());
                    detailLog.setOperationCode(operationCode);
                    detailLog.setOperationType(operationType);
                    detailLog.setFromCode(fromCode);
                    detailLog.setFromDesc(StringUtils.isNotEmpty((String)fromDesc) ? fromDesc : operationTypeValue);
                    detailLog.setRemarks(remarks);
                    detailLog.setOperationAmount(itemUse.multiply(operationTypeGroupEnum.getUsableAmountWeight()));
                    detailLog.setOperationDateTime(operationDateTime);
                    detailLog.setProductCode(useItem.getProductCode());
                    detailLog.setProductName(productMap.get(useItem.getProductCode()).getProductName());
                    detailLogList.add(detailLog);
                }
                Assert.isTrue((restAmount.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)"\u8d39\u7528\u6c60\u91d1\u989d\u5f02\u5e38");
            }
            this.feePoolDetailService.updateBatchById(poolDetailList);
            this.feePoolDetailLogService.savePoolDetailLog(detailLogList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void useGoodsAmountByProductLevelList(String operationType, String fromCode, String fromDesc, String remarks, List<FeePoolGoodsUseByProductLevelItemReqVo> productLevelItemList, List<FeePoolFileReqVo> fileList) {
        Assert.hasText((String)operationType, (String)"\u7f3a\u5931\u64cd\u4f5c\u7c7b\u578b");
        String operationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)operationType);
        Assert.hasText((String)operationTypeValue, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
        Assert.notEmpty(productLevelItemList, (String)"\u7f3a\u5931\u4f7f\u7528\u91d1\u989d\u660e\u7ec6");
        Assert.isTrue((boolean)FeePoolConfigUtil.checkOperationTypeGroup((String)operationType, (FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.USE), (String)"\u8be5\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4f7f\u7528\u8d39\u7528\u6c60\u91d1\u989d");
        if (FeePoolOperationTypeEnum.ORDER_USE.getValue().equals(operationType)) {
            Assert.hasText((String)fromCode, (String)(operationTypeValue + "\u5fc5\u987b\u6709\u6765\u6e90\u5355\u53f7"));
        }
        productLevelItemList.forEach(x -> {
            Assert.hasText((String)x.getProductLevelCode(), (String)"\u7f3a\u5931\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801");
            Assert.isTrue((x.getAmount() != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u4f7f\u7528\u91d1\u989d");
            Assert.isTrue((x.getAmount().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u4f7f\u7528\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
        });
        List productLevelByCodeList = ProductLevelUtil.getProductLevelByCodeList(productLevelItemList.stream().map(FeePoolGoodsUseByProductLevelItemReqVo::getProductLevelCode).collect(Collectors.toList()));
        Map<String, MdmProductLevelRespVo> productLevelMap = productLevelByCodeList.stream().collect(Collectors.toMap(MdmProductLevelRespVo::getProductLevelCode, v -> v));
        productLevelItemList.forEach(x -> Assert.isTrue((boolean)productLevelMap.containsKey(x.getProductLevelCode()), (String)("\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u3010" + x.getProductLevelCode() + "\u3011\u4e0d\u5b58\u5728")));
        Map<String, BigDecimal> productLevelAmountMap = productLevelItemList.stream().collect(Collectors.groupingBy(FeePoolGoodsUseByProductLevelItemReqVo::getProductLevelCode, Collectors.mapping(FeePoolGoodsUseByProductLevelItemReqVo::getAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        String operationDateTime = DateUtil.dateNowHms();
        FeePoolOperationTypeGroupEnum operationTypeGroupEnum = FeePoolConfigUtil.getOperationTypeGroup((String)operationType);
        for (Map.Entry<String, BigDecimal> entry : productLevelAmountMap.entrySet()) {
            String productLevelCode = entry.getKey();
            String productLevelName = productLevelMap.get(productLevelCode).getProductLevelName();
            List collect = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolService.lambdaQuery().eq(FeePoolEntity::getPoolType, (Object)FeePoolTypeEnum.GOODS.getValue())).eq(FeePoolEntity::getGoodsProductLevelCode, (Object)productLevelCode)).list().stream().filter(x -> StringUtils.isEmpty((String)x.getGoodsProductCode())).collect(Collectors.toList());
            Assert.notEmpty(collect, (String)("\u672a\u627e\u5230\u4ea7\u54c1\u5c42\u7ea7\u3010" + productLevelName + "\u3011\u7684\u8d27\u8865\u8d39\u7528\u6c60"));
            FeePoolEntity pool = (FeePoolEntity)collect.get(0);
            BigDecimal amount = entry.getValue();
            Assert.isTrue((pool.getUsableAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)("\u4ea7\u54c1\u5c42\u7ea7\u3010" + productLevelName + "\u3011\u7684\u8d27\u8865\u53ef\u7528\u4f59\u989d\u4e0d\u8db3"));
            pool.setHasUseAmount(pool.getHasUseAmount().add(amount));
            pool.setUsableAmount(pool.getUsableAmount().subtract(amount));
            this.feePoolService.updateById(pool);
            String operationCode = this.feePoolOperationService.savePoolOperation(pool.getPoolCode(), operationType, FeeBpmStatusEnum.PASS.getValue(), fromCode, StringUtils.isNotEmpty((String)fromDesc) ? fromDesc : operationTypeValue, remarks, amount, operationTypeGroupEnum.getUsableAmountWeight(), operationDateTime, fileList);
            List poolDetailList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolDetailService.lambdaQuery().eq(FeePoolDetailEntity::getPoolCode, (Object)pool.getPoolCode())).orderByAsc(FeePoolDetailEntity::getAccountDateTime)).list();
            ArrayList<FeePoolDetailLogReqVo> detailLogList = new ArrayList<FeePoolDetailLogReqVo>();
            BigDecimal restAmount = amount;
            for (FeePoolDetailEntity poolDetail : poolDetailList) {
                if (restAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                if (poolDetail.getUsableAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal itemUse = BigDecimal.ZERO;
                itemUse = poolDetail.getUsableAmount().compareTo(restAmount) >= 0 ? restAmount : poolDetail.getUsableAmount();
                restAmount = restAmount.subtract(itemUse);
                poolDetail.setHasUseAmount(poolDetail.getHasUseAmount().add(itemUse));
                poolDetail.setUsableAmount(poolDetail.getUsableAmount().subtract(itemUse));
                FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
                detailLog.setPoolCode(pool.getPoolCode());
                detailLog.setPoolDetailCode(poolDetail.getPoolDetailCode());
                detailLog.setOperationCode(operationCode);
                detailLog.setOperationType(operationType);
                detailLog.setFromCode(fromCode);
                detailLog.setFromDesc(StringUtils.isNotEmpty((String)fromDesc) ? fromDesc : operationTypeValue);
                detailLog.setRemarks(remarks);
                detailLog.setOperationAmount(itemUse.multiply(operationTypeGroupEnum.getUsableAmountWeight()));
                detailLog.setOperationDateTime(operationDateTime);
                detailLog.setProductCode(productLevelCode);
                detailLog.setProductName(productLevelName);
                detailLogList.add(detailLog);
            }
            Assert.isTrue((restAmount.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)"\u8d39\u7528\u6c60\u91d1\u989d\u5f02\u5e38");
            this.feePoolDetailService.updateBatchById(poolDetailList);
            this.feePoolDetailLogService.savePoolDetailLog(detailLogList);
        }
    }
}

