/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.fee.FeeBpmStatusEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeExtendEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeGroupEnum;
import com.biz.crm.nebular.fee.pool.req.FeePoolAdjustReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailAdjustReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailLogReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolOperationReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolFileRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolQueryForAdjustRespVo;
import com.biz.crm.pool.mapper.FeePoolDetailMapper;
import com.biz.crm.pool.model.FeePoolDetailEntity;
import com.biz.crm.pool.model.FeePoolEntity;
import com.biz.crm.pool.service.FeePoolDetailLogService;
import com.biz.crm.pool.service.FeePoolDetailService;
import com.biz.crm.pool.service.FeePoolFileService;
import com.biz.crm.pool.service.FeePoolOperationService;
import com.biz.crm.pool.service.FeePoolService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"FeePoolDetailServiceExpandImpl"})
public class FeePoolDetailServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<FeePoolDetailMapper, FeePoolDetailEntity>
implements FeePoolDetailService {
    private static final Logger log = LoggerFactory.getLogger(FeePoolDetailServiceImpl.class);
    @Resource
    private FeePoolDetailMapper feePoolDetailMapper;
    @Resource
    private FeePoolDetailLogService feePoolDetailLogService;
    @Resource
    private FeePoolService feePoolService;
    @Resource
    private FeePoolFileService feePoolFileService;
    @Resource
    private FeePoolOperationService feePoolOperationService;

    @Override
    public FeePoolDetailRespVo queryByPoolDetailCode(String poolDetailCode) {
        FeePoolDetailEntity one;
        if (StringUtils.isNotEmpty((String)poolDetailCode) && (one = (FeePoolDetailEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolDetailEntity::getPoolDetailCode, (Object)poolDetailCode)).one()) != null) {
            FeePoolDetailRespVo copy = (FeePoolDetailRespVo)CrmBeanUtil.copy((Object)one, FeePoolDetailRespVo.class);
            copy.setFileList(this.feePoolFileService.getFeePoolFileListByOperationCode(copy.getOperationCode()));
            return copy;
        }
        return null;
    }

    @Override
    public FeePoolDetailRespVo queryById(String id) {
        FeePoolDetailEntity one;
        if (StringUtils.isNotEmpty((String)id) && (one = (FeePoolDetailEntity)this.getById((Serializable)((Object)id))) != null) {
            FeePoolDetailRespVo copy = (FeePoolDetailRespVo)CrmBeanUtil.copy((Object)one, FeePoolDetailRespVo.class);
            copy.setFileList(this.feePoolFileService.getFeePoolFileListByOperationCode(copy.getOperationCode()));
            return copy;
        }
        return null;
    }

    @Override
    public PageResult<FeePoolDetailRespVo> findFeePoolDetailPageList(FeePoolDetailReqVo reqVo) {
        List collect;
        Page page;
        List<FeePoolDetailRespVo> list;
        if (StringUtils.isNotEmpty((String)reqVo.getBeginDate())) {
            reqVo.setBeginDate(reqVo.getBeginDate() + " 00:00:00");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getEndDate())) {
            reqVo.setEndDate(reqVo.getEndDate() + " 23:59:59");
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(list = this.feePoolDetailMapper.findFeePoolDetailPageList((Page<FeePoolDetailRespVo>)(page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize())), reqVo, collect = FeePoolConfigUtil.getOperationTypeList()))) {
            Map<String, List<FeePoolFileRespVo>> map = this.feePoolFileService.getFeePoolFileListGroupByOperationCodeList(list.stream().map(FeePoolDetailRespVo::getOperationCode).collect(Collectors.toList()));
            list.forEach(item -> {
                if (map.containsKey(item.getOperationCode())) {
                    item.setFileList((List)map.get(item.getOperationCode()));
                }
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void useByPoolDetailCode(FeePoolDetailAdjustReqVo reqVo) {
        String bpmStatus = FeeBpmStatusEnum.PASS.getValue();
        String operationDateTime = DateUtil.dateNowHms();
        FeePoolDetailEntity poolDetail = (FeePoolDetailEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolDetailEntity::getPoolDetailCode, (Object)reqVo.getPoolDetailCode())).one();
        Assert.notNull((Object)poolDetail, (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        Assert.isTrue((poolDetail.getUsableAmount().compareTo(reqVo.getAmount()) >= 0 ? 1 : 0) != 0, (String)"\u4f7f\u7528\u91d1\u989d\u8d85\u8fc7\u53ef\u7528\u91d1\u989d");
        poolDetail.setHasUseAmount(poolDetail.getHasUseAmount().add(reqVo.getAmount()));
        poolDetail.setUsableAmount(poolDetail.getUsableAmount().subtract(reqVo.getAmount()));
        this.updateById(poolDetail);
        FeePoolOperationReqVo operationReqVo = new FeePoolOperationReqVo();
        operationReqVo.setPoolCode(poolDetail.getPoolCode());
        operationReqVo.setOperationType(reqVo.getOperationType());
        operationReqVo.setBpmStatus(bpmStatus);
        operationReqVo.setFromCode(reqVo.getFromCode());
        operationReqVo.setFromDesc(DictUtil.dictValue((String)"fee_pool_operation_type", (String)reqVo.getOperationType()));
        operationReqVo.setOperationDateTime(operationDateTime);
        operationReqVo.setOperationAmount(reqVo.getAmount().multiply(FeePoolOperationTypeGroupEnum.USE.getUsableAmountWeight()));
        operationReqVo.setFileList(reqVo.getFileList());
        operationReqVo.setRemarks(reqVo.getRemarks());
        String operationCode = this.feePoolOperationService.savePoolOperation(operationReqVo);
        this.feePoolService.addHasUseAmount(poolDetail.getPoolCode(), reqVo.getAmount());
        FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
        detailLog.setPoolCode(poolDetail.getPoolCode());
        detailLog.setPoolDetailCode(poolDetail.getPoolDetailCode());
        detailLog.setOperationCode(operationCode);
        detailLog.setOperationType(reqVo.getOperationType());
        detailLog.setFromCode(reqVo.getFromCode());
        detailLog.setFromDesc(DictUtil.dictValue((String)"fee_pool_operation_type", (String)reqVo.getOperationType()));
        detailLog.setRemarks(reqVo.getRemarks());
        detailLog.setOperationAmount(reqVo.getAmount().multiply(FeePoolOperationTypeGroupEnum.USE.getUsableAmountWeight()));
        detailLog.setOperationDateTime(operationDateTime);
        this.feePoolDetailLogService.savePoolDetailLog(detailLog);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void freezeByPoolDetailCode(FeePoolDetailAdjustReqVo reqVo) {
        String bpmStatus = FeeBpmStatusEnum.PASS.getValue();
        Assert.hasText((String)reqVo.getPoolDetailCode(), (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        BigDecimal freezeAmount = reqVo.getAmount();
        Assert.isTrue((freezeAmount != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u51bb\u7ed3\u91d1\u989d");
        Assert.isTrue((freezeAmount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u51bb\u7ed3\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        FeePoolDetailEntity poolDetail = (FeePoolDetailEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolDetailEntity::getPoolDetailCode, (Object)reqVo.getPoolDetailCode())).one();
        Assert.notNull((Object)poolDetail, (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        Assert.isTrue((poolDetail.getUsableAmount().compareTo(freezeAmount) >= 0 ? 1 : 0) != 0, (String)"\u51bb\u7ed3\u91d1\u989d\u5927\u4e8e\u53ef\u7528\u91d1\u989d");
        String operationDateTime = DateUtil.dateNowHms();
        FeePoolOperationReqVo operationReqVo = new FeePoolOperationReqVo();
        operationReqVo.setPoolCode(poolDetail.getPoolCode());
        operationReqVo.setOperationType(FeePoolOperationTypeEnum.FREEZE.getValue());
        operationReqVo.setBpmStatus(bpmStatus);
        operationReqVo.setFromCode(reqVo.getFromCode());
        operationReqVo.setFromDesc(DictUtil.dictValue((String)"fee_pool_operation_type", (String)FeePoolOperationTypeEnum.FREEZE.getValue()));
        operationReqVo.setOperationDateTime(operationDateTime);
        operationReqVo.setOperationAmount(freezeAmount.multiply(FeePoolOperationTypeGroupEnum.FREEZE.getUsableAmountWeight()));
        operationReqVo.setFileList(reqVo.getFileList());
        operationReqVo.setRemarks(reqVo.getRemarks());
        String operationCode = this.feePoolOperationService.savePoolOperation(operationReqVo);
        poolDetail.setFreezeAmount(poolDetail.getFreezeAmount().add(freezeAmount));
        poolDetail.setUsableAmount(poolDetail.getUsableAmount().subtract(freezeAmount));
        this.updateById(poolDetail);
        this.feePoolService.addFreezeAmount(poolDetail.getPoolCode(), freezeAmount);
        FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
        detailLog.setPoolCode(poolDetail.getPoolCode());
        detailLog.setPoolDetailCode(poolDetail.getPoolDetailCode());
        detailLog.setOperationCode(operationCode);
        detailLog.setOperationType(FeePoolOperationTypeEnum.FREEZE.getValue());
        detailLog.setFromCode(reqVo.getFromCode());
        detailLog.setFromDesc(DictUtil.dictValue((String)"fee_pool_operation_type", (String)FeePoolOperationTypeEnum.FREEZE.getValue()));
        detailLog.setRemarks(reqVo.getRemarks());
        detailLog.setOperationAmount(freezeAmount.multiply(FeePoolOperationTypeGroupEnum.FREEZE.getUsableAmountWeight()));
        detailLog.setOperationDateTime(operationDateTime);
        this.feePoolDetailLogService.savePoolDetailLog(detailLog);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unfreezeByPoolDetailCode(FeePoolDetailAdjustReqVo reqVo) {
        String bpmStatus = FeeBpmStatusEnum.PASS.getValue();
        Assert.hasText((String)reqVo.getPoolDetailCode(), (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        BigDecimal unfreezeAmount = reqVo.getAmount();
        Assert.isTrue((unfreezeAmount != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u89e3\u51bb\u91d1\u989d");
        Assert.isTrue((unfreezeAmount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u51bb\u7ed3\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        FeePoolDetailEntity poolDetail = (FeePoolDetailEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolDetailEntity::getPoolDetailCode, (Object)reqVo.getPoolDetailCode())).one();
        Assert.notNull((Object)poolDetail, (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        Assert.isTrue((poolDetail.getFreezeAmount().compareTo(unfreezeAmount) >= 0 ? 1 : 0) != 0, (String)"\u89e3\u51bb\u91d1\u989d\u5927\u4e8e\u5df2\u51bb\u7ed3\u91d1\u989d");
        String operationDateTime = DateUtil.dateNowHms();
        FeePoolOperationReqVo operationReqVo = new FeePoolOperationReqVo();
        operationReqVo.setPoolCode(poolDetail.getPoolCode());
        operationReqVo.setOperationType(FeePoolOperationTypeEnum.UNFREEZE.getValue());
        operationReqVo.setBpmStatus(bpmStatus);
        operationReqVo.setFromCode(reqVo.getFromCode());
        operationReqVo.setFromDesc(DictUtil.dictValue((String)"fee_pool_operation_type", (String)FeePoolOperationTypeEnum.UNFREEZE.getValue()));
        operationReqVo.setOperationDateTime(operationDateTime);
        operationReqVo.setOperationAmount(unfreezeAmount.multiply(FeePoolOperationTypeGroupEnum.UNFREEZE.getUsableAmountWeight()));
        operationReqVo.setFileList(reqVo.getFileList());
        operationReqVo.setRemarks(reqVo.getRemarks());
        String operationCode = this.feePoolOperationService.savePoolOperation(operationReqVo);
        poolDetail.setFreezeAmount(poolDetail.getFreezeAmount().subtract(unfreezeAmount));
        poolDetail.setUsableAmount(poolDetail.getUsableAmount().add(unfreezeAmount));
        this.updateById(poolDetail);
        this.feePoolService.subtractFreezeAmount(poolDetail.getPoolCode(), unfreezeAmount);
        FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
        detailLog.setPoolCode(poolDetail.getPoolCode());
        detailLog.setPoolDetailCode(poolDetail.getPoolDetailCode());
        detailLog.setOperationCode(operationCode);
        detailLog.setOperationType(FeePoolOperationTypeEnum.UNFREEZE.getValue());
        detailLog.setFromCode(reqVo.getFromCode());
        detailLog.setFromDesc(DictUtil.dictValue((String)"fee_pool_operation_type", (String)FeePoolOperationTypeEnum.UNFREEZE.getValue()));
        detailLog.setRemarks(reqVo.getRemarks());
        detailLog.setOperationAmount(unfreezeAmount.multiply(FeePoolOperationTypeGroupEnum.UNFREEZE.getUsableAmountWeight()));
        detailLog.setOperationDateTime(operationDateTime);
        this.feePoolDetailLogService.savePoolDetailLog(detailLog);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void adjust(FeePoolAdjustReqVo reqVo) {
        this.feePoolService.adjust(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void adjustByPoolDetailCode(FeePoolDetailAdjustReqVo reqVo) {
        Assert.hasText((String)reqVo.getPoolDetailCode(), (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        BigDecimal amount = reqVo.getAmount();
        Assert.isTrue((amount != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u8c03\u6574\u91d1\u989d");
        Assert.isTrue((amount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u8c03\u6574\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        FeePoolDetailEntity poolDetail = (FeePoolDetailEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolDetailEntity::getPoolDetailCode, (Object)reqVo.getPoolDetailCode())).one();
        Assert.notNull((Object)poolDetail, (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        Assert.isTrue((boolean)FeePoolConfigUtil.checkOperationTypeUsable((String)reqVo.getOperationType(), (FeePoolOperationTypeExtendEnum)FeePoolOperationTypeExtendEnum.ADJUST_POOL_DETAIL_LINE), (String)"\u4e0d\u652f\u6301\u7684\u884c\u64cd\u4f5c");
        FeePoolOperationTypeGroupEnum operationTypeGroup = FeePoolConfigUtil.getOperationTypeGroup((String)reqVo.getOperationType());
        Assert.isTrue((FeePoolOperationTypeGroupEnum.ACCOUNT != operationTypeGroup ? 1 : 0) != 0, (String)"\u884c\u64cd\u4f5c\u4e0d\u652f\u6301\u6dfb\u52a0\u91d1\u989d");
        Assert.isTrue((FeePoolOperationTypeGroupEnum.BACK != operationTypeGroup ? 1 : 0) != 0, (String)"\u884c\u64cd\u4f5c\u4e0d\u652f\u6301\u56de\u9000\u91d1\u989d\u7c7b\u64cd\u4f5c");
        switch (operationTypeGroup) {
            case USE: {
                this.useByPoolDetailCode(reqVo);
                break;
            }
            case FREEZE: {
                this.freezeByPoolDetailCode((FeePoolDetailAdjustReqVo)CrmBeanUtil.copy((Object)reqVo, FeePoolDetailAdjustReqVo.class));
                break;
            }
            case UNFREEZE: {
                this.unfreezeByPoolDetailCode((FeePoolDetailAdjustReqVo)CrmBeanUtil.copy((Object)reqVo, FeePoolDetailAdjustReqVo.class));
                break;
            }
        }
    }

    @Override
    public FeePoolQueryForAdjustRespVo queryForAdjustByPoolDetailCode(String poolDetailCode) {
        FeePoolDetailEntity poolDetail;
        FeePoolQueryForAdjustRespVo respVo = new FeePoolQueryForAdjustRespVo();
        if (StringUtils.isNotEmpty((String)poolDetailCode) && (poolDetail = (FeePoolDetailEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolDetailEntity::getPoolDetailCode, (Object)poolDetailCode)).one()) != null) {
            FeePoolEntity pool = (FeePoolEntity)((LambdaQueryChainWrapper)this.feePoolService.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolDetail.getPoolCode())).one();
            if (pool != null) {
                CrmBeanUtil.copyProperties((Object)pool, (Object)respVo);
            }
            CrmBeanUtil.copyExt10((Object)poolDetail, (Object)respVo);
            respVo.setTotalAmount(poolDetail.getTotalAmount());
            respVo.setFreezeAmount(poolDetail.getFreezeAmount());
            respVo.setHasUseAmount(poolDetail.getHasUseAmount());
            respVo.setUsableAmount(poolDetail.getUsableAmount());
        }
        return respVo;
    }
}

