/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.IsShelfEnum;
import com.biz.crm.eunm.fee.FeePoolGroupEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeGroupEnum;
import com.biz.crm.eunm.fee.FeePoolTypeEnum;
import com.biz.crm.mdm.pricesetting.MdmPriceSettingFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailLogReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolFileReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsProductGroupReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsUseByPoolProductItemReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsUseByProductLevelItemReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolOperationReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolGoodsProductGroupRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolGoodsProductRespVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSearchReqVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceResp;
import com.biz.crm.nebular.mdm.product.req.MdmProductQueryReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductMediaRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductQueryRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.pool.mapper.FeePoolMapper;
import com.biz.crm.pool.model.FeePoolDetailEntity;
import com.biz.crm.pool.model.FeePoolEntity;
import com.biz.crm.pool.service.FeePoolDetailLogService;
import com.biz.crm.pool.service.FeePoolDetailService;
import com.biz.crm.pool.service.FeePoolGoodsService;
import com.biz.crm.pool.service.FeePoolOperationService;
import com.biz.crm.pool.service.FeePoolService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ProductLevelUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"FeePoolGoodsServiceExpandImpl"})
public class FeePoolGoodsServiceImpl
implements FeePoolGoodsService {
    private static final Logger log = LoggerFactory.getLogger(FeePoolGoodsServiceImpl.class);
    @Resource
    private FeePoolMapper feePoolMapper;
    @Resource
    private FeePoolService feePoolService;
    @Resource
    private FeePoolOperationService feePoolOperationService;
    @Resource
    private FeePoolDetailService feePoolDetailService;
    @Resource
    private FeePoolDetailLogService feePoolDetailLogService;
    @Resource
    private MdmProductFeign mdmProductFeign;
    @Resource
    private MdmPriceSettingFeign mdmPriceSettingFeign;

    @Override
    public PageResult<FeePoolGoodsProductGroupRespVo> findFeePoolGoodsProductGroupList(FeePoolGoodsProductGroupReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getPoolGroup())) {
            reqVo.setPoolGroup(FeePoolGroupEnum.DEFAULT.getValue());
        }
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        Result productQueryResult = this.mdmProductFeign.queryProductList(new MdmProductQueryReqVo().setIsShelf(IsShelfEnum.UP.getCode()).setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()).setProductCode(reqVo.getGoodsProductCode()).setProductName(reqVo.getGoodsProductName()));
        Assert.isTrue((boolean)productQueryResult.isSuccess(), (String)("\u67e5\u8be2\u5546\u54c1\u5931\u8d25\uff1a" + productQueryResult.getMessage()));
        List productQueryList = (List)productQueryResult.getResult();
        if (CollectionUtil.listEmpty((List)productQueryList)) {
            return PageResult.builder().data(new ArrayList()).count(Long.valueOf(0L)).build();
        }
        List productCodeList = productQueryList.stream().filter(x -> StringUtils.isNotEmpty((String)x.getProductLevelCode())).map(MdmProductQueryRespVo::getProductCode).distinct().collect(Collectors.toList());
        List<Map<String, String>> productLikeMapList = productCodeList.stream().map(x -> {
            HashMap<String, String> map = new HashMap<String, String>(4);
            map.put("likeLeft", "%," + x);
            map.put("likeRight", x + ",%");
            map.put("like", "%," + x + ",%");
            map.put("equals", (String)x);
            return map;
        }).collect(Collectors.toList());
        List strings = productQueryList.stream().filter(x -> StringUtils.isNotEmpty((String)x.getProductLevelCode())).map(MdmProductQueryRespVo::getProductLevelCode).distinct().collect(Collectors.toList());
        List productLevelCodeList = ProductLevelUtil.getParentProductLevelCodeListIncludeSelfEnable(strings);
        List<FeePoolGoodsProductGroupRespVo> list = this.feePoolMapper.findFeePoolGoodsProductGroupList((Page<FeePoolGoodsProductGroupRespVo>)page, reqVo, FeePoolTypeEnum.GOODS.getValue(), productLevelCodeList, productLikeMapList);
        if (CollectionUtil.listEmpty(list)) {
            return PageResult.builder().data(new ArrayList()).count(Long.valueOf(0L)).build();
        }
        Set paramProductLevelCodeSet = list.stream().filter(item -> StringUtils.isNotEmpty((String)item.getGoodsProductLevelCode()) && StringUtils.isEmpty((String)item.getGoodsProductCode())).map(item -> Arrays.asList(item.getGoodsProductLevelCode().split(","))).flatMap(Collection::stream).collect(Collectors.toSet());
        Set paramProductCodeSet = list.stream().filter(item -> StringUtils.isNotEmpty((String)item.getGoodsProductCode())).map(item -> Arrays.asList(item.getGoodsProductCode().split(","))).flatMap(Collection::stream).collect(Collectors.toSet());
        HashSet goodsProductCodeSet = new HashSet(16);
        if (!paramProductCodeSet.isEmpty()) {
            goodsProductCodeSet.addAll(paramProductCodeSet);
        }
        if (!paramProductLevelCodeSet.isEmpty()) {
            Result productQueryByProductLevelResult = this.mdmProductFeign.queryProductList(new MdmProductQueryReqVo().setIsShelf(IsShelfEnum.UP.getCode()).setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()).setProductCode(reqVo.getGoodsProductCode()).setProductName(reqVo.getGoodsProductName()).setUnderProductLevelCodeList(new ArrayList(paramProductLevelCodeSet)));
            Assert.isTrue((boolean)productQueryByProductLevelResult.isSuccess(), (String)("\u67e5\u8be2\u5546\u54c1\u5931\u8d25\uff1a" + productQueryByProductLevelResult.getMessage()));
            if (CollectionUtil.listNotEmptyNotSizeZero((List)((List)productQueryByProductLevelResult.getResult()))) {
                goodsProductCodeSet.addAll(((List)productQueryByProductLevelResult.getResult()).stream().map(MdmProductQueryRespVo::getProductCode).collect(Collectors.toSet()));
            }
        }
        if (goodsProductCodeSet.isEmpty()) {
            return PageResult.builder().data(new ArrayList()).count(Long.valueOf(0L)).build();
        }
        Result productQueryByProductResult = this.mdmProductFeign.queryProductList(new MdmProductQueryReqVo().setIsShelf(IsShelfEnum.UP.getCode()).setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()).setProductCode(reqVo.getGoodsProductCode()).setProductName(reqVo.getGoodsProductName()).setProductCodeList(new ArrayList(goodsProductCodeSet)));
        Assert.isTrue((boolean)productQueryByProductResult.isSuccess(), (String)("\u67e5\u8be2\u5546\u54c1\u5931\u8d25\uff1a" + productQueryByProductResult.getMessage()));
        List usableProductList = (List)productQueryByProductResult.getResult();
        Set usableProductCodeSet = usableProductList.stream().map(MdmProductQueryRespVo::getProductCode).collect(Collectors.toSet());
        Map<Object, Object> productPictureMap = new HashMap(16);
        if (!usableProductCodeSet.isEmpty()) {
            Result pictureResult = this.mdmProductFeign.queryBatchProductPictureList(new ArrayList(usableProductCodeSet));
            Assert.isTrue((boolean)pictureResult.isSuccess(), (String)("\u67e5\u8be2\u5546\u54c1\u56fe\u7247\u5931\u8d25\uff1a" + pictureResult.getMessage()));
            productPictureMap = ((List)pictureResult.getResult()).stream().collect(Collectors.groupingBy(MdmProductMediaRespVo::getProductCode));
        }
        Map<String, String> productMainPictureMap = productPictureMap.entrySet().stream().collect(Collectors.toMap(k -> (String)k.getKey(), v -> {
            String mainPictureUrl = "";
            List value = (List)v.getValue();
            if (value != null && value.size() > 0) {
                for (MdmProductMediaRespVo item : value) {
                    if (!StringUtils.isNotEmpty((String)item.getUrlAddress())) continue;
                    mainPictureUrl = item.getUrlAddress();
                    break;
                }
            }
            return mainPictureUrl;
        }));
        Map productPriceSearchMap = new HashMap(16);
        String conditionType = reqVo.getConditionType();
        boolean priceSearch = StringUtils.isNotEmpty((String)conditionType);
        if (priceSearch) {
            MdmPriceSearchReqVo searchReqVo = new MdmPriceSearchReqVo();
            searchReqVo.setCustomerCode(reqVo.getCustomerCode());
            searchReqVo.setProductCodeList(new ArrayList(usableProductCodeSet));
            searchReqVo.setSearchTime(DateUtil.dateNow2Str());
            searchReqVo.setConditionTypeCodeList(Collections.singletonList(conditionType));
            Result search = this.mdmPriceSettingFeign.search(searchReqVo);
            Assert.isTrue((boolean)search.isSuccess(), (String)"\u67e5\u8be2\u4ef7\u683c\u5931\u8d25");
            productPriceSearchMap = (Map)search.getResult();
        }
        HashMap productPriceMap = priceSearch ? productPriceSearchMap.values().stream().filter(item -> item.containsKey(conditionType) && item.get(conditionType) != null).map(item -> (MdmPriceResp)item.get(conditionType)).collect(Collectors.toMap(MdmPriceResp::getProductCode, MdmPriceResp::getPrice)) : new HashMap(16);
        Map<String, MdmProductQueryRespVo> usableProductMap = usableProductList.stream().collect(Collectors.toMap(MdmProductQueryRespVo::getProductCode, v -> v));
        Map saleUnitMap = DictUtil.dictMap((String)"product_sale_unit");
        list.forEach(item -> {
            List goodsProductLevelChildrenCodeList;
            ArrayList productList = new ArrayList();
            ArrayList goodsProductCodeList = new ArrayList();
            if (StringUtils.isNotEmpty((String)item.getGoodsProductCode())) {
                goodsProductCodeList.addAll(Arrays.asList(item.getGoodsProductCode().split(",")).stream().filter(x -> usableProductCodeSet.contains(x)).collect(Collectors.toList()));
            } else if (StringUtils.isNotEmpty((String)item.getGoodsProductLevelCode()) && CollectionUtil.listNotEmptyNotSizeZero((List)(goodsProductLevelChildrenCodeList = ProductLevelUtil.getChildrenProductLevelCodeListIncludeSelfEnable(Arrays.asList(item.getGoodsProductLevelCode().split(",")))))) {
                HashSet set = new HashSet(goodsProductLevelChildrenCodeList);
                goodsProductCodeList.addAll(usableProductList.stream().filter(x -> set.contains(x.getProductLevelCode())).map(MdmProductQueryRespVo::getProductCode).collect(Collectors.toList()));
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(goodsProductCodeList)) {
                productList.addAll(goodsProductCodeList.stream().map(x -> {
                    MdmProductQueryRespVo product = (MdmProductQueryRespVo)usableProductMap.get(x);
                    FeePoolGoodsProductRespVo goodsProduct = new FeePoolGoodsProductRespVo();
                    goodsProduct.setProductCode(product.getProductCode());
                    goodsProduct.setProductName(product.getProductName());
                    goodsProduct.setSpec(product.getSpec());
                    goodsProduct.setSaleUnit(product.getSaleUnit());
                    goodsProduct.setSaleUnitName((String)saleUnitMap.get(product.getSaleUnit()));
                    if (priceSearch) {
                        goodsProduct.setPrice((BigDecimal)productPriceMap.get(product.getProductCode()));
                    }
                    if (productMainPictureMap.containsKey(product.getProductCode())) {
                        goodsProduct.setMainPictureUrl((String)productMainPictureMap.get(product.getProductCode()));
                    }
                    return goodsProduct;
                }).collect(Collectors.toList()));
            }
            item.setProductList(productList);
            item.setGoodsProductCode(productList.stream().map(FeePoolGoodsProductRespVo::getProductCode).collect(Collectors.joining(",")));
            item.setGoodsProductName(productList.stream().map(FeePoolGoodsProductRespVo::getProductName).collect(Collectors.joining(",")));
        });
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void useGoodsAmountByPoolProductList(String poolGroup, String useType, String operationType, String fromCode, String fromDesc, String remarks, List<FeePoolGoodsUseByPoolProductItemReqVo> poolProductItemList, List<FeePoolFileReqVo> fileList) {
        Assert.hasText((String)operationType, (String)"\u7f3a\u5931\u64cd\u4f5c\u7c7b\u578b");
        String operationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)operationType);
        Assert.hasText((String)operationTypeValue, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
        Assert.notEmpty(poolProductItemList, (String)"\u7f3a\u5931\u4f7f\u7528\u660e\u7ec6");
        Assert.isTrue((boolean)FeePoolConfigUtil.checkOperationTypeGroup((String)operationType, (FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.USE), (String)("\u8be5\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4f7f\u7528\u8d39\u7528\u6c60" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        if (FeePoolOperationTypeEnum.ORDER_USE.getValue().equals(operationType)) {
            Assert.hasText((String)fromCode, (String)(operationTypeValue + "\u5fc5\u987b\u6709\u6765\u6e90\u5355\u53f7"));
        }
        poolProductItemList.forEach(x -> {
            Assert.hasText((String)x.getPoolCode(), (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u7801");
            Assert.hasText((String)x.getProductCode(), (String)"\u7f3a\u5931\u5546\u54c1\u7f16\u7801");
            Assert.isTrue((x.getAmount() != null ? 1 : 0) != 0, (String)("\u7f3a\u5931\u4f7f\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
            Assert.isTrue((x.getAmount().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)("\u4f7f\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u5c0f\u4e8e0"));
        });
        Result result = this.mdmProductFeign.queryBatchByProductCodeList(poolProductItemList.stream().map(FeePoolGoodsUseByPoolProductItemReqVo::getProductCode).collect(Collectors.toList()));
        Assert.isTrue((boolean)result.isSuccess(), (String)"\u67e5\u8be2\u5546\u54c1\u5931\u8d25");
        Map<String, MdmProductRespVo> productMap = ((List)result.getResult()).stream().collect(Collectors.toMap(MdmProductRespVo::getProductCode, v -> v));
        poolProductItemList.forEach(x -> Assert.isTrue((boolean)productMap.containsKey(x.getProductCode()), (String)("\u5546\u54c1\u7f16\u7801\u3010" + x.getProductCode() + "\u3011\u4e0d\u5b58\u5728")));
        Map<String, List<FeePoolGoodsUseByPoolProductItemReqVo>> groupByPoolCodeMap = poolProductItemList.stream().collect(Collectors.groupingBy(FeePoolGoodsUseByPoolProductItemReqVo::getPoolCode));
        String operationDateTime = DateUtil.dateNowHms();
        FeePoolOperationTypeGroupEnum operationTypeGroupEnum = FeePoolConfigUtil.getOperationTypeGroup((String)operationType);
        for (Map.Entry<String, List<FeePoolGoodsUseByPoolProductItemReqVo>> entry : groupByPoolCodeMap.entrySet()) {
            String poolCode = entry.getKey();
            List<FeePoolGoodsUseByPoolProductItemReqVo> itemList = entry.getValue();
            FeePoolEntity pool = (FeePoolEntity)((LambdaQueryChainWrapper)this.feePoolService.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)entry.getKey())).one();
            BigDecimal amount = itemList.stream().map(FeePoolGoodsUseByPoolProductItemReqVo::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            Assert.notNull((Object)pool, (String)("\u672a\u627e\u5230\u8d39\u7528\u6c60[" + poolCode + "]"));
            Assert.isTrue((pool.getUsableAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60" + poolCode + "\u53ef\u4ee5\u4f59\u989d\u4e0d\u8db3"));
            pool.setHasUseAmount(pool.getHasUseAmount().add(amount));
            pool.setUsableAmount(pool.getUsableAmount().subtract(amount));
            this.feePoolService.updateById(pool);
            FeePoolOperationReqVo operationReqVo = new FeePoolOperationReqVo();
            operationReqVo.setPoolCode(pool.getPoolCode());
            operationReqVo.setOperationType(operationType);
            operationReqVo.setFromCode(fromCode);
            operationReqVo.setFromDesc(StringUtils.isNotEmpty((String)fromDesc) ? fromDesc : operationTypeValue);
            operationReqVo.setOperationDateTime(operationDateTime);
            operationReqVo.setOperationAmount(amount.multiply(operationTypeGroupEnum.getUsableAmountWeight()));
            operationReqVo.setFileList(fileList);
            operationReqVo.setRemarks(remarks);
            String operationCode = this.feePoolOperationService.savePoolOperation(operationReqVo);
            List poolDetailList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolDetailService.lambdaQuery().eq(FeePoolDetailEntity::getPoolCode, (Object)poolCode)).orderByAsc(FeePoolDetailEntity::getAccountDateTime)).list();
            ArrayList<FeePoolDetailLogReqVo> detailLogList = new ArrayList<FeePoolDetailLogReqVo>();
            for (FeePoolGoodsUseByPoolProductItemReqVo useItem : itemList) {
                BigDecimal restAmount = useItem.getAmount();
                for (FeePoolDetailEntity poolDetail : poolDetailList) {
                    if (restAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                    if (poolDetail.getUsableAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                    BigDecimal itemUse = BigDecimal.ZERO;
                    itemUse = poolDetail.getUsableAmount().compareTo(restAmount) >= 0 ? restAmount : poolDetail.getUsableAmount();
                    restAmount = restAmount.subtract(itemUse);
                    poolDetail.setHasUseAmount(poolDetail.getHasUseAmount().add(itemUse));
                    poolDetail.setUsableAmount(poolDetail.getUsableAmount().subtract(itemUse));
                    FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
                    detailLog.setPoolCode(poolCode);
                    detailLog.setPoolDetailCode(poolDetail.getPoolDetailCode());
                    detailLog.setOperationCode(operationCode);
                    detailLog.setOperationType(operationType);
                    detailLog.setFromCode(fromCode);
                    detailLog.setFromDesc(StringUtils.isNotEmpty((String)fromDesc) ? fromDesc : operationTypeValue);
                    detailLog.setRemarks(remarks);
                    detailLog.setOperationAmount(itemUse.multiply(operationTypeGroupEnum.getUsableAmountWeight()));
                    detailLog.setOperationDateTime(operationDateTime);
                    detailLog.setProductCode(useItem.getProductCode());
                    detailLog.setProductName(productMap.get(useItem.getProductCode()).getProductName());
                    detailLogList.add(detailLog);
                }
                Assert.isTrue((restAmount.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u5f02\u5e38"));
            }
            this.feePoolDetailService.updateBatchById(poolDetailList);
            this.feePoolDetailLogService.savePoolDetailLog(detailLogList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void useGoodsAmountByProductLevelList(String poolGroup, String useType, String operationType, String fromCode, String fromDesc, String remarks, List<FeePoolGoodsUseByProductLevelItemReqVo> productLevelItemList, List<FeePoolFileReqVo> fileList, String customerCode) {
        Assert.hasText((String)operationType, (String)"\u7f3a\u5931\u64cd\u4f5c\u7c7b\u578b");
        String operationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)operationType);
        Assert.hasText((String)operationTypeValue, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
        Assert.notEmpty(productLevelItemList, (String)"\u7f3a\u5931\u4f7f\u7528\u660e\u7ec6");
        Assert.isTrue((boolean)FeePoolConfigUtil.checkOperationTypeGroup((String)operationType, (FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.USE), (String)("\u8be5\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4f7f\u7528\u8d39\u7528\u6c60" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        if (FeePoolOperationTypeEnum.ORDER_USE.getValue().equals(operationType)) {
            Assert.hasText((String)fromCode, (String)(operationTypeValue + "\u5fc5\u987b\u6709\u6765\u6e90\u5355\u53f7"));
        }
        productLevelItemList.forEach(x -> {
            Assert.hasText((String)x.getProductLevelCode(), (String)"\u7f3a\u5931\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801");
            Assert.isTrue((x.getAmount() != null ? 1 : 0) != 0, (String)("\u7f3a\u5931\u4f7f\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
            Assert.isTrue((x.getAmount().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)("\u4f7f\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u5c0f\u4e8e0"));
        });
        List productLevelByCodeList = ProductLevelUtil.getProductLevelByCodeList(productLevelItemList.stream().map(FeePoolGoodsUseByProductLevelItemReqVo::getProductLevelCode).collect(Collectors.toList()));
        Map<String, MdmProductLevelRespVo> productLevelMap = productLevelByCodeList.stream().collect(Collectors.toMap(MdmProductLevelRespVo::getProductLevelCode, v -> v));
        productLevelItemList.forEach(x -> Assert.isTrue((boolean)productLevelMap.containsKey(x.getProductLevelCode()), (String)("\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u3010" + x.getProductLevelCode() + "\u3011\u4e0d\u5b58\u5728")));
        Map<String, BigDecimal> productLevelAmountMap = productLevelItemList.stream().collect(Collectors.groupingBy(FeePoolGoodsUseByProductLevelItemReqVo::getProductLevelCode, Collectors.mapping(FeePoolGoodsUseByProductLevelItemReqVo::getAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        String operationDateTime = DateUtil.dateNowHms();
        FeePoolOperationTypeGroupEnum operationTypeGroupEnum = FeePoolConfigUtil.getOperationTypeGroup((String)operationType);
        for (Map.Entry<String, BigDecimal> entry : productLevelAmountMap.entrySet()) {
            String productLevelCode = entry.getKey();
            String productLevelName = productLevelMap.get(productLevelCode).getProductLevelName();
            List collect = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolService.lambdaQuery().eq(FeePoolEntity::getPoolType, (Object)FeePoolTypeEnum.GOODS.getValue())).eq(FeePoolEntity::getCustomerCode, (Object)customerCode)).eq(FeePoolEntity::getGoodsProductLevelCode, (Object)productLevelCode)).list().stream().filter(x -> StringUtils.isEmpty((String)x.getGoodsProductCode())).collect(Collectors.toList());
            Assert.notEmpty(collect, (String)("\u672a\u627e\u5230\u4ea7\u54c1\u5c42\u7ea7\u3010" + productLevelName + "\u3011\u7684\u8d27\u8865\u8d39\u7528\u6c60"));
            FeePoolEntity pool = (FeePoolEntity)collect.get(0);
            BigDecimal amount = entry.getValue();
            Assert.isTrue((pool.getUsableAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)("\u4ea7\u54c1\u5c42\u7ea7\u3010" + productLevelName + "\u3011\u7684\u8d27\u8865\u53ef\u7528\u4f59\u989d\u4e0d\u8db3"));
            pool.setHasUseAmount(pool.getHasUseAmount().add(amount));
            pool.setUsableAmount(pool.getUsableAmount().subtract(amount));
            this.feePoolService.updateById(pool);
            FeePoolOperationReqVo operationReqVo = new FeePoolOperationReqVo();
            operationReqVo.setPoolCode(pool.getPoolCode());
            operationReqVo.setOperationType(operationType);
            operationReqVo.setFromCode(fromCode);
            operationReqVo.setFromDesc(StringUtils.isNotEmpty((String)fromDesc) ? fromDesc : operationTypeValue);
            operationReqVo.setOperationDateTime(operationDateTime);
            operationReqVo.setOperationAmount(amount.multiply(operationTypeGroupEnum.getUsableAmountWeight()));
            operationReqVo.setFileList(fileList);
            operationReqVo.setRemarks(remarks);
            String operationCode = this.feePoolOperationService.savePoolOperation(operationReqVo);
            List poolDetailList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolDetailService.lambdaQuery().eq(FeePoolDetailEntity::getPoolCode, (Object)pool.getPoolCode())).orderByAsc(FeePoolDetailEntity::getAccountDateTime)).list();
            ArrayList<FeePoolDetailLogReqVo> detailLogList = new ArrayList<FeePoolDetailLogReqVo>();
            BigDecimal restAmount = amount;
            for (FeePoolDetailEntity poolDetail : poolDetailList) {
                if (restAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                if (poolDetail.getUsableAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal itemUse = BigDecimal.ZERO;
                itemUse = poolDetail.getUsableAmount().compareTo(restAmount) >= 0 ? restAmount : poolDetail.getUsableAmount();
                restAmount = restAmount.subtract(itemUse);
                poolDetail.setHasUseAmount(poolDetail.getHasUseAmount().add(itemUse));
                poolDetail.setUsableAmount(poolDetail.getUsableAmount().subtract(itemUse));
                FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
                detailLog.setPoolCode(pool.getPoolCode());
                detailLog.setPoolDetailCode(poolDetail.getPoolDetailCode());
                detailLog.setOperationCode(operationCode);
                detailLog.setOperationType(operationType);
                detailLog.setFromCode(fromCode);
                detailLog.setFromDesc(StringUtils.isNotEmpty((String)fromDesc) ? fromDesc : operationTypeValue);
                detailLog.setRemarks(remarks);
                detailLog.setOperationAmount(itemUse.multiply(operationTypeGroupEnum.getUsableAmountWeight()));
                detailLog.setOperationDateTime(operationDateTime);
                detailLog.setProductCode(productLevelCode);
                detailLog.setProductName(productLevelName);
                detailLogList.add(detailLog);
            }
            Assert.isTrue((restAmount.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u5f02\u5e38"));
            this.feePoolDetailService.updateBatchById(poolDetailList);
            this.feePoolDetailLogService.savePoolDetailLog(detailLogList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void occupyGoodsAmountByPoolProductList(String poolGroup, String useType, String operationType, String fromCode, String fromDesc, String remarks, List<FeePoolGoodsUseByPoolProductItemReqVo> poolProductItemList, List<FeePoolFileReqVo> fileList) {
        Assert.hasText((String)operationType, (String)"\u7f3a\u5931\u64cd\u4f5c\u7c7b\u578b");
        String operationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)operationType);
        Assert.hasText((String)operationTypeValue, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
        Assert.notEmpty(poolProductItemList, (String)"\u7f3a\u5931\u4f7f\u7528\u660e\u7ec6");
        Assert.isTrue((boolean)FeePoolConfigUtil.checkOperationTypeGroup((String)operationType, (FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.OCCUPY), (String)("\u8be5\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u5360\u7528\u8d39\u7528\u6c60" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        Assert.hasText((String)fromCode, (String)"\u5360\u7528\u64cd\u4f5c\u5fc5\u987b\u6709\u6765\u6e90\u5355\u53f7");
        poolProductItemList.forEach(x -> {
            Assert.hasText((String)x.getPoolCode(), (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u7801");
            Assert.hasText((String)x.getProductCode(), (String)"\u7f3a\u5931\u5546\u54c1\u7f16\u7801");
            Assert.isTrue((x.getAmount() != null ? 1 : 0) != 0, (String)("\u7f3a\u5931\u4f7f\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
            Assert.isTrue((x.getAmount().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)("\u4f7f\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u5c0f\u4e8e0"));
        });
        Result result = this.mdmProductFeign.queryBatchByProductCodeList(poolProductItemList.stream().map(FeePoolGoodsUseByPoolProductItemReqVo::getProductCode).collect(Collectors.toList()));
        Assert.isTrue((boolean)result.isSuccess(), (String)"\u67e5\u8be2\u5546\u54c1\u5931\u8d25");
        Map<String, MdmProductRespVo> productMap = ((List)result.getResult()).stream().collect(Collectors.toMap(MdmProductRespVo::getProductCode, v -> v));
        poolProductItemList.forEach(x -> Assert.isTrue((boolean)productMap.containsKey(x.getProductCode()), (String)("\u5546\u54c1\u7f16\u7801\u3010" + x.getProductCode() + "\u3011\u4e0d\u5b58\u5728")));
        Map<String, List<FeePoolGoodsUseByPoolProductItemReqVo>> groupByPoolCodeMap = poolProductItemList.stream().collect(Collectors.groupingBy(FeePoolGoodsUseByPoolProductItemReqVo::getPoolCode));
        String operationDateTime = DateUtil.dateNowHms();
        FeePoolOperationTypeGroupEnum operationTypeGroupEnum = FeePoolConfigUtil.getOperationTypeGroup((String)operationType);
        for (Map.Entry<String, List<FeePoolGoodsUseByPoolProductItemReqVo>> entry : groupByPoolCodeMap.entrySet()) {
            String poolCode = entry.getKey();
            List<FeePoolGoodsUseByPoolProductItemReqVo> itemList = entry.getValue();
            FeePoolEntity pool = (FeePoolEntity)((LambdaQueryChainWrapper)this.feePoolService.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)entry.getKey())).one();
            BigDecimal amount = itemList.stream().map(FeePoolGoodsUseByPoolProductItemReqVo::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            Assert.notNull((Object)pool, (String)("\u672a\u627e\u5230\u8d39\u7528\u6c60[" + poolCode + "]"));
            Assert.isTrue((pool.getUsableAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60" + poolCode + "\u53ef\u7528\u4f59\u989d\u4e0d\u8db3"));
            this.feePoolService.addOccupyAmountByPoolCode(poolCode, amount);
            FeePoolOperationReqVo operationReqVo = new FeePoolOperationReqVo();
            operationReqVo.setPoolCode(poolCode);
            operationReqVo.setOperationType(operationType);
            operationReqVo.setFromCode(fromCode);
            operationReqVo.setFromDesc(StringUtils.isNotEmpty((String)fromDesc) ? fromDesc : operationTypeValue);
            operationReqVo.setOperationDateTime(operationDateTime);
            operationReqVo.setOperationAmount(amount.multiply(operationTypeGroupEnum.getUsableAmountWeight()));
            operationReqVo.setFileList(fileList);
            operationReqVo.setRemarks(remarks);
            String operationCode = this.feePoolOperationService.savePoolOperation(operationReqVo);
            List poolDetailList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolDetailService.lambdaQuery().eq(FeePoolDetailEntity::getPoolCode, (Object)poolCode)).orderByAsc(FeePoolDetailEntity::getAccountDateTime)).list();
            ArrayList<FeePoolDetailLogReqVo> detailLogList = new ArrayList<FeePoolDetailLogReqVo>();
            for (FeePoolGoodsUseByPoolProductItemReqVo useItem : itemList) {
                BigDecimal restAmount = useItem.getAmount();
                for (FeePoolDetailEntity poolDetail : poolDetailList) {
                    if (restAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                    if (poolDetail.getUsableAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                    BigDecimal itemUse = BigDecimal.ZERO;
                    itemUse = poolDetail.getUsableAmount().compareTo(restAmount) >= 0 ? restAmount : poolDetail.getUsableAmount();
                    restAmount = restAmount.subtract(itemUse);
                    poolDetail.setHasUseAmount(poolDetail.getHasUseAmount().add(itemUse));
                    poolDetail.setUsableAmount(poolDetail.getUsableAmount().subtract(itemUse));
                    FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
                    detailLog.setPoolCode(poolCode);
                    detailLog.setPoolDetailCode(poolDetail.getPoolDetailCode());
                    detailLog.setOperationCode(operationCode);
                    detailLog.setOperationType(operationType);
                    detailLog.setFromCode(fromCode);
                    detailLog.setFromDesc(StringUtils.isNotEmpty((String)fromDesc) ? fromDesc : operationTypeValue);
                    detailLog.setRemarks(remarks);
                    detailLog.setOperationAmount(itemUse.multiply(operationTypeGroupEnum.getUsableAmountWeight()));
                    detailLog.setOperationDateTime(operationDateTime);
                    detailLog.setProductCode(useItem.getProductCode());
                    detailLog.setProductName(productMap.get(useItem.getProductCode()).getProductName());
                    detailLogList.add(detailLog);
                }
                Assert.isTrue((restAmount.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u5f02\u5e38"));
            }
            this.feePoolDetailService.updateBatchById(poolDetailList);
            this.feePoolDetailLogService.savePoolDetailLog(detailLogList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void occupyGoodsAmountByProductLevelList(String poolGroup, String useType, String operationType, String fromCode, String fromDesc, String remarks, List<FeePoolGoodsUseByProductLevelItemReqVo> productLevelItemList, List<FeePoolFileReqVo> fileList, String customerCode) {
        Assert.hasText((String)operationType, (String)"\u7f3a\u5931\u64cd\u4f5c\u7c7b\u578b");
        String operationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)operationType);
        Assert.hasText((String)operationTypeValue, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
        Assert.notEmpty(productLevelItemList, (String)"\u7f3a\u5931\u4f7f\u7528\u660e\u7ec6");
        Assert.isTrue((boolean)FeePoolConfigUtil.checkOperationTypeGroup((String)operationType, (FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.OCCUPY), (String)("\u8be5\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u5360\u7528\u8d39\u7528\u6c60" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        Assert.hasText((String)fromCode, (String)(operationTypeValue + "\u5fc5\u987b\u6709\u6765\u6e90\u5355\u53f7"));
        productLevelItemList.forEach(x -> {
            Assert.hasText((String)x.getProductLevelCode(), (String)"\u7f3a\u5931\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801");
            Assert.isTrue((x.getAmount() != null ? 1 : 0) != 0, (String)("\u7f3a\u5931\u5360\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
            Assert.isTrue((x.getAmount().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)("\u5360\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u5c0f\u4e8e0"));
        });
        List productLevelByCodeList = ProductLevelUtil.getProductLevelByCodeList(productLevelItemList.stream().map(FeePoolGoodsUseByProductLevelItemReqVo::getProductLevelCode).collect(Collectors.toList()));
        Map<String, MdmProductLevelRespVo> productLevelMap = productLevelByCodeList.stream().collect(Collectors.toMap(MdmProductLevelRespVo::getProductLevelCode, v -> v));
        productLevelItemList.forEach(x -> Assert.isTrue((boolean)productLevelMap.containsKey(x.getProductLevelCode()), (String)("\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u3010" + x.getProductLevelCode() + "\u3011\u4e0d\u5b58\u5728")));
        Map<String, BigDecimal> productLevelAmountMap = productLevelItemList.stream().collect(Collectors.groupingBy(FeePoolGoodsUseByProductLevelItemReqVo::getProductLevelCode, Collectors.mapping(FeePoolGoodsUseByProductLevelItemReqVo::getAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        String operationDateTime = DateUtil.dateNowHms();
        FeePoolOperationTypeGroupEnum operationTypeGroupEnum = FeePoolConfigUtil.getOperationTypeGroup((String)operationType);
        for (Map.Entry<String, BigDecimal> entry : productLevelAmountMap.entrySet()) {
            String productLevelCode = entry.getKey();
            String productLevelName = productLevelMap.get(productLevelCode).getProductLevelName();
            List collect = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolService.lambdaQuery().eq(FeePoolEntity::getPoolType, (Object)FeePoolTypeEnum.GOODS.getValue())).eq(FeePoolEntity::getCustomerCode, (Object)customerCode)).eq(FeePoolEntity::getGoodsProductLevelCode, (Object)productLevelCode)).list().stream().filter(x -> StringUtils.isEmpty((String)x.getGoodsProductCode())).collect(Collectors.toList());
            Assert.notEmpty(collect, (String)("\u672a\u627e\u5230\u4ea7\u54c1\u5c42\u7ea7\u3010" + productLevelName + "\u3011\u7684\u8d27\u8865\u8d39\u7528\u6c60"));
            FeePoolEntity pool = (FeePoolEntity)collect.get(0);
            BigDecimal amount = entry.getValue();
            Assert.isTrue((pool.getUsableAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)("\u4ea7\u54c1\u5c42\u7ea7\u3010" + productLevelName + "\u3011\u7684\u8d27\u8865\u53ef\u7528\u4f59\u989d\u4e0d\u8db3"));
            pool.setOccupyAmount(Optional.ofNullable(pool.getOccupyAmount()).orElse(BigDecimal.ZERO).add(amount));
            pool.setUsableAmount(pool.getUsableAmount().subtract(amount));
            this.feePoolService.updateById(pool);
            FeePoolOperationReqVo operationReqVo = new FeePoolOperationReqVo();
            operationReqVo.setPoolCode(pool.getPoolCode());
            operationReqVo.setOperationType(operationType);
            operationReqVo.setFromCode(fromCode);
            operationReqVo.setFromDesc(StringUtils.isNotEmpty((String)fromDesc) ? fromDesc : operationTypeValue);
            operationReqVo.setOperationDateTime(operationDateTime);
            operationReqVo.setOperationAmount(amount.multiply(operationTypeGroupEnum.getUsableAmountWeight()));
            operationReqVo.setFileList(fileList);
            operationReqVo.setRemarks(remarks);
            String operationCode = this.feePoolOperationService.savePoolOperation(operationReqVo);
            List poolDetailList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolDetailService.lambdaQuery().eq(FeePoolDetailEntity::getPoolCode, (Object)pool.getPoolCode())).orderByAsc(FeePoolDetailEntity::getAccountDateTime)).list();
            ArrayList<FeePoolDetailLogReqVo> detailLogList = new ArrayList<FeePoolDetailLogReqVo>();
            BigDecimal restAmount = amount;
            for (FeePoolDetailEntity poolDetail : poolDetailList) {
                if (restAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                if (poolDetail.getUsableAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal itemUse = BigDecimal.ZERO;
                itemUse = poolDetail.getUsableAmount().compareTo(restAmount) >= 0 ? restAmount : poolDetail.getUsableAmount();
                restAmount = restAmount.subtract(itemUse);
                poolDetail.setOccupyAmount(poolDetail.getOccupyAmount().add(itemUse));
                poolDetail.setUsableAmount(poolDetail.getUsableAmount().subtract(itemUse));
                FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
                detailLog.setPoolCode(pool.getPoolCode());
                detailLog.setPoolDetailCode(poolDetail.getPoolDetailCode());
                detailLog.setOperationCode(operationCode);
                detailLog.setOperationType(operationType);
                detailLog.setFromCode(fromCode);
                detailLog.setFromDesc(StringUtils.isNotEmpty((String)fromDesc) ? fromDesc : operationTypeValue);
                detailLog.setRemarks(remarks);
                detailLog.setOperationAmount(itemUse.multiply(operationTypeGroupEnum.getUsableAmountWeight()));
                detailLog.setOperationDateTime(operationDateTime);
                detailLog.setProductCode(productLevelCode);
                detailLog.setProductName(productLevelName);
                detailLogList.add(detailLog);
            }
            Assert.isTrue((restAmount.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u5f02\u5e38"));
            this.feePoolDetailService.updateBatchById(poolDetailList);
            this.feePoolDetailLogService.savePoolDetailLog(detailLogList);
        }
    }
}

