/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.fee.FeePoolGroupEnum;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailLogPageReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailLogReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailLogPageRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolFileRespVo;
import com.biz.crm.pool.mapper.FeePoolDetailLogMapper;
import com.biz.crm.pool.model.FeePoolDetailLogEntity;
import com.biz.crm.pool.service.FeePoolDetailLogService;
import com.biz.crm.pool.service.FeePoolFileService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"FeePoolDetailLogServiceExpandImpl"})
public class FeePoolDetailLogServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<FeePoolDetailLogMapper, FeePoolDetailLogEntity>
implements FeePoolDetailLogService {
    private static final Logger log = LoggerFactory.getLogger(FeePoolDetailLogServiceImpl.class);
    @Resource
    private FeePoolDetailLogMapper feePoolDetailLogMapper;
    @Resource
    private FeePoolFileService feePoolFileService;

    @Override
    public PageResult<FeePoolDetailLogPageRespVo> findFeePoolDetailLogList(FeePoolDetailLogPageReqVo reqVo) {
        if (StringUtils.isNotEmpty((String)reqVo.getBeginDate())) {
            reqVo.setBeginDate(reqVo.getBeginDate() + " 00:00:00");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getEndDate())) {
            reqVo.setEndDate(reqVo.getEndDate() + " 23:59:59");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getPoolGroup())) {
            reqVo.setPoolGroup(FeePoolGroupEnum.DEFAULT.getValue());
        }
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<FeePoolDetailLogPageRespVo> list = this.feePoolDetailLogMapper.findFeePoolDetailLogList((Page<FeePoolDetailLogPageRespVo>)page, reqVo);
        this.queryAndSetFileList(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<FeePoolDetailLogPageRespVo> findFeePoolDetailLogListByConfigCode(FeePoolDetailLogPageReqVo reqVo) {
        String configCode = reqVo.getConfigCode();
        Assert.hasText((String)configCode, (String)"\u7f3a\u5931\u914d\u7f6e\u7f16\u7801");
        String poolGroup = FeePoolConfigUtil.getConfigQueryPoolGroup((String)configCode);
        Assert.hasText((String)poolGroup, (String)("\u914d\u7f6e\u3010" + configCode + "\u3011\u672a\u914d\u7f6e\u67e5\u8be2\u7684\u8d39\u7528\u6c60\u5206\u7ec4"));
        reqVo.setPoolGroup(poolGroup);
        List poolTypeList = FeePoolConfigUtil.getConfigQueryPoolTypeList((String)configCode);
        Assert.notEmpty((Collection)poolTypeList, (String)("\u914d\u7f6e\u3010" + configCode + "\u3011\u672a\u914d\u7f6e\u67e5\u8be2\u7684\u8d39\u7528\u6c60\u7c7b\u578b"));
        reqVo.setPoolTypeList(poolTypeList);
        List operationTypeList = FeePoolConfigUtil.getConfigQueryOperationTypeList((String)configCode);
        Assert.notEmpty((Collection)operationTypeList, (String)("\u914d\u7f6e\u3010" + configCode + "\u3011\u672a\u914d\u7f6e\u67e5\u8be2\u7684\u8d39\u7528\u6c60\u64cd\u4f5c\u65b9\u5f0f"));
        reqVo.setOperationTypeList(operationTypeList);
        return this.findFeePoolDetailLogList(reqVo);
    }

    @Override
    public PageResult<FeePoolDetailLogPageRespVo> findFeePoolDetailLogListByPoolCode(FeePoolDetailLogPageReqVo reqVo) {
        Assert.hasText((String)reqVo.getPoolCode(), (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
        return this.findFeePoolDetailLogList(reqVo);
    }

    @Override
    public PageResult<FeePoolDetailLogPageRespVo> findFeePoolDetailLogListByPoolDetailCode(FeePoolDetailLogPageReqVo reqVo) {
        Assert.hasText((String)reqVo.getPoolDetailCode(), (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        return this.findFeePoolDetailLogList(reqVo);
    }

    @Override
    public PageResult<FeePoolDetailLogPageRespVo> findFeePoolDetailLogListByOperationCode(FeePoolDetailLogPageReqVo reqVo) {
        Assert.hasText((String)reqVo.getOperationCode(), (String)"\u7f3a\u5931\u64cd\u4f5c\u8bb0\u5f55\u7f16\u53f7");
        return this.findFeePoolDetailLogList(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void savePoolDetailLog(FeePoolDetailLogReqVo reqVo) {
        this.savePoolDetailLog(Collections.singletonList(reqVo));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void savePoolDetailLog(List<FeePoolDetailLogReqVo> list) {
        this.saveBatch(CrmBeanUtil.copyList(list, FeePoolDetailLogEntity.class));
    }

    protected void queryAndSetFileList(List<FeePoolDetailLogPageRespVo> list) {
        Set collect;
        Map<String, List<FeePoolFileRespVo>> fileGroupMap;
        if (CollectionUtil.listNotEmptyNotSizeZero(list) && !(fileGroupMap = this.feePoolFileService.getFeePoolFileListGroupByOperationCodeList(new ArrayList<String>(collect = list.stream().map(FeePoolDetailLogPageRespVo::getOperationCode).collect(Collectors.toSet())))).isEmpty()) {
            list.forEach(item -> {
                if (fileGroupMap.containsKey(item.getOperationCode())) {
                    item.setFileList((List)fileGroupMap.get(item.getOperationCode()));
                }
            });
        }
    }
}

