/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.fee.FeePoolGroupEnum;
import com.biz.crm.nebular.fee.pool.req.FeePoolOperationPageReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolOperationReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolFileRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolOperationPageRespVo;
import com.biz.crm.pool.mapper.FeePoolOperationMapper;
import com.biz.crm.pool.model.FeePoolOperationEntity;
import com.biz.crm.pool.service.FeePoolFileService;
import com.biz.crm.pool.service.FeePoolOperationService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"FeePoolOperationServiceExpandImpl"})
public class FeePoolOperationServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<FeePoolOperationMapper, FeePoolOperationEntity>
implements FeePoolOperationService {
    private static final Logger log = LoggerFactory.getLogger(FeePoolOperationServiceImpl.class);
    @Resource
    private FeePoolOperationMapper feePoolOperationMapper;
    @Resource
    private FeePoolFileService feePoolFileService;

    @Override
    public PageResult<FeePoolOperationPageRespVo> findFeePoolOperationPageList(FeePoolOperationPageReqVo reqVo) {
        if (StringUtils.isNotEmpty((String)reqVo.getBeginDate())) {
            reqVo.setBeginDate(reqVo.getBeginDate() + " 00:00:00");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getEndDate())) {
            reqVo.setEndDate(reqVo.getEndDate() + " 23:59:59");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getPoolGroup())) {
            reqVo.setPoolGroup(FeePoolGroupEnum.DEFAULT.getValue());
        }
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<FeePoolOperationPageRespVo> list = this.feePoolOperationMapper.findFeePoolOperationPageList((Page<FeePoolOperationPageRespVo>)page, reqVo);
        this.queryAndSetFileList(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<FeePoolOperationPageRespVo> findFeePoolOperationPageListByConfigCode(FeePoolOperationPageReqVo reqVo) {
        String configCode = reqVo.getConfigCode();
        Assert.hasText((String)configCode, (String)"\u7f3a\u5931\u914d\u7f6e\u7f16\u7801");
        String poolGroup = FeePoolConfigUtil.getConfigQueryPoolGroup((String)configCode);
        Assert.hasText((String)poolGroup, (String)("\u914d\u7f6e\u3010" + configCode + "\u3011\u672a\u914d\u7f6e\u67e5\u8be2\u7684\u8d39\u7528\u6c60\u5206\u7ec4"));
        reqVo.setPoolGroup(poolGroup);
        List poolTypeList = FeePoolConfigUtil.getConfigQueryPoolTypeList((String)configCode);
        Assert.notEmpty((Collection)poolTypeList, (String)("\u914d\u7f6e\u3010" + configCode + "\u3011\u672a\u914d\u7f6e\u67e5\u8be2\u7684\u8d39\u7528\u6c60\u7c7b\u578b"));
        reqVo.setPoolTypeList(poolTypeList);
        List operationTypeList = FeePoolConfigUtil.getConfigQueryOperationTypeList((String)configCode);
        Assert.notEmpty((Collection)operationTypeList, (String)("\u914d\u7f6e\u3010" + configCode + "\u3011\u672a\u914d\u7f6e\u67e5\u8be2\u7684\u8d39\u7528\u6c60\u64cd\u4f5c\u65b9\u5f0f"));
        reqVo.setOperationTypeList(operationTypeList);
        return this.findFeePoolOperationPageList(reqVo);
    }

    @Override
    public PageResult<FeePoolOperationPageRespVo> findFeePoolOperationPageListByPoolCode(FeePoolOperationPageReqVo reqVo) {
        Assert.hasText((String)reqVo.getPoolCode(), (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
        return this.findFeePoolOperationPageList(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String savePoolOperation(FeePoolOperationReqVo reqVo) {
        Assert.hasText((String)reqVo.getPoolCode(), (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.hasText((String)reqVo.getOperationType(), (String)"\u7f3a\u5931\u64cd\u4f5c\u7c7b\u578b");
        Assert.isTrue((reqVo.getOperationAmount() != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u64cd\u4f5c\u91d1\u989d");
        FeePoolOperationEntity entity = (FeePoolOperationEntity)CrmBeanUtil.copy((Object)reqVo, FeePoolOperationEntity.class);
        entity.setOperationCode(CodeUtil.getCodeDefault());
        this.save(entity);
        this.feePoolFileService.savePoolFileList(reqVo.getPoolCode(), entity.getOperationCode(), reqVo.getFileList());
        return entity.getOperationCode();
    }

    protected void queryAndSetFileList(List<FeePoolOperationPageRespVo> list) {
        Set collect;
        Map<String, List<FeePoolFileRespVo>> fileGroupMap;
        if (CollectionUtil.listNotEmptyNotSizeZero(list) && !(fileGroupMap = this.feePoolFileService.getFeePoolFileListGroupByOperationCodeList(new ArrayList<String>(collect = list.stream().map(FeePoolOperationPageRespVo::getOperationCode).collect(Collectors.toSet())))).isEmpty()) {
            list.forEach(item -> {
                if (fileGroupMap.containsKey(item.getOperationCode())) {
                    item.setFileList((List)fileGroupMap.get(item.getOperationCode()));
                }
            });
        }
    }
}

