/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.fee.FeePoolOperationTypeGroupEnum;
import com.biz.crm.eunm.fee.FeePoolTypeEnum;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailPageReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsProductGroupReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolOperationPageReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolAmountRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailPageRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolGoodsProductGroupRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolMonthAmountRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolOperationPageRespVo;
import com.biz.crm.pool.service.FeePoolDetailService;
import com.biz.crm.pool.service.FeePoolGoodsService;
import com.biz.crm.pool.service.FeePoolOperationService;
import com.biz.crm.pool.service.FeePoolService;
import com.biz.crm.util.Result;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/feePoolGoodsController"})
@Api(tags={"FEE-\u4ea7\u54c1\u7ec4-\u8d27\u8865\u76f8\u5173\u63a5\u53e3\uff08\u76ee\u524d\u7531DMS\u3001\u5c0f\u7a0b\u5e8f\u8c03\u7528\uff09"})
@CrmGlobalLog
public class FeePoolGoodsController {
    private static final Logger log = LoggerFactory.getLogger(FeePoolGoodsController.class);
    @Resource
    private FeePoolGoodsService feePoolGoodsService;
    @Resource
    private FeePoolService feePoolService;
    @Resource
    private FeePoolDetailService feePoolDetailService;
    @Resource
    private FeePoolOperationService feePoolOperationService;

    @ApiOperation(value="\uff08DMS\u3001\u5c0f\u7a0b\u5e8f\uff09\u67e5\u8be2\u5ba2\u6237\u8d27\u8865\u8d39\u7528\u6c60\u4e0a\u8d26\u660e\u7ec6\u5206\u9875")
    @PostMapping(value={"/findFeePoolDetailAccountList"})
    @CrmDictMethod
    public Result<PageResult<FeePoolDetailPageRespVo>> findFeePoolDetailAccountList(@RequestBody FeePoolDetailPageReqVo reqVo) {
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        reqVo.setPoolType(FeePoolTypeEnum.GOODS.getValue());
        return Result.ok(this.feePoolDetailService.findFeePoolDetailPageList(reqVo));
    }

    @ApiOperation(value="\uff08DMS\u3001\u5c0f\u7a0b\u5e8f\uff09\u67e5\u8be2\u5ba2\u6237\u8d27\u8865\u8d39\u7528\u6c60\u4f7f\u7528\u660e\u7ec6\u5206\u9875")
    @PostMapping(value={"/findFeePoolUseList"})
    @CrmDictMethod
    public Result<PageResult<FeePoolOperationPageRespVo>> findFeePoolUseList(@RequestBody FeePoolOperationPageReqVo reqVo) {
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        reqVo.setPoolType(FeePoolTypeEnum.GOODS.getValue());
        ArrayList operationTypeList = new ArrayList();
        operationTypeList.addAll(FeePoolConfigUtil.getOperationTypeList((FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.BACK));
        operationTypeList.addAll(FeePoolConfigUtil.getOperationTypeList((FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.USE));
        operationTypeList.addAll(FeePoolConfigUtil.getOperationTypeList((FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.FREEZE));
        operationTypeList.addAll(FeePoolConfigUtil.getOperationTypeList((FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.UNFREEZE));
        reqVo.setOperationTypeList(operationTypeList);
        return Result.ok(this.feePoolOperationService.findFeePoolOperationPageList(reqVo));
    }

    @ApiOperation(value="\uff08DMS\u3001\u5c0f\u7a0b\u5e8f\uff09\u67e5\u8be2\u8d27\u8865\u5546\u54c1\u7ec4\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/findFeePoolGoodsProductGroupList"})
    public Result<PageResult<FeePoolGoodsProductGroupRespVo>> findFeePoolGoodsProductGroupList(@RequestBody FeePoolGoodsProductGroupReqVo reqVo) {
        PageResult<FeePoolGoodsProductGroupRespVo> result = this.feePoolGoodsService.findFeePoolGoodsProductGroupList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u901a\u8fc7\u5ba2\u6237\u7f16\u7801\u83b7\u53d6\u5ba2\u6237\u4e0b\u7684\u8d27\u8865\u91d1\u989d\u6c47\u603b", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="poolGroup", value="\u8d39\u7528\u6c60\u5206\u7ec4", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="customerCode", value="\u5ba2\u6237\u7f16\u7801", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/queryGoodsAmountByCustomerCode"})
    public Result<FeePoolAmountRespVo> queryGoodsAmountByCustomerCode(@RequestParam(value="poolGroup", required=false) String poolGroup, @RequestParam(value="customerCode", required=true) String customerCode) {
        return Result.ok((Object)this.feePoolService.queryAmountByCustomerCode(poolGroup, customerCode, FeePoolTypeEnum.GOODS.getValue()));
    }

    @ApiOperation(value="\u901a\u8fc7\u5ba2\u6237\u7f16\u7801\u548c\u5e74\u6708\u83b7\u53d6\u5ba2\u6237\u4e0b\u7684\u6708\u5ea6\u8d27\u8865\u91d1\u989d\u6c47\u603b", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="poolGroup", value="\u8d39\u7528\u6c60\u5206\u7ec4", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="customerCode", value="\u5ba2\u6237\u7f16\u7801", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="yearMonth", value="\u5e74\u6708 yyyy-MM", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/queryGoodsMonthAmountByCustomerCode"})
    public Result<FeePoolMonthAmountRespVo> queryGoodsMonthAmountByCustomerCode(@RequestParam(value="poolGroup", required=false) String poolGroup, @RequestParam(value="customerCode", required=true) String customerCode, @RequestParam(value="yearMonth", required=true) String yearMonth) {
        return Result.ok((Object)this.feePoolService.queryMonthAmountByCustomerCode(poolGroup, customerCode, FeePoolTypeEnum.GOODS.getValue(), yearMonth));
    }
}

