/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.fee.FeePoolGroupEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeGroupEnum;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailAdjustReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailLogReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailPageReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolOperationReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailPageRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolFileRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolRespVo;
import com.biz.crm.pool.mapper.FeePoolDetailMapper;
import com.biz.crm.pool.model.FeePoolDetailEntity;
import com.biz.crm.pool.service.FeePoolDetailLogService;
import com.biz.crm.pool.service.FeePoolDetailService;
import com.biz.crm.pool.service.FeePoolFileService;
import com.biz.crm.pool.service.FeePoolOperationService;
import com.biz.crm.pool.service.FeePoolService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"FeePoolDetailServiceExpandImpl"})
public class FeePoolDetailServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<FeePoolDetailMapper, FeePoolDetailEntity>
implements FeePoolDetailService {
    private static final Logger log = LoggerFactory.getLogger(FeePoolDetailServiceImpl.class);
    @Resource
    private FeePoolDetailMapper feePoolDetailMapper;
    @Resource
    private FeePoolDetailLogService feePoolDetailLogService;
    @Resource
    private FeePoolService feePoolService;
    @Resource
    private FeePoolFileService feePoolFileService;
    @Resource
    private FeePoolOperationService feePoolOperationService;

    @Override
    public PageResult<FeePoolDetailPageRespVo> findFeePoolDetailPageList(FeePoolDetailPageReqVo reqVo) {
        if (StringUtils.isNotEmpty((String)reqVo.getBeginDate())) {
            reqVo.setBeginDate(reqVo.getBeginDate() + " 00:00:00");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getEndDate())) {
            reqVo.setEndDate(reqVo.getEndDate() + " 23:59:59");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getPoolGroup())) {
            reqVo.setPoolGroup(FeePoolGroupEnum.DEFAULT.getValue());
        }
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<FeePoolDetailPageRespVo> list = this.feePoolDetailMapper.findFeePoolDetailPageList((Page<FeePoolDetailPageRespVo>)page, reqVo);
        this.queryAndSetFileList(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<FeePoolDetailPageRespVo> findFeePoolDetailPageListByConfigCode(FeePoolDetailPageReqVo reqVo) {
        String configCode = reqVo.getConfigCode();
        Assert.hasText((String)configCode, (String)"\u7f3a\u5931\u914d\u7f6e\u7f16\u7801");
        String poolGroup = FeePoolConfigUtil.getConfigQueryPoolGroup((String)configCode);
        Assert.hasText((String)poolGroup, (String)("\u914d\u7f6e\u3010" + configCode + "\u3011\u672a\u914d\u7f6e\u67e5\u8be2\u7684\u8d39\u7528\u6c60\u5206\u7ec4"));
        reqVo.setPoolGroup(poolGroup);
        List poolTypeList = FeePoolConfigUtil.getConfigQueryPoolTypeList((String)configCode);
        Assert.notEmpty((Collection)poolTypeList, (String)("\u914d\u7f6e\u3010" + configCode + "\u3011\u672a\u914d\u7f6e\u67e5\u8be2\u7684\u8d39\u7528\u6c60\u7c7b\u578b"));
        reqVo.setPoolTypeList(poolTypeList);
        List operationTypeList = FeePoolConfigUtil.getConfigQueryOperationTypeList((String)configCode);
        Assert.notEmpty((Collection)operationTypeList, (String)("\u914d\u7f6e\u3010" + configCode + "\u3011\u672a\u914d\u7f6e\u67e5\u8be2\u7684\u8d39\u7528\u6c60\u64cd\u4f5c\u65b9\u5f0f"));
        reqVo.setOperationTypeList(operationTypeList);
        List useTypeList = FeePoolConfigUtil.getConfigUseTypeList((String)configCode);
        Assert.notEmpty((Collection)useTypeList, (String)("\u914d\u7f6e\u3010" + configCode + "\u3011\u672a\u914d\u7f6e\u4f7f\u7528\u8d39\u7528\u7c7b\u578b"));
        reqVo.setUseTypeList(useTypeList);
        return this.findFeePoolDetailPageList(reqVo);
    }

    @Override
    public PageResult<FeePoolDetailPageRespVo> findFeePoolDetailPageListByPoolCode(FeePoolDetailPageReqVo reqVo) {
        Assert.hasText((String)reqVo.getPoolCode(), (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
        return this.findFeePoolDetailPageList(reqVo);
    }

    @Override
    public FeePoolDetailRespVo queryByPoolDetailCode(String poolDetailCode) {
        FeePoolDetailEntity one;
        if (StringUtils.isNotEmpty((String)poolDetailCode) && (one = (FeePoolDetailEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolDetailEntity::getPoolDetailCode, (Object)poolDetailCode)).one()) != null) {
            FeePoolDetailRespVo poolDetail = new FeePoolDetailRespVo();
            FeePoolRespVo pool = this.feePoolService.queryByPoolCode(one.getPoolCode());
            if (pool != null) {
                CrmBeanUtil.copyProperties((Object)pool, (Object)poolDetail);
            }
            CrmBeanUtil.copyProperties((Object)one, (Object)poolDetail);
            poolDetail.setFileList(this.feePoolFileService.getFeePoolFileListByOperationCode(poolDetail.getOperationCode()));
            return poolDetail;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addTotalAmountByPoolDetailCode(String poolDetailCode, BigDecimal amount) {
        Assert.hasText((String)poolDetailCode, (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        Assert.isTrue((amount != null ? 1 : 0) != 0, (String)(FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((amount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)(FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u5c0f\u4e8e0"));
        FeePoolDetailEntity poolDetail = (FeePoolDetailEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolDetailEntity::getPoolDetailCode, (Object)poolDetailCode)).one();
        Assert.notNull((Object)poolDetail, (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        poolDetail.setTotalAmount(poolDetail.getTotalAmount().add(amount));
        poolDetail.setUsableAmount(poolDetail.getUsableAmount().add(amount));
        this.updateById(poolDetail);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addHasUseAmountByPoolDetailCode(String poolDetailCode, BigDecimal amount) {
        Assert.hasText((String)poolDetailCode, (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        Assert.isTrue((amount != null ? 1 : 0) != 0, (String)(FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((amount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)(FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u5c0f\u4e8e0"));
        FeePoolDetailEntity poolDetail = (FeePoolDetailEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolDetailEntity::getPoolDetailCode, (Object)poolDetailCode)).one();
        Assert.isTrue((poolDetail.getUsableAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)("\u4f7f\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u8d85\u8fc7\u53ef\u4f7f\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        poolDetail.setHasUseAmount(poolDetail.getHasUseAmount().add(amount));
        poolDetail.setUsableAmount(poolDetail.getUsableAmount().subtract(amount));
        this.updateById(poolDetail);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void subtractHasUseAmountByPoolDetailCode(String poolDetailCode, BigDecimal amount) {
        Assert.hasText((String)poolDetailCode, (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        Assert.isTrue((amount != null ? 1 : 0) != 0, (String)(FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((amount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)(FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u5c0f\u4e8e0"));
        FeePoolDetailEntity poolDetail = (FeePoolDetailEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolDetailEntity::getPoolDetailCode, (Object)poolDetailCode)).one();
        Assert.isTrue((poolDetail.getHasUseAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)("\u56de\u9000\u4f7f\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u8d85\u8fc7\u53ef\u4f7f\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        poolDetail.setHasUseAmount(poolDetail.getHasUseAmount().subtract(amount));
        poolDetail.setUsableAmount(poolDetail.getUsableAmount().add(amount));
        this.updateById(poolDetail);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addFreezeAmountByPoolDetailCode(String poolDetailCode, BigDecimal amount) {
        Assert.hasText((String)poolDetailCode, (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        Assert.isTrue((amount != null ? 1 : 0) != 0, (String)(FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((amount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)(FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u5c0f\u4e8e0"));
        FeePoolDetailEntity poolDetail = (FeePoolDetailEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolDetailEntity::getPoolDetailCode, (Object)poolDetailCode)).one();
        Assert.notNull((Object)poolDetail, (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        Assert.isTrue((poolDetail.getUsableAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)("\u51bb\u7ed3" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u8d85\u8fc7\u53ef\u4f7f\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        poolDetail.setFreezeAmount(poolDetail.getFreezeAmount().add(amount));
        poolDetail.setUsableAmount(poolDetail.getUsableAmount().subtract(amount));
        this.updateById(poolDetail);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void subtractFreezeAmountByPoolDetailCode(String poolDetailCode, BigDecimal amount) {
        Assert.hasText((String)poolDetailCode, (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        Assert.isTrue((amount != null ? 1 : 0) != 0, (String)(FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((amount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)(FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u5c0f\u4e8e0"));
        FeePoolDetailEntity poolDetail = (FeePoolDetailEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolDetailEntity::getPoolDetailCode, (Object)poolDetailCode)).one();
        Assert.notNull((Object)poolDetail, (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        Assert.isTrue((poolDetail.getFreezeAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)("\u89e3\u51bb" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u8d85\u8fc7\u51bb\u7ed3" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        poolDetail.setFreezeAmount(poolDetail.getFreezeAmount().subtract(amount));
        poolDetail.setUsableAmount(poolDetail.getUsableAmount().add(amount));
        this.updateById(poolDetail);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void useByPoolDetailCode(FeePoolDetailAdjustReqVo reqVo) {
        String operationDateTime = DateUtil.dateNowHms();
        FeePoolDetailRespVo poolDetail = this.queryByPoolDetailCode(reqVo.getPoolDetailCode());
        Assert.notNull((Object)poolDetail, (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        Assert.isTrue((poolDetail.getUsableAmount().compareTo(reqVo.getAmount()) >= 0 ? 1 : 0) != 0, (String)("\u4f7f\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u8d85\u8fc7\u53ef\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        this.addHasUseAmountByPoolDetailCode(reqVo.getPoolDetailCode(), reqVo.getAmount());
        FeePoolOperationReqVo operationReqVo = new FeePoolOperationReqVo();
        operationReqVo.setPoolCode(poolDetail.getPoolCode());
        operationReqVo.setOperationType(reqVo.getOperationType());
        operationReqVo.setFromCode(reqVo.getFromCode());
        operationReqVo.setFromDesc(DictUtil.dictValue((String)"fee_pool_operation_type", (String)reqVo.getOperationType()));
        operationReqVo.setOperationDateTime(operationDateTime);
        operationReqVo.setOperationAmount(reqVo.getAmount().multiply(FeePoolOperationTypeGroupEnum.USE.getUsableAmountWeight()));
        operationReqVo.setFileList(reqVo.getFileList());
        operationReqVo.setRemarks(reqVo.getRemarks());
        String operationCode = this.feePoolOperationService.savePoolOperation(operationReqVo);
        this.feePoolService.addHasUseAmountByPoolCode(poolDetail.getPoolCode(), reqVo.getAmount());
        FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
        detailLog.setPoolCode(poolDetail.getPoolCode());
        detailLog.setPoolDetailCode(poolDetail.getPoolDetailCode());
        detailLog.setOperationCode(operationCode);
        detailLog.setOperationType(reqVo.getOperationType());
        detailLog.setFromCode(reqVo.getFromCode());
        detailLog.setFromDesc(DictUtil.dictValue((String)"fee_pool_operation_type", (String)reqVo.getOperationType()));
        detailLog.setRemarks(reqVo.getRemarks());
        detailLog.setOperationAmount(reqVo.getAmount().multiply(FeePoolOperationTypeGroupEnum.USE.getUsableAmountWeight()));
        detailLog.setOperationDateTime(operationDateTime);
        this.feePoolDetailLogService.savePoolDetailLog(detailLog);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void freezeByPoolDetailCode(FeePoolDetailAdjustReqVo reqVo) {
        Assert.hasText((String)reqVo.getPoolDetailCode(), (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        BigDecimal freezeAmount = reqVo.getAmount();
        Assert.isTrue((freezeAmount != null ? 1 : 0) != 0, (String)("\u7f3a\u5931\u51bb\u7ed3" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        Assert.isTrue((freezeAmount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)("\u51bb\u7ed3" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u5fc5\u987b\u5927\u4e8e0"));
        FeePoolDetailRespVo poolDetail = this.queryByPoolDetailCode(reqVo.getPoolDetailCode());
        Assert.notNull((Object)poolDetail, (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        Assert.isTrue((poolDetail.getUsableAmount().compareTo(freezeAmount) >= 0 ? 1 : 0) != 0, (String)("\u51bb\u7ed3" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u5927\u4e8e\u53ef\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        String operationDateTime = DateUtil.dateNowHms();
        FeePoolOperationReqVo operationReqVo = new FeePoolOperationReqVo();
        operationReqVo.setPoolCode(poolDetail.getPoolCode());
        operationReqVo.setOperationType(reqVo.getOperationType());
        operationReqVo.setFromCode(reqVo.getFromCode());
        operationReqVo.setFromDesc(DictUtil.dictValue((String)"fee_pool_operation_type", (String)reqVo.getOperationType()));
        operationReqVo.setOperationDateTime(operationDateTime);
        operationReqVo.setOperationAmount(freezeAmount.multiply(FeePoolOperationTypeGroupEnum.FREEZE.getUsableAmountWeight()));
        operationReqVo.setFileList(reqVo.getFileList());
        operationReqVo.setRemarks(reqVo.getRemarks());
        String operationCode = this.feePoolOperationService.savePoolOperation(operationReqVo);
        this.addFreezeAmountByPoolDetailCode(poolDetail.getPoolDetailCode(), freezeAmount);
        this.feePoolService.addFreezeAmountByPoolCode(poolDetail.getPoolCode(), freezeAmount);
        FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
        detailLog.setPoolCode(poolDetail.getPoolCode());
        detailLog.setPoolDetailCode(poolDetail.getPoolDetailCode());
        detailLog.setOperationCode(operationCode);
        detailLog.setOperationType(reqVo.getOperationType());
        detailLog.setFromCode(reqVo.getFromCode());
        detailLog.setFromDesc(DictUtil.dictValue((String)"fee_pool_operation_type", (String)reqVo.getOperationType()));
        detailLog.setRemarks(reqVo.getRemarks());
        detailLog.setOperationAmount(freezeAmount.multiply(FeePoolOperationTypeGroupEnum.FREEZE.getUsableAmountWeight()));
        detailLog.setOperationDateTime(operationDateTime);
        this.feePoolDetailLogService.savePoolDetailLog(detailLog);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unfreezeByPoolDetailCode(FeePoolDetailAdjustReqVo reqVo) {
        Assert.hasText((String)reqVo.getPoolDetailCode(), (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        BigDecimal unfreezeAmount = reqVo.getAmount();
        Assert.isTrue((unfreezeAmount != null ? 1 : 0) != 0, (String)("\u7f3a\u5931\u89e3\u51bb" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        Assert.isTrue((unfreezeAmount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)("\u51bb\u7ed3" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u5fc5\u987b\u5927\u4e8e0"));
        FeePoolDetailRespVo poolDetail = this.queryByPoolDetailCode(reqVo.getPoolDetailCode());
        Assert.notNull((Object)poolDetail, (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        Assert.isTrue((poolDetail.getFreezeAmount().compareTo(unfreezeAmount) >= 0 ? 1 : 0) != 0, (String)("\u89e3\u51bb" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u5927\u4e8e\u5df2\u51bb\u7ed3" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        String operationDateTime = DateUtil.dateNowHms();
        FeePoolOperationReqVo operationReqVo = new FeePoolOperationReqVo();
        operationReqVo.setPoolCode(poolDetail.getPoolCode());
        operationReqVo.setOperationType(reqVo.getOperationType());
        operationReqVo.setFromCode(reqVo.getFromCode());
        operationReqVo.setFromDesc(DictUtil.dictValue((String)"fee_pool_operation_type", (String)reqVo.getOperationType()));
        operationReqVo.setOperationDateTime(operationDateTime);
        operationReqVo.setOperationAmount(unfreezeAmount.multiply(FeePoolOperationTypeGroupEnum.UNFREEZE.getUsableAmountWeight()));
        operationReqVo.setFileList(reqVo.getFileList());
        operationReqVo.setRemarks(reqVo.getRemarks());
        String operationCode = this.feePoolOperationService.savePoolOperation(operationReqVo);
        this.subtractFreezeAmountByPoolDetailCode(poolDetail.getPoolDetailCode(), unfreezeAmount);
        this.feePoolService.subtractFreezeAmountByPoolCode(poolDetail.getPoolCode(), unfreezeAmount);
        FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
        detailLog.setPoolCode(poolDetail.getPoolCode());
        detailLog.setPoolDetailCode(poolDetail.getPoolDetailCode());
        detailLog.setOperationCode(operationCode);
        detailLog.setOperationType(reqVo.getOperationType());
        detailLog.setFromCode(reqVo.getFromCode());
        detailLog.setFromDesc(DictUtil.dictValue((String)"fee_pool_operation_type", (String)reqVo.getOperationType()));
        detailLog.setRemarks(reqVo.getRemarks());
        detailLog.setOperationAmount(unfreezeAmount.multiply(FeePoolOperationTypeGroupEnum.UNFREEZE.getUsableAmountWeight()));
        detailLog.setOperationDateTime(operationDateTime);
        this.feePoolDetailLogService.savePoolDetailLog(detailLog);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void adjustByPoolDetailCode(FeePoolDetailAdjustReqVo reqVo) {
        Assert.hasText((String)reqVo.getPoolDetailCode(), (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7");
        Assert.isTrue((reqVo.getAmount() != null ? 1 : 0) != 0, (String)("\u7f3a\u5931\u8c03\u6574" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        Assert.isTrue((reqVo.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)("\u8c03\u6574" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u5fc5\u987b\u5927\u4e8e0"));
        Assert.hasText((String)reqVo.getOperationType(), (String)"\u7f3a\u5931\u64cd\u4f5c\u7c7b\u578b");
        FeePoolOperationTypeGroupEnum operationTypeGroup = FeePoolConfigUtil.getOperationTypeGroup((String)reqVo.getOperationType());
        Assert.isTrue((FeePoolOperationTypeGroupEnum.ACCOUNT != operationTypeGroup ? 1 : 0) != 0, (String)("\u884c\u8c03\u6574\u4e0d\u652f\u6301" + DictUtil.dictValue((String)"fee_pool_operation_type_group", (String)FeePoolOperationTypeGroupEnum.ACCOUNT.getValue()) + "\u64cd\u4f5c"));
        Assert.isTrue((FeePoolOperationTypeGroupEnum.BACK != operationTypeGroup ? 1 : 0) != 0, (String)("\u884c\u8c03\u6574\u4e0d\u652f\u6301" + DictUtil.dictValue((String)"fee_pool_operation_type_group", (String)FeePoolOperationTypeGroupEnum.BACK.getValue()) + "\u64cd\u4f5c"));
        switch (operationTypeGroup) {
            case USE: {
                this.useByPoolDetailCode(reqVo);
                break;
            }
            case FREEZE: {
                this.freezeByPoolDetailCode(reqVo);
                break;
            }
            case UNFREEZE: {
                this.unfreezeByPoolDetailCode(reqVo);
                break;
            }
        }
    }

    protected void queryAndSetFileList(List<FeePoolDetailPageRespVo> list) {
        Set collect;
        Map<String, List<FeePoolFileRespVo>> fileGroupMap;
        if (CollectionUtil.listNotEmptyNotSizeZero(list) && !(fileGroupMap = this.feePoolFileService.getFeePoolFileListGroupByOperationCodeList(new ArrayList<String>(collect = list.stream().map(FeePoolDetailPageRespVo::getOperationCode).collect(Collectors.toSet())))).isEmpty()) {
            list.forEach(item -> {
                if (fileGroupMap.containsKey(item.getOperationCode())) {
                    item.setFileList((List)fileGroupMap.get(item.getOperationCode()));
                }
            });
        }
    }
}

