package com.biz.crm.capital.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.capital.CapitalEntity;
import com.biz.crm.nebular.fee.capital.CapitalVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

/**
 * @Description: 唯一键处理器
 * @Author: zhangyuzhu
 * @Date: 2021/5/24 15:37
 **/
@ConditionalOnMissingBean(name = "capitalOnlyKeyHandlerExpandImpl")
@Service(value = "capitalOnlyKeyHandler")
public class CapitalOnlyKeyHandler {


    /**
     * 根据实体类组装唯一键
     * 客户编码+客户销售公司+类型(英文半角逗号隔开)
     * @param entity
     * @return
     */
    public String packageOnlyKey(CapitalEntity entity){
        StringBuilder stb = new StringBuilder();
        if(StringUtils.isEmpty(entity.getCusCode())){
            throw new BusinessException("客户未填写!");
        }
        if(StringUtils.isEmpty(entity.getCompanyCode())){
            throw new BusinessException("客户销售公司未填写!");
        }
        if(StringUtils.isEmpty(entity.getCapitalType())){
            throw new BusinessException("资金池类型未填写!");
        }
        stb.append(entity.getCusCode()).append(",")
                .append(entity.getCompanyCode()).append(",")
                .append(entity.getCapitalType());
        return stb.toString();
    }

    /**
     * 根据VO类组装唯一键
     * 客户编码+客户销售公司+类型(英文半角逗号隔开)
     * @param entity
     * @return
     */
    public String packageOnlyKey(CapitalVo vo){
        StringBuilder stb = new StringBuilder();
        if(StringUtils.isEmpty(vo.getCusCode())){
            throw new BusinessException("客户未填写!");
        }
        if(StringUtils.isEmpty(vo.getCompanyCode())){
            throw new BusinessException("客户销售公司未填写!");
        }
        if(StringUtils.isEmpty(vo.getCapitalType())){
            throw new BusinessException("资金池类型未填写!");
        }
        stb.append(vo.getCusCode()).append(",")
                .append(vo.getCompanyCode()).append(",")
                .append(vo.getCapitalType());
        return stb.toString();
    }
}
