package com.biz.crm.pool.controller;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.fee.pool.req.FeePoolAdjustReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailAdjustReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailPageReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailPageRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailRespVo;
import com.biz.crm.pool.service.FeePoolDetailService;
import com.biz.crm.pool.service.FeePoolService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * 费用池明细表
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Slf4j
@RestController
@RequestMapping("/feePoolDetailController")
@Api(tags = "FEE-产品组-费用池明细表")
public class FeePoolDetailController {

    @Resource
    private FeePoolService feePoolService;
    @Resource
    private FeePoolDetailService feePoolDetailService;

    @ApiOperation(value = "（费用池管理页面专用）查询费用池明细分页列表")
    @PostMapping("/findFeePoolDetailPageList")
    public Result<PageResult<FeePoolDetailPageRespVo>> findFeePoolDetailPageList(@RequestBody FeePoolDetailPageReqVo reqVo) {
        return Result.ok(feePoolDetailService.findFeePoolDetailPageList(reqVo));
    }

    @ApiOperation(value = "（费用池管理页面专用）查询费用池明细分页列表，根据配置编码")
    @PostMapping("/findFeePoolDetailPageListByConfigCode")
    public Result<PageResult<FeePoolDetailPageRespVo>> findFeePoolDetailPageListByConfigCode(@RequestBody FeePoolDetailPageReqVo reqVo) {
        return Result.ok(feePoolDetailService.findFeePoolDetailPageListByConfigCode(reqVo));
    }

    @ApiOperation(value = "（费用池管理页面专用）查询费用池明细分页列表，根据费用池编号")
    @PostMapping("/findFeePoolDetailPageListByPoolCode")
    public Result<PageResult<FeePoolDetailPageRespVo>> findFeePoolDetailPageListByPoolCode(@RequestBody FeePoolDetailPageReqVo reqVo) {
        return Result.ok(feePoolDetailService.findFeePoolDetailPageListByPoolCode(reqVo));
    }

    @ApiOperation(value = "（费用池管理页面专用）明细冻结，通过费用池明细编号")
    @PostMapping("/freezeByPoolDetailCode")
    public Result freezeByPoolDetailCode(@RequestBody FeePoolDetailAdjustReqVo reqVo) {
        feePoolDetailService.freezeByPoolDetailCode(reqVo);
        return Result.ok();
    }

    @ApiOperation(value = "（费用池管理页面专用）明细解冻，通过费用池明细编号")
    @PostMapping("/unfreezeByPoolDetailCode")
    public Result unfreezeByPoolDetailCode(@RequestBody FeePoolDetailAdjustReqVo reqVo) {
        feePoolDetailService.unfreezeByPoolDetailCode(reqVo);
        return Result.ok();
    }

    @ApiOperation(value = "（费用池管理页面专用）维度调整")
    @PostMapping("/adjust")
    public Result adjust(@RequestBody FeePoolAdjustReqVo reqVo) {
        feePoolService.adjust(reqVo);
        return Result.ok();
    }

    @ApiOperation(value = "（费用池管理页面专用）明细调整，通过费用池明细编号")
    @PostMapping("/adjustByPoolDetailCode")
    public Result adjustByPoolDetailCode(@RequestBody FeePoolDetailAdjustReqVo reqVo) {
        feePoolDetailService.adjustByPoolDetailCode(reqVo);
        return Result.ok();
    }

    @ApiOperation(value = "通过费用池明细编号查询明细详情", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "poolDetailCode", value = "费用池明细编号", required = true, dataType = "String", paramType = "query")
    })
    @GetMapping("/queryByPoolDetailCode")
    public Result<FeePoolDetailRespVo> queryByPoolDetailCode(@RequestParam(value = "poolDetailCode", required = true) String poolDetailCode) {
        return Result.ok(feePoolDetailService.queryByPoolDetailCode(poolDetailCode));
    }
}
