package com.biz.crm.pool.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailLogPageReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailLogPageRespVo;
import com.biz.crm.pool.model.FeePoolDetailLogEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 费用池明细操作记录表
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
public interface FeePoolDetailLogMapper extends BaseMapper<FeePoolDetailLogEntity> {

    /**
     * 查询费用池明细操作记录表分页列表
     *
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(custCode = "a.customer_code")
    List<FeePoolDetailLogPageRespVo> findFeePoolDetailLogList(Page<FeePoolDetailLogPageRespVo> page, @Param("vo") FeePoolDetailLogPageReqVo reqVo);
}
