package com.biz.crm.pool.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailPageReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailPageRespVo;
import com.biz.crm.pool.model.FeePoolDetailEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 费用池明细表
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
public interface FeePoolDetailMapper extends BaseMapper<FeePoolDetailEntity> {

    /**
     * 查询费用池明细分页列表
     *
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(custCode = "a.customer_code")
    List<FeePoolDetailPageRespVo> findFeePoolDetailPageList(Page<FeePoolDetailPageRespVo> page, @Param("vo") FeePoolDetailPageReqVo reqVo);

}
