package com.biz.crm.pool.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailLogPageReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailLogReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailLogPageRespVo;
import com.biz.crm.pool.model.FeePoolDetailLogEntity;

import java.util.List;

/**
 * 费用池上账明细表接口
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
public interface FeePoolDetailLogService extends IService<FeePoolDetailLogEntity> {

    /**
     * 查询费用池明细操作记录表分页列表
     *
     * @param reqVo
     * @return PageResult<FeePoolAccountOperationRespVo>
     */
    PageResult<FeePoolDetailLogPageRespVo> findFeePoolDetailLogList(FeePoolDetailLogPageReqVo reqVo);

    /**
     * 查询费用池明细操作记录表分页列表，按照配置编码
     *
     * @param reqVo
     * @return PageResult<FeePoolAccountOperationRespVo>
     */
    PageResult<FeePoolDetailLogPageRespVo> findFeePoolDetailLogListByConfigCode(FeePoolDetailLogPageReqVo reqVo);

    /**
     * 查询费用池明细操作记录表分页列表，按照费用池编号
     *
     * @param reqVo
     * @return
     */
    PageResult<FeePoolDetailLogPageRespVo> findFeePoolDetailLogListByPoolCode(FeePoolDetailLogPageReqVo reqVo);

    /**
     * 查询费用池明细操作记录表分页列表，按照费用池明细编号
     *
     * @param reqVo
     * @return
     */
    PageResult<FeePoolDetailLogPageRespVo> findFeePoolDetailLogListByPoolDetailCode(FeePoolDetailLogPageReqVo reqVo);

    /**
     * 查询费用池明细操作记录表分页列表，按照操作记录编号
     *
     * @param reqVo
     * @return
     */
    PageResult<FeePoolDetailLogPageRespVo> findFeePoolDetailLogListByOperationCode(FeePoolDetailLogPageReqVo reqVo);

    /**
     * 添加查询费用池明细操作记录
     *
     * @param reqVo
     */
    void savePoolDetailLog(FeePoolDetailLogReqVo reqVo);

    /**
     * 批量添加查询费用池明细操作记录
     *
     * @param list
     */
    void savePoolDetailLog(List<FeePoolDetailLogReqVo> list);

}

