package com.biz.crm.pool.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailAdjustReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailPageReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailPageRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailRespVo;
import com.biz.crm.pool.model.FeePoolDetailEntity;

import java.math.BigDecimal;

/**
 * 费用池明细表接口
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
public interface FeePoolDetailService extends IService<FeePoolDetailEntity> {

    /**
     * 费用池明细分页列表
     *
     * @param reqVo
     * @return
     */
    PageResult<FeePoolDetailPageRespVo> findFeePoolDetailPageList(FeePoolDetailPageReqVo reqVo);

    /**
     * 费用池明细分页列表，按照配置编码
     *
     * @param reqVo
     * @return
     */
    PageResult<FeePoolDetailPageRespVo> findFeePoolDetailPageListByConfigCode(FeePoolDetailPageReqVo reqVo);

    /**
     * 费用池明细分页列表，按照费用池编号
     *
     * @param reqVo
     * @return
     */
    PageResult<FeePoolDetailPageRespVo> findFeePoolDetailPageListByPoolCode(FeePoolDetailPageReqVo reqVo);

    /**
     * 根据费用池明细编号获取详情
     *
     * @param poolDetailCode
     * @return
     */
    FeePoolDetailRespVo queryByPoolDetailCode(String poolDetailCode);

    /**
     * 增加总金额和可使用金额（单表操作）
     *
     * @param poolDetailCode 费用池明细编号
     * @param amount         金额
     */
    void addTotalAmountByPoolDetailCode(String poolDetailCode, BigDecimal amount);

    /**
     * 增加已使用金额，减少可使用金额（单表操作）
     *
     * @param poolDetailCode 费用池明细编号
     * @param amount         金额
     */
    void addHasUseAmountByPoolDetailCode(String poolDetailCode, BigDecimal amount);

    /**
     * 减少已使用金额，增加可使用金额（单表操作）
     *
     * @param poolDetailCode 费用池明细编号
     * @param amount         金额
     */
    void subtractHasUseAmountByPoolDetailCode(String poolDetailCode, BigDecimal amount);

    /**
     * 增加占用金额，减少可使用金额（单表操作）
     *
     * @param poolDetailCode 费用池明细编号
     * @param amount         金额
     */
    void addOccupyAmountByPoolDetailCode(String poolDetailCode, BigDecimal amount);

    /**
     * 减少占用金额，增加可使用金额（单表操作）
     *
     * @param poolDetailCode 费用池明细编号
     * @param amount         金额
     */
    void subtractOccupyAmountByPoolDetailCode(String poolDetailCode, BigDecimal amount);

    /**
     * 增加冻结金额，减少可使用金额（单表操作）
     *
     * @param poolDetailCode 费用池明细编号
     * @param amount         金额
     */
    void addFreezeAmountByPoolDetailCode(String poolDetailCode, BigDecimal amount);

    /**
     * 减少冻结金额，增加可使用金额（单表操作）
     *
     * @param poolDetailCode 费用池明细编号
     * @param amount         金额
     */
    void subtractFreezeAmountByPoolDetailCode(String poolDetailCode, BigDecimal amount);

    /**
     * 按照明细编号扣减使用
     *
     * @param reqVo
     */
    void useByPoolDetailCode(FeePoolDetailAdjustReqVo reqVo);

    /**
     * 冻结
     *
     * @param reqVo
     */
    void freezeByPoolDetailCode(FeePoolDetailAdjustReqVo reqVo);

    /**
     * 解冻
     *
     * @param reqVo
     */
    void unfreezeByPoolDetailCode(FeePoolDetailAdjustReqVo reqVo);

    /**
     * 通过费用池明细编号调整
     *
     * @param reqVo
     */
    void adjustByPoolDetailCode(FeePoolDetailAdjustReqVo reqVo);

}

