package com.biz.crm.pool.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.fee.pool.req.FeePoolOperationPageReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolOperationReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolOperationPageRespVo;
import com.biz.crm.pool.model.FeePoolOperationEntity;

/**
 * 费用池操作记录表接口
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
public interface FeePoolOperationService extends IService<FeePoolOperationEntity> {

    /**
     * 查询费用池操作记录分页列表
     *
     * @param reqVo
     * @return
     */
    PageResult<FeePoolOperationPageRespVo> findFeePoolOperationPageList(FeePoolOperationPageReqVo reqVo);

    /**
     * 查询费用池操作记录分页列表，按照配置编码
     *
     * @param reqVo
     * @return
     */
    PageResult<FeePoolOperationPageRespVo> findFeePoolOperationPageListByConfigCode(FeePoolOperationPageReqVo reqVo);

    /**
     * 查询费用池操作记录分页列表，按照费用池编号
     *
     * @param reqVo
     * @return
     */
    PageResult<FeePoolOperationPageRespVo> findFeePoolOperationPageListByPoolCode(FeePoolOperationPageReqVo reqVo);

    /**
     * 保存操作记录，返回操作记录编号
     *
     * @param reqVo
     * @return
     */
    String savePoolOperation(FeePoolOperationReqVo reqVo);

}

