/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.fee.FeePoolGroupEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeGroupEnum;
import com.biz.crm.eunm.fee.FeePoolTypeEnum;
import com.biz.crm.eunm.fee.FeePoolUseTypeEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.nebular.fee.pool.req.FeePoolAccountReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolAdjustReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolAmountQueryReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailLogReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDiscountUseReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolFileReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsUseBackItemReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolOccupyBackAllReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolOccupyToUseReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolOperationReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolPageReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolUseBackAllReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolUseBackReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolUseReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolAmountGroupByUseTypeRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolAmountQueryRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolAmountRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolMonthAmountRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolPageRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.pool.mapper.FeePoolMapper;
import com.biz.crm.pool.model.FeePoolDetailEntity;
import com.biz.crm.pool.model.FeePoolDetailLogEntity;
import com.biz.crm.pool.model.FeePoolEntity;
import com.biz.crm.pool.model.FeePoolOperationEntity;
import com.biz.crm.pool.service.FeePoolDetailLogService;
import com.biz.crm.pool.service.FeePoolDetailService;
import com.biz.crm.pool.service.FeePoolGoodsService;
import com.biz.crm.pool.service.FeePoolOperationService;
import com.biz.crm.pool.service.FeePoolService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ProductLevelUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import com.biz.crm.util.fee.FeePoolRollbackUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"FeePoolServiceExpandImpl"})
public class FeePoolServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<FeePoolMapper, FeePoolEntity>
implements FeePoolService {
    @Resource
    private FeePoolMapper feePoolMapper;
    @Resource
    private FeePoolOperationService feePoolOperationService;
    @Resource
    private FeePoolDetailService feePoolDetailService;
    @Resource
    private FeePoolDetailLogService feePoolDetailLogService;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private MdmProductFeign mdmProductFeign;
    @Resource
    private FeePoolGoodsService feePoolGoodsService;

    @Override
    public PageResult<FeePoolPageRespVo> findFeePoolPageList(FeePoolPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        if (StringUtils.isEmpty((String)reqVo.getPoolGroup())) {
            reqVo.setPoolGroup(FeePoolGroupEnum.DEFAULT.getValue());
        }
        List<FeePoolPageRespVo> list = this.feePoolMapper.findFeePoolPageList((Page<FeePoolPageRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<FeePoolPageRespVo> findFeePoolPageListByConfigCode(FeePoolPageReqVo reqVo) {
        String configCode = reqVo.getConfigCode();
        Assert.hasText((String)configCode, (String)"\u7f3a\u5931\u914d\u7f6e\u7f16\u7801");
        String poolGroup = FeePoolConfigUtil.getConfigQueryPoolGroup((String)configCode);
        Assert.hasText((String)poolGroup, (String)("\u914d\u7f6e\u3010" + configCode + "\u3011\u672a\u914d\u7f6e\u67e5\u8be2\u7684\u8d39\u7528\u6c60\u5206\u7ec4"));
        reqVo.setPoolGroup(poolGroup);
        List poolTypeList = FeePoolConfigUtil.getConfigQueryPoolTypeList((String)configCode);
        Assert.notEmpty((Collection)poolTypeList, (String)("\u914d\u7f6e\u3010" + configCode + "\u3011\u672a\u914d\u7f6e\u67e5\u8be2\u7684\u8d39\u7528\u6c60\u7c7b\u578b"));
        reqVo.setPoolTypeList(poolTypeList);
        List useTypeList = FeePoolConfigUtil.getConfigUseTypeList((String)configCode);
        Assert.notEmpty((Collection)useTypeList, (String)("\u914d\u7f6e\u3010" + configCode + "\u3011\u672a\u914d\u7f6e\u4f7f\u7528\u8d39\u7528\u7c7b\u578b"));
        reqVo.setUseTypeList(useTypeList);
        return this.findFeePoolPageList(reqVo);
    }

    @Override
    public void saveFeePool(FeePoolReqVo reqVo) {
        FeePoolEntity entity = (FeePoolEntity)CrmBeanUtil.copy((Object)reqVo, FeePoolEntity.class);
        this.save(entity);
    }

    @Override
    public FeePoolRespVo queryByPoolCode(String poolCode) {
        FeePoolEntity one;
        if (StringUtils.isNotEmpty((String)poolCode) && (one = (FeePoolEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolCode)).one()) != null) {
            return (FeePoolRespVo)CrmBeanUtil.copy((Object)one, FeePoolRespVo.class);
        }
        return null;
    }

    @Override
    public FeePoolAmountQueryRespVo queryPoolAmount(FeePoolAmountQueryReqVo reqVo) {
        FeePoolAmountQueryRespVo respVo = new FeePoolAmountQueryRespVo();
        if (StringUtils.isNotEmpty((String)reqVo.getCustomerCode())) {
            respVo.setDiscountUseTypeUsableAmountList(((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolGroup, (Object)(StringUtils.isNotEmpty((String)reqVo.getPoolGroup()) ? reqVo.getPoolGroup() : FeePoolGroupEnum.DEFAULT.getValue()))).eq(FeePoolEntity::getPoolType, (Object)FeePoolTypeEnum.DISCOUNT.getValue())).eq(FeePoolEntity::getCustomerCode, (Object)reqVo.getCustomerCode())).select(new SFunction[]{FeePoolEntity::getUseType, FeePoolEntity::getUsableAmount}).list().stream().collect(Collectors.groupingBy(FeePoolEntity::getUseType)).entrySet().stream().map(x -> {
                FeePoolAmountGroupByUseTypeRespVo useTypeRespVo = new FeePoolAmountGroupByUseTypeRespVo();
                useTypeRespVo.setUseType((String)x.getKey());
                useTypeRespVo.setUseTypeName(DictUtil.dictValue((String)"fee_pool_use_type", (String)((String)x.getKey())));
                useTypeRespVo.setAmount(((List)x.getValue()).stream().map(FeePoolEntity::getUsableAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
                return useTypeRespVo;
            }).collect(Collectors.toList()));
            respVo.setDiscountUsableAmount(respVo.getDiscountUseTypeUsableAmountList().stream().map(FeePoolAmountGroupByUseTypeRespVo::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
            respVo.setPoolUsableAmountMap(((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getCustomerCode, (Object)reqVo.getCustomerCode())).in(CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getPoolCodeList()), FeePoolEntity::getPoolCode, (Collection)reqVo.getPoolCodeList())).select(new SFunction[]{FeePoolEntity::getPoolCode, FeePoolEntity::getUsableAmount}).list().stream().collect(Collectors.toMap(FeePoolEntity::getPoolCode, FeePoolEntity::getUsableAmount)));
        }
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void account(FeePoolAccountReqVo reqVo) {
        Assert.hasText((String)reqVo.getPoolType(), (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7c7b\u578b");
        FeePoolTypeEnum poolTypeEnum = FeePoolTypeEnum.getEnum((String)reqVo.getPoolType());
        Assert.notNull((Object)poolTypeEnum, (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u7c7b\u578b");
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        Assert.hasText((String)reqVo.getOperationType(), (String)"\u7f3a\u5931\u64cd\u4f5c\u7c7b\u578b");
        Assert.isTrue((reqVo.getAmount() != null ? 1 : 0) != 0, (String)("\u7f3a\u5931\u4e0a\u8d26" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        Assert.isTrue((reqVo.getAmount().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)("\u4e0a\u8d26" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u5c0f\u4e8e0"));
        Assert.isTrue((boolean)FeePoolConfigUtil.checkOperationTypeGroup((String)reqVo.getOperationType(), (FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.ACCOUNT), (String)"\u8be5\u64cd\u4f5c\u7c7b\u578b\u4e0d\u652f\u6301\u4e0a\u8d26");
        String payType = FeePoolConfigUtil.getPayType((String)poolTypeEnum.getValue());
        if (StringUtils.isEmpty((String)reqVo.getPoolGroup())) {
            reqVo.setPoolGroup(FeePoolGroupEnum.DEFAULT.getValue());
        }
        if (StringUtils.isEmpty((String)reqVo.getUseType())) {
            reqVo.setUseType(FeePoolUseTypeEnum.DEFAULT.getValue());
        }
        FeePoolAdjustReqVo adjust = (FeePoolAdjustReqVo)CrmBeanUtil.copy((Object)reqVo, FeePoolAdjustReqVo.class);
        if (FeePoolTypeEnum.GOODS == poolTypeEnum) {
            Assert.isTrue((StringUtils.isNotEmpty((String)reqVo.getProductLevelCode()) || CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getProductCodeList()) ? 1 : 0) != 0, (String)"\u4ea7\u54c1\u5c42\u7ea7\u548c\u5546\u54c1\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
            adjust.setGoodsProductLevelCode(reqVo.getProductLevelCode());
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getProductCodeList())) {
                adjust.setGoodsProductCode(String.join((CharSequence)",", reqVo.getProductCodeList()));
            }
        }
        adjust.setPoolGroup(reqVo.getPoolGroup());
        adjust.setUseType(reqVo.getUseType());
        adjust.setPoolType(poolTypeEnum.getValue());
        adjust.setCustomerCode(reqVo.getCustomerCode());
        adjust.setOperationType(reqVo.getOperationType());
        adjust.setFromCode(reqVo.getFromCode());
        adjust.setFromDesc(reqVo.getFromDesc());
        adjust.setRemarks(reqVo.getRemarks());
        adjust.setAmount(reqVo.getAmount());
        adjust.setPayType(payType);
        adjust.setFileList(reqVo.getFileList());
        this.adjust(adjust);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void accountFeePool(FeePoolAdjustReqVo reqVo) {
        String operationDateTime = DateUtil.dateNowHms();
        if (StringUtils.isNotEmpty((String)reqVo.getPoolCode())) {
            FeePoolRespVo pool = this.queryByPoolCode(reqVo.getPoolCode());
            Assert.notNull((Object)pool, (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u7f16\u53f7");
            this.addTotalAmountByPoolCode(reqVo.getPoolCode(), reqVo.getAmount());
        } else {
            if (StringUtils.isEmpty((String)reqVo.getCustomerName())) {
                Result customerResult = this.mdmCustomerMsgFeign.query(null, reqVo.getCustomerCode());
                Assert.isTrue((boolean)customerResult.isSuccess(), (String)"\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                MdmCustomerMsgRespVo customer = (MdmCustomerMsgRespVo)customerResult.getResult();
                Assert.isTrue((customer != null && StringUtils.isNotEmpty((String)customer.getCustomerCode()) ? 1 : 0) != 0, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
                reqVo.setCustomerName(customer.getCustomerName());
            }
            if (StringUtils.isNotEmpty((String)reqVo.getGoodsProductLevelCode()) && StringUtils.isEmpty((String)reqVo.getGoodsProductLevelName())) {
                MdmProductLevelRespVo productLevel = ProductLevelUtil.getProductLevelByCode((String)reqVo.getGoodsProductLevelCode());
                Assert.isTrue((productLevel != null && StringUtils.isNotEmpty((String)productLevel.getProductLevelCode()) ? 1 : 0) != 0, (String)"\u4ea7\u54c1\u5c42\u7ea7\u4e0d\u5b58\u5728");
                reqVo.setGoodsProductLevelName(productLevel.getProductLevelName());
            }
            if (StringUtils.isNotEmpty((String)reqVo.getGoodsProductCode()) && StringUtils.isEmpty((String)reqVo.getGoodsProductName())) {
                HashMap<String, MdmProductRespVo> productMap = new HashMap<String, MdmProductRespVo>(16);
                List<String> sortedProductCodeList = Arrays.stream(reqVo.getGoodsProductCode().split(",")).sorted().collect(Collectors.toList());
                Result productResult = this.mdmProductFeign.queryBatchByProductCodeList(sortedProductCodeList);
                Assert.isTrue((boolean)productResult.isSuccess(), (String)"\u67e5\u8be2\u5546\u54c1\u5931\u8d25");
                productMap.putAll(((List)productResult.getResult()).stream().collect(Collectors.toMap(MdmProductRespVo::getProductCode, v -> v)));
                sortedProductCodeList.forEach(productCode -> Assert.isTrue((boolean)productMap.containsKey(productCode), (String)("\u5546\u54c1\u7f16\u7801[" + productCode + "]\u65e0\u6548")));
                List sortedProductNameList = sortedProductCodeList.stream().map(productCode -> ((MdmProductRespVo)productMap.get(productCode)).getProductName()).collect(Collectors.toList());
                reqVo.setGoodsProductCode(String.join((CharSequence)",", sortedProductCodeList));
            }
            FeePoolReqVo poolReqVo = (FeePoolReqVo)CrmBeanUtil.copy((Object)reqVo, FeePoolReqVo.class);
            poolReqVo.setPoolGroup(StringUtils.isNotEmpty((String)reqVo.getPoolGroup()) ? reqVo.getPoolGroup() : FeePoolGroupEnum.DEFAULT.getValue());
            poolReqVo.setPoolCode(CodeUtil.generateCode((String)CodeRuleEnum.FEE_POOL_CODE.getCode()));
            poolReqVo.setPayType(StringUtils.isNotEmpty((String)reqVo.getPayType()) ? reqVo.getPayType() : FeePoolConfigUtil.getPayType((String)reqVo.getPoolType()));
            poolReqVo.setUseType(StringUtils.isNotEmpty((String)reqVo.getUseType()) ? reqVo.getUseType() : FeePoolUseTypeEnum.DEFAULT.getValue());
            poolReqVo.setTotalAmount(reqVo.getAmount());
            poolReqVo.setUsableAmount(reqVo.getAmount());
            poolReqVo.setHasUseAmount(BigDecimal.ZERO);
            poolReqVo.setFreezeAmount(BigDecimal.ZERO);
            poolReqVo.setOccupyAmount(BigDecimal.ZERO);
            this.saveFeePool(poolReqVo);
            reqVo.setPoolCode(poolReqVo.getPoolCode());
        }
        FeePoolOperationReqVo operationReqVo = new FeePoolOperationReqVo();
        operationReqVo.setPoolCode(reqVo.getPoolCode());
        operationReqVo.setOperationType(reqVo.getOperationType());
        operationReqVo.setFromCode(reqVo.getFromCode());
        operationReqVo.setFromDesc(reqVo.getFromDesc());
        operationReqVo.setOperationDateTime(operationDateTime);
        operationReqVo.setOperationAmount(reqVo.getAmount().multiply(FeePoolOperationTypeGroupEnum.ACCOUNT.getUsableAmountWeight()));
        operationReqVo.setFileList(reqVo.getFileList());
        operationReqVo.setRemarks(reqVo.getRemarks());
        String operationCode = this.feePoolOperationService.savePoolOperation(operationReqVo);
        FeePoolRollbackUtil.addRollbackOperationCode((String)operationCode);
        FeePoolDetailEntity poolDetail = (FeePoolDetailEntity)CrmBeanUtil.copy((Object)reqVo, FeePoolDetailEntity.class);
        poolDetail.setId(null);
        poolDetail.setPoolCode(reqVo.getPoolCode());
        poolDetail.setPoolDetailCode(CodeUtil.generateCode((String)CodeRuleEnum.FEE_POOL_DETAIL_CODE.getCode()));
        poolDetail.setOperationCode(operationCode);
        poolDetail.setOperationType(reqVo.getOperationType());
        poolDetail.setFromCode(reqVo.getFromCode());
        poolDetail.setFromDesc(reqVo.getFromDesc());
        poolDetail.setAccountDateTime(operationDateTime);
        poolDetail.setTotalAmount(reqVo.getAmount());
        poolDetail.setUsableAmount(reqVo.getAmount());
        poolDetail.setHasUseAmount(BigDecimal.ZERO);
        poolDetail.setFreezeAmount(BigDecimal.ZERO);
        poolDetail.setOccupyAmount(BigDecimal.ZERO);
        poolDetail.setRemarks(reqVo.getRemarks());
        this.feePoolDetailService.save(poolDetail);
        FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
        detailLog.setPoolCode(poolDetail.getPoolCode());
        detailLog.setPoolDetailCode(poolDetail.getPoolDetailCode());
        detailLog.setOperationCode(operationCode);
        detailLog.setOperationType(reqVo.getOperationType());
        detailLog.setFromCode(reqVo.getFromCode());
        detailLog.setFromDesc(reqVo.getFromDesc());
        detailLog.setRemarks(reqVo.getRemarks());
        detailLog.setOperationAmount(reqVo.getAmount().multiply(FeePoolOperationTypeGroupEnum.ACCOUNT.getUsableAmountWeight()));
        detailLog.setOperationDateTime(operationDateTime);
        this.feePoolDetailLogService.savePoolDetailLog(detailLog);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void accountBatch(List<FeePoolAccountReqVo> list) {
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(this::account);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void rollback(String rollbackCode) {
        List list = FeePoolRollbackUtil.getOperationCodeListByRollbackCode((String)rollbackCode);
        if (list != null && list.size() > 0) {
            List operationEntityList = ((LambdaQueryChainWrapper)this.feePoolOperationService.lambdaQuery().in(FeePoolOperationEntity::getOperationCode, (Collection)list)).list();
            Map<String, BigDecimal> poolOperationMap = operationEntityList.stream().collect(Collectors.groupingBy(FeePoolOperationEntity::getPoolCode, Collectors.mapping(FeePoolOperationEntity::getOperationAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            List poolEntityList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(FeePoolEntity::getPoolCode, poolOperationMap.keySet())).list();
            if (poolEntityList.size() > 0) {
                Set deletePoolCodeSet = poolEntityList.stream().filter(x -> {
                    if (x.getHasUseAmount().compareTo(BigDecimal.ZERO) == 0 && x.getFreezeAmount().compareTo(BigDecimal.ZERO) == 0 && (x.getOccupyAmount() == null ? BigDecimal.ZERO : x.getOccupyAmount()).compareTo(BigDecimal.ZERO) == 0 && x.getTotalAmount().compareTo(x.getHasUseAmount()) == 0) {
                        BigDecimal bigDecimal = (BigDecimal)poolOperationMap.get(x.getPoolCode());
                        if (x.getTotalAmount().compareTo(bigDecimal) == 0) {
                            return true;
                        }
                    }
                    return false;
                }).map(FeePoolEntity::getPoolCode).collect(Collectors.toSet());
                List<FeePoolEntity> updatePoolEntityList = poolEntityList.stream().filter(x -> !deletePoolCodeSet.contains(x.getPoolCode())).collect(Collectors.toList());
                if (updatePoolEntityList.size() > 0) {
                    updatePoolEntityList.forEach(x -> {
                        BigDecimal bigDecimal = (BigDecimal)poolOperationMap.get(x.getPoolCode());
                        x.setTotalAmount(x.getTotalAmount().subtract(bigDecimal));
                        x.setUsableAmount(x.getUsableAmount().subtract(bigDecimal));
                    });
                    this.updateBatchById(updatePoolEntityList);
                }
                if (!deletePoolCodeSet.isEmpty()) {
                    ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(FeePoolEntity::getPoolCode, deletePoolCodeSet)).remove();
                }
            }
            ((LambdaUpdateChainWrapper)this.feePoolDetailLogService.lambdaUpdate().in(FeePoolDetailLogEntity::getOperationCode, (Collection)list)).remove();
            ((LambdaUpdateChainWrapper)this.feePoolDetailService.lambdaUpdate().in(FeePoolDetailEntity::getOperationCode, (Collection)list)).remove();
            ((LambdaUpdateChainWrapper)this.feePoolOperationService.lambdaUpdate().in(FeePoolOperationEntity::getOperationCode, (Collection)list)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void adjust(FeePoolAdjustReqVo reqVo) {
        reqVo.setId(null);
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        Assert.hasText((String)reqVo.getOperationType(), (String)"\u7f3a\u5931\u8c03\u6574\u7c7b\u578b");
        Assert.hasText((String)reqVo.getPoolType(), (String)"\u7f3a\u5931\u8d39\u7528\u7c7b\u578b");
        FeePoolTypeEnum poolTypeEnum = FeePoolTypeEnum.getEnum((String)reqVo.getPoolType());
        Assert.notNull((Object)poolTypeEnum, (String)"\u65e0\u6548\u7684\u8d39\u7528\u7c7b\u578b");
        Assert.isTrue((reqVo.getAmount() != null ? 1 : 0) != 0, (String)("\u7f3a\u5931" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        Assert.isTrue((reqVo.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)(FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u5fc5\u987b\u5927\u4e8e0"));
        String operationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)reqVo.getOperationType());
        Assert.hasText((String)operationTypeValue, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
        reqVo.setFromDesc(StringUtils.isNotEmpty((String)reqVo.getFromDesc()) ? reqVo.getFromDesc() : operationTypeValue);
        FeePoolOperationTypeGroupEnum operationTypeGroup = FeePoolConfigUtil.getOperationTypeGroup((String)reqVo.getOperationType());
        reqVo.setPayType(FeePoolConfigUtil.getPayType((String)poolTypeEnum.getValue()));
        reqVo.setPoolGroup(StringUtils.isNotEmpty((String)reqVo.getPoolGroup()) ? reqVo.getPoolGroup() : FeePoolGroupEnum.DEFAULT.getValue());
        reqVo.setUseType(StringUtils.isNotEmpty((String)reqVo.getUseType()) ? reqVo.getUseType() : FeePoolUseTypeEnum.DEFAULT.getValue());
        Assert.isTrue((FeePoolOperationTypeGroupEnum.BACK != operationTypeGroup ? 1 : 0) != 0, (String)("\u5934\u64cd\u4f5c\u4e0d\u652f\u6301" + DictUtil.dictValue((String)"fee_pool_operation_type_group", (String)FeePoolOperationTypeGroupEnum.BACK.getValue()) + "\u64cd\u4f5c"));
        Result customerResult = this.mdmCustomerMsgFeign.query(null, reqVo.getCustomerCode());
        Assert.isTrue((boolean)customerResult.isSuccess(), (String)"\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        MdmCustomerMsgRespVo customer = (MdmCustomerMsgRespVo)customerResult.getResult();
        Assert.isTrue((customer != null && StringUtils.isNotEmpty((String)customer.getCustomerCode()) ? 1 : 0) != 0, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
        FeePoolEntity pool = null;
        LambdaQueryWrapper poolLambdaQueryWrapper = new LambdaQueryWrapper();
        poolLambdaQueryWrapper.eq(FeePoolEntity::getPoolGroup, (Object)reqVo.getPoolGroup());
        poolLambdaQueryWrapper.eq(FeePoolEntity::getPoolType, (Object)poolTypeEnum.getValue());
        poolLambdaQueryWrapper.eq(FeePoolEntity::getUseType, (Object)reqVo.getUseType());
        poolLambdaQueryWrapper.eq(FeePoolEntity::getCustomerCode, (Object)reqVo.getCustomerCode());
        String goodsProductLevelCode = null;
        String goodsProductLevelName = null;
        String goodsProductCode = null;
        String goodsProductName = null;
        if (poolTypeEnum != FeePoolTypeEnum.DISCOUNT) {
            if (poolTypeEnum == FeePoolTypeEnum.GOODS) {
                Assert.isTrue((StringUtils.isNotEmpty((String)reqVo.getGoodsProductLevelCode()) || StringUtils.isNotEmpty((String)reqVo.getGoodsProductCode()) ? 1 : 0) != 0, (String)"\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5546\u54c1\u6216\u4e00\u4e2a\u4ea7\u54c1\u5c42\u7ea7");
                HashMap<String, MdmProductRespVo> productMap = new HashMap<String, MdmProductRespVo>(16);
                if (StringUtils.isNotEmpty((String)reqVo.getGoodsProductCode())) {
                    List<String> sortedProductCodeList = Arrays.stream(reqVo.getGoodsProductCode().split(",")).sorted().collect(Collectors.toList());
                    Result productResult = this.mdmProductFeign.queryBatchByProductCodeList(sortedProductCodeList);
                    Assert.isTrue((boolean)productResult.isSuccess(), (String)"\u67e5\u8be2\u5546\u54c1\u5931\u8d25");
                    productMap.putAll(((List)productResult.getResult()).stream().collect(Collectors.toMap(MdmProductRespVo::getProductCode, v -> v)));
                    sortedProductCodeList.forEach(productCode -> Assert.isTrue((boolean)productMap.containsKey(productCode), (String)("\u5546\u54c1\u7f16\u7801[" + productCode + "]\u65e0\u6548")));
                    List sortedProductNameList = sortedProductCodeList.stream().map(productCode -> ((MdmProductRespVo)productMap.get(productCode)).getProductName()).collect(Collectors.toList());
                    reqVo.setGoodsProductCode(String.join((CharSequence)",", sortedProductCodeList));
                    goodsProductCode = String.join((CharSequence)",", sortedProductCodeList);
                    goodsProductName = String.join((CharSequence)",", sortedProductNameList);
                }
                if (StringUtils.isNotEmpty((String)reqVo.getGoodsProductLevelCode())) {
                    MdmProductLevelRespVo productLevel = ProductLevelUtil.getProductLevelByCode((String)reqVo.getGoodsProductLevelCode());
                    Assert.notNull((Object)productLevel, (String)"\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u65e0\u6548");
                    goodsProductLevelCode = productLevel.getProductLevelCode();
                    goodsProductLevelName = productLevel.getProductLevelName();
                    HashSet childrenCodeSet = new HashSet(ProductLevelUtil.getChildrenProductLevelCodeListIncludeSelf((String)productLevel.getProductLevelCode()));
                    if (StringUtils.isNotEmpty((String)reqVo.getGoodsProductCode())) {
                        List<String> goodsProductCodeList = Arrays.stream(reqVo.getGoodsProductCode().split(",")).collect(Collectors.toList());
                        goodsProductCodeList.forEach(productCode -> Assert.isTrue((boolean)childrenCodeSet.contains(((MdmProductRespVo)productMap.get(productCode)).getProductLevelCode()), (String)("\u5546\u54c1[" + productCode + "]\u4e0d\u5c5e\u4e8e\u4ea7\u54c1\u5c42\u7ea7[" + reqVo.getGoodsProductLevelCode() + "]")));
                    }
                }
                if (StringUtils.isNotEmpty(goodsProductLevelCode)) {
                    poolLambdaQueryWrapper.eq(FeePoolEntity::getGoodsProductLevelCode, goodsProductLevelCode);
                } else {
                    poolLambdaQueryWrapper.and(x -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(FeePoolEntity::getGoodsProductLevelCode, (Object)"")).or()).isNull(FeePoolEntity::getGoodsProductLevelCode);
                    });
                }
                if (StringUtils.isNotEmpty(goodsProductCode)) {
                    poolLambdaQueryWrapper.eq(FeePoolEntity::getGoodsProductCode, goodsProductCode);
                } else {
                    poolLambdaQueryWrapper.and(x -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(FeePoolEntity::getGoodsProductCode, (Object)"")).or()).isNull(FeePoolEntity::getGoodsProductCode);
                    });
                }
            } else {
                throw new BusinessException("\u4e0d\u8bc6\u522b\u7684\u8d39\u7528\u6c60\u7c7b\u578b");
            }
        }
        String goodsProductLevelCodeFinal = goodsProductLevelCode;
        String goodsProductCodeFinal = goodsProductCode;
        List poolEntityList = this.feePoolMapper.selectList((Wrapper)poolLambdaQueryWrapper).stream().filter(x -> {
            if (poolTypeEnum == FeePoolTypeEnum.GOODS) {
                if (!Optional.ofNullable(goodsProductLevelCodeFinal).orElse("").equals(Optional.ofNullable(x.getGoodsProductLevelCode()).orElse(""))) {
                    return false;
                }
                if (!Optional.ofNullable(goodsProductCodeFinal).orElse("").equals(Optional.ofNullable(x.getGoodsProductCode()).orElse(""))) {
                    return false;
                }
            }
            return true;
        }).collect(Collectors.toList());
        if (CollectionUtil.listNotEmptyNotSizeZero(poolEntityList)) {
            pool = (FeePoolEntity)poolEntityList.get(0);
            reqVo.setPoolCode(pool.getPoolCode());
        }
        switch (operationTypeGroup) {
            case ACCOUNT: {
                if (FeePoolOperationTypeEnum.INIT.getValue().equals(reqVo.getOperationType()) && pool != null) {
                    StringBuilder builder = new StringBuilder("\u5df2\u5b58\u5728");
                    builder.append("\u5ba2\u6237\u3010").append(customer.getCustomerName()).append("\u3011");
                    if (!FeePoolGroupEnum.DEFAULT.getValue().equals(reqVo.getPoolGroup())) {
                        builder.append("\uff0c\u8d39\u7528\u6c60\u5206\u7ec4\u3010").append(DictUtil.dictValue((String)"fee_pool_group", (String)reqVo.getPoolGroup())).append("\u3011");
                    }
                    builder.append("\uff0c\u8d39\u7528\u7c7b\u578b\u3010").append(poolTypeEnum.getDesc()).append("\u3011");
                    if (!FeePoolUseTypeEnum.DEFAULT.getValue().equals(reqVo.getUseType())) {
                        builder.append("\uff0c\u4f7f\u7528\u7c7b\u578b\u3010").append(DictUtil.dictValue((String)"fee_pool_use_type", (String)reqVo.getUseType())).append("\u3011");
                    }
                    if (FeePoolTypeEnum.GOODS == poolTypeEnum) {
                        if (StringUtils.isNotEmpty((String)goodsProductLevelName)) {
                            builder.append("\uff0c\u4ea7\u54c1\u5c42\u7ea7\u3010").append(goodsProductLevelName).append("\u3011");
                        }
                        if (StringUtils.isNotEmpty((String)goodsProductName)) {
                            builder.append("\uff0c\u5546\u54c1\u3010").append(goodsProductName).append("\u3011");
                        }
                    }
                    builder.append("\u7684\u8d39\u7528\u7ef4\u5ea6\uff0c\u4e0d\u80fd\u518d\u671f\u521d\u4e0a\u8d26");
                    throw new BusinessException(builder.toString());
                }
                reqVo.setCustomerName(customer.getCustomerName());
                reqVo.setGoodsProductLevelName(goodsProductLevelName);
                reqVo.setGoodsProductName(goodsProductName);
                this.accountFeePool(reqVo);
                break;
            }
            case USE: {
                Assert.notNull((Object)pool, (String)("\u4e0d\u5b58\u5728\u8be5\u7ef4\u5ea6\uff0c\u4e0d\u80fd\u4f7f\u7528" + DictUtil.dictValue((String)"fee_pool_operation_type_group", (String)FeePoolOperationTypeGroupEnum.USE.getValue()) + "\u64cd\u4f5c"));
                this.useByPoolCode(reqVo);
                break;
            }
            case FREEZE: {
                Assert.notNull((Object)pool, (String)("\u4e0d\u5b58\u5728\u8be5\u7ef4\u5ea6\uff0c\u4e0d\u80fd\u4f7f\u7528" + DictUtil.dictValue((String)"fee_pool_operation_type_group", (String)FeePoolOperationTypeGroupEnum.FREEZE.getValue()) + "\u64cd\u4f5c"));
                this.freezeByPoolCode(reqVo);
                break;
            }
            case UNFREEZE: {
                Assert.notNull((Object)pool, (String)("\u4e0d\u5b58\u5728\u8be5\u7ef4\u5ea6\uff0c\u4e0d\u80fd\u4f7f\u7528" + DictUtil.dictValue((String)"fee_pool_operation_type_group", (String)FeePoolOperationTypeGroupEnum.UNFREEZE.getValue()) + "\u64cd\u4f5c"));
                this.unfreezeByPoolCode(reqVo);
                break;
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void adjustByPoolCode(FeePoolAdjustReqVo reqVo) {
        Assert.hasText((String)reqVo.getPoolCode(), (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.hasText((String)reqVo.getOperationType(), (String)"\u7f3a\u5931\u8c03\u6574\u7c7b\u578b");
        Assert.isTrue((reqVo.getAmount() != null ? 1 : 0) != 0, (String)("\u7f3a\u5931\u8c03\u6574" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        Assert.isTrue((reqVo.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)("\u8c03\u6574" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u5fc5\u987b\u5927\u4e8e0"));
        String operationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)reqVo.getOperationType());
        Assert.hasText((String)operationTypeValue, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
        FeePoolOperationTypeGroupEnum operationTypeGroup = FeePoolConfigUtil.getOperationTypeGroup((String)reqVo.getOperationType());
        Assert.isTrue((FeePoolOperationTypeGroupEnum.BACK != operationTypeGroup ? 1 : 0) != 0, (String)("\u884c\u64cd\u4f5c\u4e0d\u652f\u6301" + DictUtil.dictValue((String)"fee_pool_operation_type_group", (String)FeePoolOperationTypeGroupEnum.BACK.getValue()) + "\u64cd\u4f5c"));
        FeePoolEntity pool = (FeePoolEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)reqVo.getPoolCode())).one();
        Assert.notNull((Object)pool, (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u7f16\u53f7");
        String remarks = reqVo.getRemarks();
        CrmBeanUtil.copyProperties((Object)pool, (Object)reqVo);
        reqVo.setFromDesc(StringUtils.isNotEmpty((String)reqVo.getFromDesc()) ? reqVo.getFromDesc() : operationTypeValue);
        reqVo.setRemarks(remarks);
        switch (operationTypeGroup) {
            case ACCOUNT: {
                this.accountFeePool(reqVo);
                break;
            }
            case USE: {
                this.useByPoolCode(reqVo);
                break;
            }
            case FREEZE: {
                this.freezeByPoolCode(reqVo);
                break;
            }
            case UNFREEZE: {
                this.unfreezeByPoolCode(reqVo);
                break;
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void usePool(FeePoolUseReqVo reqVo) {
        Assert.hasText((String)reqVo.getOperationType(), (String)"\u7f3a\u5931\u64cd\u4f5c\u7c7b\u578b");
        String operationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)reqVo.getOperationType());
        reqVo.setFromDesc(StringUtils.isNotEmpty((String)reqVo.getFromDesc()) ? reqVo.getFromDesc() : operationTypeValue);
        List fileList = reqVo.getFileList();
        Assert.isTrue((boolean)FeePoolConfigUtil.checkOperationTypeGroup((String)reqVo.getOperationType(), (FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.USE), (String)("\u8be5\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4f7f\u7528\u8d39\u7528\u6c60" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        Assert.isTrue((reqVo.getDiscount() != null || reqVo.getGoods() != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u4f7f\u7528\u660e\u7ec6");
        if (reqVo.getDiscount() != null && reqVo.getDiscount().getAmount().compareTo(BigDecimal.ZERO) != 0) {
            Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
            FeePoolDiscountUseReqVo discount = reqVo.getDiscount();
            Assert.isTrue((discount.getAmount() != null ? 1 : 0) != 0, (String)("\u7f3a\u5931\u4f7f\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
            Assert.isTrue((discount.getAmount().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)("\u4f7f\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u5c0f\u4e8e0"));
            List feeDiscountList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolGroup, (Object)(StringUtils.isNotEmpty((String)reqVo.getPoolGroup()) ? reqVo.getPoolGroup() : FeePoolGroupEnum.DEFAULT.getValue()))).eq(FeePoolEntity::getCustomerCode, (Object)reqVo.getCustomerCode())).eq(FeePoolEntity::getPoolType, (Object)FeePoolTypeEnum.DISCOUNT.getValue())).eq(FeePoolEntity::getUseType, (Object)(StringUtils.isNotEmpty((String)discount.getUseType()) ? discount.getUseType() : FeePoolUseTypeEnum.DEFAULT.getValue()))).list();
            Assert.notEmpty((Collection)feeDiscountList, (String)("\u672a\u627e\u5230\u5ba2\u6237[" + reqVo.getCustomerCode() + "]" + (StringUtils.isNotEmpty((String)discount.getUseType()) ? "\u4f7f\u7528\u7c7b\u578b[" + DictUtil.dictValue((String)"fee_pool_use_type", (String)discount.getUseType()) + "]" : "") + "\u7684\u6298\u6263\u8d39\u7528\u6c60"));
            FeePoolEntity pool = (FeePoolEntity)feeDiscountList.get(0);
            FeePoolAdjustReqVo adjustReqVo = (FeePoolAdjustReqVo)CrmBeanUtil.copy((Object)pool, FeePoolAdjustReqVo.class);
            adjustReqVo.setAmount(discount.getAmount());
            adjustReqVo.setUseType(discount.getUseType());
            adjustReqVo.setFromCode(reqVo.getFromCode());
            adjustReqVo.setFromDesc(reqVo.getFromDesc());
            adjustReqVo.setOperationType(reqVo.getOperationType());
            adjustReqVo.setRemarks(reqVo.getRemarks());
            adjustReqVo.setFileList(reqVo.getFileList());
            this.useByPoolCode(adjustReqVo);
        }
        if (reqVo.getGoods() != null) {
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getGoods().getGoodsUseByPoolProductList())) {
                this.feePoolGoodsService.useGoodsAmountByPoolProductList(reqVo.getPoolGroup(), reqVo.getGoods().getUseType(), reqVo.getOperationType(), reqVo.getFromCode(), reqVo.getFromDesc(), reqVo.getRemarks(), reqVo.getGoods().getGoodsUseByPoolProductList(), fileList);
            }
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getGoods().getGoodsUseByProductLevelList())) {
                this.feePoolGoodsService.useGoodsAmountByProductLevelList(reqVo.getPoolGroup(), reqVo.getGoods().getUseType(), reqVo.getOperationType(), reqVo.getFromCode(), reqVo.getFromDesc(), reqVo.getRemarks(), reqVo.getGoods().getGoodsUseByProductLevelList(), fileList, reqVo.getCustomerCode());
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void usePoolBatch(List<FeePoolUseReqVo> list) {
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(this::usePool);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void usePoolAfterBackByFromCode(FeePoolUseReqVo reqVo) {
        String operationType = reqVo.getOperationType();
        Assert.hasText((String)reqVo.getFromCode(), (String)"\u7f3a\u5931\u6765\u6e90\u5355\u53f7");
        String operationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)operationType);
        String fromDesc = StringUtils.isNotEmpty((String)reqVo.getFromDesc()) ? reqVo.getFromDesc() : operationTypeValue;
        Assert.isTrue((boolean)FeePoolConfigUtil.checkOperationTypeGroup((String)operationType, (FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.USE), (String)("\u8be5\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4f7f\u7528\u8d39\u7528\u6c60" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        Assert.isTrue((reqVo.getDiscount() != null || reqVo.getGoods() != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u4f7f\u7528\u660e\u7ec6");
        FeePoolUseBackAllReqVo backAllReqVo = new FeePoolUseBackAllReqVo();
        backAllReqVo.setFromCode(reqVo.getFromCode());
        backAllReqVo.setFromDesc(fromDesc + "\u5148\u56de\u9000");
        backAllReqVo.setRemarks(reqVo.getRemarks());
        backAllReqVo.setOperationType(FeePoolOperationTypeEnum.ORDER_BACK.getValue());
        this.backAllUseByFromCode(backAllReqVo);
        this.usePool(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void usePoolAfterBackByFromCodeBatch(List<FeePoolUseReqVo> list) {
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(this::usePoolAfterBackByFromCode);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void backUseByFromCode(FeePoolUseBackReqVo reqVo) {
        String fromDesc;
        String operationType = reqVo.getOperationType();
        Assert.hasText((String)operationType, (String)"\u7f3a\u5931\u64cd\u4f5c\u7c7b\u578b");
        String fromCode = reqVo.getFromCode();
        Assert.hasText((String)fromCode, (String)"\u7f3a\u5931\u6765\u6e90\u5355\u53f7");
        String string = fromDesc = StringUtils.isNotEmpty((String)reqVo.getFromDesc()) ? reqVo.getFromDesc() : DictUtil.dictValue((String)"fee_pool_operation_type", (String)operationType);
        if (reqVo.getDiscountBackAmount() != null && reqVo.getDiscountBackAmount().compareTo(BigDecimal.ZERO) != 0) {
            this.backDiscountUseAmount(operationType, fromCode, fromDesc, reqVo.getDiscountBackAmount(), reqVo.getRemarks(), null);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getGoodsBackItemList())) {
            this.backGoodsUseAmount(operationType, fromCode, fromDesc, reqVo.getGoodsBackItemList(), reqVo.getRemarks(), null);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void backUseByFromCodeBatch(List<FeePoolUseBackReqVo> list) {
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(this::backUseByFromCode);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void useByPoolCode(FeePoolAdjustReqVo reqVo) {
        FeePoolOperationTypeGroupEnum operationTypeGroupEnum = FeePoolConfigUtil.getOperationTypeGroup((String)reqVo.getOperationType());
        Assert.isTrue((operationTypeGroupEnum == FeePoolOperationTypeGroupEnum.USE ? 1 : 0) != 0, (String)"\u8be5\u64cd\u4f5c\u7c7b\u578b\u4e0d\u652f\u6301\u4f7f\u7528\u6263\u51cf");
        String operationDateTime = DateUtil.dateNowHms();
        this.addHasUseAmountByPoolCode(reqVo.getPoolCode(), reqVo.getAmount());
        FeePoolOperationReqVo operationReqVo = new FeePoolOperationReqVo();
        operationReqVo.setPoolCode(reqVo.getPoolCode());
        operationReqVo.setOperationType(reqVo.getOperationType());
        operationReqVo.setFromCode(reqVo.getFromCode());
        operationReqVo.setFromDesc(reqVo.getFromDesc());
        operationReqVo.setOperationDateTime(operationDateTime);
        operationReqVo.setOperationAmount(reqVo.getAmount().multiply(operationTypeGroupEnum.getUsableAmountWeight()));
        operationReqVo.setFileList(reqVo.getFileList());
        operationReqVo.setRemarks(reqVo.getRemarks());
        String operationCode = this.feePoolOperationService.savePoolOperation(operationReqVo);
        List poolDetailList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolDetailService.lambdaQuery().eq(FeePoolDetailEntity::getPoolCode, (Object)reqVo.getPoolCode())).orderByAsc(FeePoolDetailEntity::getAccountDateTime)).list();
        BigDecimal restAmount = reqVo.getAmount();
        ArrayList<FeePoolDetailLogReqVo> detailLogList = new ArrayList<FeePoolDetailLogReqVo>();
        for (FeePoolDetailEntity poolDetail : poolDetailList) {
            if (restAmount.compareTo(BigDecimal.ZERO) <= 0) break;
            if (poolDetail.getUsableAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal itemUse = BigDecimal.ZERO;
            itemUse = poolDetail.getUsableAmount().compareTo(restAmount) >= 0 ? restAmount : poolDetail.getUsableAmount();
            restAmount = restAmount.subtract(itemUse);
            this.feePoolDetailService.addHasUseAmountByPoolDetailCode(poolDetail.getPoolDetailCode(), itemUse);
            FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
            detailLog.setPoolCode(reqVo.getPoolCode());
            detailLog.setPoolDetailCode(poolDetail.getPoolDetailCode());
            detailLog.setOperationCode(operationCode);
            detailLog.setOperationType(reqVo.getOperationType());
            detailLog.setFromCode(reqVo.getFromCode());
            detailLog.setFromDesc(reqVo.getFromDesc());
            detailLog.setRemarks(reqVo.getRemarks());
            detailLog.setOperationAmount(itemUse.multiply(operationTypeGroupEnum.getUsableAmountWeight()));
            detailLog.setOperationDateTime(operationDateTime);
            detailLogList.add(detailLog);
        }
        Assert.isTrue((restAmount.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u5f02\u5e38"));
        if (CollectionUtil.listNotEmptyNotSizeZero(detailLogList)) {
            this.feePoolDetailLogService.savePoolDetailLog(detailLogList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void occupyByPoolCode(FeePoolAdjustReqVo reqVo) {
        FeePoolOperationTypeGroupEnum operationTypeGroupEnum = FeePoolConfigUtil.getOperationTypeGroup((String)reqVo.getOperationType());
        Assert.isTrue((operationTypeGroupEnum == FeePoolOperationTypeGroupEnum.OCCUPY ? 1 : 0) != 0, (String)"\u8be5\u64cd\u4f5c\u7c7b\u578b\u4e0d\u652f\u6301\u4f7f\u7528\u5360\u7528");
        String operationDateTime = DateUtil.dateNowHms();
        this.addOccupyAmountByPoolCode(reqVo.getPoolCode(), reqVo.getAmount());
        FeePoolOperationReqVo operationReqVo = new FeePoolOperationReqVo();
        operationReqVo.setPoolCode(reqVo.getPoolCode());
        operationReqVo.setOperationType(reqVo.getOperationType());
        operationReqVo.setFromCode(reqVo.getFromCode());
        operationReqVo.setFromDesc(reqVo.getFromDesc());
        operationReqVo.setOperationDateTime(operationDateTime);
        operationReqVo.setOperationAmount(reqVo.getAmount().multiply(operationTypeGroupEnum.getUsableAmountWeight()));
        operationReqVo.setFileList(reqVo.getFileList());
        operationReqVo.setRemarks(reqVo.getRemarks());
        String operationCode = this.feePoolOperationService.savePoolOperation(operationReqVo);
        List poolDetailList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolDetailService.lambdaQuery().eq(FeePoolDetailEntity::getPoolCode, (Object)reqVo.getPoolCode())).orderByAsc(FeePoolDetailEntity::getAccountDateTime)).list();
        BigDecimal restAmount = reqVo.getAmount();
        ArrayList<FeePoolDetailLogReqVo> detailLogList = new ArrayList<FeePoolDetailLogReqVo>();
        for (FeePoolDetailEntity poolDetail : poolDetailList) {
            if (restAmount.compareTo(BigDecimal.ZERO) <= 0) break;
            if (poolDetail.getUsableAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal itemUse = BigDecimal.ZERO;
            itemUse = poolDetail.getUsableAmount().compareTo(restAmount) >= 0 ? restAmount : poolDetail.getUsableAmount();
            restAmount = restAmount.subtract(itemUse);
            this.feePoolDetailService.addOccupyAmountByPoolDetailCode(poolDetail.getPoolDetailCode(), itemUse);
            FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
            detailLog.setPoolCode(reqVo.getPoolCode());
            detailLog.setPoolDetailCode(poolDetail.getPoolDetailCode());
            detailLog.setOperationCode(operationCode);
            detailLog.setOperationType(reqVo.getOperationType());
            detailLog.setFromCode(reqVo.getFromCode());
            detailLog.setFromDesc(reqVo.getFromDesc());
            detailLog.setRemarks(reqVo.getRemarks());
            detailLog.setOperationAmount(itemUse.multiply(operationTypeGroupEnum.getUsableAmountWeight()));
            detailLog.setOperationDateTime(operationDateTime);
            detailLogList.add(detailLog);
        }
        Assert.isTrue((restAmount.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u5f02\u5e38"));
        if (CollectionUtil.listNotEmptyNotSizeZero(detailLogList)) {
            this.feePoolDetailLogService.savePoolDetailLog(detailLogList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void freezeByPoolCode(FeePoolAdjustReqVo reqVo) {
        FeePoolOperationTypeGroupEnum operationTypeGroupEnum = FeePoolConfigUtil.getOperationTypeGroup((String)reqVo.getOperationType());
        Assert.isTrue((operationTypeGroupEnum == FeePoolOperationTypeGroupEnum.FREEZE ? 1 : 0) != 0, (String)"\u8be5\u64cd\u4f5c\u7c7b\u578b\u4e0d\u652f\u6301\u51bb\u7ed3");
        String operationDateTime = DateUtil.dateNowHms();
        this.addFreezeAmountByPoolCode(reqVo.getPoolCode(), reqVo.getAmount());
        FeePoolOperationReqVo operationReqVo = new FeePoolOperationReqVo();
        operationReqVo.setPoolCode(reqVo.getPoolCode());
        operationReqVo.setOperationType(reqVo.getOperationType());
        operationReqVo.setFromCode(reqVo.getFromCode());
        operationReqVo.setFromDesc(reqVo.getFromDesc());
        operationReqVo.setOperationDateTime(operationDateTime);
        operationReqVo.setOperationAmount(reqVo.getAmount().multiply(operationTypeGroupEnum.getUsableAmountWeight()));
        operationReqVo.setFileList(reqVo.getFileList());
        operationReqVo.setRemarks(reqVo.getRemarks());
        String operationCode = this.feePoolOperationService.savePoolOperation(operationReqVo);
        List poolDetailList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolDetailService.lambdaQuery().eq(FeePoolDetailEntity::getPoolCode, (Object)reqVo.getPoolCode())).orderByAsc(FeePoolDetailEntity::getAccountDateTime)).list();
        BigDecimal restAmount = reqVo.getAmount();
        ArrayList<FeePoolDetailLogReqVo> detailLogList = new ArrayList<FeePoolDetailLogReqVo>();
        for (FeePoolDetailEntity poolDetail : poolDetailList) {
            if (restAmount.compareTo(BigDecimal.ZERO) <= 0) break;
            if (poolDetail.getUsableAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal itemUse = BigDecimal.ZERO;
            itemUse = poolDetail.getUsableAmount().compareTo(restAmount) >= 0 ? restAmount : poolDetail.getUsableAmount();
            restAmount = restAmount.subtract(itemUse);
            this.feePoolDetailService.addFreezeAmountByPoolDetailCode(poolDetail.getPoolDetailCode(), itemUse);
            FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
            detailLog.setPoolCode(reqVo.getPoolCode());
            detailLog.setPoolDetailCode(poolDetail.getPoolDetailCode());
            detailLog.setOperationCode(operationCode);
            detailLog.setOperationType(reqVo.getOperationType());
            detailLog.setFromCode(reqVo.getFromCode());
            detailLog.setFromDesc(reqVo.getFromDesc());
            detailLog.setRemarks(reqVo.getRemarks());
            detailLog.setOperationAmount(itemUse.multiply(operationTypeGroupEnum.getUsableAmountWeight()));
            detailLog.setOperationDateTime(operationDateTime);
            detailLogList.add(detailLog);
        }
        Assert.isTrue((restAmount.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u5f02\u5e38"));
        if (CollectionUtil.listNotEmptyNotSizeZero(detailLogList)) {
            this.feePoolDetailLogService.savePoolDetailLog(detailLogList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unfreezeByPoolCode(FeePoolAdjustReqVo reqVo) {
        FeePoolOperationTypeGroupEnum operationTypeGroupEnum = FeePoolConfigUtil.getOperationTypeGroup((String)reqVo.getOperationType());
        Assert.isTrue((operationTypeGroupEnum == FeePoolOperationTypeGroupEnum.UNFREEZE ? 1 : 0) != 0, (String)"\u8be5\u64cd\u4f5c\u7c7b\u578b\u4e0d\u652f\u6301\u89e3\u51bb");
        String operationDateTime = DateUtil.dateNowHms();
        this.subtractFreezeAmountByPoolCode(reqVo.getPoolCode(), reqVo.getAmount());
        FeePoolOperationReqVo operationReqVo = new FeePoolOperationReqVo();
        operationReqVo.setPoolCode(reqVo.getPoolCode());
        operationReqVo.setOperationType(reqVo.getOperationType());
        operationReqVo.setFromCode(reqVo.getFromCode());
        operationReqVo.setFromDesc(reqVo.getFromDesc());
        operationReqVo.setOperationDateTime(operationDateTime);
        operationReqVo.setOperationAmount(reqVo.getAmount().multiply(operationTypeGroupEnum.getUsableAmountWeight()));
        operationReqVo.setFileList(reqVo.getFileList());
        operationReqVo.setRemarks(reqVo.getRemarks());
        String operationCode = this.feePoolOperationService.savePoolOperation(operationReqVo);
        List poolDetailList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolDetailService.lambdaQuery().eq(FeePoolDetailEntity::getPoolCode, (Object)reqVo.getPoolCode())).orderByAsc(FeePoolDetailEntity::getAccountDateTime)).list();
        BigDecimal restAmount = reqVo.getAmount();
        ArrayList<FeePoolDetailLogReqVo> detailLogList = new ArrayList<FeePoolDetailLogReqVo>();
        for (FeePoolDetailEntity poolDetail : poolDetailList) {
            if (restAmount.compareTo(BigDecimal.ZERO) <= 0) break;
            if (poolDetail.getFreezeAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal itemUse = BigDecimal.ZERO;
            itemUse = poolDetail.getFreezeAmount().compareTo(restAmount) >= 0 ? restAmount : poolDetail.getFreezeAmount();
            restAmount = restAmount.subtract(itemUse);
            this.feePoolDetailService.subtractFreezeAmountByPoolDetailCode(poolDetail.getPoolDetailCode(), itemUse);
            FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
            detailLog.setPoolCode(reqVo.getPoolCode());
            detailLog.setPoolDetailCode(poolDetail.getPoolDetailCode());
            detailLog.setOperationCode(operationCode);
            detailLog.setOperationType(reqVo.getOperationType());
            detailLog.setFromCode(reqVo.getFromCode());
            detailLog.setFromDesc(reqVo.getFromDesc());
            detailLog.setRemarks(reqVo.getRemarks());
            detailLog.setOperationAmount(itemUse.multiply(operationTypeGroupEnum.getUsableAmountWeight()));
            detailLog.setOperationDateTime(operationDateTime);
            detailLogList.add(detailLog);
        }
        Assert.isTrue((restAmount.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u5f02\u5e38"));
        if (CollectionUtil.listNotEmptyNotSizeZero(detailLogList)) {
            this.feePoolDetailLogService.savePoolDetailLog(detailLogList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void backAllUseByFromCode(FeePoolUseBackAllReqVo reqVo) {
        FeePoolOperationTypeGroupEnum operationTypeGroupEnum;
        String fromCode = reqVo.getFromCode();
        String fromDesc = reqVo.getFromDesc();
        String remarks = reqVo.getRemarks();
        Assert.hasText((String)fromCode, (String)"\u7f3a\u5931\u6765\u6e90\u5355\u53f7");
        String operationType = reqVo.getOperationType();
        if (StringUtils.isEmpty((String)operationType)) {
            operationType = FeePoolOperationTypeEnum.ORDER_BACK.getValue();
        }
        Assert.isTrue(((operationTypeGroupEnum = FeePoolConfigUtil.getOperationTypeGroup((String)operationType)) == FeePoolOperationTypeGroupEnum.BACK ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u652f\u6301\u56de\u9000");
        String operationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)operationType);
        HashSet operationTypeSet = new HashSet(16);
        operationTypeSet.addAll(FeePoolConfigUtil.getOperationTypeList((FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.USE));
        operationTypeSet.addAll(FeePoolConfigUtil.getOperationTypeList((FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.BACK));
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolOperationService.lambdaQuery().eq(FeePoolOperationEntity::getFromCode, (Object)fromCode)).in(FeePoolOperationTypeEnum.ORDER_BACK.getValue().equals(reqVo.getOperationType()), FeePoolOperationEntity::getOperationType, Arrays.asList(FeePoolOperationTypeEnum.ORDER_USE.getValue(), FeePoolOperationTypeEnum.ORDER_BACK.getValue()))).in(FeePoolOperationEntity::getOperationType, operationTypeSet)).list();
        if (CollectionUtil.listEmpty((List)list)) {
            return;
        }
        Map<String, List<FeePoolOperationEntity>> poolOperationGroup = list.stream().collect(Collectors.groupingBy(FeePoolOperationEntity::getPoolCode));
        String operationDateTime = DateUtil.dateNowHms();
        for (Map.Entry<String, List<FeePoolOperationEntity>> entry : poolOperationGroup.entrySet()) {
            String poolCode = entry.getKey();
            List<FeePoolOperationEntity> operationEntityList = entry.getValue();
            BigDecimal operationAmountTotal = operationEntityList.stream().map(FeePoolOperationEntity::getOperationAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (operationAmountTotal.compareTo(BigDecimal.ZERO) == 0) continue;
            Assert.isTrue((operationAmountTotal.compareTo(BigDecimal.ZERO) <= 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60\u3010" + poolCode + "\u3011\u6570\u636e\u5f02\u5e38"));
            List detailLogList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolDetailLogService.lambdaQuery().eq(FeePoolDetailLogEntity::getPoolCode, (Object)poolCode)).eq(FeePoolDetailLogEntity::getFromCode, (Object)fromCode)).in(FeePoolOperationTypeEnum.ORDER_BACK.getValue().equals(reqVo.getOperationType()), FeePoolDetailLogEntity::getOperationType, Arrays.asList(FeePoolOperationTypeEnum.ORDER_USE.getValue(), FeePoolOperationTypeEnum.ORDER_BACK.getValue()))).in(FeePoolDetailLogEntity::getOperationType, operationTypeSet)).list();
            Assert.notEmpty((Collection)detailLogList, (String)("\u8d39\u7528\u6c60\u3010" + poolCode + "\u3011\u6570\u636e\u5f02\u5e38"));
            Set poolDetailCodeSet = detailLogList.stream().map(FeePoolDetailLogEntity::getPoolDetailCode).collect(Collectors.toSet());
            Map<String, String> productCodeNameMap = detailLogList.stream().filter(x -> StringUtils.isNotEmpty((String)x.getProductCode())).collect(Collectors.toMap(FeePoolDetailLogEntity::getProductCode, FeePoolDetailLogEntity::getProductName, (x1, x2) -> x1));
            Map<String, FeePoolDetailEntity> poolDetailEntityMap = ((LambdaQueryChainWrapper)this.feePoolDetailService.lambdaQuery().in(FeePoolDetailEntity::getPoolDetailCode, poolDetailCodeSet)).list().stream().collect(Collectors.toMap(FeePoolDetailEntity::getPoolDetailCode, v -> v));
            ArrayList<FeePoolDetailEntity> hasEditDetailEntityList = new ArrayList<FeePoolDetailEntity>();
            FeePoolOperationReqVo operationReqVo = new FeePoolOperationReqVo();
            operationReqVo.setPoolCode(poolCode);
            operationReqVo.setOperationType(operationType);
            operationReqVo.setFromCode(fromCode);
            operationReqVo.setFromDesc(StringUtils.isNotEmpty((String)fromDesc) ? fromDesc : operationTypeValue);
            operationReqVo.setOperationDateTime(operationDateTime);
            operationReqVo.setOperationAmount(operationAmountTotal.abs().multiply(operationTypeGroupEnum.getUsableAmountWeight()));
            operationReqVo.setFileList(null);
            operationReqVo.setRemarks(remarks);
            String operationCode = this.feePoolOperationService.savePoolOperation(operationReqVo);
            ArrayList<FeePoolDetailLogReqVo> logList = new ArrayList<FeePoolDetailLogReqVo>();
            Map<String, List<FeePoolDetailLogEntity>> groupByDetailCodeMap = detailLogList.stream().collect(Collectors.groupingBy(FeePoolDetailLogEntity::getPoolDetailCode));
            for (Map.Entry<String, List<FeePoolDetailLogEntity>> groupByDetailCodeEntry : groupByDetailCodeMap.entrySet()) {
                String poolDetailCode = groupByDetailCodeEntry.getKey();
                List<FeePoolDetailLogEntity> groupByDetailLogList = groupByDetailCodeEntry.getValue();
                BigDecimal thisDetailAmount = groupByDetailLogList.stream().map(FeePoolDetailLogEntity::getOperationAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                Assert.isTrue((thisDetailAmount.compareTo(BigDecimal.ZERO) <= 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60\u660e\u7ec6\u3010" + poolDetailCode + "\u3011\u9000\u8fd8" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u6709\u8bef"));
                Assert.isTrue((boolean)poolDetailEntityMap.containsKey(poolDetailCode), (String)("\u8d39\u7528\u6c60\u3010" + poolCode + "\u3011\u6570\u636e\u6709\u8bef"));
                Map<String, List<FeePoolDetailLogEntity>> groupByProductCodeMap = groupByDetailLogList.stream().collect(Collectors.groupingBy(x -> x.getProductCode() == null ? "" : x.getProductCode()));
                for (Map.Entry<String, List<FeePoolDetailLogEntity>> groupByProductCodeEntry : groupByProductCodeMap.entrySet()) {
                    String productCode = groupByProductCodeEntry.getKey();
                    List<FeePoolDetailLogEntity> groupByProductLogList = groupByProductCodeEntry.getValue();
                    BigDecimal thisDetailProductAmount = groupByProductLogList.stream().map(FeePoolDetailLogEntity::getOperationAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    Assert.isTrue((thisDetailProductAmount.compareTo(BigDecimal.ZERO) <= 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60\u660e\u7ec6\u3010" + poolDetailCode + "\u3011" + (StringUtils.isNotEmpty((String)productCode) ? "\u5546\u54c1\u3010" + productCode + "\u3011" : "") + "\u9000\u8fd8" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u6709\u8bef"));
                    FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
                    detailLog.setPoolCode(poolCode);
                    detailLog.setPoolDetailCode(poolDetailCode);
                    detailLog.setOperationCode(operationCode);
                    detailLog.setOperationType(operationType);
                    detailLog.setFromCode(fromCode);
                    detailLog.setFromDesc(StringUtils.isNotEmpty((String)fromDesc) ? fromDesc : operationTypeValue);
                    detailLog.setRemarks(remarks);
                    detailLog.setOperationAmount(thisDetailProductAmount.abs().multiply(operationTypeGroupEnum.getUsableAmountWeight()));
                    detailLog.setOperationDateTime(operationDateTime);
                    if (StringUtils.isNotEmpty((String)productCode)) {
                        detailLog.setProductCode(productCode);
                        detailLog.setProductName(productCodeNameMap.get(productCode));
                    }
                    logList.add(detailLog);
                }
                FeePoolDetailEntity feePoolDetailEntity = poolDetailEntityMap.get(poolDetailCode);
                feePoolDetailEntity.setHasUseAmount(feePoolDetailEntity.getHasUseAmount().subtract(thisDetailAmount.abs()));
                feePoolDetailEntity.setUsableAmount(feePoolDetailEntity.getUsableAmount().add(thisDetailAmount.abs()));
                hasEditDetailEntityList.add(feePoolDetailEntity);
            }
            this.subtractHasUseAmountByPoolCode(poolCode, operationAmountTotal.abs());
            this.feePoolDetailService.updateBatchById(hasEditDetailEntityList);
            this.feePoolDetailLogService.savePoolDetailLog(logList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void backAllUseByFromCodeBatch(List<FeePoolUseBackAllReqVo> list) {
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(this::backAllUseByFromCode);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void occupyPool(FeePoolUseReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getOperationType())) {
            reqVo.setOperationType(FeePoolOperationTypeEnum.OCCUPY.getValue());
        }
        String operationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)reqVo.getOperationType());
        reqVo.setFromDesc(StringUtils.isNotEmpty((String)reqVo.getFromDesc()) ? reqVo.getFromDesc() : operationTypeValue);
        List fileList = reqVo.getFileList();
        Assert.isTrue((boolean)FeePoolConfigUtil.checkOperationTypeGroup((String)reqVo.getOperationType(), (FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.OCCUPY), (String)("\u8be5\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u5360\u7528\u8d39\u7528\u6c60" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        Assert.isTrue((reqVo.getDiscount() != null || reqVo.getGoods() != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u4f7f\u7528\u660e\u7ec6");
        if (reqVo.getDiscount() != null && reqVo.getDiscount().getAmount().compareTo(BigDecimal.ZERO) != 0) {
            Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
            FeePoolDiscountUseReqVo discount = reqVo.getDiscount();
            Assert.isTrue((discount.getAmount() != null ? 1 : 0) != 0, (String)("\u7f3a\u5931\u5360\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
            Assert.isTrue((discount.getAmount().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)("\u5360\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u5c0f\u4e8e0"));
            List feeDiscountList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolGroup, (Object)(StringUtils.isNotEmpty((String)reqVo.getPoolGroup()) ? reqVo.getPoolGroup() : FeePoolGroupEnum.DEFAULT.getValue()))).eq(FeePoolEntity::getCustomerCode, (Object)reqVo.getCustomerCode())).eq(FeePoolEntity::getPoolType, (Object)FeePoolTypeEnum.DISCOUNT.getValue())).eq(FeePoolEntity::getUseType, (Object)(StringUtils.isNotEmpty((String)discount.getUseType()) ? discount.getUseType() : FeePoolUseTypeEnum.DEFAULT.getValue()))).list();
            Assert.notEmpty((Collection)feeDiscountList, (String)("\u672a\u627e\u5230\u5ba2\u6237[" + reqVo.getCustomerCode() + "]" + (StringUtils.isNotEmpty((String)discount.getUseType()) ? "\u4f7f\u7528\u7c7b\u578b[" + DictUtil.dictValue((String)"fee_pool_use_type", (String)discount.getUseType()) + "]" : "") + "\u7684\u6298\u6263\u8d39\u7528\u6c60"));
            FeePoolEntity pool = (FeePoolEntity)feeDiscountList.get(0);
            FeePoolAdjustReqVo adjustReqVo = (FeePoolAdjustReqVo)CrmBeanUtil.copy((Object)pool, FeePoolAdjustReqVo.class);
            adjustReqVo.setAmount(discount.getAmount());
            adjustReqVo.setUseType(discount.getUseType());
            adjustReqVo.setFromCode(reqVo.getFromCode());
            adjustReqVo.setFromDesc(reqVo.getFromDesc());
            adjustReqVo.setOperationType(reqVo.getOperationType());
            adjustReqVo.setRemarks(reqVo.getRemarks());
            adjustReqVo.setFileList(reqVo.getFileList());
            this.occupyByPoolCode(adjustReqVo);
        }
        if (reqVo.getGoods() != null) {
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getGoods().getGoodsUseByPoolProductList())) {
                this.feePoolGoodsService.occupyGoodsAmountByPoolProductList(reqVo.getPoolGroup(), reqVo.getGoods().getUseType(), reqVo.getOperationType(), reqVo.getFromCode(), reqVo.getFromDesc(), reqVo.getRemarks(), reqVo.getGoods().getGoodsUseByPoolProductList(), fileList);
            }
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getGoods().getGoodsUseByProductLevelList())) {
                this.feePoolGoodsService.occupyGoodsAmountByProductLevelList(reqVo.getPoolGroup(), reqVo.getGoods().getUseType(), reqVo.getOperationType(), reqVo.getFromCode(), reqVo.getFromDesc(), reqVo.getRemarks(), reqVo.getGoods().getGoodsUseByProductLevelList(), fileList, reqVo.getCustomerCode());
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void occupyPoolBatch(List<FeePoolUseReqVo> list) {
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(this::occupyPool);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void backAllOccupyByFromCode(FeePoolOccupyBackAllReqVo reqVo) {
        FeePoolOperationTypeGroupEnum operationTypeGroupEnum;
        String fromCode = reqVo.getFromCode();
        String fromDesc = reqVo.getFromDesc();
        String remarks = reqVo.getRemarks();
        String operationType = reqVo.getOperationType();
        Assert.hasText((String)fromCode, (String)"\u7f3a\u5931\u6765\u6e90\u5355\u53f7");
        if (StringUtils.isEmpty((String)operationType)) {
            operationType = FeePoolOperationTypeEnum.UNOCCUPY.getValue();
        }
        Assert.isTrue(((operationTypeGroupEnum = FeePoolConfigUtil.getOperationTypeGroup((String)operationType)) == FeePoolOperationTypeGroupEnum.UNOCCUPY ? 1 : 0) != 0, (String)"\u8be5\u64cd\u4f5c\u7c7b\u578b\u4e0d\u652f\u6301\u91ca\u653e");
        String operationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)operationType);
        HashSet operationTypeSet = new HashSet(16);
        operationTypeSet.addAll(FeePoolConfigUtil.getOperationTypeList((FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.OCCUPY));
        operationTypeSet.addAll(FeePoolConfigUtil.getOperationTypeList((FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.UNOCCUPY));
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolOperationService.lambdaQuery().eq(FeePoolOperationEntity::getFromCode, (Object)fromCode)).in(FeePoolOperationEntity::getOperationType, operationTypeSet)).list();
        if (CollectionUtil.listEmpty((List)list)) {
            return;
        }
        Map<String, List<FeePoolOperationEntity>> poolOperationGroup = list.stream().collect(Collectors.groupingBy(FeePoolOperationEntity::getPoolCode));
        String operationDateTime = DateUtil.dateNowHms();
        for (Map.Entry<String, List<FeePoolOperationEntity>> entry : poolOperationGroup.entrySet()) {
            String poolCode = entry.getKey();
            List<FeePoolOperationEntity> operationEntityList = entry.getValue();
            BigDecimal operationAmountTotal = operationEntityList.stream().map(FeePoolOperationEntity::getOperationAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (operationAmountTotal.compareTo(BigDecimal.ZERO) == 0) continue;
            Assert.isTrue((operationAmountTotal.compareTo(BigDecimal.ZERO) <= 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60\u3010" + poolCode + "\u3011\u6570\u636e\u5f02\u5e38"));
            List detailLogList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolDetailLogService.lambdaQuery().eq(FeePoolDetailLogEntity::getPoolCode, (Object)poolCode)).eq(FeePoolDetailLogEntity::getFromCode, (Object)fromCode)).in(FeePoolDetailLogEntity::getOperationType, operationTypeSet)).list();
            Assert.notEmpty((Collection)detailLogList, (String)("\u8d39\u7528\u6c60\u3010" + poolCode + "\u3011\u6570\u636e\u5f02\u5e38"));
            Set poolDetailCodeSet = detailLogList.stream().map(FeePoolDetailLogEntity::getPoolDetailCode).collect(Collectors.toSet());
            Map<String, String> productCodeNameMap = detailLogList.stream().filter(x -> StringUtils.isNotEmpty((String)x.getProductCode())).collect(Collectors.toMap(FeePoolDetailLogEntity::getProductCode, FeePoolDetailLogEntity::getProductName, (x1, x2) -> x1));
            Map<String, FeePoolDetailEntity> poolDetailEntityMap = ((LambdaQueryChainWrapper)this.feePoolDetailService.lambdaQuery().in(FeePoolDetailEntity::getPoolDetailCode, poolDetailCodeSet)).list().stream().collect(Collectors.toMap(FeePoolDetailEntity::getPoolDetailCode, v -> v));
            ArrayList<FeePoolDetailEntity> hasEditDetailEntityList = new ArrayList<FeePoolDetailEntity>();
            FeePoolOperationReqVo operationReqVo = new FeePoolOperationReqVo();
            operationReqVo.setPoolCode(poolCode);
            operationReqVo.setOperationType(operationType);
            operationReqVo.setFromCode(fromCode);
            operationReqVo.setFromDesc(StringUtils.isNotEmpty((String)fromDesc) ? fromDesc : operationTypeValue);
            operationReqVo.setOperationDateTime(operationDateTime);
            operationReqVo.setOperationAmount(operationAmountTotal.abs().multiply(operationTypeGroupEnum.getUsableAmountWeight()));
            operationReqVo.setFileList(null);
            operationReqVo.setRemarks(remarks);
            String operationCode = this.feePoolOperationService.savePoolOperation(operationReqVo);
            ArrayList<FeePoolDetailLogReqVo> logList = new ArrayList<FeePoolDetailLogReqVo>();
            Map<String, List<FeePoolDetailLogEntity>> groupByDetailCodeMap = detailLogList.stream().collect(Collectors.groupingBy(FeePoolDetailLogEntity::getPoolDetailCode));
            for (Map.Entry<String, List<FeePoolDetailLogEntity>> groupByDetailCodeEntry : groupByDetailCodeMap.entrySet()) {
                String poolDetailCode = groupByDetailCodeEntry.getKey();
                List<FeePoolDetailLogEntity> groupByDetailLogList = groupByDetailCodeEntry.getValue();
                BigDecimal thisDetailAmount = groupByDetailLogList.stream().map(FeePoolDetailLogEntity::getOperationAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                Assert.isTrue((thisDetailAmount.compareTo(BigDecimal.ZERO) <= 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60\u660e\u7ec6\u3010" + poolDetailCode + "\u3011\u91ca\u653e" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u6709\u8bef"));
                Assert.isTrue((boolean)poolDetailEntityMap.containsKey(poolDetailCode), (String)("\u8d39\u7528\u6c60\u3010" + poolCode + "\u3011\u6570\u636e\u6709\u8bef"));
                Map<String, List<FeePoolDetailLogEntity>> groupByProductCodeMap = groupByDetailLogList.stream().collect(Collectors.groupingBy(x -> x.getProductCode() == null ? "" : x.getProductCode()));
                for (Map.Entry<String, List<FeePoolDetailLogEntity>> groupByProductCodeEntry : groupByProductCodeMap.entrySet()) {
                    String productCode = groupByProductCodeEntry.getKey();
                    List<FeePoolDetailLogEntity> groupByProductLogList = groupByProductCodeEntry.getValue();
                    BigDecimal thisDetailProductAmount = groupByProductLogList.stream().map(FeePoolDetailLogEntity::getOperationAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    Assert.isTrue((thisDetailProductAmount.compareTo(BigDecimal.ZERO) <= 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60\u660e\u7ec6\u3010" + poolDetailCode + "\u3011" + (StringUtils.isNotEmpty((String)productCode) ? "\u5546\u54c1\u3010" + productCode + "\u3011" : "") + "\u91ca\u653e" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u6709\u8bef"));
                    FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
                    detailLog.setPoolCode(poolCode);
                    detailLog.setPoolDetailCode(poolDetailCode);
                    detailLog.setOperationCode(operationCode);
                    detailLog.setOperationType(operationType);
                    detailLog.setFromCode(fromCode);
                    detailLog.setFromDesc(StringUtils.isNotEmpty((String)fromDesc) ? fromDesc : operationTypeValue);
                    detailLog.setRemarks(remarks);
                    detailLog.setOperationAmount(thisDetailProductAmount.abs().multiply(operationTypeGroupEnum.getUsableAmountWeight()));
                    detailLog.setOperationDateTime(operationDateTime);
                    if (StringUtils.isNotEmpty((String)productCode)) {
                        detailLog.setProductCode(productCode);
                        detailLog.setProductName(productCodeNameMap.get(productCode));
                    }
                    logList.add(detailLog);
                }
                FeePoolDetailEntity feePoolDetailEntity = poolDetailEntityMap.get(poolDetailCode);
                feePoolDetailEntity.setOccupyAmount(feePoolDetailEntity.getOccupyAmount().subtract(thisDetailAmount.abs()));
                feePoolDetailEntity.setUsableAmount(feePoolDetailEntity.getUsableAmount().add(thisDetailAmount.abs()));
                hasEditDetailEntityList.add(feePoolDetailEntity);
            }
            this.subtractOccupyAmountByPoolCode(poolCode, operationAmountTotal.abs());
            this.feePoolDetailService.updateBatchById(hasEditDetailEntityList);
            this.feePoolDetailLogService.savePoolDetailLog(logList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void backAllOccupyByFromCodeBatch(List<FeePoolOccupyBackAllReqVo> list) {
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(this::backAllOccupyByFromCode);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void occupyToUseByFromCode(FeePoolOccupyToUseReqVo reqVo) {
        String fromCode = reqVo.getFromCode();
        Assert.hasText((String)fromCode, (String)"\u7f3a\u5931\u6765\u6e90\u5355\u53f7");
        String fromDesc = reqVo.getFromDesc();
        String remarks = reqVo.getRemarks();
        String operationType = reqVo.getOperationType();
        if (StringUtils.isEmpty((String)operationType)) {
            operationType = FeePoolOperationTypeEnum.ORDER_USE.getValue();
        }
        String operationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)operationType);
        String unoccupyOperationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)FeePoolOperationTypeEnum.UNOCCUPY.getValue());
        if (StringUtils.isEmpty((String)fromDesc)) {
            fromDesc = operationTypeValue;
        }
        HashSet operationTypeSet = new HashSet(16);
        operationTypeSet.addAll(FeePoolConfigUtil.getOperationTypeList((FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.OCCUPY));
        operationTypeSet.addAll(FeePoolConfigUtil.getOperationTypeList((FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.UNOCCUPY));
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolOperationService.lambdaQuery().eq(FeePoolOperationEntity::getFromCode, (Object)fromCode)).in(FeePoolOperationEntity::getOperationType, operationTypeSet)).list();
        if (CollectionUtil.listEmpty((List)list)) {
            return;
        }
        Map<String, List<FeePoolOperationEntity>> poolOperationGroup = list.stream().collect(Collectors.groupingBy(FeePoolOperationEntity::getPoolCode));
        String operationDateTime = DateUtil.dateNowHms();
        for (Map.Entry<String, List<FeePoolOperationEntity>> entry : poolOperationGroup.entrySet()) {
            String poolCode = entry.getKey();
            List<FeePoolOperationEntity> operationEntityList = entry.getValue();
            BigDecimal operationAmountTotal = operationEntityList.stream().map(FeePoolOperationEntity::getOperationAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (operationAmountTotal.compareTo(BigDecimal.ZERO) == 0) continue;
            Assert.isTrue((operationAmountTotal.compareTo(BigDecimal.ZERO) <= 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60\u3010" + poolCode + "\u3011\u6570\u636e\u5f02\u5e38"));
            List detailLogList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolDetailLogService.lambdaQuery().eq(FeePoolDetailLogEntity::getPoolCode, (Object)poolCode)).eq(FeePoolDetailLogEntity::getFromCode, (Object)fromCode)).in(FeePoolDetailLogEntity::getOperationType, operationTypeSet)).list();
            Assert.notEmpty((Collection)detailLogList, (String)("\u8d39\u7528\u6c60\u3010" + poolCode + "\u3011\u6570\u636e\u5f02\u5e38"));
            Set poolDetailCodeSet = detailLogList.stream().map(FeePoolDetailLogEntity::getPoolDetailCode).collect(Collectors.toSet());
            Map<String, String> productCodeNameMap = detailLogList.stream().filter(x -> StringUtils.isNotEmpty((String)x.getProductCode())).collect(Collectors.toMap(FeePoolDetailLogEntity::getProductCode, FeePoolDetailLogEntity::getProductName, (x1, x2) -> x1));
            Map<String, FeePoolDetailEntity> poolDetailEntityMap = ((LambdaQueryChainWrapper)this.feePoolDetailService.lambdaQuery().in(FeePoolDetailEntity::getPoolDetailCode, poolDetailCodeSet)).list().stream().collect(Collectors.toMap(FeePoolDetailEntity::getPoolDetailCode, v -> v));
            ArrayList<FeePoolDetailEntity> hasEditDetailEntityList = new ArrayList<FeePoolDetailEntity>();
            FeePoolOperationReqVo occupyOperationReqVo = new FeePoolOperationReqVo();
            occupyOperationReqVo.setPoolCode(poolCode);
            occupyOperationReqVo.setOperationType(FeePoolOperationTypeEnum.UNOCCUPY.getValue());
            occupyOperationReqVo.setFromCode(fromCode);
            occupyOperationReqVo.setFromDesc(unoccupyOperationTypeValue);
            occupyOperationReqVo.setOperationDateTime(operationDateTime);
            occupyOperationReqVo.setOperationAmount(operationAmountTotal.abs().multiply(FeePoolOperationTypeGroupEnum.UNOCCUPY.getUsableAmountWeight()));
            occupyOperationReqVo.setFileList(null);
            occupyOperationReqVo.setRemarks(remarks);
            String unoccupyOperationCode = this.feePoolOperationService.savePoolOperation(occupyOperationReqVo);
            FeePoolOperationReqVo useOperationReqVo = new FeePoolOperationReqVo();
            useOperationReqVo.setPoolCode(poolCode);
            useOperationReqVo.setOperationType(operationType);
            useOperationReqVo.setFromCode(fromCode);
            useOperationReqVo.setFromDesc(fromDesc);
            useOperationReqVo.setOperationDateTime(operationDateTime);
            useOperationReqVo.setOperationAmount(operationAmountTotal.abs().multiply(FeePoolOperationTypeGroupEnum.USE.getUsableAmountWeight()));
            useOperationReqVo.setFileList(null);
            useOperationReqVo.setRemarks(remarks);
            String useOperationCode = this.feePoolOperationService.savePoolOperation(useOperationReqVo);
            ArrayList<FeePoolDetailLogReqVo> logList = new ArrayList<FeePoolDetailLogReqVo>();
            Map<String, List<FeePoolDetailLogEntity>> groupByDetailCodeMap = detailLogList.stream().collect(Collectors.groupingBy(FeePoolDetailLogEntity::getPoolDetailCode));
            for (Map.Entry<String, List<FeePoolDetailLogEntity>> groupByDetailCodeEntry : groupByDetailCodeMap.entrySet()) {
                String poolDetailCode = groupByDetailCodeEntry.getKey();
                List<FeePoolDetailLogEntity> groupByDetailLogList = groupByDetailCodeEntry.getValue();
                BigDecimal thisDetailAmount = groupByDetailLogList.stream().map(FeePoolDetailLogEntity::getOperationAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                Assert.isTrue((thisDetailAmount.compareTo(BigDecimal.ZERO) <= 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60\u660e\u7ec6\u3010" + poolDetailCode + "\u3011\u5360\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u6709\u8bef"));
                Assert.isTrue((boolean)poolDetailEntityMap.containsKey(poolDetailCode), (String)("\u8d39\u7528\u6c60\u3010" + poolCode + "\u3011\u6570\u636e\u6709\u8bef"));
                Map<String, List<FeePoolDetailLogEntity>> groupByProductCodeMap = groupByDetailLogList.stream().collect(Collectors.groupingBy(x -> x.getProductCode() == null ? "" : x.getProductCode()));
                for (Map.Entry<String, List<FeePoolDetailLogEntity>> groupByProductCodeEntry : groupByProductCodeMap.entrySet()) {
                    String productCode = groupByProductCodeEntry.getKey();
                    List<FeePoolDetailLogEntity> groupByProductLogList = groupByProductCodeEntry.getValue();
                    BigDecimal thisDetailProductAmount = groupByProductLogList.stream().map(FeePoolDetailLogEntity::getOperationAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    Assert.isTrue((thisDetailProductAmount.compareTo(BigDecimal.ZERO) <= 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60\u660e\u7ec6\u3010" + poolDetailCode + "\u3011" + (StringUtils.isNotEmpty((String)productCode) ? "\u5546\u54c1\u3010" + productCode + "\u3011" : "") + "\u5360\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u6709\u8bef"));
                    FeePoolDetailLogReqVo unoccupyDetailLog = new FeePoolDetailLogReqVo();
                    unoccupyDetailLog.setPoolCode(poolCode);
                    unoccupyDetailLog.setPoolDetailCode(poolDetailCode);
                    unoccupyDetailLog.setOperationCode(unoccupyOperationCode);
                    unoccupyDetailLog.setOperationType(FeePoolOperationTypeEnum.UNOCCUPY.getValue());
                    unoccupyDetailLog.setFromCode(fromCode);
                    unoccupyDetailLog.setFromDesc(unoccupyOperationTypeValue);
                    unoccupyDetailLog.setRemarks(remarks);
                    unoccupyDetailLog.setOperationAmount(thisDetailProductAmount.abs().multiply(FeePoolOperationTypeGroupEnum.UNOCCUPY.getUsableAmountWeight()));
                    unoccupyDetailLog.setOperationDateTime(operationDateTime);
                    if (StringUtils.isNotEmpty((String)productCode)) {
                        unoccupyDetailLog.setProductCode(productCode);
                        unoccupyDetailLog.setProductName(productCodeNameMap.get(productCode));
                    }
                    logList.add(unoccupyDetailLog);
                    FeePoolDetailLogReqVo useDetailLog = new FeePoolDetailLogReqVo();
                    useDetailLog.setPoolCode(poolCode);
                    useDetailLog.setPoolDetailCode(poolDetailCode);
                    useDetailLog.setOperationCode(useOperationCode);
                    useDetailLog.setOperationType(operationType);
                    useDetailLog.setFromCode(fromCode);
                    useDetailLog.setFromDesc(fromDesc);
                    useDetailLog.setRemarks(remarks);
                    useDetailLog.setOperationAmount(thisDetailProductAmount.abs().multiply(FeePoolOperationTypeGroupEnum.USE.getUsableAmountWeight()));
                    useDetailLog.setOperationDateTime(operationDateTime);
                    if (StringUtils.isNotEmpty((String)productCode)) {
                        useDetailLog.setProductCode(productCode);
                        useDetailLog.setProductName(productCodeNameMap.get(productCode));
                    }
                    logList.add(useDetailLog);
                }
                FeePoolDetailEntity feePoolDetailEntity = poolDetailEntityMap.get(poolDetailCode);
                feePoolDetailEntity.setOccupyAmount(feePoolDetailEntity.getOccupyAmount().subtract(thisDetailAmount.abs()));
                feePoolDetailEntity.setHasUseAmount(feePoolDetailEntity.getHasUseAmount().add(thisDetailAmount.abs()));
                hasEditDetailEntityList.add(feePoolDetailEntity);
            }
            this.subtractOccupyAmountByPoolCode(poolCode, operationAmountTotal.abs());
            this.addHasUseAmountByPoolCode(poolCode, operationAmountTotal.abs());
            this.feePoolDetailService.updateBatchById(hasEditDetailEntityList);
            this.feePoolDetailLogService.savePoolDetailLog(logList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void occupyToUseByFromCodeBatch(List<FeePoolOccupyToUseReqVo> list) {
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(this::occupyToUseByFromCode);
        }
    }

    @Override
    public FeePoolAmountRespVo queryAmountByCustomerCode(String poolGroup, String customerCode, String poolType) {
        Assert.hasText((String)customerCode, (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        if (StringUtils.isEmpty((String)poolGroup)) {
            poolGroup = FeePoolGroupEnum.DEFAULT.getValue();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolGroup, (Object)poolGroup)).eq(StringUtils.isNotEmpty((String)poolType), FeePoolEntity::getPoolType, (Object)poolType)).eq(FeePoolEntity::getCustomerCode, (Object)customerCode)).select(new SFunction[]{FeePoolEntity::getTotalAmount, FeePoolEntity::getFreezeAmount, FeePoolEntity::getHasUseAmount, FeePoolEntity::getUsableAmount}).list();
        FeePoolAmountRespVo respVo = new FeePoolAmountRespVo();
        respVo.setCustomerCode(customerCode);
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal freezeAmount = BigDecimal.ZERO;
        BigDecimal hasUseAmount = BigDecimal.ZERO;
        BigDecimal occupyAmount = BigDecimal.ZERO;
        BigDecimal usableAmount = BigDecimal.ZERO;
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            totalAmount = list.stream().map(FeePoolEntity::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            freezeAmount = list.stream().map(FeePoolEntity::getFreezeAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            hasUseAmount = list.stream().map(FeePoolEntity::getHasUseAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            occupyAmount = list.stream().map(FeePoolEntity::getOccupyAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            usableAmount = list.stream().map(FeePoolEntity::getUsableAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        respVo.setTotalAmount(totalAmount);
        respVo.setFreezeAmount(freezeAmount);
        respVo.setHasUseAmount(hasUseAmount);
        respVo.setOccupyAmount(occupyAmount);
        respVo.setUsableAmount(usableAmount);
        return respVo;
    }

    @Override
    public FeePoolMonthAmountRespVo queryMonthAmountByCustomerCode(String poolGroup, String customerCode, String poolType, String yearMonth) {
        Assert.hasText((String)customerCode, (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        Assert.hasText((String)yearMonth, (String)"\u7f3a\u5931\u5e74\u6708");
        if (StringUtils.isEmpty((String)poolGroup)) {
            poolGroup = FeePoolGroupEnum.DEFAULT.getValue();
        }
        boolean flag = false;
        try {
            Date parse = DateUtil.yyyy_MM.parse(yearMonth);
            String format = DateUtil.yyyy_MM.format(parse);
            if (format.equals(yearMonth)) {
                flag = true;
            }
        }
        catch (Exception parse) {
            // empty catch block
        }
        Assert.isTrue((boolean)flag, (String)"\u5e74\u6708\u683c\u5f0f\u4e0d\u5408\u6cd5");
        FeePoolMonthAmountRespVo respVo = new FeePoolMonthAmountRespVo();
        BigDecimal usableAmount = this.feePoolMapper.sumUsableAmount(poolGroup, poolType, customerCode);
        BigDecimal thisMonthUsableAmount = this.feePoolMapper.sumThisMonthUsableAmount(poolGroup, poolType, customerCode, yearMonth);
        BigDecimal thisMonthAccountAmount = this.feePoolMapper.sumThisMonthAccountAmount(poolGroup, poolType, customerCode, yearMonth);
        BigDecimal lastMonthUsableAmount = this.feePoolMapper.sumLastMonthUsableAmount(poolGroup, poolType, customerCode, yearMonth);
        ArrayList<String> operationTypeList = new ArrayList<String>();
        operationTypeList.addAll(FeePoolConfigUtil.getOperationTypeList((FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.USE));
        operationTypeList.addAll(FeePoolConfigUtil.getOperationTypeList((FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.BACK));
        operationTypeList.addAll(FeePoolConfigUtil.getOperationTypeList((FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.FREEZE));
        operationTypeList.addAll(FeePoolConfigUtil.getOperationTypeList((FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.UNFREEZE));
        BigDecimal thisMonthHasUseAmount = this.feePoolMapper.sumThisMonthHasUseAmount(poolGroup, poolType, customerCode, yearMonth, operationTypeList);
        respVo.setCustomerCode(customerCode);
        respVo.setYearMonth(yearMonth);
        respVo.setUsableAmount(usableAmount == null ? BigDecimal.ZERO : usableAmount);
        respVo.setThisMonthUsableAmount(thisMonthUsableAmount == null ? BigDecimal.ZERO : thisMonthUsableAmount);
        respVo.setThisMonthAccountAmount(thisMonthAccountAmount == null ? BigDecimal.ZERO : thisMonthAccountAmount);
        respVo.setLastMonthUsableAmount(lastMonthUsableAmount == null ? BigDecimal.ZERO : lastMonthUsableAmount);
        respVo.setThisMonthHasUseAmount(thisMonthHasUseAmount == null ? BigDecimal.ZERO : thisMonthHasUseAmount.negate());
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addTotalAmountByPoolCode(String poolCode, BigDecimal amount) {
        Assert.hasText((String)poolCode, (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.isTrue((amount != null ? 1 : 0) != 0, (String)(FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((amount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)(FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u5c0f\u4e8e0"));
        FeePoolEntity pool = (FeePoolEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolCode)).one();
        Assert.notNull((Object)pool, (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u7f16\u53f7");
        pool.setTotalAmount(pool.getTotalAmount().add(amount));
        pool.setUsableAmount(pool.getUsableAmount().add(amount));
        this.updateById(pool);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addHasUseAmountByPoolCode(String poolCode, BigDecimal amount) {
        Assert.hasText((String)poolCode, (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.isTrue((amount != null ? 1 : 0) != 0, (String)(FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((amount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)(FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u5c0f\u4e8e0"));
        FeePoolEntity pool = (FeePoolEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolCode)).one();
        Assert.isTrue((pool.getUsableAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)("\u4f7f\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u8d85\u8fc7\u53ef\u4f7f\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        pool.setHasUseAmount(pool.getHasUseAmount().add(amount));
        pool.setUsableAmount(pool.getUsableAmount().subtract(amount));
        this.updateById(pool);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void subtractHasUseAmountByPoolCode(String poolCode, BigDecimal amount) {
        Assert.hasText((String)poolCode, (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.isTrue((amount != null ? 1 : 0) != 0, (String)(FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((amount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)(FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u5c0f\u4e8e0"));
        FeePoolEntity pool = (FeePoolEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolCode)).one();
        Assert.isTrue((pool.getHasUseAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)("\u56de\u9000\u4f7f\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u8d85\u8fc7\u53ef\u4f7f\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        pool.setHasUseAmount(pool.getHasUseAmount().subtract(amount));
        pool.setUsableAmount(pool.getUsableAmount().add(amount));
        this.updateById(pool);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOccupyAmountByPoolCode(String poolCode, BigDecimal amount) {
        Assert.hasText((String)poolCode, (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.isTrue((amount != null ? 1 : 0) != 0, (String)(FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((amount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)(FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u5c0f\u4e8e0"));
        FeePoolEntity pool = (FeePoolEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolCode)).one();
        Assert.notNull((Object)pool, (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.isTrue((pool.getUsableAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)("\u5360\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u8d85\u8fc7\u53ef\u4f7f\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        pool.setOccupyAmount(Optional.ofNullable(pool.getOccupyAmount()).orElse(BigDecimal.ZERO).add(amount));
        pool.setUsableAmount(pool.getUsableAmount().subtract(amount));
        this.updateById(pool);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void subtractOccupyAmountByPoolCode(String poolCode, BigDecimal amount) {
        Assert.hasText((String)poolCode, (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.isTrue((amount != null ? 1 : 0) != 0, (String)(FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((amount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)(FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u5c0f\u4e8e0"));
        FeePoolEntity pool = (FeePoolEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolCode)).one();
        Assert.notNull((Object)pool, (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.isTrue((Optional.ofNullable(pool.getOccupyAmount()).orElse(BigDecimal.ZERO).compareTo(amount) >= 0 ? 1 : 0) != 0, (String)("\u91ca\u653e" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u8d85\u8fc7\u5df2\u5360\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        pool.setOccupyAmount(Optional.ofNullable(pool.getOccupyAmount()).orElse(BigDecimal.ZERO).subtract(amount));
        pool.setUsableAmount(pool.getUsableAmount().add(amount));
        this.updateById(pool);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addFreezeAmountByPoolCode(String poolCode, BigDecimal amount) {
        Assert.hasText((String)poolCode, (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.isTrue((amount != null ? 1 : 0) != 0, (String)(FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((amount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)(FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u5c0f\u4e8e0"));
        FeePoolEntity pool = (FeePoolEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolCode)).one();
        Assert.notNull((Object)pool, (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.isTrue((pool.getUsableAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)("\u51bb\u7ed3" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u8d85\u8fc7\u53ef\u4f7f\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        pool.setFreezeAmount(pool.getFreezeAmount().add(amount));
        pool.setUsableAmount(pool.getUsableAmount().subtract(amount));
        this.updateById(pool);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void subtractFreezeAmountByPoolCode(String poolCode, BigDecimal amount) {
        Assert.hasText((String)poolCode, (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.isTrue((amount != null ? 1 : 0) != 0, (String)(FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((amount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)(FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u5c0f\u4e8e0"));
        FeePoolEntity pool = (FeePoolEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolCode)).one();
        Assert.notNull((Object)pool, (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.isTrue((pool.getFreezeAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)("\u89e3\u51bb" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u8d85\u8fc7\u5df2\u51bb\u7ed3" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        pool.setFreezeAmount(pool.getFreezeAmount().subtract(amount));
        pool.setUsableAmount(pool.getUsableAmount().add(amount));
        this.updateById(pool);
    }

    @Override
    public void backDiscountUseAmount(String operationType, String fromCode, String fromDesc, BigDecimal backAmount, String remarks, List<FeePoolFileReqVo> fileList) {
        Assert.isTrue((backAmount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)("\u6298\u6263\u56de\u9000" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u80fd\u4e3a\u8d1f\u6570"));
        HashSet operationTypeSet = new HashSet(16);
        operationTypeSet.addAll(FeePoolConfigUtil.getOperationTypeList((FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.USE));
        operationTypeSet.addAll(FeePoolConfigUtil.getOperationTypeList((FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.BACK));
        List useDetailLogEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolDetailLogService.lambdaQuery().eq(FeePoolDetailLogEntity::getFromCode, (Object)fromCode)).in(FeePoolDetailLogEntity::getOperationType, operationTypeSet)).list();
        Assert.notEmpty((Collection)useDetailLogEntityList, (String)("\u672a\u627e\u5230\u6765\u6e90\u5355\u53f7\u3010" + fromCode + "\u3011\u5bf9\u5e94\u7684\u8d39\u7528\u6c60\u4f7f\u7528\u8bb0\u5f55"));
        BigDecimal notBackAmount = useDetailLogEntityList.stream().map(FeePoolDetailLogEntity::getOperationAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        Assert.isTrue((notBackAmount.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)("\u6765\u6e90\u5355\u53f7\u3010" + fromCode + "\u3011\u6ca1\u6709\u53ef\u56de\u9000\u7684" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        Assert.isTrue((notBackAmount.compareTo(BigDecimal.ZERO) < 0 ? 1 : 0) != 0, (String)("\u6765\u6e90\u5355\u53f7\u3010" + fromCode + "\u3011\u6570\u636e\u5f02\u5e38"));
        Assert.isTrue((notBackAmount.abs().compareTo(backAmount) >= 0 ? 1 : 0) != 0, (String)("\u6765\u6e90\u5355\u53f7\u3010" + fromCode + "\u3011\u56de\u9000\u6298\u6263" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u8d85\u8fc7\u5269\u4f59\u53ef\u56de\u9000\u7684" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        List poolEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(FeePoolEntity::getPoolType, new Object[]{FeePoolTypeEnum.DISCOUNT.getValue()})).in(FeePoolEntity::getPoolCode, (Collection)useDetailLogEntityList.stream().map(FeePoolDetailLogEntity::getPoolCode).collect(Collectors.toSet()))).list();
        Set poolCodeSet = poolEntityList.stream().map(FeePoolEntity::getPoolCode).collect(Collectors.toSet());
        BigDecimal restAmount = backAmount;
        String operationDateTime = DateUtil.dateNowHms();
        Map<String, List<FeePoolDetailLogEntity>> groupByPoolCodeMap = useDetailLogEntityList.stream().filter(x -> poolCodeSet.contains(x.getPoolCode())).collect(Collectors.groupingBy(FeePoolDetailLogEntity::getPoolCode));
        for (Map.Entry<String, List<FeePoolDetailLogEntity>> groupByPoolCodeEntry : groupByPoolCodeMap.entrySet()) {
            ArrayList<FeePoolDetailLogReqVo> detailLogList = new ArrayList<FeePoolDetailLogReqVo>();
            BigDecimal poolCodeBackAmount = BigDecimal.ZERO;
            HashMap<String, BigDecimal> poolDetailCodeBackAmountMap = new HashMap<String, BigDecimal>(16);
            String poolCode = groupByPoolCodeEntry.getKey();
            List<FeePoolDetailLogEntity> groupByPoolCodeList = groupByPoolCodeEntry.getValue();
            Map<String, BigDecimal> poolDetailCodeUseAmountMap = groupByPoolCodeList.stream().collect(Collectors.groupingBy(FeePoolDetailLogEntity::getPoolDetailCode, Collectors.mapping(FeePoolDetailLogEntity::getOperationAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            for (Map.Entry<String, BigDecimal> poolDetailCodeUseAmountEntry : poolDetailCodeUseAmountMap.entrySet()) {
                String poolDetailCode = poolDetailCodeUseAmountEntry.getKey();
                BigDecimal useNotBackAmountAbs = poolDetailCodeUseAmountEntry.getValue().abs();
                if (useNotBackAmountAbs.compareTo(BigDecimal.ZERO) == 0 || restAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal itemBack = BigDecimal.ZERO;
                itemBack = useNotBackAmountAbs.compareTo(restAmount) >= 0 ? restAmount : useNotBackAmountAbs;
                restAmount = restAmount.subtract(itemBack);
                FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
                detailLog.setPoolCode(poolCode);
                detailLog.setPoolDetailCode(poolDetailCode);
                detailLog.setOperationType(operationType);
                detailLog.setFromCode(fromCode);
                detailLog.setFromDesc(fromDesc);
                detailLog.setRemarks(remarks);
                detailLog.setOperationAmount(itemBack.multiply(FeePoolOperationTypeGroupEnum.BACK.getUsableAmountWeight()));
                detailLogList.add(detailLog);
                poolCodeBackAmount = poolCodeBackAmount.add(itemBack);
                poolDetailCodeBackAmountMap.put(poolDetailCode, itemBack.add(poolDetailCodeBackAmountMap.getOrDefault(poolDetailCode, BigDecimal.ZERO)));
            }
            if (poolCodeBackAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            FeePoolOperationReqVo operationReqVo = new FeePoolOperationReqVo();
            operationReqVo.setPoolCode(poolCode);
            operationReqVo.setOperationType(operationType);
            operationReqVo.setFromCode(fromCode);
            operationReqVo.setFromDesc(fromDesc);
            operationReqVo.setOperationDateTime(operationDateTime);
            operationReqVo.setOperationAmount(poolCodeBackAmount.multiply(FeePoolOperationTypeGroupEnum.BACK.getUsableAmountWeight()));
            operationReqVo.setFileList(fileList);
            operationReqVo.setRemarks(remarks);
            String operationCode = this.feePoolOperationService.savePoolOperation(operationReqVo);
            this.subtractHasUseAmountByPoolCode(poolCode, poolCodeBackAmount);
            List list = ((LambdaQueryChainWrapper)this.feePoolDetailService.lambdaQuery().in(FeePoolDetailEntity::getPoolDetailCode, poolDetailCodeBackAmountMap.keySet())).list();
            list.forEach(x -> {
                if (poolDetailCodeBackAmountMap.containsKey(x.getPoolDetailCode())) {
                    BigDecimal poolDetailBackAmount = (BigDecimal)poolDetailCodeBackAmountMap.get(x.getPoolDetailCode());
                    x.setHasUseAmount(x.getHasUseAmount().subtract(poolDetailBackAmount));
                    x.setUsableAmount(x.getUsableAmount().add(poolDetailBackAmount));
                }
            });
            this.feePoolDetailService.updateBatchById(list);
            detailLogList.forEach(x -> x.setOperationCode(operationCode));
            this.feePoolDetailLogService.savePoolDetailLog(detailLogList);
        }
    }

    @Override
    public void backGoodsUseAmount(String operationType, String fromCode, String fromDesc, List<FeePoolGoodsUseBackItemReqVo> itemList, String remarks, List<FeePoolFileReqVo> fileList) {
        Assert.hasText((String)operationType, (String)"\u7f3a\u5931\u64cd\u4f5c\u7c7b\u578b");
        Assert.hasText((String)fromCode, (String)"\u7f3a\u5931\u6765\u6e90\u5355\u53f7");
        Assert.notEmpty(itemList, (String)"\u7f3a\u5931\u9000\u8fd8\u660e\u7ec6");
        String operationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)operationType);
        Assert.hasText((String)operationTypeValue, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
        Assert.isTrue((boolean)FeePoolConfigUtil.checkOperationTypeGroup((String)operationType, (FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.BACK), (String)("\u8be5\u64cd\u4f5c\u7c7b\u578b\u4e0d\u652f\u6301\u56de\u9000" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        itemList.forEach(item -> {
            Assert.hasText((String)item.getProductCode(), (String)"\u660e\u7ec6\u7f3a\u5931\u5546\u54c1\u7f16\u7801");
            Assert.isTrue((item.getAmount() != null ? 1 : 0) != 0, (String)("\u660e\u7ec6\u7f3a\u5931\u56de\u9000" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
            Assert.isTrue((item.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)("\u660e\u7ec6\u56de\u9000" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u5fc5\u987b\u5927\u4e8e0"));
        });
        List useDetailLogEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolDetailLogService.lambdaQuery().eq(FeePoolDetailLogEntity::getFromCode, (Object)fromCode)).in(FeePoolDetailLogEntity::getOperationType, (Collection)FeePoolConfigUtil.getOperationTypeList((FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.USE))).orderByAsc(FeePoolDetailLogEntity::getOperationDateTime)).list();
        Assert.notEmpty((Collection)useDetailLogEntityList, (String)("\u672a\u627e\u5230\u6765\u6e90\u5355\u53f7\u3010" + fromCode + "\u3011\u5bf9\u5e94\u7684\u8d39\u7528\u6c60\u4f7f\u7528\u8bb0\u5f55"));
        HashMap<String, BigDecimal> hasBackAmountMap = new HashMap<String, BigDecimal>(16);
        List backDetailLogEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolDetailLogService.lambdaQuery().eq(FeePoolDetailLogEntity::getFromCode, (Object)fromCode)).in(FeePoolDetailLogEntity::getOperationType, (Collection)FeePoolConfigUtil.getOperationTypeList((FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.BACK))).orderByAsc(FeePoolDetailLogEntity::getOperationDateTime)).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)backDetailLogEntityList)) {
            for (FeePoolDetailLogEntity item2 : backDetailLogEntityList) {
                String key = item2.getPoolCode() + "_" + item2.getPoolDetailCode() + "_" + item2.getProductCode();
                BigDecimal bigDecimal = hasBackAmountMap.getOrDefault(key, BigDecimal.ZERO);
                bigDecimal = bigDecimal.add(item2.getOperationAmount());
                hasBackAmountMap.put(key, bigDecimal);
            }
        }
        Map<String, BigDecimal> backProductAmountMap = itemList.stream().collect(Collectors.groupingBy(FeePoolGoodsUseBackItemReqVo::getProductCode, Collectors.mapping(FeePoolGoodsUseBackItemReqVo::getAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        Map<String, List<FeePoolDetailLogEntity>> groupByPoolCodeMap = useDetailLogEntityList.stream().collect(Collectors.groupingBy(FeePoolDetailLogEntity::getPoolCode));
        LinkedHashMap<String, BigDecimal> poolDetailCodeNeedBackAmountMap = new LinkedHashMap<String, BigDecimal>(16);
        for (Map.Entry<String, List<FeePoolDetailLogEntity>> entry : groupByPoolCodeMap.entrySet()) {
            String poolCode = entry.getKey();
            List<FeePoolDetailLogEntity> groupByPoolCodeList = entry.getValue();
            ArrayList<FeePoolDetailLogReqVo> detailLogList = new ArrayList<FeePoolDetailLogReqVo>();
            BigDecimal poolCodeNeedBackAmount = BigDecimal.ZERO;
            for (FeePoolDetailLogEntity item3 : groupByPoolCodeList) {
                BigDecimal productBackAmount;
                String key = item3.getPoolCode() + "_" + item3.getPoolDetailCode() + "_" + item3.getProductCode();
                BigDecimal notBackAmount = item3.getOperationAmount().abs();
                if (hasBackAmountMap.containsKey(key)) {
                    BigDecimal hasBack = (BigDecimal)hasBackAmountMap.get(key);
                    if (hasBack.compareTo(BigDecimal.ZERO) > 0) {
                        if (notBackAmount.compareTo(hasBack) >= 0) {
                            notBackAmount = notBackAmount.subtract(hasBack);
                            hasBack = BigDecimal.ZERO;
                        } else {
                            hasBack = hasBack.subtract(notBackAmount);
                            notBackAmount = BigDecimal.ZERO;
                        }
                    }
                    hasBackAmountMap.put(key, hasBack);
                }
                if (notBackAmount.compareTo(BigDecimal.ZERO) <= 0 || !backProductAmountMap.containsKey(item3.getProductCode()) || (productBackAmount = backProductAmountMap.get(item3.getProductCode())).compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal thisBackAmount = BigDecimal.ZERO;
                thisBackAmount = productBackAmount.compareTo(notBackAmount) <= 0 ? productBackAmount : notBackAmount;
                notBackAmount = notBackAmount.subtract(thisBackAmount);
                productBackAmount = productBackAmount.subtract(thisBackAmount);
                backProductAmountMap.put(item3.getProductCode(), productBackAmount);
                poolCodeNeedBackAmount = poolCodeNeedBackAmount.add(thisBackAmount);
                BigDecimal poolDetailCodeNeedBackAmount = thisBackAmount;
                if (poolDetailCodeNeedBackAmountMap.containsKey(item3.getPoolDetailCode())) {
                    poolDetailCodeNeedBackAmount = poolDetailCodeNeedBackAmount.add((BigDecimal)poolDetailCodeNeedBackAmountMap.get(item3.getPoolDetailCode()));
                }
                poolDetailCodeNeedBackAmountMap.put(item3.getPoolDetailCode(), poolDetailCodeNeedBackAmount);
                FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
                detailLog.setPoolCode(poolCode);
                detailLog.setPoolDetailCode(item3.getPoolDetailCode());
                detailLog.setOperationType(operationType);
                detailLog.setFromCode(fromCode);
                detailLog.setFromDesc(StringUtils.isNotEmpty((String)fromDesc) ? fromDesc : operationTypeValue);
                detailLog.setRemarks(remarks);
                detailLog.setOperationAmount(thisBackAmount.multiply(FeePoolOperationTypeGroupEnum.BACK.getUsableAmountWeight()));
                detailLog.setProductCode(item3.getProductCode());
                detailLog.setProductName(item3.getProductName());
                detailLogList.add(detailLog);
            }
            if (poolCodeNeedBackAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            String operationDateTime = DateUtil.dateNowHms();
            FeePoolOperationReqVo operationReqVo = new FeePoolOperationReqVo();
            operationReqVo.setPoolCode(poolCode);
            operationReqVo.setOperationType(operationType);
            operationReqVo.setFromCode(fromCode);
            operationReqVo.setFromDesc(StringUtils.isNotEmpty((String)fromDesc) ? fromDesc : operationTypeValue);
            operationReqVo.setOperationDateTime(operationDateTime);
            operationReqVo.setOperationAmount(poolCodeNeedBackAmount.multiply(FeePoolOperationTypeGroupEnum.BACK.getUsableAmountWeight()));
            operationReqVo.setFileList(fileList);
            operationReqVo.setRemarks(remarks);
            String operationCode = this.feePoolOperationService.savePoolOperation(operationReqVo);
            detailLogList.forEach(item -> {
                item.setOperationCode(operationCode);
                item.setOperationDateTime(operationDateTime);
            });
            List list = ((LambdaQueryChainWrapper)this.feePoolDetailService.lambdaQuery().in(FeePoolDetailEntity::getPoolDetailCode, poolDetailCodeNeedBackAmountMap.keySet())).list();
            list.forEach(x -> {
                if (poolDetailCodeNeedBackAmountMap.containsKey(x.getPoolDetailCode())) {
                    BigDecimal detailNeedBack = (BigDecimal)poolDetailCodeNeedBackAmountMap.get(x.getPoolDetailCode());
                    if (x.getHasUseAmount().compareTo(detailNeedBack) < 0) {
                        throw new BusinessException("\u8d39\u7528\u6c60\u660e\u7ec6\u9000\u8fd8" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u4e0d\u8db3");
                    }
                    x.setHasUseAmount(x.getHasUseAmount().subtract(detailNeedBack));
                    x.setUsableAmount(x.getUsableAmount().add(detailNeedBack));
                }
            });
            this.feePoolDetailService.updateBatchById(list);
            this.subtractHasUseAmountByPoolCode(poolCode, poolCodeNeedBackAmount);
            this.feePoolDetailLogService.savePoolDetailLog(detailLogList);
        }
        for (Map.Entry<String, Object> entry : backProductAmountMap.entrySet()) {
            Assert.isTrue((((BigDecimal)entry.getValue()).compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)("\u5546\u54c1" + entry.getKey() + "\u9000\u8fd8" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC + "\u8d85\u8fc7\u5df2\u4f7f\u7528" + FeePoolConfigUtil.FEE_POOL_AMOUNT_DESC));
        }
    }
}

