package com.biz.crm.activiti.start;

import com.biz.crm.activiti.start.impl.ActivitiStartUpFeignImpl;
import com.biz.crm.nebular.activiti.start.req.ActivitiStartInfoReqVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @CLASS_DESCRIBE: 流程启动feign
 * @AUTHOR: create by zkey on 2020-11-03
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "activitiStartUpFeign",name="crm-activiti",path = "activiti",fallbackFactory = ActivitiStartUpFeignImpl.class)
public interface ActivitiStartUpFeign {

    /**
     * 工作流 公用启动方法 ，返回流程实例ID
     * @param activitiStartInfoReqVo
     * @return
     */
    @PostMapping(value = "/activitiStartUp/start")
    Result<Object> start(@RequestBody ActivitiStartInfoReqVo activitiStartInfoReqVo);

}
