package com.biz.crm.dms.orderfeerate.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.dms.orderfeerate.OrderFeeRateFeign;
import com.biz.crm.nebular.dms.orderfeerate.*;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.Map;

/**
 * @Description:
 * @Author: heyijiang
 * @Date: 2020/9/27 16:11
 **/
@Slf4j
@Component
public class OrderFeeRateFeignImpl extends BaseAbstract implements FallbackFactory<OrderFeeRateFeign> {
    @Override
    public OrderFeeRateFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new OrderFeeRateFeign() {

            @Override
            public Result<BigDecimal> calToCash(OrderFeeRateCalToCashVo orderFeeRateCalToCashVo) {
                return doBack();
            }

            @Override
            public Result<OrderFeeRateCalToCashResVo> calToCashForObj(OrderFeeRateCalToCashVo orderFeeRateCalToCashVo) {
                return doBack();
            }

            @Override
            public Result<Map<String, BigDecimal>> calToRep(OrderFeeRateCalToRepVo orderFeeRateCalToRepVo) {
                return doBack();
            }

            @Override
            public Result<Map<String, OrderFeeRateCalToResVo>> calToRepForObj(OrderFeeRateCalToRepVo orderFeeRateCalToRepVo) {
                return doBack();
            }

            @Override
            public Result<BigDecimal> calToRepAndCash(OrderFeeRateCalToRepAndCashVo orderFeeRateCalToRepAndCashVo) {
                return doBack();
            }
        };
    }
}
