package com.biz.crm.dms.promotion;

import com.biz.crm.dms.notice.impl.NoticeFeignImpl;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionAvailableResp;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionEditVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionQueryReq;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/** 公告
 * @Description:
 * @Author: heyijiang
 * @Date: 2020/9/27 16:03
 **/
@FeignClient(url ="${feign.urlip:}",qualifier = "promotionV2Feign",name="crm-dms",path = "dms",fallbackFactory = NoticeFeignImpl.class)
public interface PromotionV2Feign {


    /**
     * 根据id批量删除
     */
    @PostMapping(value = "/promotion/v2/findHitPromotionMapByPromotionCodes")
    Result<Map<String, PromotionEditVo>> findHitPromotionMapByPromotionCodes(@RequestBody ArrayList<PromotionQueryReq> params);


    /**
     * 根据客户以及商品（本品）查询可用的所有促销政策
     * @param param
     * @return
     */
    @PostMapping("/promotion/v2/findAvailablePromotionsByAccount")
    Result<List<PromotionAvailableResp>> findAvailablePromotionsByAccount(@RequestBody PromotionQueryReq param);
}
