package com.biz.crm.dms.promotion.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.dms.promotion.DmsPromotionPolicyOrderDetailFeign;
import com.biz.crm.nebular.dms.promotion.policy.req.DmsPromotionPolicyOrderDetailReqVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.DmsPromotionPolicyOrderDetailRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 促销政策订单明细feign接口熔断类
 *
 * @author lf
 * @date 2020-12-26 13:34:30
 */
@Slf4j
@Component
public class DmsPromotionPolicyOrderDetailFeignImpl extends BaseAbstract implements FallbackFactory<DmsPromotionPolicyOrderDetailFeign> {

    @Override
    public DmsPromotionPolicyOrderDetailFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new DmsPromotionPolicyOrderDetailFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<DmsPromotionPolicyOrderDetailRespVo>> list(DmsPromotionPolicyOrderDetailReqVo dmsPromotionPolicyOrderDetailReqVo) {
                doBack();
                PageResult<DmsPromotionPolicyOrderDetailRespVo> build = PageResult.<DmsPromotionPolicyOrderDetailRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<DmsPromotionPolicyOrderDetailRespVo> query(DmsPromotionPolicyOrderDetailReqVo dmsPromotionPolicyOrderDetailReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(DmsPromotionPolicyOrderDetailReqVo dmsPromotionPolicyOrderDetailReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(DmsPromotionPolicyOrderDetailReqVo dmsPromotionPolicyOrderDetailReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(DmsPromotionPolicyOrderDetailReqVo dmsPromotionPolicyOrderDetailReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(DmsPromotionPolicyOrderDetailReqVo dmsPromotionPolicyOrderDetailReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(DmsPromotionPolicyOrderDetailReqVo dmsPromotionPolicyOrderDetailReqVo) {
                return doBack();
            }

            /**
             * 批量锁定促销政策使用明细
             * @param reqVo
             * @return
             */
            @Override
            public Result<Boolean> lockPromotionPolicyOrderDetailBatch(List<DmsPromotionPolicyOrderDetailReqVo> reqVo) {
                return doBack();
            }

            /**
             * 提交促销政策使用明细
             * @param orderNo
             * @return
             */
            @Override
            public Result<Boolean> commitPromotionPolicyOrderDetail(String orderNo) {
                return doBack();
            }

            /**
             * 回滚促销政策使用明细
             * @param orderNo
             * @return
             */
            @Override
            public Result<Boolean> rollbackPromotionPolicyOrderDetail(String orderNo) {
                return doBack();
            }
        };
    }
}
