package com.biz.crm.dms.rotationpic.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.dms.rotationpic.RotationPicFeign;
import com.biz.crm.nebular.dms.rotationpic.DmsRotationPicVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/8/26 15:40
 **/
@Slf4j
@Component
public class RotationPicFeignImpl extends BaseAbstract implements FallbackFactory<RotationPicFeign> {
    @Override
    public RotationPicFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new RotationPicFeign() {

            @Override
            public Result add(DmsRotationPicVo dmsRotationPicVo) {
                return doBack();
            }

            @Override
            public Result edit(DmsRotationPicVo dmsRotationPicVo) {
                return doBack();
            }

            @Override
            public Result<DmsRotationPicVo> findById(String id) {
                return doBack();
            }

            @Override
            public Result<PageResult<DmsRotationPicVo>> list(DmsRotationPicVo dmsRotationPicVo) {
                return doBack();
            }

            @Override
            public Result<Object> delByIds(ArrayList<String> ids) {
                return doBack();
            }

            @Override
            public Result<Object> delByParam(DmsRotationPicVo dmsRotationPicVo) {
                return doBack();
            }
        };
    }
}
