package com.biz.crm.mdm.bpmrole.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.mdm.bpmrole.MdmBpmRoleFeign;
import com.biz.crm.mdm.bpmrole.MdmBpmRoleRedisFeign;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRedisRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRedisVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Description:
 * @project：crm-core
 * @package：com.biz.crm.mdm.bpmrole.impl
 * @author：longyu
 * @create：2021/1/14 15:21
 */
@Slf4j
@Component
public class MdmBpmRoleRedisFeignImpl extends BaseAbstract implements FallbackFactory<MdmBpmRoleRedisFeign> {


    @Override
    public MdmBpmRoleRedisFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new MdmBpmRoleRedisFeign(){
            @Override
            public Result<List<MdmBpmRoleRedisRespVo>> findRedisListByBpmRoleCodeList(List<String> bpmRoleCodeList) {
                return doBack();
            }

            @Override
            public Result<List<MdmBpmRoleRedisRespVo>> findRedisReloadList() {
                return doBack();
            }

        };
    }
}
